/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util;

import com.uwyn.jhighlight.renderer.Renderer;
import com.uwyn.jhighlight.renderer.XhtmlRendererFactory;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.frameworkset.util.tokenizer.StringTokenizer;
import org.frameworkset.util.tokenizer.Token;
import org.frameworkset.util.tokenizer.Tokenizer;
import org.frameworkset.util.tokenizer.TokenizerSymbol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeUtils {
    private static Logger logger = LoggerFactory.getLogger(CodeUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file, String charsetName) throws IOException {
        String result = null;
        try (FileInputStream fis = new FileInputStream(file);){
            result = CodeUtils.readStream(fis, charsetName);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStream(InputStream is, String charsetName) throws IOException {
        Charset charset = Charset.forName(System.getProperty("file.encoding"));
        if (Charset.isSupported(charsetName)) {
            charset = Charset.forName(charsetName);
        }
        StringBuilder out = new StringBuilder();
        try (BufferedReader r = new BufferedReader(new InputStreamReader(is, charset), 4096);){
            String b;
            while ((b = r.readLine()) != null) {
                out.append(b).append("\n");
            }
        }
        return out.toString();
    }

    public static void delete(File f) {
        if (f != null && f.exists()) {
            if (f.isDirectory()) {
                File[] files = f.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    CodeUtils.delete(files[i]);
                }
            }
            if (!f.delete()) {
                logger.debug("Cannot delete " + f.getAbsolutePath());
            }
        } else {
            logger.debug(f + " does not exist");
        }
    }

    public static int toInt(String num, int defaultValue) {
        try {
            return Integer.parseInt(num);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static int toIntHex(String num, int defaultValue) {
        try {
            if (num != null && num.startsWith("#")) {
                num = num.substring(1);
            }
            return Integer.parseInt(num, 16);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static int toInt(Integer num, int defaultValue) {
        return num == null ? defaultValue : num;
    }

    public static long toLong(Long num, long defaultValue) {
        return num == null ? defaultValue : num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJSPEncoding(InputStream is) throws IOException {
        Object token;
        String encoding = null;
        String contentType = null;
        Tokenizer jspTokenizer = new Tokenizer();
        jspTokenizer.addSymbol("\n", true);
        jspTokenizer.addSymbol(" ", true);
        jspTokenizer.addSymbol("\t", true);
        jspTokenizer.addSymbol(new TokenizerSymbol("dir", "<%@", "%>", false, false, true, false));
        StringTokenizer directiveTokenizer = new StringTokenizer();
        directiveTokenizer.addSymbol("\n", true);
        directiveTokenizer.addSymbol(" ", true);
        directiveTokenizer.addSymbol("\t", true);
        directiveTokenizer.addSymbol("=");
        directiveTokenizer.addSymbol("\"", "\"", false);
        directiveTokenizer.addSymbol("'", "'", false);
        StringTokenizer contentTypeTokenizer = new StringTokenizer();
        contentTypeTokenizer.addSymbol(" ", true);
        contentTypeTokenizer.addSymbol(";", true);
        try (InputStreamReader reader = new InputStreamReader(is, "ISO-8859-1");){
            jspTokenizer.setReader((Reader)reader);
            block3: while (jspTokenizer.hasMore()) {
                token = jspTokenizer.nextToken();
                if (!"dir".equals(token.getName())) continue;
                directiveTokenizer.setString(token.getInnerText());
                if (!directiveTokenizer.hasMore() || !directiveTokenizer.nextToken().getText().equals("page")) continue;
                while (directiveTokenizer.hasMore()) {
                    Token dTk = directiveTokenizer.nextToken();
                    if ("pageEncoding".equals(dTk.getText())) {
                        if (!directiveTokenizer.hasMore() || !"=".equals(directiveTokenizer.nextToken().getText()) || !directiveTokenizer.hasMore()) continue;
                        encoding = directiveTokenizer.nextToken().getInnerText();
                        continue block3;
                    }
                    if (!"contentType".equals(dTk.getText()) || !directiveTokenizer.hasMore() || !"=".equals(directiveTokenizer.nextToken().getText()) || !directiveTokenizer.hasMore()) continue;
                    contentType = directiveTokenizer.nextToken().getInnerText();
                }
            }
        }
        if (encoding == null && contentType != null) {
            contentTypeTokenizer.setString(contentType);
            while (contentTypeTokenizer.hasMore()) {
                token = contentTypeTokenizer.nextToken().getText();
                if (!((String)token).startsWith("charset=")) continue;
                encoding = ((String)token).substring("charset=".length());
                break;
            }
        }
        return encoding != null ? encoding : "ISO-8859-1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void sendFile(HttpServletRequest request, HttpServletResponse response, File file) throws IOException {
        ServletOutputStream out = response.getOutputStream();
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            long fileSize = raf.length();
            long rangeStart = 0L;
            long rangeFinish = fileSize - 1L;
            String range = request.getHeader("Range");
            if (range != null && range.startsWith("bytes=")) {
                String pureRange = range.replaceAll("bytes=", "");
                int rangeSep = pureRange.indexOf("-");
                try {
                    rangeStart = Long.parseLong(pureRange.substring(0, rangeSep));
                    if (rangeStart > fileSize || rangeStart < 0L) {
                        rangeStart = 0L;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (rangeSep < pureRange.length() - 1) {
                    try {
                        rangeFinish = Long.parseLong(pureRange.substring(rangeSep + 1));
                        if (rangeFinish < 0L || rangeFinish >= fileSize) {
                            rangeFinish = fileSize - 1L;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            response.setContentType("application/x-download");
            response.setHeader("Content-Disposition", "attachment; filename=" + file.getName());
            response.setHeader("Accept-Ranges", "bytes");
            response.setHeader("Content-Length", Long.toString(rangeFinish - rangeStart + 1L));
            response.setHeader("Content-Range", "bytes " + rangeStart + "-" + rangeFinish + "/" + fileSize);
            raf.seek(rangeStart);
            byte[] buffer = new byte[4096];
            int totalRead = 0;
            boolean nomore = false;
            do {
                long len;
                if ((len = (long)raf.read(buffer)) > 0L && (long)totalRead + len > rangeFinish - rangeStart + 1L) {
                    len = rangeFinish - rangeStart + 1L - (long)totalRead;
                    nomore = true;
                }
                if (len <= 0L) return;
                out.write(buffer, 0, (int)len);
                totalRead = (int)((long)totalRead + len);
            } while (!nomore);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String highlightStream(String name, File input, String rendererName, String encoding) throws IOException {
        try (FileInputStream input_ = null;){
            input_ = new FileInputStream(input);
            String string = CodeUtils.highlightStream(name, input_, rendererName, encoding);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String highlightStream(String name, String input, String rendererName, String encoding) throws IOException {
        try (FileInputStream input_ = null;){
            input_ = new FileInputStream(input);
            String string = CodeUtils.highlightStream(name, input_, rendererName, encoding);
            return string;
        }
    }

    public static String highlightStream(String name, InputStream input, String rendererName, String encoding) throws IOException {
        Renderer jspRenderer = XhtmlRendererFactory.getRenderer((String)rendererName);
        if (jspRenderer != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            jspRenderer.highlight(name, input, (OutputStream)bos, encoding, true);
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            Tokenizer tokenizer = new Tokenizer((Reader)new InputStreamReader((InputStream)bis, encoding));
            tokenizer.addSymbol(new TokenizerSymbol("EOL", "\n", null, false, false, true, false));
            tokenizer.addSymbol(new TokenizerSymbol("EOL", "\r\n", null, false, false, true, false));
            StringBuilder buffer = new StringBuilder();
            long counter = 0L;
            while (tokenizer.hasMore()) {
                Token tk = tokenizer.nextToken();
                if ("EOL".equals(tk.getName())) {
                    ++counter;
                    buffer.append(tk.getText());
                    continue;
                }
                if (counter <= 0L) continue;
                buffer.append("<span class=\"codeline\">");
                buffer.append("<span class=\"linenum\">");
                buffer.append(CodeUtils.leftPad(Long.toString(counter), 6, "&nbsp;"));
                buffer.append("</span>");
                buffer.append(tk.getText());
                buffer.append("</span>");
            }
            return buffer.toString();
        }
        return null;
    }

    public static String leftPad(String s, int len, String fill) {
        StringBuilder sb = new StringBuilder(len);
        if (s.length() < len) {
            for (int i = s.length(); i < len; ++i) {
                sb.append(fill);
            }
        }
        sb.append(s);
        return sb.toString();
    }

    public static List getNamesForLocale(String baseName, Locale locale) {
        ArrayList<String> result = new ArrayList<String>(3);
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        StringBuilder temp = new StringBuilder(baseName);
        if (language.length() > 0) {
            temp.append('_').append(language);
            result.add(0, temp.toString());
        }
        if (country.length() > 0) {
            temp.append('_').append(country);
            result.add(0, temp.toString());
        }
        if (variant.length() > 0) {
            temp.append('_').append(variant);
            result.add(0, temp.toString());
        }
        return result;
    }
}

