/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.util;

import java.util.ArrayList;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Substitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexUtil {
    private static Logger log = LoggerFactory.getLogger(RegexUtil.class);
    public static final int default_mask = 16;

    public static String[] parser(String src, String regex) {
        String patternStr = regex;
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern pattern = null;
        try {
            pattern = compiler.compile(patternStr, 16);
        }
        catch (MalformedPatternException e) {
            e.printStackTrace();
            return null;
        }
        Perl5Matcher matcher = new Perl5Matcher();
        MatchResult result = null;
        String[] tokens = null;
        boolean match = matcher.matches(src, pattern);
        if (match) {
            result = matcher.getMatch();
            int size = result.groups() - 1;
            tokens = new String[size];
            for (int i = 0; i < size; ++i) {
                tokens[i] = result.group(i + 1);
            }
        }
        return tokens;
    }

    public static String[] matchWithPatternMatcherInput(String src, String regex) {
        String patternStr = regex;
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern pattern = null;
        try {
            pattern = compiler.compile(patternStr, 16);
        }
        catch (MalformedPatternException e) {
            e.printStackTrace();
            return null;
        }
        Perl5Matcher matcher = new Perl5Matcher();
        MatchResult result = null;
        String[] tokens = null;
        ArrayList<String> sets = new ArrayList<String>();
        PatternMatcherInput input = new PatternMatcherInput(src);
        while (matcher.matches(input, pattern)) {
            result = matcher.getMatch();
            int size = result.groups();
            for (int i = 1; i < size; ++i) {
                sets.add(result.group(i));
            }
        }
        tokens = new String[sets.size()];
        sets.toArray(tokens);
        return tokens;
    }

    public static String[] match(String src, String regex) {
        String patternStr = regex;
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern pattern = null;
        try {
            pattern = compiler.compile(patternStr, 16);
        }
        catch (MalformedPatternException e) {
            e.printStackTrace();
            return null;
        }
        Perl5Matcher matcher = new Perl5Matcher();
        MatchResult result = null;
        String[] tokens = null;
        if (matcher.matches(src, pattern)) {
            result = matcher.getMatch();
            int size = result.groups() - 1;
            tokens = new String[size];
            for (int i = 0; i < size; ++i) {
                tokens[i] = result.group(i + 1);
            }
        }
        return tokens;
    }

    public static String[] containWithPatternMatcherInput(String src, String regex) {
        String patternStr = regex;
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern pattern = null;
        try {
            pattern = compiler.compile(patternStr, 16);
        }
        catch (MalformedPatternException e) {
            e.printStackTrace();
            return null;
        }
        Perl5Matcher matcher = new Perl5Matcher();
        MatchResult result = null;
        String[] tokens = null;
        ArrayList<String> sets = new ArrayList<String>();
        PatternMatcherInput input = new PatternMatcherInput(src);
        while (matcher.contains(input, pattern)) {
            result = matcher.getMatch();
            int size = result.groups();
            for (int i = 1; i < size; ++i) {
                sets.add(result.group(i));
            }
        }
        tokens = new String[sets.size()];
        sets.toArray(tokens);
        return tokens;
    }

    public static String[] containWithPatternMatcherInput(String src, String regex, int mask) {
        String patternStr = regex;
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern pattern = null;
        try {
            pattern = compiler.compile(patternStr, mask);
        }
        catch (MalformedPatternException e) {
            e.printStackTrace();
            return null;
        }
        Perl5Matcher matcher = new Perl5Matcher();
        MatchResult result = null;
        String[] tokens = null;
        ArrayList<String> sets = new ArrayList<String>();
        PatternMatcherInput input = new PatternMatcherInput(src);
        while (matcher.contains(input, pattern)) {
            result = matcher.getMatch();
            int size = result.groups();
            for (int i = 1; i < size; ++i) {
                sets.add(result.group(i));
            }
        }
        tokens = new String[sets.size()];
        sets.toArray(tokens);
        return tokens;
    }

    public static String[][] contain2ndReplaceWithPatternMatcherInput(String src, String regex, String substitution) {
        String patternStr = regex;
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern pattern = null;
        try {
            pattern = compiler.compile(patternStr, 16);
        }
        catch (MalformedPatternException e) {
            e.printStackTrace();
            return null;
        }
        Perl5Matcher matcher = new Perl5Matcher();
        MatchResult result = null;
        String[] tokens = null;
        ArrayList<String> sets = new ArrayList<String>();
        PatternMatcherInput input = new PatternMatcherInput(src);
        while (matcher.contains(input, pattern)) {
            result = matcher.getMatch();
            int size = result.groups();
            for (int i = 1; i < size; ++i) {
                sets.add(result.group(i));
            }
        }
        String[][] retvalue = null;
        String newsrc = src;
        if (sets.size() > 0) {
            newsrc = Util.substitute((PatternMatcher)matcher, (Pattern)pattern, (Substitution)new Perl5Substitution(substitution), (String)src, (int)-1);
        }
        tokens = new String[sets.size()];
        sets.toArray(tokens);
        retvalue = new String[][]{{newsrc}, tokens};
        return retvalue;
    }

    public static String[][] contain2ndReplaceWithPatternMatcherInput(String src, String regex, String substitution, int MASK) {
        String patternStr = regex;
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern pattern = null;
        try {
            pattern = compiler.compile(patternStr, MASK);
        }
        catch (MalformedPatternException e) {
            e.printStackTrace();
            return null;
        }
        Perl5Matcher matcher = new Perl5Matcher();
        MatchResult result = null;
        String[] tokens = null;
        ArrayList<String> sets = new ArrayList<String>();
        PatternMatcherInput input = new PatternMatcherInput(src);
        while (matcher.contains(input, pattern)) {
            result = matcher.getMatch();
            int size = result.groups();
            for (int i = 1; i < size; ++i) {
                sets.add(result.group(i));
            }
        }
        String[][] retvalue = null;
        String newsrc = src;
        if (sets.size() > 0) {
            newsrc = Util.substitute((PatternMatcher)matcher, (Pattern)pattern, (Substitution)new Perl5Substitution(substitution), (String)src, (int)-1);
        }
        tokens = new String[sets.size()];
        sets.toArray(tokens);
        retvalue = new String[][]{{newsrc}, tokens};
        return retvalue;
    }

    public static String[] contain(String src, String regex) {
        String patternStr = regex;
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern pattern = null;
        try {
            pattern = compiler.compile(patternStr, 16);
        }
        catch (MalformedPatternException e) {
            e.printStackTrace();
            return null;
        }
        Perl5Matcher matcher = new Perl5Matcher();
        MatchResult result = null;
        String[] tokens = null;
        if (matcher.contains(src, pattern)) {
            result = matcher.getMatch();
            int size = result.groups() - 1;
            tokens = new String[size];
            for (int i = 0; i < size; ++i) {
                tokens[i] = result.group(i + 1);
            }
        }
        return tokens;
    }

    public static boolean isContain(String src, String regex) {
        if (src == null) {
            return false;
        }
        String patternStr = regex;
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern pattern = null;
        try {
            pattern = compiler.compile(patternStr, 16);
        }
        catch (MalformedPatternException e) {
            e.printStackTrace();
            return false;
        }
        Perl5Matcher matcher = new Perl5Matcher();
        return matcher.contains(src, pattern);
    }

    public static boolean isMatch(String src, String regex) {
        if (src == null) {
            return false;
        }
        boolean flag = false;
        String patternStr = regex;
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern pattern = null;
        try {
            pattern = compiler.compile(patternStr, 16);
        }
        catch (MalformedPatternException e) {
            e.printStackTrace();
            return false;
        }
        Perl5Matcher matcher = new Perl5Matcher();
        flag = matcher.matches(src, pattern);
        return flag;
    }

    public static void replace(String content, String pattern, String newstr) {
    }
}

