/*
 * Decompiled with CFR 0.152.
 */
package mybatis.mate.config;

import com.zaxxer.hikari.HikariDataSource;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import mybatis.mate.config.DataSourceProperty;
import mybatis.mate.config.HikariConfig;
import mybatis.mate.strategy.IShardingStrategy;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

public class ShardingConfig
implements Serializable {
    private String primary;
    private boolean health;
    private IShardingStrategy dbShardingStrategy;
    private Map<String, List<DataSourceProperty>> datasource = new LinkedHashMap<String, List<DataSourceProperty>>();
    @NestedConfigurationProperty
    private HikariConfig hikari;

    public boolean enable() {
        return null != this.primary;
    }

    public DataSource toDataSource(DataSourceProperty dataSourceProperty) {
        if (null == this.hikari) {
            this.hikari = new HikariConfig();
        }
        this.hikari.setDriverClassName(dataSourceProperty.getDriverClassName());
        this.hikari.setJdbcUrl(dataSourceProperty.getUrl());
        this.hikari.setUsername(dataSourceProperty.getUsername());
        this.hikari.setPassword(dataSourceProperty.getPassword());
        this.hikari.setDataSourceJNDI(dataSourceProperty.getJndiName());
        this.hikari.setSchema(dataSourceProperty.getSchema());
        return new HikariDataSource((com.zaxxer.hikari.HikariConfig)this.hikari);
    }

    public String getPrimary() {
        return this.primary;
    }

    public boolean isHealth() {
        return this.health;
    }

    public IShardingStrategy getDbShardingStrategy() {
        return this.dbShardingStrategy;
    }

    public Map<String, List<DataSourceProperty>> getDatasource() {
        return this.datasource;
    }

    public HikariConfig getHikari() {
        return this.hikari;
    }

    public void setPrimary(String string) {
        this.primary = string;
    }

    public void setHealth(boolean bl) {
        this.health = bl;
    }

    public void setDbShardingStrategy(IShardingStrategy iShardingStrategy) {
        this.dbShardingStrategy = iShardingStrategy;
    }

    public void setDatasource(Map<String, List<DataSourceProperty>> map) {
        this.datasource = map;
    }

    public void setHikari(HikariConfig hikariConfig) {
        this.hikari = hikariConfig;
    }
}

