/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.qianfan.util.http;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SSEIterator
implements Iterator<String>,
Closeable {
    private final BufferedReader reader;
    private final AutoCloseable closeable;
    private String nextLine = null;

    public SSEIterator(InputStream stream, AutoCloseable closeable) {
        this.reader = new BufferedReader(new InputStreamReader(stream));
        this.closeable = closeable;
    }

    @Override
    public boolean hasNext() {
        if (this.nextLine != null) {
            return true;
        }
        try {
            this.nextLine = this.reader.readLine();
            if (this.nextLine == null) {
                this.silentlyClose();
            }
            return this.nextLine != null;
        }
        catch (Exception e) {
            this.silentlyClose();
            return false;
        }
    }

    @Override
    public String next() {
        if (this.nextLine != null || this.hasNext()) {
            String lineToReturn = this.nextLine;
            this.nextLine = null;
            return lineToReturn;
        }
        this.silentlyClose();
        throw new NoSuchElementException();
    }

    private void silentlyClose() {
        try {
            this.closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.closeable.close();
        }
        catch (Exception e) {
            throw new IOException("Failed to close sseIterator", e);
        }
    }
}

