/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.qianfan.core.builder;

import com.baidubce.qianfan.model.chat.FunctionCall;
import com.baidubce.qianfan.model.chat.Message;
import java.util.ArrayList;
import java.util.List;

public class MessageBuilder {
    private List<Message> messages = new ArrayList<Message>();

    public MessageBuilder add(Message message) {
        this.messages.add(message);
        return this;
    }

    public MessageBuilder add(String role, String content) {
        this.messages.add(new Message().setRole(role).setContent(content));
        return this;
    }

    public MessageBuilder addUser(String content) {
        this.messages.add(new Message().setRole("user").setContent(content));
        return this;
    }

    public MessageBuilder addAssistant(String content) {
        this.messages.add(new Message().setRole("assistant").setContent(content));
        return this;
    }

    public MessageBuilder addFunctionCall(FunctionCall functionCall) {
        this.messages.add(new Message().setRole("assistant").setFunctionCall(functionCall));
        return this;
    }

    public MessageBuilder addFunctionCallResult(String name, String content) {
        this.messages.add(new Message().setRole("function").setName(name).setContent(content));
        return this;
    }

    public MessageBuilder messages(List<Message> messages) {
        this.messages = messages;
        return this;
    }

    public List<Message> build() {
        return this.messages;
    }
}

