/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.qianfan.core.builder;

import com.baidubce.qianfan.Qianfan;
import com.baidubce.qianfan.core.builder.ExtraParameterBuilder;
import com.baidubce.qianfan.model.exception.ValidationException;
import java.util.Map;

abstract class BaseBuilder<T extends BaseBuilder<T>> {
    private Qianfan qianfan;
    private String model;
    private String endpoint;
    private String userId;
    private ExtraParameterBuilder extraParameterBuilder = new ExtraParameterBuilder();

    protected BaseBuilder() {
    }

    protected BaseBuilder(Qianfan qianfan) {
        this.qianfan = qianfan;
    }

    public T addExtraParameter(String key, Object value) {
        this.extraParameterBuilder.add(key, value);
        return (T)this;
    }

    public T extraParameters(ExtraParameterBuilder extraParameters) {
        this.extraParameterBuilder = extraParameters;
        return (T)this;
    }

    public T extraParameters(Map<String, Object> extraParameters) {
        this.extraParameterBuilder.extraParameters(extraParameters);
        return (T)this;
    }

    public T model(String model) {
        this.model = model;
        return (T)this;
    }

    public T endpoint(String endpoint) {
        this.endpoint = endpoint;
        return (T)this;
    }

    public T userId(String userId) {
        this.userId = userId;
        return (T)this;
    }

    protected Qianfan getQianfan() {
        if (this.qianfan == null) {
            throw new ValidationException("Qianfan client is not set. please create builder from Qianfan client, or use build() instead of execute() to get Request and send it by yourself.");
        }
        return this.qianfan;
    }

    protected String getModel() {
        return this.model;
    }

    protected String getEndpoint() {
        return this.endpoint;
    }

    protected String getUserId() {
        return this.userId;
    }

    protected Map<String, Object> getExtraParameters() {
        return this.extraParameterBuilder.build();
    }
}

