/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.qianfan.core.auth;

import com.baidubce.qianfan.core.QianfanConfig;
import com.baidubce.qianfan.core.auth.IAuth;
import com.baidubce.qianfan.model.exception.AuthException;
import com.baidubce.qianfan.util.Pair;
import com.baidubce.qianfan.util.StringUtils;
import com.baidubce.qianfan.util.http.HttpRequest;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class IAMAuth
implements IAuth {
    private static final String HMAC_SHA256 = "HmacSHA256";
    private static final List<String> HEADER_TO_SIGN = Arrays.asList("host", "x-bce-date");
    private static final String SESSION_KEY_TEMPLATE = "bce-auth-v1/%s/%s/%s";
    private static final String SIGNATURE_TEMPLATE = "%s\n%s\n%s\n%s";
    private static final String AUTHORIZATION_TEMPLATE = "%s/%s/%s";
    private final String accessKey;
    private final String secretKey;

    public IAMAuth(String accessKey, String secretKey) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }

    @Override
    public HttpRequest signRequest(HttpRequest request) {
        try {
            return request.addHeader("Authorization", this.sign(request.getMethod(), request.getUrl())).addHeader("X-Bce-Date", this.getTimestamp());
        }
        catch (Exception e) {
            throw new AuthException("Failed to sign request", e);
        }
    }

    private String sign(String method, String url) {
        int expirationInSeconds = QianfanConfig.getIamSignExpirationSec();
        String rawSessionKey = String.format(SESSION_KEY_TEMPLATE, this.accessKey, this.getTimestamp(), expirationInSeconds);
        String sessionKey = this.hash(rawSessionKey, this.secretKey);
        URI uri = URI.create(url);
        String canonicalQueryString = this.queryStringCanonicalization(uri.getQuery());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("host", uri.getHost());
        headers.put("x-bce-date", this.getTimestamp());
        Pair<String, String[]> rv = this.headersCanonicalization(headers);
        String canonicalHeaders = (String)rv.first;
        String signedHeaders = String.join((CharSequence)";", (CharSequence[])rv.second);
        String rawSignature = String.format(SIGNATURE_TEMPLATE, method, uri.getPath(), canonicalQueryString, canonicalHeaders);
        String signature = this.hash(rawSignature, sessionKey);
        return String.format(AUTHORIZATION_TEMPLATE, rawSessionKey, signedHeaders, signature);
    }

    private String getTimestamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(new Date());
    }

    private String queryStringCanonicalization(String queryString) {
        if (StringUtils.isEmpty(queryString)) {
            return "";
        }
        HashMap<String, String> params = new HashMap<String, String>();
        for (String param : queryString.split("&")) {
            String[] pair = param.split("=");
            params.put(pair[0], pair[1]);
        }
        return params.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> (String)entry.getKey() + "=" + this.normalize(entry.getValue().toString(), true)).collect(Collectors.joining("&"));
    }

    private Pair<String, String[]> headersCanonicalization(Map<String, String> headers) {
        ArrayList canonicalHeaders = new ArrayList();
        ArrayList signedHeadersList = new ArrayList();
        headers.entrySet().stream().filter(entry -> StringUtils.isNotEmpty((String)entry.getValue())).forEach(entry -> {
            String key = ((String)entry.getKey()).toLowerCase();
            String value = ((String)entry.getValue()).trim();
            if (HEADER_TO_SIGN.contains(key)) {
                canonicalHeaders.add(this.normalize(key, false) + ":" + this.normalize(value, false));
                signedHeadersList.add(key);
            }
        });
        Collections.sort(canonicalHeaders);
        Collections.sort(signedHeadersList);
        return new Pair<String, String[]>(String.join((CharSequence)"\n", canonicalHeaders), signedHeadersList.toArray(new String[0]));
    }

    private String normalize(String string, boolean encodingSlash) {
        try {
            String result = URLEncoder.encode(string, StandardCharsets.UTF_8.name()).replace("+", "%20").replace("%21", "!").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%2A", "*");
            if (!encodingSlash) {
                result = result.replace("%2F", "/");
            }
            return result;
        }
        catch (UnsupportedEncodingException ignored) {
            return "";
        }
    }

    private String hash(String data, String key) {
        try {
            Mac sha256Hmac = Mac.getInstance(HMAC_SHA256);
            sha256Hmac.init(new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), HMAC_SHA256));
            byte[] hashedBytes = sha256Hmac.doFinal(data.getBytes(StandardCharsets.UTF_8));
            return StringUtils.bytesToHexString(hashedBytes);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ignored) {
            return "";
        }
    }
}

