/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.qianfan;

import com.baidubce.qianfan.core.ModelEndpointRetriever;
import com.baidubce.qianfan.core.QianfanConfig;
import com.baidubce.qianfan.core.RateLimiter;
import com.baidubce.qianfan.core.StreamIterator;
import com.baidubce.qianfan.core.auth.Auth;
import com.baidubce.qianfan.core.auth.IAuth;
import com.baidubce.qianfan.model.ApiErrorResponse;
import com.baidubce.qianfan.model.BaseRequest;
import com.baidubce.qianfan.model.BaseResponse;
import com.baidubce.qianfan.model.RateLimitConfig;
import com.baidubce.qianfan.model.RetryConfig;
import com.baidubce.qianfan.model.exception.ApiException;
import com.baidubce.qianfan.model.exception.QianfanException;
import com.baidubce.qianfan.model.exception.RequestException;
import com.baidubce.qianfan.util.Json;
import com.baidubce.qianfan.util.StringUtils;
import com.baidubce.qianfan.util.function.ThrowingFunction;
import com.baidubce.qianfan.util.http.HttpClient;
import com.baidubce.qianfan.util.http.HttpRequest;
import com.baidubce.qianfan.util.http.HttpResponse;
import com.baidubce.qianfan.util.http.SSEIterator;

class QianfanClient {
    private static final String SDK_VERSION = "0.0.9";
    private static final String QIANFAN_URL_TEMPLATE = "%s/rpc/2.0/ai_custom/v1/wenxinworkshop%s";
    private static final String EXTRA_PARAM_REQUEST_SOURCE = "request_source";
    private static final String REQUEST_SOURCE_PREFIX = "qianfan_java_sdk_v";
    private static final String REQUEST_SOURCE = "qianfan_java_sdk_v0.0.9";
    private final IAuth auth;
    private final ModelEndpointRetriever endpointRetriever;
    private RetryConfig retryConfig;
    private RateLimiter rateLimiter;

    public QianfanClient() {
        this(Auth.create());
    }

    public QianfanClient(String accessKey, String secretKey) {
        this(Auth.create(accessKey, secretKey));
    }

    public QianfanClient(String type, String accessKey, String secretKey) {
        this(Auth.create(type, accessKey, secretKey));
    }

    private QianfanClient(IAuth auth) {
        this.auth = auth;
        this.endpointRetriever = new ModelEndpointRetriever(auth);
        this.retryConfig = QianfanConfig.getRetryConfig();
        this.rateLimiter = new RateLimiter(QianfanConfig.getRateLimitConfig());
    }

    public void setRetryConfig(RetryConfig retryConfig) {
        this.retryConfig = retryConfig;
    }

    public void setRateLimitConfig(RateLimitConfig rateLimitConfig) {
        this.rateLimiter = new RateLimiter(rateLimitConfig);
    }

    public <T extends BaseResponse<T>, U extends BaseRequest<U>> T request(BaseRequest<U> request, Class<T> responseClass) {
        return (T)this.request(request, req -> req.executeJson(responseClass), resp -> ((BaseResponse)resp.getBody()).setHeaders(resp.getHeaders()));
    }

    public <T extends BaseResponse<T>, U extends BaseRequest<U>> StreamIterator<T> requestStream(BaseRequest<U> request, Class<T> responseClass) {
        return this.request(request, HttpRequest::executeSSE, resp -> new StreamIterator(resp.getHeaders(), (SSEIterator)resp.getBody(), responseClass));
    }

    private <T extends BaseRequest<T>> HttpRequest createHttpRequest(BaseRequest<T> baseRequest) {
        String finalEndpoint = this.endpointRetriever.getEndpoint(baseRequest.getType(), baseRequest.getModel(), baseRequest.getEndpoint());
        String url = String.format(QIANFAN_URL_TEMPLATE, QianfanConfig.getBaseUrl(), finalEndpoint);
        baseRequest.getExtraParameters().put(EXTRA_PARAM_REQUEST_SOURCE, REQUEST_SOURCE);
        HttpRequest request = HttpClient.request().post(url).body(baseRequest);
        return this.auth.signRequest(request);
    }

    private <T extends BaseRequest<T>, U, V, E extends Exception> V request(BaseRequest<T> request, ThrowingFunction<HttpRequest, HttpResponse<U>, E> reqProcessor, ThrowingFunction<HttpResponse<U>, V, E> respProcessor) {
        for (int i = 0; i < this.retryConfig.getRetryCount(); ++i) {
            try {
                return this.innerRequest(request, reqProcessor, respProcessor);
            }
            catch (RuntimeException ex) {
                if (ex instanceof ApiException) {
                    Integer errorCode = ((ApiException)ex).getErrorResponse().getErrorCode();
                    if (!this.retryConfig.getRetryErrCodes().contains(errorCode)) {
                        throw ex;
                    }
                }
                if (i == this.retryConfig.getRetryCount() - 1) {
                    throw ex;
                }
                this.backoffSleep(i, this.retryConfig.getBackoffFactor(), this.retryConfig.getMaxWaitInterval());
                continue;
            }
        }
        throw new IllegalStateException("Request failed with unknown error");
    }

    private <T extends BaseRequest<T>, U, V, E extends Exception> V innerRequest(BaseRequest<T> request, ThrowingFunction<HttpRequest, HttpResponse<U>, E> reqProcessor, ThrowingFunction<HttpResponse<U>, V, E> respProcessor) {
        try {
            ApiErrorResponse errorResp;
            HttpRequest httpRequest = this.createHttpRequest(request);
            this.rateLimiter.acquire(httpRequest.getUrl());
            HttpResponse<U> resp = reqProcessor.apply(httpRequest);
            if (resp.getCode() != 200) {
                throw new RequestException(String.format("Request failed with status code %d: %s", resp.getCode(), resp.getStringBody()));
            }
            String contentType = resp.getHeaders().getOrDefault("Content-Type", "");
            if (contentType.startsWith("application/json") && StringUtils.isNotEmpty((errorResp = (ApiErrorResponse)Json.deserialize(resp.getStringBody(), ApiErrorResponse.class)).getErrorMsg())) {
                throw new ApiException("Request failed with api error", errorResp);
            }
            return respProcessor.apply(resp);
        }
        catch (QianfanException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RequestException(String.format("Request failed: %s", e.getMessage()), e);
        }
    }

    private void backoffSleep(int retryCount, double backoffFactor, int maxWaitInterval) throws RequestException {
        try {
            long delay = (long)(Math.pow(2.0, retryCount) * backoffFactor * 1000.0);
            Thread.sleep(Math.min(delay, (long)maxWaitInterval * 1000L));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RequestException("Request failed: retry delay interrupted", e);
        }
    }
}

