/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.scs;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.scs.ScsArgumentUtil;
import com.baidubce.services.scs.ScsClientConfiguration;
import com.baidubce.services.scs.model.InstanceListRequest;
import com.baidubce.services.scs.model.InstanceListResponse;
import com.baidubce.services.scs.model.ScsBilling;
import com.baidubce.services.scs.model.ScsChangeConfigRequest;
import com.baidubce.services.scs.model.ScsCreateRequest;
import com.baidubce.services.scs.model.ScsCreateResponse;
import com.baidubce.services.scs.model.ScsDeleteInstanceRequest;
import com.baidubce.services.scs.model.ScsFlushInstanceRequest;
import com.baidubce.services.scs.model.ScsInstanceDetailRequest;
import com.baidubce.services.scs.model.ScsInstanceDetailResponse;
import com.baidubce.services.scs.model.ScsListOrder;
import com.baidubce.services.scs.model.ScsParamListRequest;
import com.baidubce.services.scs.model.ScsParamListResponse;
import com.baidubce.services.scs.model.ScsParamModifyRequest;
import com.baidubce.services.scs.model.ScsRecoverInstanceRequest;
import com.baidubce.services.scs.model.ScsReleaseInstanceRequest;
import com.baidubce.services.scs.model.ScsRenewInstanceRequest;
import com.baidubce.services.scs.model.ScsRenewInstanceResponse;
import com.baidubce.services.scs.model.ScsReservation;
import com.baidubce.services.scs.model.ScsSlowLogAction;
import com.baidubce.services.scs.model.ScsSlowLogModifyRequest;
import com.baidubce.services.scs.model.ScsSlowLogRequest;
import com.baidubce.services.scs.model.ScsSlowLogResponse;
import com.baidubce.services.scs.model.ScsSubnetRequest;
import com.baidubce.services.scs.model.ScsSubnetResponse;
import com.baidubce.services.scs.model.ScsSwapDomainRequest;
import com.baidubce.services.scs.model.ScsZoneRequest;
import com.baidubce.services.scs.model.ScsZoneResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ScsClient
extends AbstractBceClient {
    private static final HttpResponseHandler[] SCS_HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};
    private static final String SCS_AK_KEY = "X-Bce-Accesskey";
    private static final String[] HEADERS_TO_SIGN = new String[]{"host", "x-bce-date"};
    private static final String INSTANCE_ID = "instanceId";
    private static final String CLIENT_TOKEN = "clientToken";

    public ScsClient() {
        this(new ScsClientConfiguration());
    }

    public ScsClient(BceClientConfiguration config) {
        this(config, SCS_HANDLERS);
    }

    public ScsClient(BceClientConfiguration config, HttpResponseHandler[] responseHandlers) {
        super(config, responseHandlers);
    }

    private InternalRequest createRequest(AbstractBceRequest request, HttpMethodName method, String ... pathVariables) {
        return this.createRequest(null, request, method, pathVariables);
    }

    private InternalRequest createRequest(String version, AbstractBceRequest request, HttpMethodName method, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        if (StringUtils.isEmpty((String)version)) {
            path.add("v2");
        } else {
            path.add(version);
        }
        if (pathVariables != null) {
            Collections.addAll(path, pathVariables);
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[0]));
        InternalRequest internalRequest = new InternalRequest(method, uri);
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        internalRequest.setSignOptions(signOptions);
        internalRequest.setCredentials(request.getRequestCredentials());
        return internalRequest;
    }

    public ScsCreateResponse createInstance(ScsCreateRequest request) {
        ScsBilling billing;
        Validate.checkNotNull(request, "request should not be null.");
        if (StringUtils.isEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if ((billing = request.getBilling()) == null) {
            billing = this.defaultScsBilling();
        }
        request.setBilling(billing);
        ScsArgumentUtil.checkBilling(billing);
        ScsArgumentUtil.checkClusterName(request.getInstanceName());
        ScsArgumentUtil.checkString(request.getNodeType(), "nodeType");
        int port = request.getPort();
        ScsArgumentUtil.checkClusterPort(port);
        ScsArgumentUtil.checkString(request.getEngineVersion(), "EngineVersion");
        ScsArgumentUtil.checkPurchaseCount(request.getPurchaseCount());
        ScsArgumentUtil.checkNull((Object)request.getClusterType(), "ClusterType");
        String autoRenewTimeUnit = request.getAutoRenewTimeUnit();
        ScsArgumentUtil.checkAutoRenewTimeUnit(autoRenewTimeUnit);
        ScsArgumentUtil.checkAutoRenewTime(request.getAutoRenewTime(), autoRenewTimeUnit);
        String clientAuth = request.getClientAuth().trim();
        if (StringUtils.isNotEmpty((String)clientAuth)) {
            ScsArgumentUtil.checkClientAuth(clientAuth);
            try {
                String password = this.aes128WithFirst16Char(clientAuth, this.config.getCredentials().getSecretKey());
                request.setClientAuth(password);
            }
            catch (GeneralSecurityException e) {
                throw new BceClientException("encryption error");
            }
        }
        String[] paths = new String[]{"instance"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, paths);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        internalRequest.addHeader(SCS_AK_KEY, this.config.getCredentials().getAccessKeyId());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, ScsCreateResponse.class);
    }

    public AbstractBceResponse deleteInstance(ScsDeleteInstanceRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        String id = request.getInstanceId();
        ScsArgumentUtil.checkString(id, INSTANCE_ID);
        String[] paths = new String[]{"instance", id};
        InternalRequest internalRequest = this.createRequest("v1", request, HttpMethodName.DELETE, paths);
        return this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ScsRenewInstanceResponse renewInstance(ScsRenewInstanceRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        if (CollectionUtils.isEmpty(request.getInstanceIds())) {
            throw new IllegalArgumentException("Please set the instance id when renew instance");
        }
        if (request.getDuration() <= 0) {
            throw new IllegalArgumentException("The duration must more than one month");
        }
        String[] paths = new String[]{"instance", "renew"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, paths);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, ScsRenewInstanceResponse.class);
    }

    public AbstractBceResponse recoverInstance(ScsRecoverInstanceRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        if (CollectionUtils.isEmpty(request.getInstanceIds())) {
            throw new IllegalArgumentException("Please set the instance ids when recover instance");
        }
        String[] paths = new String[]{"recycler", "recover"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, paths);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public InstanceListResponse getInstanceList(InstanceListRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, "instance");
        if (StringUtils.isNotEmpty((String)request.getMarker())) {
            internalRequest.addParameter("marker", request.getMarker());
            Integer maxKeys = request.getMaxKeys();
            if (maxKeys != null) {
                if (maxKeys > 1000) {
                    throw new IllegalArgumentException("maxKeys can not be greater than 1000");
                }
                internalRequest.addParameter("maxKeys", String.valueOf(maxKeys));
            }
        }
        return this.invokeHttpClient(internalRequest, InstanceListResponse.class);
    }

    public ScsInstanceDetailResponse getInstanceDetail(ScsInstanceDetailRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        String instanceId = request.getInstanceId();
        ScsArgumentUtil.checkString(instanceId, INSTANCE_ID);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, "instance", instanceId);
        return this.invokeHttpClient(internalRequest, ScsInstanceDetailResponse.class);
    }

    public ScsParamListResponse getParamList(ScsParamListRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        String id = request.getInstanceId();
        ScsArgumentUtil.checkString(id, INSTANCE_ID);
        HttpMethodName get = HttpMethodName.GET;
        InternalRequest internalRequest = this.createRequest(request, get, "instance", id, "parameter");
        return this.invokeHttpClient(internalRequest, ScsParamListResponse.class);
    }

    public AbstractBceResponse modifyScsParameter(ScsParamModifyRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        String id = request.getInstanceId();
        ScsArgumentUtil.checkString(id, INSTANCE_ID);
        if (StringUtils.isEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        String[] paths = new String[]{"instance", id, "parameter"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, paths);
        internalRequest.addParameter(INSTANCE_ID, id);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public AbstractBceResponse changeScsInstance(ScsChangeConfigRequest request) {
        String nodeType;
        Validate.checkNotNull(request, "request should not be null.");
        String id = request.getInstanceId();
        ScsArgumentUtil.checkString(id, INSTANCE_ID);
        if (StringUtils.isEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (StringUtils.isEmpty((String)(nodeType = request.getNodeType()))) {
            throw new BceClientException("Please set nodeType");
        }
        Integer shardNum = request.getShardNum();
        if (shardNum != null && shardNum <= 0) {
            throw new BceClientException("ShardNum must be at least 1");
        }
        ScsInstanceDetailRequest detailRequest = new ScsInstanceDetailRequest();
        detailRequest.setInstanceId(id);
        ScsInstanceDetailResponse detailResponse = this.getInstanceDetail(detailRequest);
        if (detailResponse == null) {
            throw new BceClientException("Can not get instance detail");
        }
        String detailNodeType = detailResponse.getNodeType();
        Integer detailShardNum = detailResponse.getShardNum();
        if (nodeType.equals(detailNodeType) && shardNum != null && shardNum.equals(detailShardNum)) {
            throw new BceClientException("NodeType and shardNum has not changed");
        }
        if (!nodeType.equals(detailNodeType) && shardNum != null && detailShardNum != null && !shardNum.equals(detailShardNum)) {
            throw new BceClientException("NodeType and shareNum can not change together");
        }
        ScsBilling billing = request.getBilling();
        if (billing == null) {
            billing = this.defaultScsBilling();
        }
        ScsArgumentUtil.checkBilling(billing);
        String[] paths = new String[]{"instance", id, "change"};
        InternalRequest internalRequest = this.createRequest("v1", request, HttpMethodName.PUT, paths);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    private void fillPayload(InternalRequest internalRequest, AbstractBceRequest request) {
        if (HttpMethodName.POST == internalRequest.getHttpMethod() || HttpMethodName.PUT == internalRequest.getHttpMethod()) {
            byte[] requestJson;
            String strJson = JsonUtils.toJsonString(request);
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    private String generateClientToken() {
        return UUID.randomUUID().toString();
    }

    private ScsBilling defaultScsBilling() {
        ScsBilling billing = new ScsBilling();
        billing.setPaymentTiming("Postpaid");
        return billing;
    }

    private ScsBilling defaultScsBillingWithReservation() {
        ScsBilling billing = new ScsBilling();
        billing.setPaymentTiming("Prepaid");
        ScsReservation reservation = new ScsReservation();
        reservation.setReservationLength(1);
        reservation.setReservationTimeUnit("month");
        return billing;
    }

    private String aes128WithFirst16Char(String content, String privateKey) throws GeneralSecurityException {
        byte[] crypted = null;
        SecretKeySpec skey = new SecretKeySpec(privateKey.substring(0, 16).getBytes(), "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(1, skey);
        crypted = cipher.doFinal(content.getBytes());
        return new String(Hex.encodeHex((byte[])crypted));
    }

    public AbstractBceResponse swapDomain(ScsSwapDomainRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        ScsArgumentUtil.checkString(request.getSourceInstanceId(), "sourceInstanceId");
        ScsArgumentUtil.checkString(request.getTargetInstanceId(), "targetInstanceId");
        String[] paths = new String[]{"instance", "swapDomain"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, paths);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public AbstractBceResponse flushInstance(ScsFlushInstanceRequest request) throws GeneralSecurityException {
        Validate.checkNotNull(request, "request should not be null.");
        String instanceId = request.getInstanceId();
        ScsArgumentUtil.checkString(instanceId, INSTANCE_ID);
        if (StringUtils.isNotEmpty((String)request.getPassword())) {
            String signedPwd = this.aes128WithFirst16Char(request.getPassword(), this.config.getCredentials().getSecretKey());
            request.setPassword(signedPwd);
        }
        ScsArgumentUtil.checkDbIndex(request.getDbIndex());
        String[] paths = new String[]{"instance", instanceId, "flush"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, paths);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ScsSlowLogResponse getSlowLog(ScsSlowLogRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        ScsArgumentUtil.checkString(request.getInstanceId(), INSTANCE_ID);
        ScsArgumentUtil.checkNull((Object)request.getType(), "type");
        ScsArgumentUtil.checkNull(request.getStartTime(), "startTime");
        ScsArgumentUtil.checkPage(request.getPageNow(), request.getPageSize());
        String[] paths = new String[]{"instance", "cloudlog", request.getInstanceId()};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, paths);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        internalRequest.addParameter("type", request.getType().getValue());
        internalRequest.addParameter("startTime", dateFormat.format(request.getStartTime()));
        internalRequest.addParameter("pageNow", String.valueOf(request.getPageNow()));
        if (request.getPageSize() == null) {
            request.setPageSize(1000);
        }
        internalRequest.addParameter("pageSize", String.valueOf(request.getPageSize()));
        this.setSlowLogParameter(internalRequest, request, dateFormat);
        return this.invokeHttpClient(internalRequest, ScsSlowLogResponse.class);
    }

    private void setSlowLogParameter(InternalRequest internalRequest, ScsSlowLogRequest request, SimpleDateFormat dateFormat) {
        ScsListOrder listOrder;
        String nodeId;
        String shardId;
        Date endTime = request.getEndTime();
        if (endTime != null) {
            internalRequest.addParameter("endTime", dateFormat.format(endTime));
        }
        if (StringUtils.isNotEmpty((String)(shardId = request.getShardId()))) {
            internalRequest.addParameter("shardId", shardId);
        }
        if (StringUtils.isNotEmpty((String)(nodeId = request.getNodeId()))) {
            internalRequest.addParameter("nodeId", nodeId);
        }
        if ((listOrder = request.getListOrder()) != null) {
            internalRequest.addParameter("listOrder", listOrder.getValue());
        }
    }

    public AbstractBceResponse modifySlowLog(ScsSlowLogModifyRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        String instanceId = request.getInstanceId();
        ScsArgumentUtil.checkString(instanceId, INSTANCE_ID);
        ScsSlowLogAction action = request.getAction();
        ScsArgumentUtil.checkNull((Object)action, "action");
        String[] paths = new String[]{"cloudlog", instanceId, "modify"};
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, paths);
        internalRequest.addParameter("action", action.getValue());
        return this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ScsZoneResponse getZoneList() {
        ScsZoneRequest request = new ScsZoneRequest();
        String[] paths = new String[]{"zone"};
        InternalRequest internalRequest = this.createRequest("v1", request, HttpMethodName.GET, paths);
        return this.invokeHttpClient(internalRequest, ScsZoneResponse.class);
    }

    public ScsSubnetResponse getSubnetList(ScsSubnetRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        String[] paths = new String[]{"subnet"};
        InternalRequest internalRequest = this.createRequest("v1", request, HttpMethodName.GET, paths);
        if (StringUtils.isNotEmpty((String)request.getVpcId())) {
            internalRequest.addParameter("vpcId", request.getVpcId());
        }
        if (StringUtils.isNotEmpty((String)request.getZoneName())) {
            internalRequest.addParameter("zoneName", request.getZoneName());
        }
        return this.invokeHttpClient(internalRequest, ScsSubnetResponse.class);
    }

    public AbstractBceResponse releaseInstance(ScsReleaseInstanceRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        ScsArgumentUtil.checkString(request.getInstanceId(), INSTANCE_ID);
        String[] paths = new String[]{"instance", request.getInstanceId()};
        InternalRequest internalRequest = this.createRequest("v1", request, HttpMethodName.DELETE, paths);
        return this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }
}

