/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.iotdmp;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.model.GenericAccountRequest;
import com.baidubce.services.iotdmp.model.CommonListRequest;
import com.baidubce.services.iotdmp.model.CommonResult;
import com.baidubce.services.iotdmp.model.alarm.AlarmRecordInfo;
import com.baidubce.services.iotdmp.model.alarm.AlarmRuleInfo;
import com.baidubce.services.iotdmp.model.alarm.BatchDeleteAlarmRuleRequest;
import com.baidubce.services.iotdmp.model.alarm.BatchProcessAlarmRecordRequest;
import com.baidubce.services.iotdmp.model.alarm.CreateAlarmRuleRequest;
import com.baidubce.services.iotdmp.model.alarm.ListAlarmRecordRequest;
import com.baidubce.services.iotdmp.model.alarm.ListAlarmRecordResponse;
import com.baidubce.services.iotdmp.model.alarm.ListAlarmRuleResponse;
import com.baidubce.services.iotdmp.model.alarm.TriggerAlarmRequest;
import com.baidubce.services.iotdmp.model.alarm.UpdateAlarmRuleRequest;
import com.baidubce.services.iotdmp.model.c2c.ComputationSourceResponse;
import com.baidubce.services.iotdmp.model.component.BindComponentRequest;
import com.baidubce.services.iotdmp.model.component.ListBindComponentResponse;
import com.baidubce.services.iotdmp.model.device.AuthRequest;
import com.baidubce.services.iotdmp.model.device.AuthType;
import com.baidubce.services.iotdmp.model.device.BatchCreateDeviceRequest;
import com.baidubce.services.iotdmp.model.device.BatchDeleteDeviceRequest;
import com.baidubce.services.iotdmp.model.device.CreateDeviceRequest;
import com.baidubce.services.iotdmp.model.device.DeviceInfo;
import com.baidubce.services.iotdmp.model.device.DeviceKey;
import com.baidubce.services.iotdmp.model.device.DeviceResourcesConnectionInfo;
import com.baidubce.services.iotdmp.model.device.GetDeviceConnectionInfoRequest;
import com.baidubce.services.iotdmp.model.device.ListDeviceKeyRequest;
import com.baidubce.services.iotdmp.model.device.ListDeviceRequest;
import com.baidubce.services.iotdmp.model.device.ListDeviceResponse;
import com.baidubce.services.iotdmp.model.device.ListDeviceStatesResponse;
import com.baidubce.services.iotdmp.model.device.UpdateDeviceRequest;
import com.baidubce.services.iotdmp.model.device.UpdateDeviceStateRequest;
import com.baidubce.services.iotdmp.model.device.batch.BatchDownloadMqtt;
import com.baidubce.services.iotdmp.model.device.batch.BatchInfoResponse;
import com.baidubce.services.iotdmp.model.device.batch.GetBatchPageResponse;
import com.baidubce.services.iotdmp.model.device.batch.GetBatchTuplesResponse;
import com.baidubce.services.iotdmp.model.device.evs.AddEvsDeviceRequest;
import com.baidubce.services.iotdmp.model.device.evs.EvsDeviceInfo;
import com.baidubce.services.iotdmp.model.device.evs.EvsDurationRequest;
import com.baidubce.services.iotdmp.model.device.evs.EvsPtzRequest;
import com.baidubce.services.iotdmp.model.device.evs.EvsUrlProtocol;
import com.baidubce.services.iotdmp.model.device.evs.UpdateEvsDeviceRequest;
import com.baidubce.services.iotdmp.model.device.tag.ListTagResponse;
import com.baidubce.services.iotdmp.model.device.topic.ListTopicResponse;
import com.baidubce.services.iotdmp.model.device.topo.DeviceSubsetsFileResponse;
import com.baidubce.services.iotdmp.model.fm.AddConfigRequest;
import com.baidubce.services.iotdmp.model.fm.AddTaskRequest;
import com.baidubce.services.iotdmp.model.fm.ConfigManagementListResponse;
import com.baidubce.services.iotdmp.model.fm.ConfigManagementResponse;
import com.baidubce.services.iotdmp.model.fm.ConfigTaskDetailListResponse;
import com.baidubce.services.iotdmp.model.fm.ConfigTaskListResponse;
import com.baidubce.services.iotdmp.model.fm.ConfigVersionListResponse;
import com.baidubce.services.iotdmp.model.fm.GetConfigVersionResponse;
import com.baidubce.services.iotdmp.model.group.CreateGroupRequest;
import com.baidubce.services.iotdmp.model.group.GroupInfo;
import com.baidubce.services.iotdmp.model.group.ListDeviceByGroupResponse;
import com.baidubce.services.iotdmp.model.group.ListGroupRequest;
import com.baidubce.services.iotdmp.model.group.ListGroupResponse;
import com.baidubce.services.iotdmp.model.group.UpdateGroupInfoRequest;
import com.baidubce.services.iotdmp.model.handler.BceDmpHandler;
import com.baidubce.services.iotdmp.model.instance.ExtensionResourceResponse;
import com.baidubce.services.iotdmp.model.instance.InstanceInfo;
import com.baidubce.services.iotdmp.model.instance.ListInstanceResourceResponse;
import com.baidubce.services.iotdmp.model.instance.ListInstancesResponse;
import com.baidubce.services.iotdmp.model.instance.ResourceSupplier;
import com.baidubce.services.iotdmp.model.instance.ResourceType;
import com.baidubce.services.iotdmp.model.instance.UpdateInstanceResourcePropertiesRequest;
import com.baidubce.services.iotdmp.model.linkage.BatchDeleteLinkageRuleRequest;
import com.baidubce.services.iotdmp.model.linkage.CreateLinkageRuleRequest;
import com.baidubce.services.iotdmp.model.linkage.CreateLinkageRuleResponse;
import com.baidubce.services.iotdmp.model.linkage.LinkageRuleInfo;
import com.baidubce.services.iotdmp.model.linkage.ListLinkageRuleResponse;
import com.baidubce.services.iotdmp.model.linkage.UpdateLinkageRuleRequest;
import com.baidubce.services.iotdmp.model.ota.CommonOtaListRequest;
import com.baidubce.services.iotdmp.model.ota.device.ListAllTestDeviceForTaskResponse;
import com.baidubce.services.iotdmp.model.ota.device.SearchDeviceForTaskResponse;
import com.baidubce.services.iotdmp.model.ota.device.SearchType;
import com.baidubce.services.iotdmp.model.ota.packages.CheckOtaPackageRequest;
import com.baidubce.services.iotdmp.model.ota.packages.CheckOtaPackageResponse;
import com.baidubce.services.iotdmp.model.ota.packages.ListOtaPackageRequest;
import com.baidubce.services.iotdmp.model.ota.packages.ListOtaPackageResponse;
import com.baidubce.services.iotdmp.model.ota.packages.OSStsResponse;
import com.baidubce.services.iotdmp.model.ota.packages.Type;
import com.baidubce.services.iotdmp.model.ota.packages.UploadOtaPackageRequest;
import com.baidubce.services.iotdmp.model.ota.packages.UploadOtaPackageResponse;
import com.baidubce.services.iotdmp.model.ota.packing.CancelOtaPackingResponse;
import com.baidubce.services.iotdmp.model.ota.packing.CreateOtaPackingRequest;
import com.baidubce.services.iotdmp.model.ota.packing.CreateOtaPackingResponse;
import com.baidubce.services.iotdmp.model.ota.packing.DeleteOtaPackingResponse;
import com.baidubce.services.iotdmp.model.ota.packing.GetOtaPackingStatusResponse;
import com.baidubce.services.iotdmp.model.ota.packing.ListOtaCompletedPackingResponse;
import com.baidubce.services.iotdmp.model.ota.packing.ListOtaUncompletedPackingResponse;
import com.baidubce.services.iotdmp.model.ota.product.CreateOtaProductRequest;
import com.baidubce.services.iotdmp.model.ota.product.CreateOtaProductResponse;
import com.baidubce.services.iotdmp.model.ota.product.ListOtaProductOperationRequest;
import com.baidubce.services.iotdmp.model.ota.product.ListOtaProductOperationResponse;
import com.baidubce.services.iotdmp.model.ota.product.ListOtaProductRequest;
import com.baidubce.services.iotdmp.model.ota.product.ListOtaProductResponse;
import com.baidubce.services.iotdmp.model.ota.product.OtaProductConfig;
import com.baidubce.services.iotdmp.model.ota.product.OtaProductDetail;
import com.baidubce.services.iotdmp.model.ota.statistics.OtaTaskIssuedFailedStatisticsResponse;
import com.baidubce.services.iotdmp.model.ota.statistics.OtaTaskIssuedFailureInfoStatisticsResponse;
import com.baidubce.services.iotdmp.model.ota.statistics.OtaTaskIssuedStatisticsResponse;
import com.baidubce.services.iotdmp.model.ota.statistics.OtaTaskProductLineWeekStatisticsResponse;
import com.baidubce.services.iotdmp.model.ota.statistics.OtaTaskStageStatisticsResponse;
import com.baidubce.services.iotdmp.model.ota.statistics.OtaTaskStatisticsResponse;
import com.baidubce.services.iotdmp.model.ota.statistics.Stage;
import com.baidubce.services.iotdmp.model.ota.task.CreateOrUpdateGrayTaskRequest;
import com.baidubce.services.iotdmp.model.ota.task.CreateOtaTaskRequest;
import com.baidubce.services.iotdmp.model.ota.task.CreateOtaTaskResponse;
import com.baidubce.services.iotdmp.model.ota.task.DeleteOtaTaskRequest;
import com.baidubce.services.iotdmp.model.ota.task.GetOtaTaskResponse;
import com.baidubce.services.iotdmp.model.ota.task.GrayTask;
import com.baidubce.services.iotdmp.model.ota.task.ListOtaTaskRequest;
import com.baidubce.services.iotdmp.model.ota.task.ListOtaTaskResponse;
import com.baidubce.services.iotdmp.model.ota.task.UpdateOtaTaskRequest;
import com.baidubce.services.iotdmp.model.ota.task.UpdateOtaTaskResponse;
import com.baidubce.services.iotdmp.model.ota.task.UpdateOtaTaskStatusRequest;
import com.baidubce.services.iotdmp.model.ota.task.UpdateOtaTaskStatusResponse;
import com.baidubce.services.iotdmp.model.platform.BatchDeleteRuleChainExternalDestinationRequest;
import com.baidubce.services.iotdmp.model.platform.BatchDeleteRuleChainRequest;
import com.baidubce.services.iotdmp.model.platform.CreateRuleChainExternalDestinationRequest;
import com.baidubce.services.iotdmp.model.platform.CreateRuleChainRequest;
import com.baidubce.services.iotdmp.model.platform.CreateRuleChainResponse;
import com.baidubce.services.iotdmp.model.platform.ListRuleChainDestinationRequest;
import com.baidubce.services.iotdmp.model.platform.ListRuleChainDestinationResponse;
import com.baidubce.services.iotdmp.model.platform.ListRuleChainRequest;
import com.baidubce.services.iotdmp.model.platform.ListRuleChainResponse;
import com.baidubce.services.iotdmp.model.platform.PlatformRuleChainInfo;
import com.baidubce.services.iotdmp.model.platform.UpdatePlatformRuleChainRequest;
import com.baidubce.services.iotdmp.model.platform.UpdateRuleChainStateRequest;
import com.baidubce.services.iotdmp.model.platform.ValidateRuleChainRequest;
import com.baidubce.services.iotdmp.model.platform.ValidateRuleChainResponse;
import com.baidubce.services.iotdmp.model.product.CreateProductInfoRequest;
import com.baidubce.services.iotdmp.model.product.CreateTagRequest;
import com.baidubce.services.iotdmp.model.product.ListProductCategoryResponse;
import com.baidubce.services.iotdmp.model.product.ListProductModelRequest;
import com.baidubce.services.iotdmp.model.product.ListProductModelResponse;
import com.baidubce.services.iotdmp.model.product.ListProductRequest;
import com.baidubce.services.iotdmp.model.product.ListProductResponse;
import com.baidubce.services.iotdmp.model.product.PermanentConnectRequest;
import com.baidubce.services.iotdmp.model.product.ProductInfo;
import com.baidubce.services.iotdmp.model.product.ProductModelInfo;
import com.baidubce.services.iotdmp.model.product.UpdateProductInfoRequest;
import com.baidubce.services.iotdmp.model.product.evs.CreateEvsSpaceRequest;
import com.baidubce.services.iotdmp.model.product.evs.EvsSpaceInfo;
import com.baidubce.services.iotdmp.model.product.evs.UpdateEvsSpaceRequest;
import com.baidubce.services.iotdmp.model.product.feature.DtmlDetailResponse;
import com.baidubce.services.iotdmp.model.product.feature.command.CreateFeatureCommandRequest;
import com.baidubce.services.iotdmp.model.product.feature.command.ListFeatureCommandResponse;
import com.baidubce.services.iotdmp.model.product.feature.command.ProductFeatureCommandInfo;
import com.baidubce.services.iotdmp.model.product.feature.command.UpdateProductCommandRequest;
import com.baidubce.services.iotdmp.model.product.feature.event.CreateFeatureEventRequest;
import com.baidubce.services.iotdmp.model.product.feature.event.ListFeatureEventResponse;
import com.baidubce.services.iotdmp.model.product.feature.event.ProductFeatureEventInfo;
import com.baidubce.services.iotdmp.model.product.feature.event.UpdateProductEventRequest;
import com.baidubce.services.iotdmp.model.product.feature.property.CreateFeaturePropertyRequest;
import com.baidubce.services.iotdmp.model.product.feature.property.ListFeaturePropertyResponse;
import com.baidubce.services.iotdmp.model.product.feature.property.ProductFeaturePropertyInfo;
import com.baidubce.services.iotdmp.model.product.feature.property.UpdateProductPropertyRequest;
import com.baidubce.services.iotdmp.model.product.feature.thing.Thing;
import com.baidubce.services.iotdmp.model.service.ConsumerGroupQueueInfoResponse;
import com.baidubce.services.iotdmp.model.service.ConsumerGroupUserInfoResponse;
import com.baidubce.services.iotdmp.model.service.CreateConsumerGroupRequest;
import com.baidubce.services.iotdmp.model.service.CreateConsumerGroupResponse;
import com.baidubce.services.iotdmp.model.service.GetBridgeListResponse;
import com.baidubce.services.iotdmp.model.service.ListConsumerGroupResponse;
import com.baidubce.services.iotdmp.model.service.ListSubResponse;
import com.baidubce.services.iotdmp.model.service.ProductSubscriptionResponse;
import com.baidubce.services.iotdmp.model.service.ResetConsumerGroupUserPwdResponse;
import com.baidubce.services.iotdmp.model.service.SendMessageRequest;
import com.baidubce.services.iotdmp.model.service.ServiceInfoResponse;
import com.baidubce.services.iotdmp.model.service.UpdateProductSubscriptionRequest;
import com.baidubce.services.iotdmp.model.service.rulechain.AvailableMessageTypeResponse;
import com.baidubce.services.iotdmp.model.service.rulechain.BlinkDataPermission;
import com.baidubce.services.iotdmp.model.service.rulechain.TopicDecodeRequest;
import com.baidubce.services.iotdmp.model.service.rulechain.TopicDecodeResponse;
import com.baidubce.services.iotdmp.model.service.rulechain.TopicEncodeRequest;
import com.baidubce.services.iotdmp.model.service.rulechain.TopicEncodeResponse;
import com.baidubce.services.iotdmp.model.shadow.DeviceShadowResponse;
import com.baidubce.services.iotdmp.model.shadow.ListDeviceShadowRequest;
import com.baidubce.services.iotdmp.model.shadow.ListDeviceShadowSnapshotResponse;
import com.baidubce.services.iotdmp.model.shadow.ShadowStatesRequest;
import com.baidubce.services.iotdmp.model.shadow.UpdateDesiredRequest;
import com.baidubce.services.iotdmp.model.userlog.ListUserLogRequest;
import com.baidubce.services.iotdmp.model.userlog.ListUserLogResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;

public class PlatformClient
extends AbstractBceClient {
    private static final String ENDPOINT = "TBD";
    private static final String VERSION = "v1";
    private static final String CONTENT_TYPE = "application/json;charset=UTF-8";
    private static final String INSTANCE = "instances";
    private static final String EXTENSION = "extensions";
    private static final String AVAILABLE = "available";
    private static final String CONFIG = "config";
    private static final String ENABLED = "enabled";
    private static final String ENABLE = "enable";
    private static final String PLATFORM_RULECHAINS = "platform/rulechains";
    private static final String PLATFORM_LINKAGES = "platform/linkages";
    private static final String BATCH_DELETE = "batchDelete";
    private static final String UPDATE_STATE = "updateState";
    private static final String COMPUTE = "compute";
    private static final String DESTINATIONS = "destinations";
    private static final String SERVICE = "services";
    private static final String C2C = "c2c";
    private static final String DEVICES = "devices";
    private static final String SECRET = "secret";
    private static final String TOPICS = "topics";
    private static final String TAGS = "tags";
    private static final String KEY = "key";
    private static final String EVS = "evs";
    private static final String CHANNEL = "channel";
    private static final String PTZ = "ptz";
    private static final String THUMBNAIL = "thumbnail";
    private static final String RECORDING = "recording";
    private static final String RESOURCES = "resources";
    private static final String STATES = "states";
    private static final String STATE = "state";
    private static final String AUTH = "auth";
    private static final String SHADOWS = "shadows";
    private static final String SHADOW = "shadow";
    private static final String DESIRED = "desired";
    private static final String SIGNED_URL = "signedUrl";
    private static final String PRODUCTS = "products";
    private static final String PRODUCT = "product";
    private static final String PERMANENT_CONNECT = "permanentConnect";
    private static final String FEATURE = "features";
    private static final String DETAIL = "detail";
    private static final String COMMAND = "commands";
    private static final String EVENT = "events";
    private static final String PROPERTIES = "properties";
    private static final String MESSAGES = "messages";
    private static final String BLINK = "blink";
    private static final String ENCODE = "encode";
    private static final String DECODE = "decode";
    private static final String MESSAGE = "message";
    private static final String TYPES = "types";
    private static final String TYPE = "type";
    private static final String SOURCE = "sources";
    private static final String SINK = "sinks";
    private static final String CONSUMER = "consumers";
    private static final String USER = "user";
    private static final String RESET = "reset";
    private static final String SUBSCRIPTIONS = "subscriptions";
    private static final String BATCH = "batch";
    private static final String SUBSET = "subsets";
    private static final String DELETE = "delete";
    private static final String GATEWAY = "gateway";
    private static final String DOWNWARD = "downward";
    private static final String LOG = "logs";
    private static final String GROUPS = "groups";
    private static final String EXPORT = "export";
    private static final String COMPONENTS = "components";
    private static final String VERIFY = "verify";
    private static final String CATEGORIES = "categories";
    private static final String REPOSITORIES = "repositories";
    private static final String MODELS = "models";
    private static final String INFO = "info";
    private static final String ALARMS = "alarms";
    private static final String RULES = "rules";
    private static final String TRIGGER = "trigger";
    private static final String RECORDS = "records";
    private static final String PROCESS = "process";
    private static final String FM = "fm";
    private static final String CONFIG_VERSION = "version";
    private static final String URL = "url";
    private static final String VERSIONS = "versions";
    private static final String TASK = "task";
    private static final String CSV = "csv";
    private static final String IMPORT = "import";
    private static final String TEST = "test";
    private static final String OTA = "ota";
    private static final String OPERATION = "operation";
    private static final String PACKAGES = "packages";
    private static final String CHECK = "check";
    private static final String STS = "sts";
    private static final String STATISTICS = "statistics";
    private static final String ISSUED = "issued";
    private static final String FAILED = "failed";
    private static final String FAILURES = "failures";
    private static final String STATUS = "status";
    private static final String GRAY = "gray";
    private static final String STAGE = "stage";
    private static final String WEEK = "week";
    private static final String COMPLETED = "completed";
    private static final String UNCOMPLETED = "uncompleted";
    private static final String PACKING = "packing";
    private static final String CANCEL = "cancel";
    private static final String MQTT = "mqtt";
    private static final String DOWNLOAD = "download";
    private static final HttpResponseHandler[] HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceDmpHandler()};

    public PlatformClient(String accessKey, String secretKey) {
        this(new BceClientConfiguration().withCredentials(new DefaultBceCredentials(accessKey, secretKey)).withEndpoint(ENDPOINT));
    }

    public PlatformClient(BceClientConfiguration config) {
        super(config.getEndpoint() == null ? config.withEndpoint(ENDPOINT) : config, HANDLERS);
    }

    public InstanceInfo getInstance(String instanceId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, INSTANCE, instanceId);
        return this.invokeHttpClient(internalRequest, InstanceInfo.class);
    }

    public ListInstancesResponse listInstances(int pageNo, int pageSize) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, INSTANCE);
        internalRequest.addParameter("pageNo", Integer.toString(pageNo));
        internalRequest.addParameter("pageSize", Integer.toString(pageSize));
        return this.invokeHttpClient(internalRequest, ListInstancesResponse.class);
    }

    public ExtensionResourceResponse getConfigExtensionResources(String instanceId, String productKey) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCTS, instanceId, productKey, EXTENSION, CONFIG);
        return this.invokeHttpClient(internalRequest, ExtensionResourceResponse.class);
    }

    public ExtensionResourceResponse getConfigExtensionResources(String instanceId, String productKey, String deviceName) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DEVICES, instanceId, productKey, deviceName, EXTENSION, CONFIG);
        return this.invokeHttpClient(internalRequest, ExtensionResourceResponse.class);
    }

    public ExtensionResourceResponse getEnabledExtensionResources(String instanceId, String productKey) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCTS, instanceId, productKey, EXTENSION, ENABLED);
        return this.invokeHttpClient(internalRequest, ExtensionResourceResponse.class);
    }

    public ExtensionResourceResponse getEnabledExtensionResources(String instanceId, String productKey, String deviceName) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DEVICES, instanceId, productKey, deviceName, EXTENSION, ENABLED);
        return this.invokeHttpClient(internalRequest, ExtensionResourceResponse.class);
    }

    public ListInstanceResourceResponse listInstanceResources(String instanceId, ResourceSupplier supplier) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, INSTANCE, instanceId, RESOURCES);
        internalRequest.addParameter("supplier", supplier.name());
        return this.invokeHttpClient(internalRequest, ListInstanceResourceResponse.class);
    }

    public void updateResourceProperties(String instanceId, UpdateInstanceResourcePropertiesRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE, instanceId, RESOURCES);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void enableResource(String instanceId, ResourceSupplier supplier, ResourceType resourceType) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.POST, INSTANCE, instanceId, RESOURCES, ENABLE);
        internalRequest.addParameter("supplier", supplier.name());
        internalRequest.addParameter("resourceType", resourceType.name());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void verifyResourceProperties(String instanceId, UpdateInstanceResourcePropertiesRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, INSTANCE, instanceId, RESOURCES, VERIFY);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public CreateRuleChainResponse createRuleChain(String instanceId, CreateRuleChainRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, PLATFORM_RULECHAINS, instanceId);
        return this.invokeHttpClient(internalRequest, CreateRuleChainResponse.class);
    }

    public void deleteRuleChain(String instanceId, BatchDeleteRuleChainRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, PLATFORM_RULECHAINS, instanceId, BATCH_DELETE);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateRuleChain(String instanceId, String rulechainId, UpdatePlatformRuleChainRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, PLATFORM_RULECHAINS, instanceId, rulechainId);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateRuleChainState(String instanceId, String rulechainId, UpdateRuleChainStateRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, PLATFORM_RULECHAINS, instanceId, rulechainId, UPDATE_STATE);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public PlatformRuleChainInfo getRuleChain(String instanceId, String rulechainId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PLATFORM_RULECHAINS, instanceId, rulechainId);
        return this.invokeHttpClient(internalRequest, PlatformRuleChainInfo.class);
    }

    public ListRuleChainResponse listRuleChain(String instanceId, ListRuleChainRequest request) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PLATFORM_RULECHAINS, instanceId);
        internalRequest.addParameter("pageNo", Integer.toString(request.getPageNo()));
        internalRequest.addParameter("pageSize", Integer.toString(request.getPageSize()));
        if (StringUtils.isNotEmpty((CharSequence)request.getOrder())) {
            internalRequest.addParameter("order", request.getOrder());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getOrderBy())) {
            internalRequest.addParameter("orderBy", request.getOrderBy());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getName())) {
            internalRequest.addParameter("name", request.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getState())) {
            internalRequest.addParameter(STATE, request.getState());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getStatus())) {
            internalRequest.addParameter(STATUS, request.getStatus());
        }
        return this.invokeHttpClient(internalRequest, ListRuleChainResponse.class);
    }

    public ValidateRuleChainResponse validateRuleChain(ValidateRuleChainRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, PLATFORM_RULECHAINS, COMPUTE);
        return this.invokeHttpClient(internalRequest, ValidateRuleChainResponse.class);
    }

    public CommonResult createRuleChainExternalDestination(String instanceId, CreateRuleChainExternalDestinationRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, PLATFORM_RULECHAINS, instanceId, DESTINATIONS);
        return this.invokeHttpClient(internalRequest, CommonResult.class);
    }

    public ListRuleChainDestinationResponse listRuleChainDestinations(String instanceId, ListRuleChainDestinationRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, PLATFORM_RULECHAINS, instanceId, DESTINATIONS);
        internalRequest.addParameter("sourceType", request.getSourceType());
        internalRequest.addParameter("pageNo", Integer.toString(request.getPageNo()));
        internalRequest.addParameter("pageSize", Integer.toString(request.getPageSize()));
        if (StringUtils.isNotEmpty((CharSequence)request.getOrder())) {
            internalRequest.addParameter("order", request.getOrder());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getOrderBy())) {
            internalRequest.addParameter("orderBy", request.getOrderBy());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getRegion())) {
            internalRequest.addParameter("region", request.getRegion());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getType())) {
            internalRequest.addParameter(TYPE, request.getType());
        }
        return this.invokeHttpClient(internalRequest, ListRuleChainDestinationResponse.class);
    }

    public void batchDeleteRuleChainExternalDestinations(String instanceId, BatchDeleteRuleChainExternalDestinationRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, PLATFORM_RULECHAINS, instanceId, DESTINATIONS, BATCH_DELETE);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public CommonResult validateRuleChainDestinationConnect(String instanceId, String destId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.POST, PLATFORM_RULECHAINS, instanceId, DESTINATIONS, destId);
        return this.invokeHttpClient(internalRequest, CommonResult.class);
    }

    public ComputationSourceResponse getC2CSource(String instanceId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, SERVICE, instanceId, C2C);
        return this.invokeHttpClient(internalRequest, ComputationSourceResponse.class);
    }

    public void updateC2CDownwardState(String instanceId, boolean state) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.PUT, SERVICE, instanceId, C2C, DOWNWARD);
        internalRequest.addParameter(STATE, Boolean.toString(state));
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public DeviceInfo createDevice(String instanceId, String productKey, CreateDeviceRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, DEVICES, instanceId, productKey);
        return this.invokeHttpClient(internalRequest, DeviceInfo.class);
    }

    public void importCsvCreateDevice(String instanceId, String productKey, File file) {
        InternalRequest internalRequest = this.createUploadRequest("importFile", file, HttpMethodName.POST, DEVICES, instanceId, productKey, CSV, IMPORT);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void importCsvCreateDevice(String instanceId, String productKey, File file, AuthType authType) {
        InternalRequest internalRequest = this.createUploadRequest("importFile", file, HttpMethodName.POST, DEVICES, instanceId, productKey, CSV, IMPORT);
        internalRequest.addParameter("authType", authType.name());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteDevice(String instanceId, String productKey, String deviceName) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.DELETE, DEVICES, instanceId, productKey, deviceName);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void batchDeleteDevice(String instanceId, BatchDeleteDeviceRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DEVICES, instanceId, BATCH, DELETE);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public DeviceInfo getDevice(String instanceId, String productKey, String deviceName) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DEVICES, instanceId, productKey, deviceName);
        return this.invokeHttpClient(internalRequest, DeviceInfo.class);
    }

    public ListDeviceResponse getDeviceList(String instanceId, ListDeviceRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DEVICES, instanceId);
        internalRequest.addParameter("pageNo", Integer.toString(request.getPageNo()));
        internalRequest.addParameter("pageSize", Integer.toString(request.getPageSize()));
        internalRequest.addParameter("cursor", request.getCursor());
        if (StringUtils.isNotEmpty((CharSequence)request.getProductKey())) {
            internalRequest.addParameter("productKey", request.getProductKey());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getAlias())) {
            internalRequest.addParameter("alias", request.getAlias());
        }
        return this.invokeHttpClient(internalRequest, ListDeviceResponse.class);
    }

    public void resetDeviceSecret(String instanceId, String productKey, String deviceName) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.PUT, DEVICES, instanceId, productKey, deviceName, SECRET);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void batchCreateDevice(String instanceId, String productKey, BatchCreateDeviceRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, DEVICES, instanceId, productKey, BATCH);
        if (request.getAuthType() != null) {
            internalRequest.addParameter("authType", request.getAuthType().name());
        }
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public DeviceInfo updateDevice(String instanceId, String productKey, String deviceName, UpdateDeviceRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DEVICES, instanceId, productKey, deviceName);
        return this.invokeHttpClient(internalRequest, DeviceInfo.class);
    }

    public ListDeviceStatesResponse getDeviceStates(String instanceId, ListDeviceKeyRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, DEVICES, instanceId, STATES);
        return this.invokeHttpClient(internalRequest, ListDeviceStatesResponse.class);
    }

    public ListTopicResponse getDeviceTopic(String instanceId, String productKey, String deviceName) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DEVICES, instanceId, productKey, deviceName, TOPICS);
        return this.invokeHttpClient(internalRequest, ListTopicResponse.class);
    }

    public ListTagResponse createDeviceTag(String instanceId, String productKey, String deviceName, CreateTagRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, DEVICES, instanceId, productKey, deviceName, TAGS);
        return this.invokeHttpClient(internalRequest, ListTagResponse.class);
    }

    public void deleteDeviceTag(String instanceId, String productKey, String deviceName, String key) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.DELETE, DEVICES, instanceId, productKey, deviceName, TAGS, key);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListTagResponse getDeviceTagList(String instanceId, String productKey, String deviceName) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DEVICES, instanceId, productKey, deviceName, TAGS);
        return this.invokeHttpClient(internalRequest, ListTagResponse.class);
    }

    public EvsSpaceInfo getEvs(String instanceId, String productKey) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCTS, instanceId, productKey, EVS);
        return this.invokeHttpClient(internalRequest, EvsSpaceInfo.class);
    }

    public EvsDeviceInfo getEvs(String instanceId, String productKey, String deviceName) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DEVICES, instanceId, productKey, deviceName, EVS);
        return this.invokeHttpClient(internalRequest, EvsDeviceInfo.class);
    }

    public void createEvs(String instanceId, String productKey, CreateEvsSpaceRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, PRODUCTS, instanceId, productKey, EVS);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void createEvs(String instanceId, String productKey, String deviceName, AddEvsDeviceRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, DEVICES, instanceId, productKey, deviceName, EVS);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public CommonResult getEvsChannelUrl(String instanceId, String productKey, String deviceName, String channelId, EvsUrlProtocol protocol) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DEVICES, instanceId, productKey, deviceName, EVS, CHANNEL, channelId);
        internalRequest.addParameter("protocol", protocol.name());
        return this.invokeHttpClient(internalRequest, CommonResult.class);
    }

    public void getEvsChannelPtz(String instanceId, String productKey, String deviceName, String channelId, EvsPtzRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DEVICES, instanceId, productKey, deviceName, EVS, CHANNEL, channelId, PTZ);
        internalRequest.addParameter(PTZ, request.getPtzCommand());
        if (request.getSpeed() != null) {
            internalRequest.addParameter("speed", Integer.toString(request.getSpeed()));
        }
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public CommonResult getEvsChannel(String instanceId, String productKey, String deviceName) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DEVICES, instanceId, productKey, deviceName, EVS, CHANNEL);
        return this.invokeHttpClient(internalRequest, CommonResult.class);
    }

    public CommonResult getEvsThumbnail(String instanceId, String productKey, String deviceName, EvsDurationRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DEVICES, instanceId, productKey, deviceName, EVS, THUMBNAIL);
        internalRequest.addParameter("begin", Integer.toString(request.getBegin()));
        internalRequest.addParameter("end", Integer.toString(request.getEnd()));
        internalRequest.addParameter("pageNo", Integer.toString(request.getPageNo()));
        internalRequest.addParameter("pageSize", Integer.toString(request.getPageSize()));
        return this.invokeHttpClient(internalRequest, CommonResult.class);
    }

    public CommonResult getEvsRecording(String instanceId, String productKey, String deviceName, EvsDurationRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DEVICES, instanceId, productKey, deviceName, EVS, RECORDING);
        internalRequest.addParameter("begin", Integer.toString(request.getBegin()));
        internalRequest.addParameter("end", Integer.toString(request.getEnd()));
        internalRequest.addParameter("pageNo", Integer.toString(request.getPageNo()));
        internalRequest.addParameter("pageSize", Integer.toString(request.getPageSize()));
        return this.invokeHttpClient(internalRequest, CommonResult.class);
    }

    public void auth(String instanceId, String productKey, String deviceName, AuthRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, DEVICES, instanceId, productKey, deviceName, AUTH);
        internalRequest.addHeader("signature", request.getSignature());
        internalRequest.addHeader("expiryTime", Long.toString(request.getExpiryTime()));
        if (request.getAlgorithmType() != null) {
            internalRequest.addHeader("algorithmType", request.getAlgorithmType().name());
        }
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public DeviceResourcesConnectionInfo getResourcesInfo(String instanceId, String productKey, String deviceName, GetDeviceConnectionInfoRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, DEVICES, instanceId, productKey, deviceName, RESOURCES);
        return this.invokeHttpClient(internalRequest, DeviceResourcesConnectionInfo.class);
    }

    public void updateDeviceStates(String instanceId, String productKey, String deviceName, UpdateDeviceStateRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DEVICES, instanceId, productKey, deviceName, STATES);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public DeviceShadowResponse getDeviceShadow(String instanceId, String productKey, String deviceName, ListDeviceShadowRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, SHADOWS, instanceId, productKey, deviceName);
        internalRequest.addParameter("pageNo", Integer.toString(request.getPageNo()));
        internalRequest.addParameter("pageSize", Integer.toString(request.getPageSize()));
        if (StringUtils.isNotEmpty((CharSequence)request.getPropertyName())) {
            internalRequest.addParameter("propertyName", request.getPropertyName());
        }
        return this.invokeHttpClient(internalRequest, DeviceShadowResponse.class);
    }

    public void updateDeviceShadowState(String instanceId, String productKey, boolean shadowState) {
        ShadowStatesRequest request = new ShadowStatesRequest();
        request.setShadowState(shadowState);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, SHADOWS, instanceId, productKey, STATES);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateDesired(String instanceId, String productKey, String deviceName, UpdateDesiredRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, SHADOWS, instanceId, productKey, deviceName, DESIRED);
        internalRequest.addParameter("bindName", request.getBindName());
        String jsonStr = JsonUtils.toJsonString(request.getDesired());
        try {
            byte[] content = jsonStr.getBytes("UTF-8");
            internalRequest.setContent(RestartableInputStream.wrap(content));
            internalRequest.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListDeviceShadowSnapshotResponse listShadow(String instanceId, ListDeviceKeyRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, SHADOWS, instanceId, SHADOW, BATCH);
        return this.invokeHttpClient(internalRequest, ListDeviceShadowSnapshotResponse.class);
    }

    public CommonResult getEvsStream(String domain, String app, String stream, EvsUrlProtocol protocol) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, EVS, domain, app, stream, SIGNED_URL);
        internalRequest.addParameter("protocol", protocol.name());
        return this.invokeHttpClient(internalRequest, CommonResult.class);
    }

    public ProductInfo createProduct(String instanceId, CreateProductInfoRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, PRODUCTS, instanceId);
        return this.invokeHttpClient(internalRequest, ProductInfo.class);
    }

    public void resetSecret(String instanceId, String productKey) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.PUT, PRODUCTS, instanceId, productKey, SECRET);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ProductInfo updateProduct(String instanceId, String productKey, UpdateProductInfoRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, PRODUCTS, instanceId, productKey);
        return this.invokeHttpClient(internalRequest, ProductInfo.class);
    }

    public ListProductResponse getProductList(String instanceId, ListProductRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, PRODUCTS, instanceId);
        internalRequest.addParameter("pageNo", Integer.toString(request.getPageNo()));
        internalRequest.addParameter("pageSize", Integer.toString(request.getPageSize()));
        if (StringUtils.isNotEmpty((CharSequence)request.getProductName())) {
            internalRequest.addParameter("productName", request.getProductName());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getTagKey())) {
            internalRequest.addParameter("tagKey", request.getTagKey());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getTagValue())) {
            internalRequest.addParameter("tagValue", request.getTagValue());
        }
        if (request.getDeviceType() != null) {
            internalRequest.addParameter("deviceType", request.getDeviceType().toString());
        }
        return this.invokeHttpClient(internalRequest, ListProductResponse.class);
    }

    public ProductInfo getProduct(String instanceId, String productKey) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCTS, instanceId, productKey);
        return this.invokeHttpClient(internalRequest, ProductInfo.class);
    }

    public void deleteProduct(String instanceId, String productKey) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.DELETE, PRODUCTS, instanceId, productKey);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updatePermanentConnect(String instanceId, String productKey, boolean permanentConnect) {
        PermanentConnectRequest request = new PermanentConnectRequest(permanentConnect);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, PRODUCTS, instanceId, productKey, PERMANENT_CONNECT);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListTagResponse createProductTag(String instanceId, String productKey, CreateTagRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, PRODUCTS, instanceId, productKey, TAGS);
        return this.invokeHttpClient(internalRequest, ListTagResponse.class);
    }

    public void deleteProductTag(String instanceId, String productKey, String key) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.DELETE, PRODUCTS, instanceId, productKey, TAGS, key);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListTagResponse getProductTagList(String instanceId, String productKey) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCTS, instanceId, productKey, TAGS);
        return this.invokeHttpClient(internalRequest, ListTagResponse.class);
    }

    public ListTopicResponse getTopics(String instanceId, String productKey) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCTS, instanceId, productKey, TOPICS);
        return this.invokeHttpClient(internalRequest, ListTopicResponse.class);
    }

    public DtmlDetailResponse getDTMLDetail(String instanceId, String productKey) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.POST, PRODUCTS, instanceId, productKey, FEATURE, DETAIL);
        return this.invokeHttpClient(internalRequest, DtmlDetailResponse.class);
    }

    public void importDTMLDetail(String instanceId, String productKey, Thing thing) {
        InternalRequest internalRequest = this.createRequest(thing, HttpMethodName.POST, PRODUCTS, instanceId, productKey, FEATURE, BATCH);
        this.invokeHttpClient(internalRequest, CommonResult.class);
    }

    public ProductFeatureCommandInfo createFeatureCommand(String instanceId, String productKey, CreateFeatureCommandRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, PRODUCTS, instanceId, productKey, FEATURE, COMMAND);
        return this.invokeHttpClient(internalRequest, ProductFeatureCommandInfo.class);
    }

    public ProductFeatureCommandInfo updateFeatureCommand(String instanceId, String productKey, String name, UpdateProductCommandRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, PRODUCTS, instanceId, productKey, FEATURE, COMMAND, name);
        return this.invokeHttpClient(internalRequest, ProductFeatureCommandInfo.class);
    }

    public void deleteFeatureCommand(String instanceId, String productKey, String name) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.DELETE, PRODUCTS, instanceId, productKey, FEATURE, COMMAND, name);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ProductFeatureCommandInfo getFeatureCommand(String instanceId, String productKey, String name) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCTS, instanceId, productKey, FEATURE, COMMAND, name);
        return this.invokeHttpClient(internalRequest, ProductFeatureCommandInfo.class);
    }

    public ListFeatureCommandResponse getFeatureCommandList(String instanceId, String productKey, int pageNo, int pageSize) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCTS, instanceId, productKey, FEATURE, COMMAND);
        internalRequest.addParameter("pageNo", Integer.toString(pageNo));
        internalRequest.addParameter("pageSize", Integer.toString(pageSize));
        return this.invokeHttpClient(internalRequest, ListFeatureCommandResponse.class);
    }

    public ProductFeatureEventInfo createFeatureEvent(String instanceId, String productKey, CreateFeatureEventRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, PRODUCTS, instanceId, productKey, FEATURE, EVENT);
        return this.invokeHttpClient(internalRequest, ProductFeatureEventInfo.class);
    }

    public ProductFeatureEventInfo updateFeatureEvent(String instanceId, String productKey, String name, UpdateProductEventRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, PRODUCTS, instanceId, productKey, FEATURE, EVENT, name);
        return this.invokeHttpClient(internalRequest, ProductFeatureEventInfo.class);
    }

    public void deleteFeatureEvent(String instanceId, String productKey, String name) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.DELETE, PRODUCTS, instanceId, productKey, FEATURE, EVENT, name);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ProductFeatureEventInfo getFeatureEvent(String instanceId, String productKey, String name) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCTS, instanceId, productKey, FEATURE, EVENT, name);
        return this.invokeHttpClient(internalRequest, ProductFeatureEventInfo.class);
    }

    public ListFeatureEventResponse getFeatureEventList(String instanceId, String productKey, int pageNo, int pageSize) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCTS, instanceId, productKey, FEATURE, EVENT);
        internalRequest.addParameter("pageNo", Integer.toString(pageNo));
        internalRequest.addParameter("pageSize", Integer.toString(pageSize));
        return this.invokeHttpClient(internalRequest, ListFeatureEventResponse.class);
    }

    public ProductFeaturePropertyInfo createFeatureProperty(String instanceId, String productKey, CreateFeaturePropertyRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, PRODUCTS, instanceId, productKey, FEATURE, PROPERTIES);
        return this.invokeHttpClient(internalRequest, ProductFeaturePropertyInfo.class);
    }

    public ProductFeaturePropertyInfo updateFeatureProperty(String instanceId, String productKey, String name, UpdateProductPropertyRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, PRODUCTS, instanceId, productKey, FEATURE, PROPERTIES, name);
        return this.invokeHttpClient(internalRequest, ProductFeaturePropertyInfo.class);
    }

    public void deleteFeatureProperty(String instanceId, String productKey, String name) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.DELETE, PRODUCTS, instanceId, productKey, FEATURE, PROPERTIES, name);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ProductFeaturePropertyInfo getFeatureProperty(String instanceId, String productKey, String name) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCTS, instanceId, productKey, FEATURE, PROPERTIES, name);
        return this.invokeHttpClient(internalRequest, ProductFeaturePropertyInfo.class);
    }

    public ListFeaturePropertyResponse getFeaturePropertyList(String instanceId, String productKey, int pageNo, int pageSize) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCTS, instanceId, productKey, FEATURE, PROPERTIES);
        internalRequest.addParameter("pageNo", Integer.toString(pageNo));
        internalRequest.addParameter("pageSize", Integer.toString(pageSize));
        return this.invokeHttpClient(internalRequest, ListFeaturePropertyResponse.class);
    }

    public void updateEvs(String instanceId, String productKey, UpdateEvsSpaceRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, PRODUCTS, instanceId, productKey, EVS);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateEvs(String instanceId, String productKey, String deviceName, UpdateEvsDeviceRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DEVICES, instanceId, productKey, deviceName, EVS);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListProductResponse getSubsets(String instanceId, String productKey, int pageNo, int pageSize) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCTS, instanceId, SUBSET, productKey);
        internalRequest.addParameter("pageNo", Integer.toString(pageNo));
        internalRequest.addParameter("pageSize", Integer.toString(pageSize));
        return this.invokeHttpClient(internalRequest, ListProductResponse.class);
    }

    public ListDeviceResponse getSubsets(String instanceId, String productKey, String deviceName, int pageNo, int pageSize, String name) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DEVICES, instanceId, productKey, deviceName, SUBSET);
        if (StringUtils.isNotBlank((CharSequence)name)) {
            internalRequest.addParameter("name", name);
        }
        internalRequest.addParameter("pageNo", Integer.toString(pageNo));
        internalRequest.addParameter("pageSize", Integer.toString(pageSize));
        return this.invokeHttpClient(internalRequest, ListDeviceResponse.class);
    }

    public void deleteSubsets(String instanceId, String productKey, List<String> subProductKey) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.POST, PRODUCTS, instanceId, SUBSET, productKey, DELETE);
        String jsonStr = JsonUtils.toJsonString(subProductKey);
        try {
            byte[] content = jsonStr.getBytes("UTF-8");
            internalRequest.setContent(RestartableInputStream.wrap(content));
            internalRequest.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteSubsets(String instanceId, String productKey, String deviceName, List<DeviceKey> subDeviceKey) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.POST, DEVICES, instanceId, productKey, deviceName, SUBSET, DELETE);
        String jsonStr = JsonUtils.toJsonString(subDeviceKey);
        try {
            byte[] content = jsonStr.getBytes("UTF-8");
            internalRequest.setContent(RestartableInputStream.wrap(content));
            internalRequest.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListProductResponse getAllSubsets(String instanceId, String productKey, String subProductName, int pageNo, int pageSize) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCTS, instanceId, SUBSET);
        internalRequest.addParameter("productKey", productKey);
        if (StringUtils.isNotBlank((CharSequence)subProductName)) {
            internalRequest.addParameter("subProductName", subProductName);
        }
        internalRequest.addParameter("pageNo", Integer.toString(pageNo));
        internalRequest.addParameter("pageSize", Integer.toString(pageSize));
        return this.invokeHttpClient(internalRequest, ListProductResponse.class);
    }

    public ListDeviceResponse getAllSubsets(String instanceId, String productKey, String subProductKey, String deviceName, String name, int pageNo, int pageSize) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DEVICES, instanceId, productKey, SUBSET);
        internalRequest.addParameter("subProductKey", subProductKey);
        internalRequest.addParameter("deviceName", deviceName);
        if (StringUtils.isNotBlank((CharSequence)name)) {
            internalRequest.addParameter("name", name);
        }
        internalRequest.addParameter("pageNo", Integer.toString(pageNo));
        internalRequest.addParameter("pageSize", Integer.toString(pageSize));
        return this.invokeHttpClient(internalRequest, ListDeviceResponse.class);
    }

    public void addSubsets(String instanceId, String productKey, List<String> subProductKey) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.POST, PRODUCTS, instanceId, SUBSET, productKey);
        String jsonStr = JsonUtils.toJsonString(subProductKey);
        try {
            byte[] content = jsonStr.getBytes("UTF-8");
            internalRequest.setContent(RestartableInputStream.wrap(content));
            internalRequest.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void addSubsets(String instanceId, String productKey, String deviceName, List<DeviceKey> subDeviceKey) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.POST, DEVICES, instanceId, productKey, deviceName, SUBSET);
        String jsonStr = JsonUtils.toJsonString(subDeviceKey);
        try {
            byte[] content = jsonStr.getBytes("UTF-8");
            internalRequest.setContent(RestartableInputStream.wrap(content));
            internalRequest.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void importSubsets(String instanceId, String productKey, String deviceName, File file) {
        InternalRequest internalRequest = this.createUploadRequest("importFile", file, HttpMethodName.POST, DEVICES, instanceId, productKey, deviceName, SUBSET, IMPORT);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public DeviceSubsetsFileResponse exportSubsets(String instanceId, String productKey, String deviceName) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.POST, DEVICES, instanceId, productKey, deviceName, SUBSET, EXPORT);
        return this.invokeHttpClient(internalRequest, DeviceSubsetsFileResponse.class);
    }

    public TopicEncodeResponse topicEncode(TopicEncodeRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, SERVICE, BLINK, TOPICS, ENCODE);
        return this.invokeHttpClient(internalRequest, TopicEncodeResponse.class);
    }

    public TopicDecodeResponse topicDecode(TopicDecodeRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, SERVICE, BLINK, TOPICS, DECODE);
        return this.invokeHttpClient(internalRequest, TopicDecodeResponse.class);
    }

    public AvailableMessageTypeResponse getSourceTypes(String instanceId, BlinkDataPermission permission) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, SERVICE, instanceId, MESSAGES, TYPES, SOURCE);
        if (permission != null) {
            internalRequest.addParameter("permission", permission.name());
        }
        return this.invokeHttpClient(internalRequest, AvailableMessageTypeResponse.class);
    }

    public AvailableMessageTypeResponse getSinkTypes(String instanceId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, SERVICE, instanceId, MESSAGES, TYPES, SINK);
        return this.invokeHttpClient(internalRequest, AvailableMessageTypeResponse.class);
    }

    public ConsumerGroupUserInfoResponse getUserInfo(String instanceId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, SERVICE, instanceId, CONSUMER, USER);
        return this.invokeHttpClient(internalRequest, ConsumerGroupUserInfoResponse.class);
    }

    public void sendMessage(String instanceId, String productKey, String deviceName, SendMessageRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, SERVICE, instanceId, productKey, deviceName, MESSAGE);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public CreateConsumerGroupResponse createConsumerGroup(String instanceId, String name) {
        CreateConsumerGroupRequest request = new CreateConsumerGroupRequest(name);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, SERVICE, instanceId, CONSUMER);
        return this.invokeHttpClient(internalRequest, CreateConsumerGroupResponse.class);
    }

    public void deleteConsumerGroup(String instanceId, String consumerGroupId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.DELETE, SERVICE, instanceId, CONSUMER, consumerGroupId);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListConsumerGroupResponse getConsumerGroupList(String instanceId, CommonListRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, SERVICE, instanceId, CONSUMER);
        if (request.getPageNo() != null) {
            internalRequest.addParameter("pageNo", Integer.toString(request.getPageNo()));
        }
        if (request.getPageSize() != null) {
            internalRequest.addParameter("pageSize", Integer.toString(request.getPageSize()));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getOrderBy())) {
            internalRequest.addParameter("orderBy", request.getOrderBy());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getOrder())) {
            internalRequest.addParameter("order", request.getOrder());
        }
        return this.invokeHttpClient(internalRequest, ListConsumerGroupResponse.class);
    }

    public ResetConsumerGroupUserPwdResponse resetUserPwd(String instanceId, String username) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.PUT, SERVICE, instanceId, CONSUMER, username, RESET);
        return this.invokeHttpClient(internalRequest, ResetConsumerGroupUserPwdResponse.class);
    }

    public ConsumerGroupQueueInfoResponse getQueueInfo(String instanceId, String consumerGroupId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, SERVICE, instanceId, CONSUMER, consumerGroupId);
        return this.invokeHttpClient(internalRequest, ConsumerGroupQueueInfoResponse.class);
    }

    public ListSubResponse getSubList(String instanceId, CommonListRequest request) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, SERVICE, instanceId, SUBSCRIPTIONS);
        if (request.getPageNo() != null) {
            internalRequest.addParameter("pageNo", Integer.toString(request.getPageNo()));
        }
        if (request.getPageSize() != null) {
            internalRequest.addParameter("pageSize", Integer.toString(request.getPageSize()));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getOrderBy())) {
            internalRequest.addParameter("orderBy", request.getOrderBy());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getOrder())) {
            internalRequest.addParameter("order", request.getOrder());
        }
        return this.invokeHttpClient(internalRequest, ListSubResponse.class);
    }

    @Deprecated
    public ProductSubscriptionResponse getSub(String instanceId, String productKey) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, SERVICE, instanceId, productKey, SUBSCRIPTIONS);
        return this.invokeHttpClient(internalRequest, ProductSubscriptionResponse.class);
    }

    public ProductSubscriptionResponse getSubTopics(String instanceId, String productKey) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, SERVICE, instanceId, productKey, SUBSCRIPTIONS, TOPICS);
        return this.invokeHttpClient(internalRequest, ProductSubscriptionResponse.class);
    }

    @Deprecated
    public void updateSub(String instanceId, String productKey, UpdateProductSubscriptionRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, SERVICE, instanceId, productKey, SUBSCRIPTIONS);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateSubTopics(String instanceId, String productKey, UpdateProductSubscriptionRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, SERVICE, instanceId, productKey, SUBSCRIPTIONS, TOPICS);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateSubState(String instanceId, String productKey, boolean state) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.POST, SERVICE, instanceId, productKey, SUBSCRIPTIONS);
        internalRequest.addParameter(STATE, Boolean.toString(state));
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ProductSubscriptionResponse getMessageType(String instanceId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, SERVICE, instanceId, MESSAGE, TYPE);
        return this.invokeHttpClient(internalRequest, ProductSubscriptionResponse.class);
    }

    public void updateGatewayState(String instanceId, String productKey, String deviceName, boolean state) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.PUT, SERVICE, instanceId, productKey, deviceName, GATEWAY);
        internalRequest.addParameter(STATE, Boolean.toString(state));
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ComputationSourceResponse getGatewayInfo(String instanceId, String productKey, String deviceName) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, SERVICE, instanceId, productKey, deviceName, GATEWAY);
        return this.invokeHttpClient(internalRequest, ComputationSourceResponse.class);
    }

    public void resetGatewaySecret(String instanceId, String productKey, String deviceName) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.PUT, SERVICE, instanceId, productKey, deviceName, GATEWAY, RESET);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListUserLogResponse getLogList(String instanceId, ListUserLogRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, LOG, instanceId);
        internalRequest.addParameter("logType", request.getLogType());
        internalRequest.addParameter("pageNo", Integer.toString(request.getPageNo()));
        internalRequest.addParameter("pageSize", Integer.toString(request.getPageSize()));
        if (StringUtils.isNotEmpty((CharSequence)request.getLogSubType())) {
            internalRequest.addParameter("logSubType", request.getLogSubType());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getFlag())) {
            internalRequest.addParameter("flag", request.getFlag());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getProductKey())) {
            internalRequest.addParameter("productKey", request.getProductKey());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getDeviceName())) {
            internalRequest.addParameter("deviceName", request.getDeviceName());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getKeyword())) {
            internalRequest.addParameter("keyword", request.getKeyword());
        }
        if (request.getBeginTime() != null) {
            internalRequest.addParameter("beginTime", Long.toString(request.getBeginTime()));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", Long.toString(request.getEndTime()));
        }
        return this.invokeHttpClient(internalRequest, ListUserLogResponse.class);
    }

    public GroupInfo createGroup(String instanceId, CreateGroupRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, GROUPS, instanceId);
        return this.invokeHttpClient(internalRequest, GroupInfo.class);
    }

    public ListGroupResponse getGroupList(String instanceId, ListGroupRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, GROUPS, instanceId);
        if (StringUtils.isNotEmpty((CharSequence)request.getSuperGroupId())) {
            internalRequest.addParameter("superGroupId", request.getSuperGroupId());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getRootGroupId())) {
            internalRequest.addParameter("rootGroupId", request.getRootGroupId());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getKeyword())) {
            internalRequest.addParameter("keyword", request.getKeyword());
        }
        if (request.getPageNo() != null) {
            internalRequest.addParameter("pageNo", Integer.toString(request.getPageNo()));
        }
        if (request.getPageSize() != null) {
            internalRequest.addParameter("pageSize", Integer.toString(request.getPageSize()));
        }
        return this.invokeHttpClient(internalRequest, ListGroupResponse.class);
    }

    public void deleteGroup(String instanceId, String groupId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.DELETE, GROUPS, instanceId, groupId);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public GroupInfo updateGroup(String instanceId, String groupId, UpdateGroupInfoRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, GROUPS, instanceId, groupId);
        return this.invokeHttpClient(internalRequest, GroupInfo.class);
    }

    public GroupInfo getGroup(String instanceId, String groupId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, GROUPS, instanceId, groupId);
        return this.invokeHttpClient(internalRequest, GroupInfo.class);
    }

    public void addDeviceToGroup(String instanceId, String groupId, List<DeviceKey> listDeviceKey) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.POST, GROUPS, instanceId, groupId, DEVICES);
        String jsonStr = JsonUtils.toJsonString(listDeviceKey);
        try {
            byte[] content = jsonStr.getBytes("UTF-8");
            internalRequest.setContent(RestartableInputStream.wrap(content));
            internalRequest.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteDeviceFromGroup(String instanceId, String groupId, List<DeviceKey> listDeviceKey) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.PUT, GROUPS, instanceId, groupId, DEVICES, DELETE);
        String jsonStr = JsonUtils.toJsonString(listDeviceKey);
        try {
            byte[] content = jsonStr.getBytes("UTF-8");
            internalRequest.setContent(RestartableInputStream.wrap(content));
            internalRequest.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListDeviceByGroupResponse listDeviceByGroup(String instanceId, String groupId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, GROUPS, instanceId, groupId, DEVICES);
        return this.invokeHttpClient(internalRequest, ListDeviceByGroupResponse.class);
    }

    public ListBindComponentResponse bindProductComponents(String instanceId, String productKey, BindComponentRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, PRODUCTS, instanceId, productKey, COMPONENTS);
        return this.invokeHttpClient(internalRequest, ListBindComponentResponse.class);
    }

    public void unbindProductComponent(String instanceId, String productKey, String bindName, BindComponentRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, PRODUCTS, instanceId, productKey, COMPONENTS, bindName);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListBindComponentResponse listProductComponents(String instanceId, String productKey) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCTS, instanceId, productKey, COMPONENTS);
        return this.invokeHttpClient(internalRequest, ListBindComponentResponse.class);
    }

    public ListBindComponentResponse listDeviceComponents(String instanceId, String productKey, String deviceName, String bindName) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DEVICES, instanceId, productKey, deviceName, COMPONENTS);
        if (StringUtils.isNotEmpty((CharSequence)bindName)) {
            internalRequest.addParameter("bindName", bindName);
        }
        return this.invokeHttpClient(internalRequest, ListBindComponentResponse.class);
    }

    public CreateLinkageRuleResponse createLinkageRule(String instanceId, CreateLinkageRuleRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, PLATFORM_LINKAGES, instanceId);
        return this.invokeHttpClient(internalRequest, CreateLinkageRuleResponse.class);
    }

    public void deleteLinkageRule(String instanceId, BatchDeleteLinkageRuleRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, PLATFORM_LINKAGES, instanceId, BATCH_DELETE);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateLinkageRule(String instanceId, String ruleId, UpdateLinkageRuleRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, PLATFORM_LINKAGES, instanceId, ruleId);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public LinkageRuleInfo getLinkageRule(String instanceId, String ruleId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PLATFORM_LINKAGES, instanceId, ruleId);
        return this.invokeHttpClient(internalRequest, LinkageRuleInfo.class);
    }

    public ListLinkageRuleResponse listLinkageRule(String instanceId, int pageNo, int pageSize, String name) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PLATFORM_LINKAGES, instanceId);
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            internalRequest.addParameter("name", name);
        }
        internalRequest.addParameter("pageNo", Integer.toString(pageNo));
        internalRequest.addParameter("pageSize", Integer.toString(pageSize));
        return this.invokeHttpClient(internalRequest, ListLinkageRuleResponse.class);
    }

    public void updateLinkageRuleState(String instanceId, String ruleId, boolean state) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.PUT, PLATFORM_LINKAGES, instanceId, ruleId, STATE);
        internalRequest.addParameter(STATE, Boolean.toString(state));
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListProductCategoryResponse listProductCategory() {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCTS, CATEGORIES);
        return this.invokeHttpClient(internalRequest, ListProductCategoryResponse.class);
    }

    public ListProductModelResponse listProductModel(ListProductModelRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, PRODUCTS, REPOSITORIES, MODELS);
        if (StringUtils.isNotEmpty((CharSequence)request.getProductName())) {
            internalRequest.addParameter("productName", request.getProductName());
        }
        internalRequest.addParameter("pageNo", Integer.toString(request.getPageNo()));
        internalRequest.addParameter("pageSize", Integer.toString(request.getPageSize()));
        return this.invokeHttpClient(internalRequest, ListProductModelResponse.class);
    }

    public ProductModelInfo getMainProductInfo(String modelId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCTS, REPOSITORIES, MODELS, modelId, INFO);
        return this.invokeHttpClient(internalRequest, ProductModelInfo.class);
    }

    public ListBindComponentResponse getMainProductComponents(String modelId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCTS, REPOSITORIES, MODELS, modelId, COMPONENTS);
        return this.invokeHttpClient(internalRequest, ListBindComponentResponse.class);
    }

    public ListFeaturePropertyResponse getMainProductProperties(String modelId, int pageNo, int pageSize) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCTS, REPOSITORIES, MODELS, modelId, FEATURE, PROPERTIES);
        internalRequest.addParameter("pageNo", Integer.toString(pageNo));
        internalRequest.addParameter("pageSize", Integer.toString(pageSize));
        return this.invokeHttpClient(internalRequest, ListFeaturePropertyResponse.class);
    }

    public ListFeatureEventResponse getMainProductEvents(String modelId, int pageNo, int pageSize) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCTS, REPOSITORIES, MODELS, modelId, FEATURE, EVENT);
        internalRequest.addParameter("pageNo", Integer.toString(pageNo));
        internalRequest.addParameter("pageSize", Integer.toString(pageSize));
        return this.invokeHttpClient(internalRequest, ListFeatureEventResponse.class);
    }

    public ListFeatureCommandResponse getMainProductCommands(String modelId, int pageNo, int pageSize) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCTS, REPOSITORIES, MODELS, modelId, FEATURE, COMMAND);
        internalRequest.addParameter("pageNo", Integer.toString(pageNo));
        internalRequest.addParameter("pageSize", Integer.toString(pageSize));
        return this.invokeHttpClient(internalRequest, ListFeatureCommandResponse.class);
    }

    public DtmlDetailResponse getMainProductDTMLDetail(String modelId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, PRODUCTS, REPOSITORIES, MODELS, modelId, FEATURE, DETAIL);
        return this.invokeHttpClient(internalRequest, DtmlDetailResponse.class);
    }

    public void importProductModel(String instanceId, String modelId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.POST, PRODUCTS, MODELS, instanceId, modelId);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public AlarmRuleInfo createAlarmRule(String instanceId, CreateAlarmRuleRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, ALARMS, RULES, instanceId);
        return this.invokeHttpClient(internalRequest, AlarmRuleInfo.class);
    }

    public AlarmRuleInfo updateAlarmRule(String instanceId, String ruleId, UpdateAlarmRuleRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, ALARMS, RULES, instanceId, ruleId);
        return this.invokeHttpClient(internalRequest, AlarmRuleInfo.class);
    }

    public AlarmRuleInfo getAlarmRule(String instanceId, String ruleId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, ALARMS, RULES, instanceId, ruleId);
        return this.invokeHttpClient(internalRequest, AlarmRuleInfo.class);
    }

    public ListAlarmRuleResponse listAlarmRule(String instanceId, String name, int pageNo, int pageSize) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, ALARMS, RULES, instanceId);
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            internalRequest.addParameter("name", name);
        }
        internalRequest.addParameter("pageNo", Integer.toString(pageNo));
        internalRequest.addParameter("pageSize", Integer.toString(pageSize));
        return this.invokeHttpClient(internalRequest, ListAlarmRuleResponse.class);
    }

    public void updateAlarmRuleActiveState(String instanceId, String ruleId, boolean active) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.PUT, ALARMS, RULES, instanceId, ruleId, STATES);
        internalRequest.addParameter("active", Boolean.toString(active));
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void triggerAlarmRule(String instanceId, String ruleId, TriggerAlarmRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, ALARMS, RULES, instanceId, ruleId, TRIGGER);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void batchDeleteAlarmRule(String instanceId, BatchDeleteAlarmRuleRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, ALARMS, RULES, instanceId, BATCH, DELETE);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteAlarmRecord(String instanceId, String recordId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.DELETE, ALARMS, RECORDS, instanceId, recordId);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void batchProcessAlarmRecord(String instanceId, BatchProcessAlarmRecordRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, ALARMS, RECORDS, instanceId, BATCH, PROCESS);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public AlarmRecordInfo getAlarmRecord(String instanceId, String recordId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, ALARMS, RECORDS, instanceId, recordId);
        return this.invokeHttpClient(internalRequest, AlarmRecordInfo.class);
    }

    public ListAlarmRecordResponse listAlarmRecord(String instanceId, ListAlarmRecordRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, ALARMS, RECORDS, instanceId);
        if (request.getPageSize() != null) {
            internalRequest.addParameter("pageSize", Integer.toString(request.getPageSize()));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getCursor())) {
            internalRequest.addParameter("cursor", request.getCursor());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getName())) {
            internalRequest.addParameter("name", request.getName());
        }
        if (request.getAlarmLevel() != null) {
            internalRequest.addParameter("alarmLevel", Integer.toString(request.getAlarmLevel()));
        }
        return this.invokeHttpClient(internalRequest, ListAlarmRecordResponse.class);
    }

    public ConfigManagementListResponse getConfigList(String instanceId, String productKey, String configName, Integer pageNo, Integer pageSize) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, FM, CONFIG, instanceId);
        if (StringUtils.isNotEmpty((CharSequence)productKey)) {
            internalRequest.addParameter("productKey", productKey);
        }
        if (StringUtils.isNotEmpty((CharSequence)configName)) {
            internalRequest.addParameter("configName", configName);
        }
        internalRequest.addParameter("pageNo", Integer.toString(pageNo));
        internalRequest.addParameter("pageSize", Integer.toString(pageSize));
        return this.invokeHttpClient(internalRequest, ConfigManagementListResponse.class);
    }

    public void addConfig(String instanceId, AddConfigRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, FM, CONFIG, instanceId);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteConfig(String instanceId, String productKey, String configId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.DELETE, FM, CONFIG, instanceId, productKey, configId);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void modifyConfig(String instanceId, String productKey, String configId, AddConfigRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, FM, CONFIG, instanceId, productKey, configId);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void addConfigVersion(String instanceId, String productKey, String configId, String version, File file) {
        InternalRequest internalRequest = this.createUploadRequest("importFile", file, HttpMethodName.POST, FM, CONFIG, instanceId, productKey, configId);
        internalRequest.addParameter(CONFIG_VERSION, version);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteConfigVersion(String instanceId, String productKey, String configId, String configVersion) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.DELETE, FM, CONFIG, instanceId, productKey, configId, CONFIG_VERSION);
        internalRequest.addParameter("configVersion", configVersion);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public GetConfigVersionResponse downloadConfigVersion(String instanceId, String productKey, String configId, String configVersion) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, FM, CONFIG, instanceId, productKey, configId, URL);
        internalRequest.addParameter("configVersion", configVersion);
        return this.invokeHttpClient(internalRequest, GetConfigVersionResponse.class);
    }

    public ConfigVersionListResponse getConfigVersionList(String instanceId, String productKey, String configId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, FM, CONFIG, instanceId, productKey, configId, VERSIONS);
        return this.invokeHttpClient(internalRequest, ConfigVersionListResponse.class);
    }

    public ConfigManagementResponse getConfigInfo(String instanceId, String productKey, String configId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, FM, CONFIG, instanceId, productKey, configId);
        return this.invokeHttpClient(internalRequest, ConfigManagementResponse.class);
    }

    @Deprecated
    public ConfigTaskListResponse getTaskList(String instanceId, String productKey, String configId, int pageNo, int pageSize, String taskId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, FM, CONFIG, instanceId, productKey, configId, TASK);
        if (StringUtils.isNotEmpty((CharSequence)taskId)) {
            internalRequest.addParameter("taskId", taskId);
        }
        internalRequest.addParameter("pageNo", Integer.toString(pageNo));
        internalRequest.addParameter("pageSize", Integer.toString(pageSize));
        return this.invokeHttpClient(internalRequest, ConfigTaskListResponse.class);
    }

    public ConfigTaskListResponse getConfigTaskList(String instanceId, String productKey, String configId, int pageNo, int pageSize, String taskId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, FM, CONFIG, instanceId, productKey, configId, TASK);
        if (StringUtils.isNotEmpty((CharSequence)taskId)) {
            internalRequest.addParameter("taskId", taskId);
        }
        internalRequest.addParameter("pageNo", Integer.toString(pageNo));
        internalRequest.addParameter("pageSize", Integer.toString(pageSize));
        return this.invokeHttpClient(internalRequest, ConfigTaskListResponse.class);
    }

    @Deprecated
    public void addTask(String instanceId, String productKey, String configId, AddTaskRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, FM, CONFIG, instanceId, productKey, configId, TASK);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void addConfigTask(String instanceId, String productKey, String configId, AddTaskRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, FM, CONFIG, instanceId, productKey, configId, TASK);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    @Deprecated
    public ConfigTaskDetailListResponse getTaskDetail(String instanceId, String productKey, String configId, int pageNo, int pageSize, String keyword) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, FM, CONFIG, instanceId, productKey, configId, TASK, DETAIL);
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            internalRequest.addParameter("keyword", keyword);
        }
        internalRequest.addParameter("pageNo", Integer.toString(pageNo));
        internalRequest.addParameter("pageSize", Integer.toString(pageSize));
        return this.invokeHttpClient(internalRequest, ConfigTaskDetailListResponse.class);
    }

    public ConfigTaskDetailListResponse getConfigTaskDetail(String instanceId, String productKey, String configId, int pageNo, int pageSize, String keyword) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, FM, CONFIG, instanceId, productKey, configId, TASK, DETAIL);
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            internalRequest.addParameter("keyword", keyword);
        }
        internalRequest.addParameter("pageNo", Integer.toString(pageNo));
        internalRequest.addParameter("pageSize", Integer.toString(pageSize));
        return this.invokeHttpClient(internalRequest, ConfigTaskDetailListResponse.class);
    }

    @Deprecated
    public void addTaskCsv(String instanceId, String productKey, String configId, String configVersion, File file) {
        InternalRequest internalRequest = this.createUploadRequest("importFile", file, HttpMethodName.POST, FM, CONFIG, instanceId, productKey, configId, TASK, CSV);
        internalRequest.addParameter("configVersion", configVersion);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void addConfigTaskCsv(String instanceId, String productKey, String configId, String configVersion, File file) {
        InternalRequest internalRequest = this.createUploadRequest("importFile", file, HttpMethodName.POST, FM, CONFIG, instanceId, productKey, configId, TASK, CSV);
        internalRequest.addParameter("configVersion", configVersion);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public GetBridgeListResponse getBridgeList(String instanceId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, SERVICE, instanceId);
        return this.invokeHttpClient(internalRequest, GetBridgeListResponse.class);
    }

    public ServiceInfoResponse getBridge(String instanceId, String serviceId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, SERVICE, instanceId, serviceId);
        return this.invokeHttpClient(internalRequest, ServiceInfoResponse.class);
    }

    public void updateBridgeState(String instanceId, String serviceId, boolean state) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.PUT, SERVICE, instanceId, serviceId);
        internalRequest.addParameter(STATE, String.valueOf(state));
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void bridgeReset(String instanceId, String serviceId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.PUT, SERVICE, instanceId, serviceId, RESET);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public CreateOtaProductResponse createOtaProduct(String instanceId, String productKey, CreateOtaProductRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, OTA, PRODUCT, instanceId, productKey);
        return this.invokeHttpClient(internalRequest, CreateOtaProductResponse.class);
    }

    public void deleteOtaProduct(String instanceId, String productKey) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.DELETE, OTA, PRODUCT, instanceId, productKey);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public OtaProductDetail getOtaProductDetail(String instanceId, String productKey) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, OTA, PRODUCT, instanceId, productKey);
        return this.invokeHttpClient(internalRequest, OtaProductDetail.class);
    }

    public ListOtaProductResponse listOtaProduct(String instanceId, ListOtaProductRequest request) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, OTA, PRODUCT, instanceId);
        internalRequest.addParameter("page", Integer.toString(request.getPage()));
        internalRequest.addParameter("perPage", Integer.toString(request.getPerPage()));
        if (StringUtils.isNotBlank((CharSequence)request.getSearch())) {
            internalRequest.addParameter("search", request.getSearch());
        }
        return this.invokeHttpClient(internalRequest, ListOtaProductResponse.class);
    }

    public ListOtaProductOperationResponse listOtaProductOperation(String instanceId, String productKey, ListOtaProductOperationRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, OTA, PRODUCT, instanceId, productKey, OPERATION);
        internalRequest.addParameter("page", Integer.toString(request.getPage()));
        internalRequest.addParameter("perPage", Integer.toString(request.getPerPage()));
        if (StringUtils.isNotBlank((CharSequence)request.getSearch())) {
            internalRequest.addParameter("search", request.getSearch());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getSearch())) {
            internalRequest.addParameter(TYPE, Integer.toString(request.getType()));
        }
        if (StringUtils.isNotBlank((CharSequence)request.getSearch())) {
            internalRequest.addParameter("date", request.getDate());
        }
        return this.invokeHttpClient(internalRequest, ListOtaProductOperationResponse.class);
    }

    public OtaProductConfig getOtaProductConfig(String instanceId, String productKey) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, OTA, PRODUCT, instanceId, productKey, CONFIG);
        return this.invokeHttpClient(internalRequest, OtaProductConfig.class);
    }

    public UploadOtaPackageResponse uploadOtaPackage(String instanceId, String productKey, UploadOtaPackageRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, OTA, PACKAGES, instanceId, productKey);
        return this.invokeHttpClient(internalRequest, UploadOtaPackageResponse.class);
    }

    public ListOtaPackageResponse listOtaPackage(String instanceId, String productKey, ListOtaPackageRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, OTA, PACKAGES, instanceId, productKey);
        internalRequest.addParameter("page", Integer.toString(request.getPage()));
        internalRequest.addParameter("perPage", Integer.toString(request.getPerPage()));
        if (StringUtils.isNotBlank((CharSequence)request.getSearchStr())) {
            internalRequest.addParameter("searchStr", request.getSearchStr());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getLabel())) {
            internalRequest.addParameter("label", request.getLabel());
        }
        if (request.getOrderBy() != null) {
            internalRequest.addParameter("orderBy", request.getOrderBy().name());
        }
        if (request.getOrderDirection() != null) {
            internalRequest.addParameter("orderDirection", request.getOrderDirection().name());
        }
        return this.invokeHttpClient(internalRequest, ListOtaPackageResponse.class);
    }

    public void deleteOtaPackage(String instanceId, String productKey, int packageId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.DELETE, OTA, PACKAGES, instanceId, productKey, Integer.toString(packageId));
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public CheckOtaPackageResponse checkOtaPackage(String instanceId, String productKey, CheckOtaPackageRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, OTA, PACKAGES, instanceId, productKey, CHECK);
        return this.invokeHttpClient(internalRequest, CheckOtaPackageResponse.class);
    }

    public OSStsResponse stsOtaPackage(String instanceId, String productKey, String fileName, Long timestamp, Type type) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.POST, OTA, PACKAGES, instanceId, productKey, STS);
        internalRequest.addParameter("fileName", fileName);
        internalRequest.addParameter("timestamp", Long.toString(timestamp));
        internalRequest.addParameter(TYPE, type.name());
        return this.invokeHttpClient(internalRequest, OSStsResponse.class);
    }

    public CreateOtaTaskResponse addOtaTask(String instanceId, String productKey, CreateOtaTaskRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, OTA, TASK, instanceId, productKey);
        return this.invokeHttpClient(internalRequest, CreateOtaTaskResponse.class);
    }

    public void deleteOtaTask(String instanceId, String productKey, int taskId, DeleteOtaTaskRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, OTA, TASK, instanceId, productKey, String.valueOf(taskId));
        internalRequest.addParameter("isTrashed", request.getIsTrashed().toString());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public UpdateOtaTaskResponse updateOtaTask(String instanceId, String productKey, int taskId, UpdateOtaTaskRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, OTA, TASK, instanceId, productKey, String.valueOf(taskId));
        return this.invokeHttpClient(internalRequest, UpdateOtaTaskResponse.class);
    }

    public UpdateOtaTaskStatusResponse updateOtaTaskStatus(String instanceId, String productKey, int taskId, UpdateOtaTaskStatusRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, OTA, TASK, instanceId, productKey, String.valueOf(taskId), STATUS);
        return this.invokeHttpClient(internalRequest, UpdateOtaTaskStatusResponse.class);
    }

    public GetOtaTaskResponse getOtaTask(String instanceId, String productKey, int taskId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, OTA, TASK, instanceId, productKey, String.valueOf(taskId));
        return this.invokeHttpClient(internalRequest, GetOtaTaskResponse.class);
    }

    public ListOtaTaskResponse listOtaTask(String instanceId, String productKey, ListOtaTaskRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, OTA, TASK, instanceId, productKey);
        internalRequest.addParameter("page", Integer.toString(request.getPage()));
        internalRequest.addParameter("perPage", Integer.toString(request.getPerPage()));
        internalRequest.addParameter(STATUS, request.getStatus());
        if (request.getOrderBy() != null) {
            internalRequest.addParameter("orderBy", request.getOrderBy().name());
        }
        if (request.getDirection() != null) {
            internalRequest.addParameter("direction", request.getDirection().name());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getKeyword())) {
            internalRequest.addParameter("keyword", request.getKeyword());
        }
        if (request.getIsTrashed() != null) {
            internalRequest.addParameter("isTrashed", request.getIsTrashed().toString());
        }
        return this.invokeHttpClient(internalRequest, ListOtaTaskResponse.class);
    }

    public void createOrUpdateGrayTask(String instanceId, String productKey, int taskId, CreateOrUpdateGrayTaskRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, OTA, TASK, instanceId, productKey, String.valueOf(taskId), GRAY);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateGrayTaskStatus(String instanceId, String productKey, int taskId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.PUT, OTA, TASK, instanceId, productKey, String.valueOf(taskId), GRAY, STATUS);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public GrayTask getGrayTask(String instanceId, String productKey, int taskId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, OTA, TASK, instanceId, productKey, String.valueOf(taskId), GRAY);
        return this.invokeHttpClient(internalRequest, GrayTask.class);
    }

    public ListAllTestDeviceForTaskResponse listAllTestDeviceForTask(String instanceId, String productKey, int taskId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, OTA, DEVICES, instanceId, productKey, TASK, String.valueOf(taskId), TEST);
        return this.invokeHttpClient(internalRequest, ListAllTestDeviceForTaskResponse.class);
    }

    public SearchDeviceForTaskResponse searchDeviceForTask(String instanceId, String productKey, int taskId, SearchType type, String param) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, OTA, DEVICES, instanceId, productKey, TASK, String.valueOf(taskId));
        internalRequest.addParameter(TYPE, type.name());
        internalRequest.addParameter("param", param);
        return this.invokeHttpClient(internalRequest, SearchDeviceForTaskResponse.class);
    }

    public OtaTaskIssuedStatisticsResponse otaTaskIssuedStatistics(String instanceId, String productKey, int taskId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, OTA, STATISTICS, instanceId, productKey, TASK, String.valueOf(taskId), ISSUED);
        return this.invokeHttpClient(internalRequest, OtaTaskIssuedStatisticsResponse.class);
    }

    public OtaTaskStatisticsResponse otaTaskStatistics(String instanceId, String productKey, int taskId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, OTA, STATISTICS, instanceId, productKey, TASK, String.valueOf(taskId));
        return this.invokeHttpClient(internalRequest, OtaTaskStatisticsResponse.class);
    }

    public OtaTaskIssuedFailedStatisticsResponse otaTaskIssuedFailedStatistics(String instanceId, String productKey, int taskId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, OTA, STATISTICS, instanceId, productKey, TASK, String.valueOf(taskId), ISSUED, FAILED);
        return this.invokeHttpClient(internalRequest, OtaTaskIssuedFailedStatisticsResponse.class);
    }

    public OtaTaskIssuedFailureInfoStatisticsResponse otaTaskIssuedFailureInfoStatistics(String instanceId, String productKey, int taskId, Stage stage) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, OTA, STATISTICS, instanceId, productKey, TASK, String.valueOf(taskId), ISSUED, FAILURES);
        internalRequest.addParameter(STAGE, stage.getStage());
        return this.invokeHttpClient(internalRequest, OtaTaskIssuedFailureInfoStatisticsResponse.class);
    }

    public OtaTaskStageStatisticsResponse otaTaskStageStatistics(String instanceId, String productKey) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, OTA, STATISTICS, instanceId, productKey, TASK, STAGE);
        return this.invokeHttpClient(internalRequest, OtaTaskStageStatisticsResponse.class);
    }

    public OtaTaskProductLineWeekStatisticsResponse otaTaskProductLineWeekStatistics(String instanceId, String productKey, String date) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, OTA, STATISTICS, instanceId, productKey, WEEK);
        internalRequest.addParameter("date", date);
        return this.invokeHttpClient(internalRequest, OtaTaskProductLineWeekStatisticsResponse.class);
    }

    public ListOtaCompletedPackingResponse listOtaCompletedPacking(String instanceId, String productKey, CommonOtaListRequest request) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, OTA, PACKING, instanceId, productKey, COMPLETED);
        internalRequest.addParameter("page", Integer.toString(request.getPage()));
        internalRequest.addParameter("perPage", Integer.toString(request.getPerPage()));
        return this.invokeHttpClient(internalRequest, ListOtaCompletedPackingResponse.class);
    }

    public ListOtaUncompletedPackingResponse listOtaUncompletedPacking(String instanceId, String productKey, CommonOtaListRequest request) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, OTA, PACKING, instanceId, productKey, UNCOMPLETED);
        internalRequest.addParameter("page", Integer.toString(request.getPage()));
        internalRequest.addParameter("perPage", Integer.toString(request.getPerPage()));
        return this.invokeHttpClient(internalRequest, ListOtaUncompletedPackingResponse.class);
    }

    public CreateOtaPackingResponse createOtaPacking(String instanceId, String productKey, CreateOtaPackingRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, OTA, PACKING, instanceId, productKey);
        return this.invokeHttpClient(internalRequest, CreateOtaPackingResponse.class);
    }

    public GetOtaPackingStatusResponse getOtaPackingStatus(String instanceId, String productKey, int issueId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, OTA, PACKING, instanceId, productKey, String.valueOf(issueId), STATUS);
        return this.invokeHttpClient(internalRequest, GetOtaPackingStatusResponse.class);
    }

    public CancelOtaPackingResponse cancelOtaPacking(String instanceId, String productKey, int issueId, String stepName, boolean hasNextStep) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.PUT, OTA, PACKING, instanceId, productKey, String.valueOf(issueId), CANCEL);
        internalRequest.addParameter("stepName", stepName);
        internalRequest.addParameter("hasNextStep", Boolean.toString(hasNextStep));
        return this.invokeHttpClient(internalRequest, CancelOtaPackingResponse.class);
    }

    public DeleteOtaPackingResponse deleteOtaPacking(String instanceId, String productKey, int issueId, String stepName, boolean hasNextStep) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.DELETE, OTA, PACKING, instanceId, productKey, String.valueOf(issueId));
        internalRequest.addParameter("stepName", stepName);
        internalRequest.addParameter("hasNextStep", Boolean.toString(hasNextStep));
        return this.invokeHttpClient(internalRequest, DeleteOtaPackingResponse.class);
    }

    public GetBatchPageResponse getBatchPage(String instanceId, CommonListRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, BATCH, instanceId);
        if (request.getPageNo() != null) {
            internalRequest.addParameter("pageNo", Integer.toString(request.getPageNo()));
        }
        if (request.getPageSize() != null) {
            internalRequest.addParameter("pageSize", Integer.toString(request.getPageSize()));
        }
        return this.invokeHttpClient(internalRequest, GetBatchPageResponse.class);
    }

    public BatchInfoResponse getBatch(String instanceId, String batchId, CommonListRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, BATCH, instanceId, batchId);
        if (request.getPageNo() != null) {
            internalRequest.addParameter("pageNo", Integer.toString(request.getPageNo()));
        }
        if (request.getPageSize() != null) {
            internalRequest.addParameter("pageSize", Integer.toString(request.getPageSize()));
        }
        return this.invokeHttpClient(internalRequest, BatchInfoResponse.class);
    }

    public BatchDownloadMqtt getBatchMqtt(String instanceId, String batchId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, BATCH, instanceId, batchId, MQTT);
        return this.invokeHttpClient(internalRequest, BatchDownloadMqtt.class);
    }

    public GetBatchTuplesResponse getBatchTuples(String instanceId, String batchId) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, BATCH, instanceId, batchId, DOWNLOAD);
        return this.invokeHttpClient(internalRequest, GetBatchTuplesResponse.class);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        if (httpMethod == HttpMethodName.POST || httpMethod == HttpMethodName.PUT) {
            this.fillInHeadAndBody(bceRequest, request);
        }
        return request;
    }

    private InternalRequest createUploadRequest(String name, File file, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        if (httpMethod == HttpMethodName.POST || httpMethod == HttpMethodName.PUT) {
            FilePart fp;
            try {
                fp = new FilePart(name, file);
            }
            catch (FileNotFoundException e) {
                throw new BceClientException("\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u8def\u5f84\u9519\u8bef.");
            }
            Part[] parts = new Part[]{fp};
            MultipartRequestEntity content = new MultipartRequestEntity(parts, new HttpMethodParams());
            request.addHeader("Content-Length", Long.toString(content.getContentLength()));
            request.addHeader("Content-Type", content.getContentType());
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                content.writeRequest((OutputStream)os);
                request.setContent(RestartableInputStream.wrap(os.toByteArray()));
            }
            catch (IOException e) {
                throw new BceClientException("\u5185\u90e8\u9519\u8bef.", e);
            }
            return request;
        }
        throw new BceClientException("\u4e0a\u4f20\u6587\u4ef6\u53ea\u80fd\u4f7f\u7528post\u6216put\u8bf7\u6c42\u65b9\u6cd5.");
    }

    private void fillInHeadAndBody(AbstractBceRequest bceRequest, InternalRequest request) {
        byte[] content = this.toJson(bceRequest);
        request.addHeader("Content-Length", Integer.toString(content.length));
        request.addHeader("Content-Type", CONTENT_TYPE);
        request.setContent(RestartableInputStream.wrap(content));
    }

    private byte[] toJson(AbstractBceRequest bceRequest) {
        String jsonStr = JsonUtils.toJsonString(bceRequest);
        try {
            return jsonStr.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
    }
}

