/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.cdn.model.stat;

import com.baidubce.util.DateUtils;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class GetStatDefaultRequest {
    private String startTime;
    private String endTime;
    private Integer period = 300;
    @JsonProperty(value="key_type")
    private Integer keyType = 0;
    private List<String> key;
    private String groupBy = "key";

    public GetStatDefaultRequest withStartTime(Date startTime) {
        this.startTime = DateUtils.formatAlternateIso8601Date(startTime);
        return this;
    }

    public GetStatDefaultRequest withEndTime(Date endTime) {
        this.endTime = DateUtils.formatAlternateIso8601Date(endTime);
        return this;
    }

    public GetStatDefaultRequest withPeriod(Integer period) {
        this.period = period;
        return this;
    }

    public GetStatDefaultRequest withKeyType(Integer keyType) {
        this.keyType = keyType;
        return this;
    }

    public GetStatDefaultRequest withKey(List<String> key) {
        this.key = key;
        return this;
    }

    public GetStatDefaultRequest withKey(String key) {
        if (null == this.key) {
            this.key = new ArrayList<String>();
        }
        this.key.add(key);
        return this;
    }

    public GetStatDefaultRequest withGroupBy(String groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public Integer getPeriod() {
        return this.period;
    }

    public void setPeriod(Integer period) {
        this.period = period;
    }

    public Integer getKeyType() {
        return this.keyType;
    }

    public void setKeyType(Integer keyType) {
        this.keyType = keyType;
    }

    public List<String> getKey() {
        return this.key;
    }

    public void setKey(List<String> key) {
        this.key = key;
    }

    public String getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }
}

