/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tablestoragehbaseclient.hbase;

import com.baidubce.services.tablestoragehbaseclient.adaptor.TableStorageAdaptor;
import com.baidubce.services.tablestoragehbaseclient.adaptor.TablestorageConfiguration;
import com.baidubce.services.tablestoragehbaseclient.adaptor.TablestorageResultScanner;
import com.baidubce.services.tablestoragehbaseclient.hbase.TablestorageConnection;
import com.google.common.base.Preconditions;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AbstractClientScanner;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.util.Bytes;

public class TablestorageTable
implements Table {
    private final TableName tableName;
    private TablestorageConnection connection;
    private TableStorageAdaptor adaptor;
    private ExecutorService pool;
    private volatile long writeBufferSize = 0L;

    public TablestorageTable(TablestorageConnection connection, TableName tableName) {
        this.connection = connection;
        this.tableName = tableName;
        this.pool = Executors.newCachedThreadPool();
        TablestorageConfiguration conf = connection.getTablestorageConfiguration();
        this.adaptor = new TableStorageAdaptor(conf.getEndpoint(), conf.getInstanceName(), conf.getAccessKeyId(), conf.getSecretAccessKey());
    }

    public TableName getName() {
        return this.tableName;
    }

    public Configuration getConfiguration() {
        return this.connection.getConfiguration();
    }

    public HTableDescriptor getTableDescriptor() throws IOException {
        return this.adaptor.getTable(this.tableName.getNameAsString());
    }

    public boolean exists(Get get) throws IOException {
        Result result = this.get(get);
        return !result.isEmpty();
    }

    public boolean[] existsAll(List<Get> gets) throws IOException {
        Result[] results = this.get(gets);
        boolean[] exists = new boolean[gets.size()];
        int index = 0;
        for (Result result : results) {
            exists[index++] = !result.isEmpty();
        }
        return exists;
    }

    public void batch(List<? extends Row> actions, Object[] results) throws IOException, InterruptedException {
        Object[] objects = this.adaptor.batch(this.tableName.getNameAsString(), actions);
        for (int i = 0; i < objects.length; ++i) {
            results[i] = objects[i];
        }
    }

    @Deprecated
    public Object[] batch(List<? extends Row> actions) throws IOException, InterruptedException {
        Object[] objects = new Object[actions.size()];
        this.batch(actions, objects);
        return objects;
    }

    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("batchCallback(final List<? extends Row> actions, final Object[] results, final Batch.Callback<R> callback)");
    }

    @Deprecated
    public <R> Object[] batchCallback(List<? extends Row> actions, Batch.Callback<R> callback) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("batchCallback(List<? extends Row> actions, Batch.Callback<R> callback)");
    }

    public Result get(Get get) throws IOException {
        Preconditions.checkNotNull((Object)get, (Object)"get should not be null");
        return this.adaptor.getRow(this.tableName.getNameAsString(), get);
    }

    public Result[] get(List<Get> gets) throws IOException {
        Preconditions.checkNotNull(gets, (Object)"gets should not be null");
        if (gets.size() == 0) {
            return new Result[0];
        }
        return this.adaptor.batchGetRow(this.tableName.getNameAsString(), gets);
    }

    public ResultScanner getScanner(Scan scan) throws IOException {
        return new Scanner(this.adaptor, this.pool, scan, this.tableName.getNameAsString());
    }

    public ResultScanner getScanner(byte[] family) throws IOException {
        if (Bytes.compareTo((byte[])family, (byte[])Bytes.toBytes((String)"cf0")) != 0) {
            throw new UnsupportedOperationException("Table only support one Family named cf0");
        }
        Scan scan = new Scan();
        scan.addFamily(family);
        return new Scanner(this.adaptor, this.pool, scan, this.tableName.getNameAsString());
    }

    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        if (Bytes.compareTo((byte[])family, (byte[])Bytes.toBytes((String)"cf0")) != 0) {
            throw new UnsupportedOperationException("Table only support one Family named cf0");
        }
        Scan scan = new Scan();
        scan.addColumn(family, qualifier);
        return new Scanner(this.adaptor, this.pool, scan, this.tableName.getNameAsString());
    }

    public void put(Put put) throws IOException {
        Preconditions.checkNotNull((Object)put, (Object)"put should not be null");
        this.adaptor.putRow(this.tableName.getNameAsString(), put);
    }

    public void put(List<Put> puts) throws IOException {
        Preconditions.checkNotNull(puts, (Object)"puts should not be null");
        if (puts.size() == 0) {
            return;
        }
        this.adaptor.batchPutRow(this.tableName.getNameAsString(), puts);
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put) throws IOException {
        throw new UnsupportedOperationException("checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put)");
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Put put) throws IOException {
        throw new UnsupportedOperationException("checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Put put)");
    }

    public void delete(Delete delete) throws IOException {
        Preconditions.checkNotNull((Object)delete, (Object)"delete should not be null");
        this.adaptor.deleteRow(this.tableName.getNameAsString(), delete);
    }

    public void delete(List<Delete> deletes) throws IOException {
        Preconditions.checkNotNull(deletes, (Object)"deletes should not be null");
        if (deletes.size() == 0) {
            return;
        }
        this.adaptor.batchDeleteRow(this.tableName.getNameAsString(), deletes);
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
        throw new UnsupportedOperationException("checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete)");
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Delete delete) throws IOException {
        throw new UnsupportedOperationException("checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Delete delete)");
    }

    public void mutateRow(RowMutations rm) throws IOException {
        throw new UnsupportedOperationException("mutateRow(final RowMutations rm)");
    }

    public Result append(Append append) throws IOException {
        throw new UnsupportedOperationException("append(final Append append)");
    }

    public Result increment(Increment increment) throws IOException {
        throw new UnsupportedOperationException("increment(final Increment increment)");
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        throw new UnsupportedOperationException("incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount)");
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability) throws IOException {
        throw new UnsupportedOperationException("incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability)");
    }

    public void close() throws IOException {
        this.pool.shutdown();
        this.adaptor.close();
    }

    public CoprocessorRpcChannel coprocessorService(byte[] row) {
        throw new UnsupportedOperationException("coprocessorService(byte[] row)");
    }

    public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws ServiceException, Throwable {
        throw new UnsupportedOperationException("coprocessorService(final Class<T> service, byte[] startKey, byte[] endKey, final Batch.Call<T, R> callable)");
    }

    public <T extends Service, R> void coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws ServiceException, Throwable {
        throw new UnsupportedOperationException("coprocessorService(final Class<T> service, byte[] startKey, byte[] endKey, final Batch.Call<T, R> callable, final Batch.Callback<R> callback)");
    }

    @Deprecated
    public long getWriteBufferSize() {
        return this.writeBufferSize;
    }

    @Deprecated
    public void setWriteBufferSize(long writeBufferSize) throws IOException {
        this.writeBufferSize = writeBufferSize;
    }

    public <R extends Message> Map<byte[], R> batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype) throws ServiceException, Throwable {
        throw new UnsupportedOperationException("batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype)");
    }

    public <R extends Message> void batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype, Batch.Callback<R> callback) throws ServiceException, Throwable {
        throw new UnsupportedOperationException("batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype, Batch.Callback<R> callback)");
    }

    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, RowMutations mutation) throws IOException {
        throw new UnsupportedOperationException("checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, RowMutations mutation)");
    }

    public class Scanner
    extends AbstractClientScanner {
        private TablestorageResultScanner scanner;

        public Scanner(TableStorageAdaptor adaptor, ExecutorService pool, Scan scan, String tableName) {
            this.scanner = new TablestorageResultScanner(adaptor, pool, scan, tableName);
        }

        public Result next() throws IOException {
            return this.scanner.next();
        }

        public Result[] next(int nbRows) throws IOException {
            Result result;
            ArrayList<Result> resultList = new ArrayList<Result>(nbRows);
            for (int i = 0; i < nbRows && (result = this.next()) != null; ++i) {
                resultList.add(result);
            }
            Result[] results = new Result[resultList.size()];
            return resultList.toArray(results);
        }

        public void close() {
            this.scanner.close();
        }

        public boolean renewLease() {
            throw new UnsupportedOperationException("ResultScanner.renewLease()");
        }
    }
}

