/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bos.model;

import com.baidubce.util.Base64Utils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.HashMap;
import java.util.Map;

@JsonPropertyOrder(value={"compressionType", "csv", "json"})
public class InputSerialization {
    private String compressionType;
    @JsonIgnore
    private Map<String, String> params = new HashMap<String, String>();
    @JsonProperty(value="csv")
    private Map<String, String> csvParams;
    @JsonProperty(value="json")
    private Map<String, String> jsonParams;

    public void setCompressionType(String compressionType) {
        this.compressionType = compressionType;
    }

    public String getCompressionType() {
        return this.compressionType;
    }

    public InputSerialization withCompressionType(String compressionType) {
        this.setCompressionType(compressionType);
        return this;
    }

    public InputSerialization withFileHeaderInfo(String fileHeaderInfo) {
        this.params.put("fileHeaderInfo", fileHeaderInfo);
        return this;
    }

    public InputSerialization withRecordDelimiter(String recordDelimiter) {
        this.params.put("recordDelimiter", Base64Utils.encode(recordDelimiter));
        return this;
    }

    public InputSerialization withFieldDelimiter(String fieldDelimiter) {
        this.params.put("fieldDelimiter", Base64Utils.encode(fieldDelimiter));
        return this;
    }

    public InputSerialization withQuoteCharacter(String quoteCharacter) {
        this.params.put("quoteCharacter", Base64Utils.encode(quoteCharacter));
        return this;
    }

    public InputSerialization withCommentCharacter(String commentCharacter) {
        this.params.put("commentCharacter", Base64Utils.encode(commentCharacter));
        return this;
    }

    public InputSerialization withJsonType(String type) {
        this.params.put("type", type);
        return this;
    }

    public Map<String, String> getCsvParams() {
        return this.csvParams;
    }

    public void setCsvParams(Map<String, String> csvParams) {
        this.csvParams = csvParams;
    }

    public Map<String, String> getJsonParams() {
        return this.jsonParams;
    }

    public void setJsonParams(Map<String, String> jsonParams) {
        this.jsonParams = jsonParams;
    }

    public Map<String, String> getParams() {
        return this.params;
    }
}

