/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.appbuilder.model.appbuilderclient;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class AppBuilderClientRunRequest {
    @SerializedName(value="app_id")
    private String appId;
    private String query;
    private boolean stream;
    @SerializedName(value="conversation_id")
    private String conversationID;
    @SerializedName(value="end_user_id")
    private String endUserId;
    private Tool[] tools;
    @SerializedName(value="tool_outputs")
    private ToolOutput[] ToolOutputs;
    @SerializedName(value="tool_choice")
    private ToolChoice ToolChoice;
    private Action action;

    public AppBuilderClientRunRequest() {
    }

    public AppBuilderClientRunRequest(String appID) {
        this.appId = appID;
    }

    public AppBuilderClientRunRequest(String appID, String conversationID) {
        this.appId = appID;
        this.conversationID = conversationID;
    }

    public AppBuilderClientRunRequest(String appID, String conversationID, String query, Boolean stream) {
        this.appId = appID;
        this.conversationID = conversationID;
        this.query = query;
        this.stream = stream;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public boolean isStream() {
        return this.stream;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public String getConversationID() {
        return this.conversationID;
    }

    public void setConversationID(String conversationID) {
        this.conversationID = conversationID;
    }

    public String getEndUserId() {
        return this.endUserId;
    }

    public void setEndUserId(String endUserId) {
        this.endUserId = endUserId;
    }

    public Tool[] getTools() {
        return this.tools;
    }

    public void setTools(Tool[] tools) {
        this.tools = tools;
    }

    public void setTools(String toolJson) {
        Gson gson = new Gson();
        Tool tool = (Tool)gson.fromJson(toolJson, Tool.class);
        this.tools = new Tool[]{tool};
    }

    public void setTools(String[] toolJsons) {
        Gson gson = new Gson();
        this.tools = new Tool[toolJsons.length];
        for (int i = 0; i < toolJsons.length; ++i) {
            Tool tool;
            this.tools[i] = tool = (Tool)gson.fromJson(toolJsons[i], Tool.class);
        }
    }

    public ToolOutput[] getToolOutputs() {
        return this.ToolOutputs;
    }

    public void setToolOutputs(ToolOutput[] toolOutputs) {
        this.ToolOutputs = toolOutputs;
    }

    public void setToolOutputs(String toolCallID, String outputString) {
        ToolOutput output = new ToolOutput(toolCallID, outputString);
        this.ToolOutputs = new ToolOutput[]{output};
    }

    public ToolChoice getToolChoice() {
        return this.ToolChoice;
    }

    public void setToolChoice(ToolChoice toolChoice) {
        this.ToolChoice = toolChoice;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public static class Action {
        @SerializedName(value="action_type")
        private String actionType;
        private Parameters parameters;

        public static Action createAction(String interruptId) {
            return Action.createAction("resume", interruptId, "chat");
        }

        public static Action createAction(String actionType, String id, String type) {
            Parameters.InterruptEvent interruptEvent = new Parameters.InterruptEvent(id, type);
            Parameters parameters = new Parameters(interruptEvent);
            return new Action(actionType, parameters);
        }

        public Action(String actionType, Parameters parameters) {
            this.actionType = actionType;
            this.parameters = parameters;
        }

        public String getActionType() {
            return this.actionType;
        }

        public Parameters getParameters() {
            return this.parameters;
        }

        public static class Parameters {
            @SerializedName(value="interrupt_event")
            private InterruptEvent interruptEvent;

            public Parameters(InterruptEvent interruptEvent) {
                this.interruptEvent = interruptEvent;
            }

            public InterruptEvent getInterruptEvent() {
                return this.interruptEvent;
            }

            public static class InterruptEvent {
                private String id;
                private String type;

                public InterruptEvent(String id, String type) {
                    this.id = id;
                    this.type = type;
                }

                public String getId() {
                    return this.id;
                }

                public String getType() {
                    return this.type;
                }
            }
        }
    }

    public static class ToolChoice {
        private String type;
        private Function function;

        public ToolChoice(String type, Function function) {
            this.type = type;
            this.function = function;
        }

        public String getType() {
            return this.type;
        }

        public Function getFunction() {
            return this.function;
        }

        public static class Function {
            private String name;
            private Map<String, Object> input;

            public Function(String name, Map<String, Object> input) {
                this.name = name;
                this.input = input;
            }

            public String getName() {
                return this.name;
            }

            public Map<String, Object> getInput() {
                return this.input;
            }
        }
    }

    public static class ToolOutput {
        @SerializedName(value="tool_call_id")
        private String toolCallID;
        private String output;

        public ToolOutput(String toolCallID, String output) {
            this.toolCallID = toolCallID;
            this.output = output;
        }

        public String getToolCallID() {
            return this.toolCallID;
        }

        public String getOutput() {
            return this.output;
        }
    }

    public static class Tool {
        private String type;
        private Function function;

        public Tool(String type, Function function) {
            this.type = type;
            this.function = function;
        }

        public String getType() {
            return this.type;
        }

        public Function getFunction() {
            return this.function;
        }

        public static class Function {
            private String name;
            private String description;
            private Map<String, Object> parameters;

            public Function(String name, String description, Map<String, Object> parameters) {
                this.name = name;
                this.description = description;
                this.parameters = parameters;
            }

            public String getName() {
                return this.name;
            }

            public String getDescription() {
                return this.description;
            }

            public Map<String, Object> getParameters() {
                return this.parameters;
            }
        }
    }
}

