/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.appbuilder.console.componentclient;

import com.baidubce.appbuilder.base.component.Component;
import com.baidubce.appbuilder.base.exception.AppBuilderServerException;
import com.baidubce.appbuilder.base.utils.http.HttpResponse;
import com.baidubce.appbuilder.base.utils.json.JsonUtils;
import com.baidubce.appbuilder.model.componentclient.ComponentClientIterator;
import com.baidubce.appbuilder.model.componentclient.ComponentClientRunResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;

public class ComponentClient
extends Component {
    public ComponentClient() {
    }

    public ComponentClient(String secretKey) {
        super(secretKey);
    }

    public ComponentClient(String secretKey, String gateway) {
        super(secretKey, gateway);
    }

    public ComponentClientIterator run(String componentId, String version, String action, boolean stream, Map<String, Object> parameters) throws IOException, AppBuilderServerException {
        String url = "/components";
        String urlSuffix = String.format("%s/%s", url, componentId);
        if (!version.isEmpty()) {
            urlSuffix = urlSuffix + String.format("/version/%s", version);
        }
        if (!action.isEmpty()) {
            urlSuffix = urlSuffix.contains("?") ? urlSuffix + String.format("&action=%s", action) : urlSuffix + String.format("?action=%s", action);
        }
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("parameters", parameters);
        requestBody.put("stream", stream);
        String jsonBody = JsonUtils.serialize(requestBody);
        ClassicHttpRequest postRequest = this.httpClient.createPostRequestV2(urlSuffix, (HttpEntity)new StringEntity(jsonBody, StandardCharsets.UTF_8));
        postRequest.setHeader("Content-Type", (Object)"application/json");
        HttpResponse response = this.httpClient.executeSSE(postRequest, (Type)((Object)ComponentClientRunResponse.class));
        return new ComponentClientIterator(response.getBody());
    }
}

