/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.appbuilder.base.component;

import com.baidubce.appbuilder.base.utils.http.HttpClient;

public class Component {
    protected HttpClient httpClient;

    public Component() {
        this.initClient("", "");
    }

    public Component(String secretKey) {
        this.initClient(secretKey, "");
    }

    public Component(String secretKey, String gateway) {
        this.initClient(secretKey, gateway);
    }

    private void initClient(String secretKey, String gateway) {
        gateway = this.getEnvWithDefault("GATEWAY_URL", gateway, "https://appbuilder.baidu.com");
        String gatewayV2 = this.getEnvWithDefault("GATEWAY_URL_V2", "", "https://qianfan.baidubce.com");
        if ((secretKey = this.getEnvWithDefault("APPBUILDER_TOKEN", secretKey, "")).isEmpty()) {
            throw new RuntimeException("param secretKey is null and env APPBUILDER_TOKEN not set!");
        }
        String secretKeyPrefix = this.getEnvWithDefault("SECRET_KEY_PREFIX", "", "Bearer");
        if (!secretKey.startsWith(secretKeyPrefix)) {
            secretKey = String.format("%s %s", secretKeyPrefix, secretKey);
        }
        this.httpClient = new HttpClient(secretKey, gateway, gatewayV2);
        this.httpClient.ConsoleOpenAPIPrefix = this.getEnvWithDefault("CONSOLE_OPENAPI_PREFIX", "", "");
        this.httpClient.ConsoleOpenAPIVersion = this.getEnvWithDefault("CONSOLE_OPENAPI_VERSION", "", "/v2");
    }

    private String getEnvWithDefault(String propertyKey, String currentValue, String defaultValue) {
        if (currentValue == null || currentValue.isEmpty()) {
            currentValue = System.getProperty(propertyKey);
            if (currentValue == null) {
                currentValue = System.getenv(propertyKey);
            }
            if (currentValue == null) {
                currentValue = defaultValue;
            }
        }
        return currentValue;
    }
}

