/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bjf.remoting.protobuf.code;

import com.baidu.bjf.remoting.protobuf.FieldType;
import com.baidu.bjf.remoting.protobuf.code.CodedConstant;
import com.baidu.bjf.remoting.protobuf.code.ICodeGenerator;
import com.baidu.bjf.remoting.protobuf.utils.ClassHelper;
import com.baidu.bjf.remoting.protobuf.utils.FieldInfo;
import com.baidu.bjf.remoting.protobuf.utils.FieldUtils;
import com.baidu.bjf.remoting.protobuf.utils.ProtobufProxyUtils;
import com.baidu.bjf.remoting.protobuf.utils.StringUtils;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCodeGenerator
implements ICodeGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)AbstractCodeGenerator.class.getCanonicalName());
    protected boolean debug = false;
    protected File outputPath;
    protected Class<?> cls;
    private String targetProxyClassname;
    protected List<FieldInfo> fields;

    public AbstractCodeGenerator(Class<?> cls) {
        this.cls = cls;
        this.targetProxyClassname = ClassHelper.getInternalName(cls.getCanonicalName());
        this.fields = ProtobufProxyUtils.fetchFieldInfos(cls, true);
    }

    public void getAllDependenciesClasses(Set<Class> list) {
        if (list == null) {
            throw new RuntimeException("param 'list' is null.");
        }
        this.getAllDependenciesClasses(this.cls, list);
    }

    private void getAllDependenciesClasses(Class cls, Set<Class> list) {
        if (list == null) {
            throw new RuntimeException("param 'list' is null.");
        }
        Set<Class> dependenciesClasses = this.getDependenciesClasses(cls);
        if (dependenciesClasses.isEmpty()) {
            return;
        }
        for (Class dependencyClass : dependenciesClasses) {
            if (list.contains(dependencyClass)) continue;
            list.add(dependencyClass);
            Set<Class> subDependenciesClasses = this.getDependenciesClasses(dependencyClass);
            if (subDependenciesClasses.isEmpty()) continue;
            for (Class subClass : subDependenciesClasses) {
                if (list.contains(subClass)) continue;
                list.add(subClass);
                this.getAllDependenciesClasses(subClass, list);
            }
        }
    }

    public Set<Class> getDependenciesClasses(Class cls) {
        List<FieldInfo> fields;
        block3: {
            fields = null;
            try {
                fields = ProtobufProxyUtils.fetchFieldInfos(cls, true);
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
        if (fields == null) {
            return Collections.emptySet();
        }
        Set<Class> dependenciesClasses = this.getDependenciesClasses(fields);
        return dependenciesClasses;
    }

    public Set<Class> getDependenciesClasses() {
        return this.getDependenciesClasses(this.fields);
    }

    public Set<Class> getDependenciesClasses(List<FieldInfo> fields) {
        if (fields == null) {
            return Collections.emptySet();
        }
        HashSet<Class> ret = new HashSet<Class>();
        for (FieldInfo fieldInfo : fields) {
            Class<?> genericKeyType;
            if (fieldInfo.isObjectType()) {
                if (fieldInfo.isList()) {
                    genericKeyType = fieldInfo.getGenericKeyType();
                    if (FieldInfo.isPrimitiveType(genericKeyType)) continue;
                    ret.add(genericKeyType);
                    continue;
                }
                ret.add(fieldInfo.getField().getType());
                continue;
            }
            if (fieldInfo.isMap()) {
                Class<?> genericeValueType;
                genericKeyType = fieldInfo.getGenericKeyType();
                if (!FieldInfo.isPrimitiveType(genericKeyType)) {
                    ret.add(genericKeyType);
                }
                if (FieldInfo.isPrimitiveType(genericeValueType = fieldInfo.getGenericeValueType())) continue;
                ret.add(genericeValueType);
                continue;
            }
            if (fieldInfo.isList()) {
                genericKeyType = fieldInfo.getGenericKeyType();
                if (FieldInfo.isPrimitiveType(genericKeyType)) continue;
                ret.add(genericKeyType);
                continue;
            }
            if (!fieldInfo.getFieldType().isEnum()) continue;
            ret.add(fieldInfo.getField().getType());
        }
        return ret;
    }

    protected String getTargetProxyClassname() {
        return this.targetProxyClassname;
    }

    @Override
    public void setOutputPath(File outputPath) {
        this.outputPath = outputPath;
    }

    protected File getOutputPath() {
        return this.outputPath;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public String getClassName() {
        return ClassHelper.getClassName(this.cls);
    }

    @Override
    public String getPackage() {
        return ClassHelper.getPackage(this.cls);
    }

    @Override
    public String getFullClassName() {
        if (StringUtils.isEmpty(this.getPackage())) {
            return this.getClassName();
        }
        return this.getPackage() + "." + this.getClassName();
    }

    protected void checkType(FieldType type, Field field) {
        Class<?> cls = field.getType();
        if (type == FieldType.OBJECT || type == FieldType.ENUM) {
            return;
        }
        String javaType = type.getJavaType();
        if (Integer.class.getSimpleName().equals(javaType)) {
            if (cls.getSimpleName().equals("int") || cls.getSimpleName().equals("short") || Integer.class.getSimpleName().equals(cls.getSimpleName())) {
                return;
            }
            throw new IllegalArgumentException(this.getMismatchTypeErroMessage(type, field));
        }
        if (!javaType.equalsIgnoreCase(cls.getSimpleName()) && !javaType.equalsIgnoreCase(cls.getName())) {
            throw new IllegalArgumentException(this.getMismatchTypeErroMessage(type, field));
        }
    }

    private String getMismatchTypeErroMessage(FieldType type, Field field) {
        return "Type mismatch. @Protobuf required type '" + type.getJavaType() + "' but field type is '" + field.getType().getSimpleName() + "' of field name '" + field.getName() + "' on class " + field.getDeclaringClass().getCanonicalName();
    }

    protected String getAccessByField(String target, Field field, Class<?> cls, boolean wildcardType) {
        if (field.getModifiers() == 1 && !wildcardType) {
            return target + "." + field.getName();
        }
        String getter = "boolean".equalsIgnoreCase(field.getType().getCanonicalName()) ? "is" + CodedConstant.capitalize(field.getName()) : "get" + CodedConstant.capitalize(field.getName());
        try {
            cls.getMethod(getter, new Class[0]);
            return target + "." + getter + "()";
        }
        catch (Exception e) {
            String type;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            if ("[B".equals(type = field.getType().getCanonicalName()) || "[Ljava.lang.Byte;".equals(type) || "java.lang.Byte[]".equals(type)) {
                type = "byte[]";
            }
            String code = "(" + FieldUtils.toObjectType(type) + ") ";
            code = code + "FieldUtils.getField(" + target + ", \"" + field.getName() + "\")";
            return code;
        }
    }
}

