/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.dev2.thirdparty.jackson.databind.deser.std;

import com.baidu.dev2.thirdparty.jackson.core.JsonParser;
import com.baidu.dev2.thirdparty.jackson.databind.DeserializationContext;
import com.baidu.dev2.thirdparty.jackson.databind.deser.std.StdScalarDeserializer;
import com.baidu.dev2.thirdparty.jackson.databind.type.LogicalType;
import com.baidu.dev2.thirdparty.jackson.databind.util.ByteBufferBackedOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBufferDeserializer
extends StdScalarDeserializer<ByteBuffer> {
    private static final long serialVersionUID = 1L;

    protected ByteBufferDeserializer() {
        super(ByteBuffer.class);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Binary;
    }

    @Override
    public ByteBuffer deserialize(JsonParser parser, DeserializationContext cx) throws IOException {
        byte[] b = parser.getBinaryValue();
        return ByteBuffer.wrap(b);
    }

    @Override
    public ByteBuffer deserialize(JsonParser jp, DeserializationContext ctxt, ByteBuffer intoValue) throws IOException {
        ByteBufferBackedOutputStream out = new ByteBufferBackedOutputStream(intoValue);
        jp.readBinaryValue(ctxt.getBase64Variant(), out);
        out.close();
        return intoValue;
    }
}

