/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.dev2.thirdparty.http.protocol;

import com.baidu.dev2.thirdparty.http.HttpException;
import com.baidu.dev2.thirdparty.http.HttpResponse;
import com.baidu.dev2.thirdparty.http.HttpResponseInterceptor;
import com.baidu.dev2.thirdparty.http.annotation.Contract;
import com.baidu.dev2.thirdparty.http.annotation.ThreadingBehavior;
import com.baidu.dev2.thirdparty.http.protocol.HttpContext;
import com.baidu.dev2.thirdparty.http.protocol.HttpDateGenerator;
import com.baidu.dev2.thirdparty.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.SAFE)
public class ResponseDate
implements HttpResponseInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && !response.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            response.setHeader("Date", httpdate);
        }
    }
}

