/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.dev2.thirdparty.http.impl.cookie;

import com.baidu.dev2.thirdparty.http.annotation.Contract;
import com.baidu.dev2.thirdparty.http.annotation.ThreadingBehavior;
import com.baidu.dev2.thirdparty.http.cookie.CommonCookieAttributeHandler;
import com.baidu.dev2.thirdparty.http.cookie.Cookie;
import com.baidu.dev2.thirdparty.http.cookie.CookieOrigin;
import com.baidu.dev2.thirdparty.http.cookie.CookieRestrictionViolationException;
import com.baidu.dev2.thirdparty.http.cookie.MalformedCookieException;
import com.baidu.dev2.thirdparty.http.cookie.SetCookie;
import com.baidu.dev2.thirdparty.http.impl.cookie.AbstractCookieAttributeHandler;
import com.baidu.dev2.thirdparty.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RFC2109VersionHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        if (value.trim().isEmpty()) {
            throw new MalformedCookieException("Blank value for version attribute");
        }
        try {
            cookie.setVersion(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid version: " + e.getMessage());
        }
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie.getVersion() < 0) {
            throw new CookieRestrictionViolationException("Cookie version may not be negative");
        }
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

