/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.dev2.thirdparty.http.impl.cookie;

import com.baidu.dev2.thirdparty.http.annotation.Contract;
import com.baidu.dev2.thirdparty.http.annotation.ThreadingBehavior;
import com.baidu.dev2.thirdparty.http.cookie.CommonCookieAttributeHandler;
import com.baidu.dev2.thirdparty.http.cookie.Cookie;
import com.baidu.dev2.thirdparty.http.cookie.CookieOrigin;
import com.baidu.dev2.thirdparty.http.cookie.MalformedCookieException;
import com.baidu.dev2.thirdparty.http.cookie.SetCookie;
import com.baidu.dev2.thirdparty.http.impl.cookie.AbstractCookieAttributeHandler;
import com.baidu.dev2.thirdparty.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

