/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.dev2.thirdparty.http.client.protocol;

import com.baidu.dev2.thirdparty.commons.logging.Log;
import com.baidu.dev2.thirdparty.commons.logging.LogFactory;
import com.baidu.dev2.thirdparty.http.HttpException;
import com.baidu.dev2.thirdparty.http.HttpRequest;
import com.baidu.dev2.thirdparty.http.HttpRequestInterceptor;
import com.baidu.dev2.thirdparty.http.annotation.Contract;
import com.baidu.dev2.thirdparty.http.annotation.ThreadingBehavior;
import com.baidu.dev2.thirdparty.http.client.protocol.HttpClientContext;
import com.baidu.dev2.thirdparty.http.conn.routing.RouteInfo;
import com.baidu.dev2.thirdparty.http.protocol.HttpContext;
import com.baidu.dev2.thirdparty.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestClientConnControl
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String PROXY_CONN_DIRECTIVE = "Proxy-Connection";

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            request.setHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
            return;
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RouteInfo route = clientContext.getHttpRoute();
        if (route == null) {
            this.log.debug("Connection route not set in the context");
            return;
        }
        if ((route.getHopCount() == 1 || route.isTunnelled()) && !request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
        if (route.getHopCount() == 2 && !route.isTunnelled() && !request.containsHeader(PROXY_CONN_DIRECTIVE)) {
            request.addHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
        }
    }
}

