/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.dev2.api.sdk.manual.upload;

import com.baidu.dev2.api.sdk.invoke.ApiClient;
import com.baidu.dev2.api.sdk.invoke.ApiException;
import com.baidu.dev2.api.sdk.invoke.Pair;
import com.baidu.dev2.api.sdk.manual.upload.model.InitiateMultipartUploadInfo;
import com.baidu.dev2.api.sdk.manual.upload.model.InitiateMultipartUploadResponseWrapper;
import com.baidu.dev2.api.sdk.manual.upload.model.PartEtag;
import com.baidu.dev2.api.sdk.manual.upload.model.UploadPartResponseWrapper;
import com.baidu.dev2.thirdparty.http.client.methods.CloseableHttpResponse;
import com.baidu.dev2.thirdparty.jackson.core.type.TypeReference;
import com.baidu.dev2.thirdparty.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class UploadClient {
    private ApiClient apiClient;
    public static final UploadClient INSTANCE = new UploadClient();
    private static final int MIN_PART_SIZE = 102400;
    private static final int MAX_PART_SIZE = 0x6400000;
    private static final int DEFAULT_MULTIPART_THRESHOLD = 0x6400000;
    private static final int DEFAULT_PART_SIZE = 0x500000;
    private ThreadPoolExecutor simpleUploadExecutor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors() * 2, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(512), new ThreadPoolExecutor.CallerRunsPolicy());
    private ThreadPoolExecutor mulitUploadExecutor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors() * 2, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1024), new ThreadPoolExecutor.CallerRunsPolicy());

    public UploadClient() {
        this.apiClient = new UploadApiClient();
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setSimpleUploadExecutor(ThreadPoolExecutor simpleUploadExecutor) {
        this.simpleUploadExecutor = simpleUploadExecutor;
    }

    public void setMulitUploadExecutor(ThreadPoolExecutor mulitUploadExecutor) {
        this.mulitUploadExecutor = mulitUploadExecutor;
    }

    public <R> R uploadFile(String path, Map<String, Object> formParams, File file, ObjectNode paramsJson, String fileKey, Integer multipartThreshold, Integer partSize, Integer partParallel, Integer timeout, TypeReference<R> returnType) throws ApiException {
        if (file == null || file.length() <= 0L) {
            throw new ApiException("invalid file:" + file);
        }
        if (partSize != null && (partSize < 102400 || partSize > 0x6400000)) {
            throw new ApiException("invalid partSize");
        }
        if (partParallel != null && partParallel < 1) {
            throw new ApiException("invalid partParallel");
        }
        if (multipartThreshold != null && multipartThreshold < 0x500000) {
            throw new ApiException("invalid multipartThreshold");
        }
        if (fileKey == null) {
            fileKey = "file";
        }
        if (multipartThreshold == null) {
            multipartThreshold = 0x6400000;
        }
        if (partSize == null) {
            partSize = 0x500000;
        }
        if (partParallel == null) {
            partParallel = 5;
        }
        if (formParams == null) {
            formParams = new HashMap<String, Object>();
        }
        if (timeout == null || timeout < 0) {
            timeout = 0;
        }
        String localVarPath = path;
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = formParams;
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        try {
            CallResult callResult;
            Callable<CallResult<R>> call;
            Future<R> future = null;
            if (file.length() <= (long)multipartThreshold.intValue()) {
                localVarFormParams.put(fileKey, file);
                localVarFormParams.put("params", this.apiClient.getObjectMapper().writeValueAsString(paramsJson));
                call = new SimpleUploadCall<R>(this.apiClient, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, null, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
                future = this.simpleUploadExecutor.submit(call);
            } else {
                call = new MultiUploadCall<R>(this.apiClient, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, null, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType, file, partSize, fileKey, partParallel, timeout, this, paramsJson);
                future = this.mulitUploadExecutor.submit(call);
            }
            CallResult callResult2 = callResult = timeout != 0 ? (CallResult)future.get(timeout.intValue(), TimeUnit.MILLISECONDS) : (CallResult)future.get();
            if (callResult.t != null) {
                throw callResult.t;
            }
            return (R)callResult.result;
        }
        catch (Throwable e) {
            throw new ApiException(e);
        }
    }

    static class UploadApiClient
    extends ApiClient {
        UploadApiClient() {
        }

        @Override
        protected <T> T processResponse(CloseableHttpResponse response, TypeReference<T> returnType) throws ApiException, IOException {
            response.removeHeaders("Content-Type");
            response.addHeader("Content-Type", "application/json;charset=UTF-8");
            return super.processResponse(response, returnType);
        }
    }

    static class CallResult<R> {
        private R result;
        private Throwable t;

        public CallResult(R result) {
            this.result = result;
        }

        public CallResult(Throwable t) {
            this.t = t;
        }
    }

    static class SimpleUploadCall<R>
    implements Callable<CallResult<R>> {
        private ApiClient apiClient;
        private String localVarPath;
        private String method;
        private List<Pair> localVarQueryParams;
        private List<Pair> localVarCollectionQueryParams;
        private Object body;
        private Map<String, String> localVarHeaderParams;
        private Map<String, String> localVarCookieParams;
        private Map<String, Object> localVarFormParams;
        private String localVarAccept;
        private String localVarContentType;
        private String[] localVarAuthNames;
        private TypeReference<R> returnType;

        public SimpleUploadCall(ApiClient apiClient, String localVarPath, String method, List<Pair> localVarQueryParams, List<Pair> localVarCollectionQueryParams, Object body, Map<String, String> localVarHeaderParams, Map<String, String> localVarCookieParams, Map<String, Object> localVarFormParams, String localVarAccept, String localVarContentType, String[] localVarAuthNames, TypeReference<R> returnType) {
            this.apiClient = apiClient;
            this.localVarPath = localVarPath;
            this.method = method;
            this.localVarQueryParams = localVarQueryParams;
            this.localVarCollectionQueryParams = localVarCollectionQueryParams;
            this.body = body;
            this.localVarHeaderParams = localVarHeaderParams;
            this.localVarCookieParams = localVarCookieParams;
            this.localVarFormParams = localVarFormParams;
            this.localVarAccept = localVarAccept;
            this.localVarContentType = localVarContentType;
            this.localVarAuthNames = localVarAuthNames;
            this.returnType = returnType;
        }

        @Override
        public CallResult<R> call() throws Exception {
            try {
                R result = this.apiClient.invokeAPI(this.localVarPath, this.method, this.localVarQueryParams, this.localVarCollectionQueryParams, this.body, this.localVarHeaderParams, this.localVarCookieParams, this.localVarFormParams, this.localVarAccept, this.localVarContentType, this.localVarAuthNames, this.returnType);
                return new CallResult<R>(result);
            }
            catch (Throwable t) {
                return new CallResult(t);
            }
        }
    }

    static class PartUploadCall<R>
    implements Callable<CallResult<R>> {
        private ApiClient apiClient;
        private String localVarPath;
        private String method;
        private List<Pair> localVarQueryParams;
        private List<Pair> localVarCollectionQueryParams;
        private Object body;
        private Map<String, String> localVarHeaderParams;
        private Map<String, String> localVarCookieParams;
        private Map<String, Object> localVarFormParams;
        private String localVarAccept;
        private String localVarContentType;
        private String[] localVarAuthNames;
        private TypeReference<R> returnType;
        private Semaphore semaphore;
        private File file;
        private int partNumber;
        private int partSize;
        private String fileKey;

        public PartUploadCall(ApiClient apiClient, String localVarPath, String method, List<Pair> localVarQueryParams, List<Pair> localVarCollectionQueryParams, Object body, Map<String, String> localVarHeaderParams, Map<String, String> localVarCookieParams, Map<String, Object> localVarFormParams, String localVarAccept, String localVarContentType, String[] localVarAuthNames, TypeReference<R> returnType, Semaphore semaphore, File file, int partNumber, int partSize, String fileKey) {
            this.apiClient = apiClient;
            this.localVarPath = localVarPath;
            this.method = method;
            this.localVarQueryParams = localVarQueryParams;
            this.localVarCollectionQueryParams = localVarCollectionQueryParams;
            this.body = body;
            this.localVarHeaderParams = localVarHeaderParams;
            this.localVarCookieParams = localVarCookieParams;
            this.localVarFormParams = localVarFormParams;
            this.localVarAccept = localVarAccept;
            this.localVarContentType = localVarContentType;
            this.localVarAuthNames = localVarAuthNames;
            this.returnType = returnType;
            this.semaphore = semaphore;
            this.file = file;
            this.partNumber = partNumber;
            this.partSize = partSize;
            this.fileKey = fileKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CallResult<R> call() throws Exception {
            File tempFile = null;
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(this.file);
                byte[] data = new byte[this.partSize];
                int skip = (this.partNumber - 1) * this.partSize;
                fileInputStream.skip(skip);
                int read = fileInputStream.read(data);
                if (read != data.length) {
                    byte[] copy = new byte[read];
                    System.arraycopy(data, 0, copy, 0, read);
                    data = copy;
                }
                tempFile = File.createTempFile(this.file.getName(), "-part" + this.partNumber);
                Files.write(tempFile.toPath(), data, new OpenOption[0]);
                data = null;
                this.localVarFormParams.put(this.fileKey, tempFile);
                this.localVarFormParams.put("partNumber", this.partNumber);
                R result = this.apiClient.invokeAPI(this.localVarPath, this.method, this.localVarQueryParams, this.localVarCollectionQueryParams, this.body, this.localVarHeaderParams, this.localVarCookieParams, this.localVarFormParams, this.localVarAccept, this.localVarContentType, this.localVarAuthNames, this.returnType);
                CallResult<R> callResult = new CallResult<R>(result);
                return callResult;
            }
            catch (Throwable t) {
                CallResult callResult = new CallResult(t);
                return callResult;
            }
            finally {
                this.semaphore.release();
                if (tempFile != null) {
                    tempFile.delete();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
        }
    }

    static class MultiUploadCall<R>
    implements Callable<CallResult<R>> {
        private ApiClient apiClient;
        private String localVarPath;
        private String method;
        private List<Pair> localVarQueryParams;
        private List<Pair> localVarCollectionQueryParams;
        private Object body;
        private Map<String, String> localVarHeaderParams;
        private Map<String, String> localVarCookieParams;
        private Map<String, Object> localVarFormParams;
        private String localVarAccept;
        private String localVarContentType;
        private String[] localVarAuthNames;
        private TypeReference<R> returnType;
        private File file;
        private int partSize;
        private String fileKey;
        private int partParallel;
        private boolean timeoutEnable;
        private long deadline;
        private UploadClient uploadClient;
        private ObjectNode paramsJson;

        public MultiUploadCall(ApiClient apiClient, String localVarPath, String method, List<Pair> localVarQueryParams, List<Pair> localVarCollectionQueryParams, Object body, Map<String, String> localVarHeaderParams, Map<String, String> localVarCookieParams, Map<String, Object> localVarFormParams, String localVarAccept, String localVarContentType, String[] localVarAuthNames, TypeReference<R> returnType, File file, int partSize, String fileKey, int partParallel, int timeout, UploadClient uploadClient, ObjectNode paramsJson) {
            this.apiClient = apiClient;
            this.localVarPath = localVarPath;
            this.method = method;
            this.localVarQueryParams = localVarQueryParams;
            this.localVarCollectionQueryParams = localVarCollectionQueryParams;
            this.body = body;
            this.localVarHeaderParams = localVarHeaderParams;
            this.localVarCookieParams = localVarCookieParams;
            this.localVarFormParams = localVarFormParams;
            this.localVarAccept = localVarAccept;
            this.localVarContentType = localVarContentType;
            this.localVarAuthNames = localVarAuthNames;
            this.returnType = returnType;
            this.file = file;
            this.partSize = partSize;
            this.fileKey = fileKey;
            this.partParallel = partParallel;
            this.timeoutEnable = timeout != 0;
            this.deadline = System.currentTimeMillis() + (long)timeout;
            this.uploadClient = uploadClient;
            this.paramsJson = paramsJson;
        }

        private void checkTimeout() throws TimeoutException {
            if (this.timeoutEnable && System.currentTimeMillis() > this.deadline) {
                throw new TimeoutException();
            }
        }

        @Override
        public CallResult<R> call() throws Exception {
            try {
                Future<UploadPartResponseWrapper> future;
                long fileSize = this.file.length();
                long partCount = fileSize / (long)this.partSize;
                if (fileSize % (long)this.partSize != 0L) {
                    ++partCount;
                }
                this.localVarFormParams.put("step", "InitiateMultipartUpload");
                this.localVarFormParams.put("params", this.apiClient.getObjectMapper().writeValueAsString(this.paramsJson));
                InitiateMultipartUploadResponseWrapper initResponseWrapper = this.apiClient.invokeAPI(this.localVarPath, this.method, this.localVarQueryParams, this.localVarCollectionQueryParams, this.body, this.localVarHeaderParams, this.localVarCookieParams, this.localVarFormParams, this.localVarAccept, this.localVarContentType, this.localVarAuthNames, new TypeReference<InitiateMultipartUploadResponseWrapper>(){});
                if (initResponseWrapper.getHeader().getStatus() != 0) {
                    throw new ApiException("InitiateMultipartUpload step fail:" + initResponseWrapper);
                }
                this.checkTimeout();
                InitiateMultipartUploadInfo initiateMultipartUploadInfo = initResponseWrapper.getBody().getData().get(0);
                String uploadId = initiateMultipartUploadInfo.getUploadId();
                Long fileId = initiateMultipartUploadInfo.getFileId();
                Semaphore semaphore = new Semaphore(this.partParallel);
                HashMap<Integer, Future<UploadPartResponseWrapper>> futureMap = new HashMap<Integer, Future<UploadPartResponseWrapper>>();
                this.localVarFormParams.put("step", "UploadPart");
                this.localVarFormParams.put("uploadId", uploadId);
                int i = 0;
                while ((long)i < partCount) {
                    int partNumber = i + 1;
                    if (this.timeoutEnable) {
                        long t;
                        do {
                            if ((t = this.deadline - System.currentTimeMillis()) > 0L) continue;
                            throw new TimeoutException();
                        } while (!semaphore.tryAcquire(t, TimeUnit.MILLISECONDS));
                    } else {
                        semaphore.acquire();
                    }
                    HashMap<String, Object> formParams = new HashMap<String, Object>();
                    formParams.putAll(this.localVarFormParams);
                    PartUploadCall<UploadPartResponseWrapper> call = new PartUploadCall<UploadPartResponseWrapper>(this.apiClient, this.localVarPath, this.method, this.localVarQueryParams, this.localVarCollectionQueryParams, this.body, this.localVarHeaderParams, this.localVarCookieParams, formParams, this.localVarAccept, this.localVarContentType, this.localVarAuthNames, new TypeReference<UploadPartResponseWrapper>(){}, semaphore, this.file, partNumber, this.partSize, this.fileKey);
                    future = this.uploadClient.mulitUploadExecutor.submit(call);
                    futureMap.put(partNumber, future);
                    ++i;
                }
                ArrayList<PartEtag> etags = new ArrayList<PartEtag>();
                for (Map.Entry entry : futureMap.entrySet()) {
                    CallResult callResult;
                    Integer partNumer = (Integer)entry.getKey();
                    future = (Future<UploadPartResponseWrapper>)entry.getValue();
                    if (this.timeoutEnable) {
                        long t = this.deadline - System.currentTimeMillis();
                        if (t <= 0L) {
                            throw new TimeoutException();
                        }
                        callResult = (CallResult)future.get(t, TimeUnit.MILLISECONDS);
                    } else {
                        callResult = (CallResult)future.get();
                    }
                    if (callResult.t != null) {
                        throw callResult.t;
                    }
                    UploadPartResponseWrapper uploadPartResponseWrapper = (UploadPartResponseWrapper)callResult.result;
                    Integer status = uploadPartResponseWrapper.getHeader().getStatus();
                    if (0 != status) {
                        throw new ApiException("UploadPart step fail: " + uploadPartResponseWrapper);
                    }
                    String eTag = uploadPartResponseWrapper.getBody().getData().get(0).geteTag();
                    etags.add(new PartEtag(partNumer, eTag));
                }
                this.localVarFormParams.put("step", "CompleteMultipartUpload");
                this.localVarFormParams.put("parts", this.uploadClient.apiClient.getObjectMapper().writeValueAsString(etags));
                this.paramsJson.put("fileId", fileId);
                this.localVarFormParams.put("params", this.apiClient.getObjectMapper().writeValueAsString(this.paramsJson));
                R result = this.apiClient.invokeAPI(this.localVarPath, this.method, this.localVarQueryParams, this.localVarCollectionQueryParams, this.body, this.localVarHeaderParams, this.localVarCookieParams, this.localVarFormParams, this.localVarAccept, this.localVarContentType, this.localVarAuthNames, this.returnType);
                return new CallResult<R>(result);
            }
            catch (Throwable t) {
                return new CallResult(t);
            }
        }
    }
}

