DROP TABLE IF EXISTS OS_MEMBERSHIP;
DROP TABLE IF EXISTS OS_USER;
DROP TABLE IF EXISTS OS_GROUP;
DROP TABLE IF EXISTS OS_PROPERTYENTRY;

CREATE TABLE OS_USER
(
    USERNAME varchar(128),
    PASSWORDHASH varchar(128)
);

CREATE TABLE OS_GROUP
(
    GROUPNAME varchar(128)
);

CREATE TABLE OS_MEMBERSHIP
(
    USERNAME varchar(128),
    GROUPNAME varchar(128),
    primary key (USERNAME, GROUPNAME),
    foreign key (USERNAME) references OS_USER(USERNAME),
    foreign key (GROUPNAME) references OS_GROUP(GROUPNAME)
);

CREATE TABLE OS_PROPERTYENTRY
(
  GLOBAL_KEY varchar(255),
  ITEM_KEY varchar(255),
  ITEM_TYPE smallint,
  STRING_VALUE varchar(255),
  DATE_VALUE TIMESTAMP ,
  DATA_VALUE varbinary(2000),
  FLOAT_VALUE float,
  NUMBER_VALUE numeric,
  primary key (GLOBAL_KEY, ITEM_KEY)
);



