/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.user.provider.ofbiz;

import com.opensymphony.user.Entity;
import com.opensymphony.user.provider.UserProvider;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilMisc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OFBizAbstractProvider
implements UserProvider {
    private final Logger LOG = Logger.getLogger(this.getClass());
    private final ConcurrentMap<String, GenericValue> nameCache = new ConcurrentHashMap<String, GenericValue>();
    private volatile String delegator;
    protected volatile String userEntity;
    protected volatile boolean exclusiveAccess = false;

    @Override
    public boolean create(String s) {
        return true;
    }

    @Override
    public void flushCaches() {
        this.nameCache.clear();
        this.clearAllCache();
    }

    @Override
    public boolean init(Properties properties) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("init(" + properties.toString() + ")"));
        }
        if (properties.getProperty("exclusive-access") != null && "true".equalsIgnoreCase(properties.getProperty("exclusive-access"))) {
            this.exclusiveAccess = true;
        }
        this.delegator = properties.getProperty("delegator", "default");
        this.userEntity = properties.getProperty("userEntity", "OSUser");
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("delegator: " + this.delegator));
            this.LOG.debug((Object)("exclusiveAccess: " + this.exclusiveAccess));
            this.LOG.debug((Object)("userEntity: " + this.userEntity));
        }
        return true;
    }

    @Override
    public List<String> list() {
        return null;
    }

    @Override
    public boolean load(String s, Entity.Accessor accessor) {
        return true;
    }

    @Override
    public boolean remove(String s) {
        return true;
    }

    @Override
    public boolean store(String s, Entity.Accessor accessor) {
        return true;
    }

    protected GenericDelegator getDelegator() {
        return GenericDelegator.getGenericDelegator((String)this.delegator);
    }

    protected void clearAllCache() {
        if (this.exclusiveAccess) {
            this.getDelegator().clearCacheLine(this.userEntity, null);
        }
    }

    protected void clearUserCache(String name) {
        if (this.exclusiveAccess && name != null) {
            this.nameCache.remove(name);
        }
    }

    protected GenericValue findUser(String name) throws GenericEntityException {
        GenericValue user = null;
        if (this.exclusiveAccess && name != null) {
            user = (GenericValue)this.nameCache.get(name);
        }
        if (user == null) {
            List userId = this.getDelegator().findByAnd(this.userEntity, UtilMisc.toMap((String)"name", (Object)name));
            if (userId.size() > 1) {
                throw new RuntimeException("Found more than one user with name '" + name + "'; ids " + this.printList(userId));
            }
            user = EntityUtil.getOnly((List)userId);
            if (this.exclusiveAccess && user != null) {
                this.nameCache.putIfAbsent(user.getString("name"), user);
            }
        }
        if (user == null && this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("user " + name + " not found"));
        }
        return user;
    }

    private final String printList(List<?> list) {
        StringBuffer buf = new StringBuffer();
        Iterator<?> iter = list.iterator();
        while (iter.hasNext()) {
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }
}

