/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.annotations;

import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.UastEnvironment;
import com.android.tools.lint.annotations.ApiDatabase;
import com.android.tools.lint.annotations.Extractor;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Project;
import com.android.utils.SdkUtils;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.intellij.mock.MockProject;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.io.FilesKt;
import kotlin.text.Charsets;

public class ExtractAnnotationsDriver {
    private static final String SEP_JAVA_SEP = File.separator + "java" + File.separator;
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("package\\s+(.*)\\s*;");

    public static void main(String[] args) throws IOException {
        int status = new ExtractAnnotationsDriver().run(args);
        if (status != 0) {
            System.exit(status);
        }
    }

    private static void usage(PrintStream output) {
        output.println("Usage: " + ExtractAnnotationsDriver.class.getSimpleName() + " <flags>");
        output.println(" --sources <paths>       : Source directories or files to extract annotations from.");
        output.println("                           Separate paths with " + File.pathSeparator + ", and you can use @ ");
        output.println("                           as a filename prefix to have the filenames fed from a file");
        output.println("--classpath <paths>      : Directories and .jar files to resolve symbols from");
        output.println("--output <zip path>      : The .zip file to write the extracted annotations to, if any");
        output.println("--proguard <path>        : The proguard.cfg file to write the keep rules to, if any");
        output.println();
        output.println("Optional flags:");
        output.println("--merge-zips <paths>     : Existing external annotation files to merge in");
        output.println("--quiet                  : Don't print summary information");
        output.println("--rmtypedefs <folder>    : Remove typedef classes found in the given folder");
        output.println("--allow-missing-types    : Don't fail even if some types can't be resolved");
        output.println("--allow-errors           : Don't fail even if there are some compiler errors");
        output.println("--api-filter <api.txt>   : A framework API definition to restrict included APIs to");
        output.println("--hide-filtered          : If filtering out non-APIs, supply this flag to hide listing matches");
        output.println("--skip-class-retention   : Don't extract annotations that have class retention");
        output.println("--typedef-file <path>    : Write a packaging recipe description to the given file");
        output.println("--source-roots <paths>   : Source directories to find classes.\n                           If not specified the roots are derived from the sources above");
        output.println("--no-sort                : Do not sort the output alphabetically, output the\n                           extracted annotations in the order they are visited");
        output.println("--strict-typedef-retention : Fail if encountering a typedef with incorrect retention");
    }

    public int run(String[] args) throws IOException {
        List<Object> classpath = Lists.newArrayList();
        List<Object> sources = Lists.newArrayList();
        List<Object> mergePaths = Lists.newArrayList();
        List apiFilters = null;
        ArrayList<File> rmTypeDefs = null;
        boolean verbose = true;
        boolean allowMissingTypes = false;
        boolean allowErrors = false;
        boolean listFiltered = true;
        boolean skipClassRetention = false;
        boolean strictTypedefRetention = false;
        boolean sortAnnotations = true;
        List<File> sourceRoots = null;
        boolean useK2Uast = false;
        File output = null;
        File proguard = null;
        File typedefFile = null;
        if (args.length == 1 && "--help".equals(args[0])) {
            ExtractAnnotationsDriver.usage(System.out);
            return -1;
        }
        if (args.length < 2) {
            ExtractAnnotationsDriver.usage(System.err);
            return -1;
        }
        int n = args.length;
        block44: for (int i = 0; i < n; ++i) {
            String flag = args[i];
            switch (flag) {
                case "--quiet": {
                    verbose = false;
                    continue block44;
                }
                case "--allow-missing-types": {
                    allowMissingTypes = true;
                    continue block44;
                }
                case "--allow-errors": {
                    allowErrors = true;
                    continue block44;
                }
                case "--hide-filtered": {
                    listFiltered = false;
                    continue block44;
                }
                case "--skip-class-retention": {
                    skipClassRetention = true;
                    continue block44;
                }
                case "--no-sort": {
                    sortAnnotations = false;
                    continue block44;
                }
                case "--strict-typedef-retention": {
                    strictTypedefRetention = true;
                    continue block44;
                }
                case "--XuseK2Uast": {
                    useK2Uast = true;
                    continue block44;
                }
                default: {
                    if (i == n - 1) {
                        ExtractAnnotationsDriver.usage(System.err);
                    }
                    String value = args[i + 1];
                    ++i;
                    switch (flag) {
                        case "--sources": {
                            sources = ExtractAnnotationsDriver.getFiles(value);
                            if (sources != null) continue block44;
                            return -1;
                        }
                        case "--classpath": {
                            classpath = ExtractAnnotationsDriver.getFiles(value);
                            if (classpath != null) continue block44;
                            return -1;
                        }
                        case "--merge-zips": {
                            mergePaths = ExtractAnnotationsDriver.getFiles(value);
                            if (mergePaths != null) continue block44;
                            return -1;
                        }
                        case "--output": {
                            output = new File(value);
                            if (output.exists()) {
                                if (output.isDirectory()) {
                                    System.err.println(output + " is a directory");
                                    return -1;
                                }
                                boolean deleted = output.delete();
                                if (deleted) continue block44;
                                System.err.println("Could not delete previous version of " + output);
                                return -1;
                            }
                            if (output.getParentFile() == null || output.getParentFile().exists()) continue block44;
                            System.err.println(output.getParentFile() + " does not exist");
                            return -1;
                        }
                        case "--proguard": {
                            proguard = new File(value);
                            if (proguard.exists()) {
                                if (proguard.isDirectory()) {
                                    System.err.println(proguard + " is a directory");
                                    return -1;
                                }
                                boolean deleted = proguard.delete();
                                if (deleted) continue block44;
                                System.err.println("Could not delete previous version of " + proguard);
                                return -1;
                            }
                            if (proguard.getParentFile() == null || proguard.getParentFile().exists()) continue block44;
                            System.err.println(proguard.getParentFile() + " does not exist");
                            return -1;
                        }
                        case "--typedef-file": {
                            typedefFile = new File(value);
                            continue block44;
                        }
                        case "--api-filter": {
                            if (apiFilters == null) {
                                apiFilters = Lists.newArrayList();
                            }
                            for (String path : Splitter.on((String)",").omitEmptyStrings().split((CharSequence)value)) {
                                File apiFilter = new File(path);
                                if (!apiFilter.isFile()) {
                                    String message = apiFilter + " does not exist or is not a file";
                                    System.err.println(message);
                                    return -1;
                                }
                                apiFilters.add(apiFilter);
                            }
                            continue block44;
                        }
                        case "--rmtypedefs": {
                            File classDir = new File(value);
                            if (!classDir.isDirectory()) {
                                System.err.println(classDir + " is not a directory");
                                return -1;
                            }
                            if (rmTypeDefs == null) {
                                rmTypeDefs = new ArrayList<File>();
                            }
                            rmTypeDefs.add(classDir);
                            continue block44;
                        }
                        case "--source-roots": {
                            sourceRoots = ExtractAnnotationsDriver.getFiles(value);
                            if (sourceRoots != null) continue block44;
                            return -1;
                        }
                        default: {
                            System.err.println("Unknown flag " + (String)flag + ": Use --help for usage information");
                            return -1;
                        }
                    }
                }
            }
        }
        if (sources.isEmpty()) {
            System.err.println("Must specify at least one source path");
            return -1;
        }
        if (classpath.isEmpty()) {
            System.err.println("Must specify classpath pointing to at least android.jar or the framework");
            return -1;
        }
        if (output == null && proguard == null) {
            System.err.println("Must specify output path with --output or a proguard path with --proguard");
            return -1;
        }
        ApiDatabase database = null;
        if (apiFilters != null && !apiFilters.isEmpty()) {
            try {
                ArrayList lines = Lists.newArrayList();
                for (File file : apiFilters) {
                    lines.addAll(Files.readLines((File)file, (Charset)Charsets.UTF_8));
                }
                database = new ApiDatabase(lines);
            }
            catch (IOException e) {
                System.err.println("Could not open API database " + apiFilters + ": " + e.getLocalizedMessage());
                return -1;
            }
        }
        Extractor extractor = new Extractor(database, rmTypeDefs, verbose, !skipClassRetention, strictTypedefRetention, sortAnnotations);
        extractor.setListIgnored(listFiltered);
        UastEnvironment.Configuration config = UastEnvironment.Configuration.create((boolean)false, (boolean)useK2Uast);
        if (sourceRoots == null && (sourceRoots = ExtractAnnotationsDriver.findSourceRoots(sources)) == null) {
            return -1;
        }
        LintCliClient lintClient = new LintCliClient("cli");
        File dir = sourceRoots.stream().filter(File::isDirectory).findAny().orElse(null);
        if (dir == null) {
            return -1;
        }
        Project lintProject = Project.create((LintClient)lintClient, (File)dir, (File)dir);
        lintProject.getJavaSourceFolders().addAll(sourceRoots);
        lintProject.getJavaLibraries().addAll(classpath);
        ArrayList<UastEnvironment.Module> modules = new ArrayList<UastEnvironment.Module>();
        modules.add(new UastEnvironment.Module(lintProject, null, false, false, false));
        config.addModules(modules, null);
        UastEnvironment env = UastEnvironment.create((UastEnvironment.Configuration)config);
        MockProject project = env.getIdeaProject();
        List<File> allSourceFiles = Extractor.gatherSources(sources);
        List<? extends PsiFile> units = Extractor.createUnitsForFiles((com.intellij.openapi.project.Project)project, allSourceFiles);
        ArrayList<File> ktFiles = new ArrayList<File>();
        for (File file : allSourceFiles) {
            if (!file.getPath().endsWith(".kt")) continue;
            ktFiles.add(file);
        }
        env.analyzeFiles(ktFiles);
        extractor.extractFromProjectSource(units);
        for (File file : mergePaths) {
            extractor.mergeExisting(file);
        }
        extractor.export(output, proguard);
        if (typedefFile != null) {
            extractor.writeTypedefFile(typedefFile);
        }
        if (rmTypeDefs != null) {
            if (typedefFile != null) {
                Extractor.removeTypedefClasses(rmTypeDefs, typedefFile);
            } else {
                extractor.removeTypedefClasses();
            }
        }
        env.dispose();
        return 0;
    }

    private static List<File> findSourceRoots(List<File> sources) {
        ArrayList roots = Lists.newArrayList();
        for (File sourceFile : sources) {
            if (sourceFile.isDirectory()) {
                if (roots.contains(sourceFile)) continue;
                roots.add(sourceFile);
                continue;
            }
            String path = sourceFile.getPath();
            if (!path.endsWith(".java") && !path.endsWith(".kt")) continue;
            int index = path.indexOf(SEP_JAVA_SEP);
            if (index != -1) {
                File root = new File(path.substring(0, index + SEP_JAVA_SEP.length()));
                if (roots.contains(root)) continue;
                roots.add(root);
                continue;
            }
            try {
                String source = FilesKt.readText((File)sourceFile, (Charset)Charsets.UTF_8);
                Matcher matcher = PACKAGE_PATTERN.matcher(source);
                boolean foundPackage = matcher.find();
                if (!foundPackage) {
                    System.err.println("Couldn't find package declaration in " + sourceFile);
                    return null;
                }
                String pkg = matcher.group(1).trim();
                int end = path.lastIndexOf(File.separatorChar);
                if (end == -1) continue;
                String relative = pkg.replace('.', File.separatorChar);
                if (SdkUtils.endsWith((CharSequence)path, (int)end, (CharSequence)relative)) {
                    String rootPath = path.substring(0, end - relative.length());
                    File root = new File(rootPath);
                    if (roots.contains(root)) continue;
                    roots.add(root);
                    continue;
                }
                System.err.println("File found in a folder that doesn't appear to match the package declaration: package=" + pkg + " and file path=" + path);
                return null;
            }
            catch (Exception e) {
                System.err.println("Couldn't access " + sourceFile);
                return null;
            }
        }
        return roots;
    }

    private static List<File> getFiles(String value) {
        ArrayList files = Lists.newArrayList();
        Splitter splitter = Splitter.on((char)File.pathSeparatorChar).omitEmptyStrings().trimResults();
        for (String path : splitter.split((CharSequence)value)) {
            if (path.startsWith("@")) {
                File sourcePath = new File(path.substring(1));
                if (!sourcePath.exists()) {
                    System.err.println(sourcePath + " does not exist");
                    return null;
                }
                try {
                    for (String line : FilesKt.readLines((File)sourcePath, (Charset)Charsets.UTF_8)) {
                        if ((line = line.trim()).isEmpty()) continue;
                        File file = new File(line);
                        if (!file.exists()) {
                            for (String l : Splitter.on((CharMatcher)CharMatcher.whitespace()).split((CharSequence)line)) {
                                if (l.isEmpty()) continue;
                                file = new File(l);
                                if (!file.exists()) {
                                    System.err.println("Warning: Could not find file " + l + " listed in " + sourcePath);
                                }
                                files.add(file);
                            }
                        }
                        files.add(file);
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            File file = new File(path);
            if (!file.exists()) {
                System.err.println(file + " does not exist");
                return null;
            }
            files.add(file);
        }
        return files;
    }
}

