/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.GradleScanner;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.model.LintModelVariant;
import com.android.utils.CharSequences;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.io.File;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UComment;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UFile;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CommentDetector
extends ResourceXmlDetector
implements SourceCodeScanner,
GradleScanner {
    private static final String STOPSHIP_COMMENT = "STOPSHIP";
    private static final Implementation IMPLEMENTATION = new Implementation(CommentDetector.class, EnumSet.of(Scope.RESOURCE_FILE, Scope.JAVA_FILE, Scope.GRADLE_FILE, Scope.MANIFEST, Scope.PROPERTY_FILE), new EnumSet[]{Scope.JAVA_FILE_SCOPE, Scope.RESOURCE_FILE_SCOPE, Scope.GRADLE_SCOPE, Scope.MANIFEST_SCOPE, Scope.PROPERTY_SCOPE});
    public static final Issue EASTER_EGG = Issue.create((String)"EasterEgg", (String)"Code contains easter egg", (String)"An \"easter egg\" is code deliberately hidden in the code, both from potential users and even from other developers. This lint check looks for code which looks like it may be hidden from sight.", (Category)Category.SECURITY, (int)6, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).setAndroidSpecific(false).setEnabledByDefault(false);
    public static final Issue STOP_SHIP = Issue.create((String)"StopShip", (String)"Code contains `STOPSHIP` marker", (String)"Using the comment `// STOPSHIP` can be used to flag code that is incomplete but checked in. This comment marker can be used to indicate that the code should not be shipped until the issue is addressed, and lint will look for these. In Gradle projects, this is only checked for non-debug (release) builds.\n\nIn Kotlin, the `TODO()` method is also treated as a stop ship marker; you can use it to make incomplete code compile, but it will throw an exception at runtime and therefore should be fixed before shipping releases.", (Category)Category.CORRECTNESS, (int)10, (Severity)Severity.FATAL, (Implementation)IMPLEMENTATION).setAndroidSpecific(false).setEnabledByDefault(false);
    private static final String ESCAPE_STRING = "\\u002a\\u002f";

    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return Collections.singletonList(UFile.class);
    }

    public UElementHandler createUastHandler(JavaContext context) {
        return new CommentChecker(context);
    }

    public void visitDocument(XmlContext context, Document document) {
        CommentDetector.checkXml(context, document);
    }

    private static void checkXml(XmlContext context, Node node) {
        if (node.getNodeType() == 8) {
            String source = node.getNodeValue();
            CommentDetector.checkComment((Context)context, node, source, 0, 0, source.length());
        }
        NodeList children = node.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            CommentDetector.checkXml(context, children.item(i));
        }
    }

    private static void checkComment(Context context, Object node, CharSequence source, int offset, int start, int end) {
        int prev = 0;
        for (int i = start; i < end - 2; ++i) {
            String message2;
            char c = source.charAt(i);
            if (prev == 92) {
                if (c == 'u' || c == 'U') {
                    if (CharSequences.regionMatches((CharSequence)source, (boolean)true, (int)(i - 1), (CharSequence)ESCAPE_STRING, (int)0, (int)ESCAPE_STRING.length())) {
                        Location location;
                        message2 = "Code might be hidden here; found unicode escape sequence which is interpreted as comment end, compiled code follows";
                        if (context instanceof JavaContext && node instanceof UElement) {
                            JavaContext javaContext = (JavaContext)context;
                            UElement javaNode = (UElement)node;
                            if (!Lint.isKotlin((PsiElement)javaNode.getSourcePsi())) {
                                location = javaContext.getRangeLocation(javaNode, offset + i - 1, ESCAPE_STRING.length());
                                javaContext.report(EASTER_EGG, javaNode, location, message2);
                            }
                        } else if (context instanceof XmlContext && node instanceof Node) {
                            XmlContext xmlContext = (XmlContext)context;
                            Node xmlNode = (Node)node;
                            location = xmlContext.getLocation(xmlNode, i, i + ESCAPE_STRING.length());
                            xmlContext.report(EASTER_EGG, xmlNode, location, message2);
                        } else {
                            Location location2 = Location.create((File)context.file, (CharSequence)source, (int)(i - 1), (int)(i - 1 + ESCAPE_STRING.length()));
                            context.report(STOP_SHIP, location2, message2);
                        }
                    }
                } else {
                    ++i;
                }
            } else if (prev == 83 && c == 'T' && CharSequences.regionMatches((CharSequence)source, (int)(i - 1), (CharSequence)STOPSHIP_COMMENT, (int)0, (int)STOPSHIP_COMMENT.length())) {
                Incident incident;
                LintFix fix;
                Location location;
                message2 = "`STOPSHIP` comment found; points to code which must be fixed prior to release";
                if (context instanceof JavaContext && node instanceof UElement) {
                    JavaContext javaContext = (JavaContext)context;
                    UElement javaNode = (UElement)node;
                    location = javaContext.getRangeLocation(javaNode, offset + i - 1, STOPSHIP_COMMENT.length());
                    fix = CommentDetector.createRemoveStopShipFix();
                    incident = new Incident(STOP_SHIP, (Object)javaNode, location, message2, fix);
                } else if (context instanceof XmlContext && node instanceof Node) {
                    XmlContext xmlContext = (XmlContext)context;
                    Node xmlNode = (Node)node;
                    location = xmlContext.getLocation(xmlNode, i, i + STOPSHIP_COMMENT.length());
                    fix = CommentDetector.createRemoveStopShipFix();
                    incident = new Incident(STOP_SHIP, (Object)xmlNode, location, message2, fix);
                } else {
                    Location location3 = Location.create((File)context.file, (CharSequence)source, (int)(i - 1), (int)(i + -1 + STOPSHIP_COMMENT.length()));
                    LintFix fix2 = CommentDetector.createRemoveStopShipFix();
                    incident = new Incident(STOP_SHIP, location3, message2, fix2);
                }
                context.report(incident, new LintMap());
            }
            prev = c;
        }
    }

    public boolean filterIncident(Context context, Incident incident, LintMap map) {
        if (!context.getDriver().isIsolated()) {
            Boolean releaseMode = CommentDetector.getReleaseMode(context);
            return releaseMode != Boolean.FALSE;
        }
        return true;
    }

    private static LintFix createRemoveStopShipFix() {
        return LintFix.create().name("Remove STOPSHIP").replace().pattern("(\\s*STOPSHIP)").with("").build();
    }

    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("TODO");
    }

    public void visitMethodCall(JavaContext context, UCallExpression node, PsiMethod method) {
        String message2 = "`TODO` call found; points to code which must be fixed prior to release";
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null || !"kotlin.StandardKt__StandardKt".equals(containingClass.getQualifiedName())) {
            return;
        }
        Location location = context.getLocation((UElement)node);
        LintFix fix = this.fix().name("Remove TODO").replace().all().with("").reformat(true).build();
        context.report(STOP_SHIP, (UElement)node, location, message2, fix);
    }

    private static Boolean getReleaseMode(Context context) {
        Project project = context.getMainProject();
        LintModelVariant variant = project.getBuildVariant();
        if (variant != null) {
            return !variant.getDebuggable();
        }
        return null;
    }

    public boolean getCustomVisitor() {
        return true;
    }

    public void visitBuildScript(Context context) {
        if (context instanceof JavaContext) {
            JavaContext javaContext = (JavaContext)context;
            UFile file = javaContext.getUastFile();
            if (file != null) {
                new CommentChecker(javaContext).visitFile(file);
            }
        } else {
            CharSequence contents = context.getContents();
            if (contents == null) {
                return;
            }
            int length = contents.length();
            boolean STATE_INITIAL = true;
            int STATE_SLASH = 2;
            int STATE_LINE_COMMENT = 3;
            int STATE_BLOCK_COMMENT = 4;
            int state = 1;
            int offset = 0;
            int startComment = 0;
            block6: while (offset < length) {
                char c = contents.charAt(offset);
                switch (state) {
                    case 1: {
                        if (c == '/') {
                            state = 2;
                        }
                        ++offset;
                        continue block6;
                    }
                    case 2: {
                        if (c == '/') {
                            startComment = offset + 1;
                            state = 3;
                        } else if (c == '*') {
                            startComment = offset + 1;
                            state = 4;
                        } else {
                            state = 1;
                            continue block6;
                        }
                        ++offset;
                        continue block6;
                    }
                    case 3: {
                        if (c == '\n') {
                            CommentDetector.checkComment(context, null, contents, 0, startComment, offset);
                            state = 1;
                        }
                        ++offset;
                        continue block6;
                    }
                    case 4: {
                        if (c == '*' && offset < contents.length() - 1 && contents.charAt(offset + 1) == '/') {
                            CommentDetector.checkComment(context, null, contents, 0, startComment, offset);
                            state = 1;
                            offset += 2;
                            continue block6;
                        }
                        ++offset;
                        continue block6;
                    }
                }
                assert (false) : state;
            }
            if (state == 3) {
                CommentDetector.checkComment(context, null, contents, 0, startComment, length);
            }
        }
    }

    public void run(Context context) {
        CharSequence content2 = context.getContents();
        if (content2 == null) {
            return;
        }
        int lineBegin = 0;
        int length = content2.length();
        while (lineBegin < length) {
            int lineEnd = CharSequences.indexOf((CharSequence)content2, (char)'\n', (int)lineBegin);
            if (lineEnd == -1) {
                lineEnd = length;
            }
            for (int i = lineBegin; i < lineEnd; ++i) {
                char c = content2.charAt(i);
                if (Character.isWhitespace(c)) continue;
                if (c != '#' && c != '!') break;
                CommentDetector.checkComment(context, null, content2, 0, lineBegin, lineEnd);
                break;
            }
            lineBegin = lineEnd + 1;
        }
    }

    private static class CommentChecker
    extends UElementHandler {
        private final JavaContext mContext;

        CommentChecker(JavaContext context) {
            this.mContext = context;
        }

        public void visitFile(UFile node) {
            for (UComment comment : node.getAllCommentsInFile()) {
                String contents = comment.getText();
                CommentDetector.checkComment((Context)this.mContext, comment, contents, 0, 0, contents.length());
            }
        }
    }
}

