/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Platform;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassInitializer;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UResolvableKt;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u001cH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/lint/checks/UElementAsPsiDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "uElementType", "Lcom/intellij/psi/PsiType;", "psiElementType", "beforeCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "psiClassType", "Lcom/intellij/psi/PsiClassType;", "fqn", "", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "reportedElements", "", "Lcom/intellij/psi/PsiElement;", "afterCheckFile", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "Lcom/android/tools/lint/detector/api/JavaContext;", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nUElementAsPsiDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UElementAsPsiDetector.kt\ncom/android/tools/lint/checks/UElementAsPsiDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,266:1\n1#2:267\n*E\n"})
public final class UElementAsPsiDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private PsiType uElementType;
    @NotNull
    private PsiType psiElementType;
    @NotNull
    private final Set<PsiElement> reportedElements;
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(UElementAsPsiDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String MSG = "Do not use `UElement` as `PsiElement`";
    private static final int NOT_UELEMENT = -2;
    private static final int NOT_PSI_ELEMENT = -1;
    @NotNull
    private static final Set<String> ALLOWED_REDEFINITION;
    @NotNull
    private static final Set<String> ALLOWED_PSI_TYPE;

    public UElementAsPsiDetector() {
        PsiPrimitiveType psiPrimitiveType = PsiTypes.voidType();
        Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType, (String)"voidType(...)");
        this.uElementType = (PsiType)psiPrimitiveType;
        PsiPrimitiveType psiPrimitiveType2 = PsiTypes.voidType();
        Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType2, (String)"voidType(...)");
        this.psiElementType = (PsiType)psiPrimitiveType2;
        this.reportedElements = new LinkedHashSet();
    }

    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        Object[] objectArray = new Class[]{UBinaryExpression.class, UBinaryExpressionWithType.class, UCallExpression.class, UVariable.class, UReturnExpression.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void beforeCheckRootProject(@NotNull Context context) {
        block2: {
            PsiClassType it;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Project project = context.getProject().getIdeaProject();
            if (project == null) {
                return;
            }
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
            GlobalSearchScope scope = globalSearchScope;
            String string = UElement.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            PsiClassType psiClassType = this.psiClassType(string, scope);
            if (psiClassType != null) {
                it = psiClassType;
                boolean bl = false;
                this.uElementType = (PsiType)it;
            }
            String string2 = PsiElement.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            PsiClassType psiClassType2 = this.psiClassType(string2, scope);
            if (psiClassType2 == null) break block2;
            it = psiClassType2;
            boolean bl = false;
            this.psiElementType = (PsiType)it;
        }
    }

    private final PsiClassType psiClassType(String fqn, GlobalSearchScope searchScope) {
        Project project = searchScope.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        return PsiType.getTypeByName((String)fqn, (Project)project2, (GlobalSearchScope)searchScope);
    }

    public void afterCheckFile(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.reportedElements.clear();
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(this, context){
            final /* synthetic */ UElementAsPsiDetector this$0;
            final /* synthetic */ JavaContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
            }

            public void visitBinaryExpression(UBinaryExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (!Intrinsics.areEqual((Object)node.getOperator(), (Object)UastBinaryOperator.ASSIGN)) {
                    return;
                }
                if (this.getDimIfUElementType(node.getRightOperand().getExpressionType()) == this.getDimIfPsiElementType(node.getLeftOperand().getExpressionType())) {
                    this.reportUsage((UElement)node.getRightOperand());
                }
            }

            public void visitBinaryExpressionWithType(UBinaryExpressionWithType node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                UTypeReferenceExpression uTypeReferenceExpression = node.getTypeReference();
                if (this.getDimIfUElementType(node.getOperand().getExpressionType()) == this.getDimIfPsiElementType((PsiType)(uTypeReferenceExpression != null ? uTypeReferenceExpression.getType() : null))) {
                    this.reportUsage((UElement)node.getOperand());
                }
            }

            public void visitCallExpression(UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.checkReceiver(node);
                this.checkArguments(node);
            }

            private final void checkReceiver(UCallExpression node) {
                block15: {
                    boolean bl;
                    block13: {
                        PsiMethod it;
                        PsiMethod element$iv;
                        int n;
                        int n2;
                        PsiMethod[] superMethods2;
                        block14: {
                            boolean bl2;
                            block12: {
                                if (this.getDimIfUElementType(node.getReceiverType()) == -2) {
                                    return;
                                }
                                PsiMethod psiMethod = node.resolve();
                                if (psiMethod == null) {
                                    return;
                                }
                                PsiMethod psiMethod2 = psiMethod;
                                PsiClass psiClass = psiMethod2.getContainingClass();
                                if (psiClass == null) {
                                    return;
                                }
                                PsiClass containingClass = psiClass;
                                if (UElementAsPsiDetector.access$getALLOWED_REDEFINITION$cp().contains(containingClass.getQualifiedName())) {
                                    return;
                                }
                                PsiMethod[] psiMethodArray = psiMethod2.findSuperMethods();
                                Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findSuperMethods(...)");
                                superMethods2 = psiMethodArray;
                                if (this.isPsiElementClass(containingClass)) break block14;
                                PsiMethod[] $this$any$iv = superMethods2;
                                boolean $i$f$any = false;
                                n2 = $this$any$iv.length;
                                for (n = 0; n < n2; ++n) {
                                    it = element$iv = $this$any$iv[n];
                                    boolean bl3 = false;
                                    if (!this.isPsiElementClass(it.getContainingClass())) continue;
                                    bl2 = true;
                                    break block12;
                                }
                                bl2 = false;
                            }
                            if (!bl2) break block15;
                        }
                        PsiMethod[] $this$none$iv = superMethods2;
                        boolean $i$f$none = false;
                        n2 = $this$none$iv.length;
                        for (n = 0; n < n2; ++n) {
                            it = element$iv = $this$none$iv[n];
                            boolean bl4 = false;
                            PsiClass psiClass = it.getContainingClass();
                            if (!UElementAsPsiDetector.access$getALLOWED_REDEFINITION$cp().contains(psiClass != null ? psiClass.getQualifiedName() : null)) continue;
                            bl = false;
                            break block13;
                        }
                        bl = true;
                    }
                    if (bl) {
                        this.reportUsage((UElement)node);
                        return;
                    }
                }
                UResolvable $this$resolveToUElementOfType$iv = (UResolvable)node;
                boolean $i$f$resolveToUElementOfType = false;
                UElement uElement = UResolvableKt.resolveToUElement((UResolvable)$this$resolveToUElementOfType$iv);
                if (!(uElement instanceof UMethod)) {
                    uElement = null;
                }
                UMethod uMethod = (UMethod)((UElement)((UMethod)uElement));
                if (uMethod == null) {
                    return;
                }
                UMethod uMethod2 = uMethod;
                PsiType psiType = this.getReceiverType(uMethod2);
                if (psiType == null) {
                    return;
                }
                PsiType receiverType = psiType;
                if (!TypeConversionUtil.isAssignable((PsiType)UElementAsPsiDetector.access$getUElementType$p(this.this$0), (PsiType)receiverType) && TypeConversionUtil.isAssignable((PsiType)UElementAsPsiDetector.access$getPsiElementType$p(this.this$0), (PsiType)receiverType)) {
                    this.reportUsage((UElement)node.getReceiver());
                }
            }

            private final PsiType getReceiverType(UMethod $this$getReceiverType) {
                UParameter uParameter = (UParameter)CollectionsKt.firstOrNull((List)$this$getReceiverType.getUastParameters());
                if (uParameter == null) {
                    return null;
                }
                UParameter receiver2 = uParameter;
                UTypeReferenceExpression uTypeReferenceExpression = receiver2.getTypeReference();
                return uTypeReferenceExpression != null ? uTypeReferenceExpression.getType() : null;
            }

            private final void checkArguments(UCallExpression node) {
                for (UExpression valueArgument : node.getValueArguments()) {
                    PsiParameter param;
                    PsiParameter psiParameter = param = UastUtils.getParameterForArgument((UCallExpression)node, (UExpression)valueArgument);
                    if (this.getDimIfPsiElementType((PsiType)(psiParameter != null ? psiParameter.getType() : null)) != this.getDimIfUElementType(valueArgument.getExpressionType())) continue;
                    this.reportUsage((UElement)valueArgument);
                }
            }

            public void visitVariable(UVariable node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                UExpression uExpression = node.getUastInitializer();
                UTypeReferenceExpression uTypeReferenceExpression = node.getTypeReference();
                if (this.getDimIfUElementType((PsiType)(uExpression != null ? uExpression.getExpressionType() : null)) == this.getDimIfPsiElementType((PsiType)(uTypeReferenceExpression != null ? uTypeReferenceExpression.getType() : null))) {
                    this.reportUsage((UElement)node.getUastInitializer());
                }
            }

            public void visitReturnExpression(UReturnExpression node) {
                PsiType psiType;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                UElement jt = node.getJumpTarget();
                if (jt instanceof UMethod) {
                    psiType = ((UMethod)jt).getReturnType();
                } else if (jt instanceof ULambdaExpression) {
                    psiType = ((ULambdaExpression)jt).getExpressionType();
                } else {
                    return;
                }
                PsiType expected = psiType;
                UExpression uExpression = node.getReturnExpression();
                if (this.getDimIfUElementType((PsiType)(uExpression != null ? uExpression.getExpressionType() : null)) == this.getDimIfPsiElementType(expected)) {
                    this.reportUsage((UElement)node.getReturnExpression());
                }
            }

            private final int getDimIfPsiElementType(PsiType type) {
                PsiType psiType = type;
                if (psiType == null) {
                    return -1;
                }
                int dim = psiType.getArrayDimensions();
                PsiType psiType2 = type.getDeepComponentType();
                Intrinsics.checkNotNullExpressionValue((Object)psiType2, (String)"getDeepComponentType(...)");
                PsiType componentType = psiType2;
                if (UElementAsPsiDetector.access$getALLOWED_PSI_TYPE$cp().contains(componentType.getCanonicalText())) {
                    return -1;
                }
                return !TypeConversionUtil.isNullType((PsiType)type) && TypeConversionUtil.isAssignable((PsiType)UElementAsPsiDetector.access$getPsiElementType$p(this.this$0), (PsiType)componentType) && this.getDimIfUElementType(componentType) == -2 ? dim : -1;
            }

            private final int getDimIfUElementType(PsiType type) {
                PsiType psiType = type;
                if (psiType == null) {
                    return -2;
                }
                int dim = psiType.getArrayDimensions();
                PsiType psiType2 = type.getDeepComponentType();
                Intrinsics.checkNotNullExpressionValue((Object)psiType2, (String)"getDeepComponentType(...)");
                PsiType componentType = psiType2;
                if (UElementAsPsiDetector.access$getALLOWED_PSI_TYPE$cp().contains(componentType.getCanonicalText())) {
                    return -2;
                }
                return !TypeConversionUtil.isNullType((PsiType)type) && TypeConversionUtil.isAssignable((PsiType)UElementAsPsiDetector.access$getUElementType$p(this.this$0), (PsiType)componentType) ? dim : -2;
            }

            private final boolean isPsiElementClass(PsiClass cls) {
                if (cls == null) {
                    return false;
                }
                String string = cls.getQualifiedName();
                if (string == null) {
                    return false;
                }
                String qualifiedName = string;
                return this.getDimIfPsiElementType((PsiType)PsiType.getTypeByName((String)qualifiedName, (Project)cls.getProject(), (GlobalSearchScope)cls.getResolveScope())) != -1;
            }

            private final void reportUsage(UElement node) {
                UElement uElement = node;
                if (uElement == null || (uElement = uElement.getSourcePsi()) == null) {
                    return;
                }
                UElement sourcePsi = uElement;
                if (!UElementAsPsiDetector.access$getReportedElements$p(this.this$0).add(sourcePsi)) {
                    return;
                }
                JavaContext.report$default((JavaContext)this.$context, (Issue)UElementAsPsiDetector.ISSUE, (UElement)node, (Location)this.$context.getLocation(node), (String)"Do not use `UElement` as `PsiElement`", null, (int)16, null);
            }
        };
    }

    public static final /* synthetic */ Set access$getALLOWED_REDEFINITION$cp() {
        return ALLOWED_REDEFINITION;
    }

    public static final /* synthetic */ PsiType access$getUElementType$p(UElementAsPsiDetector $this) {
        return $this.uElementType;
    }

    public static final /* synthetic */ PsiType access$getPsiElementType$p(UElementAsPsiDetector $this) {
        return $this.psiElementType;
    }

    public static final /* synthetic */ Set access$getALLOWED_PSI_TYPE$cp() {
        return ALLOWED_PSI_TYPE;
    }

    public static final /* synthetic */ Set access$getReportedElements$p(UElementAsPsiDetector $this) {
        return $this.reportedElements;
    }

    static {
        Object[] objectArray = Issue.Companion;
        Category category = Category.CUSTOM_LINT_CHECKS;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        EnumSet enumSet = Platform.JDK_SET;
        ISSUE = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"UElementAsPsi", (String)"Avoid using UElement as PsiElement", (String)"\n            Avoid using UAST element as PSI element. \\\n            If you need to utilize PSI APIs, retrieve the underlying `javaPsi` explicitly. \\\n            If you need to analyze language-specific information, access `sourcePsi`.\n          ", (Implementation)implementation, null, (Category)category, (int)4, (Severity)severity, (boolean)false, null, (EnumSet)enumSet, null, (int)2832, null);
        objectArray = new String[]{UDeclaration.class.getName(), UClass.class.getName(), UMethod.class.getName(), UVariable.class.getName(), UClassInitializer.class.getName()};
        ALLOWED_REDEFINITION = SetsKt.setOf((Object[])objectArray);
        ALLOWED_PSI_TYPE = SetsKt.setOf((Object)PsiModifierListOwner.class.getName());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/UElementAsPsiDetector$Companion;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "MSG", "", "NOT_UELEMENT", "", "NOT_PSI_ELEMENT", "ALLOWED_REDEFINITION", "", "ALLOWED_PSI_TYPE", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

