/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.TypoLookup;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Lint;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.io.ByteStreams;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0002\b\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B#\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ&\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007J&\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007J(\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/lint/checks/TypoLookup;", "", "data", "", "indices", "", "wordCount", "", "<init>", "([B[II)V", "getTypos", "", "", "text", "", "begin", "end", "utf8Text", "computeSuggestions", "initialOffset", "glob", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nTypoLookup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypoLookup.kt\ncom/android/tools/lint/checks/TypoLookup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,700:1\n1#2:701\n*E\n"})
public final class TypoLookup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private byte[] data;
    @NotNull
    private int[] indices;
    private int wordCount;
    @NotNull
    private static final TypoLookup NONE = new TypoLookup(new byte[0], new int[0], 0);
    @NotNull
    private static final String WORD_SEPARATOR = "->";
    @NotNull
    private static final String FILE_HEADER = "Typo database used by Android lint\u0000";
    private static final int BINARY_FORMAT_VERSION = 2;
    private static final boolean DEBUG_FORCE_REGENERATE_BINARY = false;
    private static final int BYTES_PER_ENTRY = 28;
    @NotNull
    private static final WeakHashMap<String, TypoLookup> instanceMap = new WeakHashMap();

    private TypoLookup(byte[] data, int[] indices, int wordCount) {
        this.data = data;
        this.indices = indices;
        this.wordCount = wordCount;
    }

    /* synthetic */ TypoLookup(byte[] byArray, int[] nArray, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(byArray, nArray, n);
    }

    @Nullable
    public final List<String> getTypos(@NotNull CharSequence text, int begin, int end) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        boolean bl2 = bl = end <= text.length();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (Lint.assertionsEnabled()) {
            for (int i = begin; i < end; ++i) {
                char c = text.charAt(i);
                if (c < '\u0080') continue;
                if (_Assertions.ENABLED) {
                    boolean $i$a$-assert-TypoLookup$getTypos$22 = false;
                    String $i$a$-assert-TypoLookup$getTypos$22 = "Call the UTF-8 version of this method instead";
                    throw new AssertionError((Object)$i$a$-assert-TypoLookup$getTypos$22);
                }
                return null;
            }
        }
        int low = 0;
        int high = this.wordCount - 1;
        while (low <= high) {
            int middle = low + high >>> 1;
            int offset = this.indices[middle];
            int compare = Companion.compare(this.data, offset, (byte)0, text, begin, end);
            if (compare == 0) {
                offset = this.indices[middle];
                if (this.data[offset] != (byte)text.charAt(begin) && Character.isLowerCase(text.charAt(begin))) {
                    return null;
                }
                String glob = null;
                int i = begin;
                while (true) {
                    byte b;
                    if ((b = this.data[offset++]) == 0) {
                        --offset;
                        break;
                    }
                    if (b == 42) {
                        int globEnd;
                        for (globEnd = i; globEnd < text.length() && Character.isLetter(text.charAt(globEnd)); ++globEnd) {
                        }
                        glob = ((Object)text.subSequence(i, globEnd)).toString();
                        break;
                    }
                    char c = text.charAt(i);
                    byte cb = (byte)c;
                    if (b != cb && i > begin) {
                        return null;
                    }
                    ++i;
                }
                return this.computeSuggestions(this.indices[middle], offset, glob);
            }
            if (compare < 0) {
                low = middle + 1;
                continue;
            }
            high = middle - 1;
        }
        return null;
    }

    @Nullable
    public final List<String> getTypos(@NotNull byte[] utf8Text, int begin, int end) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)utf8Text, (String)"utf8Text");
        boolean bl2 = bl = end <= utf8Text.length;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        int low = 0;
        int high = this.wordCount - 1;
        while (low <= high) {
            int middle = low + high >>> 1;
            int offset = this.indices[middle];
            int compare = Companion.compare(this.data, offset, (byte)0, utf8Text, begin, end);
            if (compare == 0) {
                offset = this.indices[middle];
                if (this.data[offset] != utf8Text[begin] && TypoLookup.Companion.isUpperCase(this.data[offset])) {
                    return null;
                }
                String glob = null;
                int i = begin;
                while (true) {
                    byte b;
                    if ((b = this.data[offset++]) == 0) {
                        --offset;
                        break;
                    }
                    if (b == 42) {
                        int globEnd;
                        for (globEnd = i; globEnd < utf8Text.length && Companion.isLetter(utf8Text[globEnd]); ++globEnd) {
                        }
                        glob = new String(utf8Text, i, globEnd - i, Charsets.UTF_8);
                        break;
                    }
                    byte cb = utf8Text[i];
                    if (b != cb && i > begin) {
                        return null;
                    }
                    ++i;
                }
                return this.computeSuggestions(this.indices[middle], offset, glob);
            }
            if (compare < 0) {
                low = middle + 1;
                continue;
            }
            high = middle - 1;
        }
        return null;
    }

    private final List<String> computeSuggestions(int begin, int initialOffset, String glob) {
        boolean bl;
        int offset = initialOffset;
        String typo = new String(this.data, begin, offset - begin, Charsets.UTF_8);
        if (glob != null) {
            CharSequence charSequence = typo;
            typo = new Regex("\\*").replace(charSequence, glob);
        }
        boolean bl2 = bl = this.data[offset] == 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        int replacementEnd = ++offset;
        while (this.data[replacementEnd] != 0) {
            ++replacementEnd;
        }
        String replacements = new String(this.data, offset, replacementEnd - offset, Charsets.UTF_8);
        ArrayList<String> words = new ArrayList<String>();
        words.add(typo);
        for (String s : Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)replacements)) {
            boolean bl3;
            if (glob != null) {
                Intrinsics.checkNotNull((Object)s);
                CharSequence charSequence = s;
                bl3 = words.add(new Regex("\\*").replace(charSequence, glob));
                continue;
            }
            bl3 = words.add(s);
        }
        return words;
    }

    @JvmStatic
    @Nullable
    public static final TypoLookup get(@NotNull LintClient client, @NotNull String locale, @Nullable String region) {
        return Companion.get(client, locale, region);
    }

    @VisibleForTesting
    @JvmStatic
    public static final int compare(@NotNull byte[] data, int offset, byte terminator, @NotNull CharSequence s, int begin, int initialEnd) {
        return Companion.compare(data, offset, terminator, s, begin, initialEnd);
    }

    @VisibleForTesting
    @JvmStatic
    public static final int compare(@NotNull byte[] data, int offset, byte terminator, @NotNull byte[] s, int begin, int initialEnd) {
        return Companion.compare(data, offset, terminator, s, begin, initialEnd);
    }

    @JvmStatic
    public static final boolean isLetter(byte b) {
        return Companion.isLetter(b);
    }

    public /* synthetic */ TypoLookup(byte[] data, int[] indices, int wordCount, DefaultConstructorMarker $constructor_marker) {
        this(data, indices, wordCount);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\r\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0007H\u0087\u0002J#\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0082\u0002J$\u0010\u0018\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J \u0010\u001b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J#\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001a2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070!H\u0002\u00a2\u0006\u0002\u0010\"J8\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020\nH\u0007J8\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020%2\u0006\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020\nH\u0007J\u0010\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020(H\u0002J\u0010\u0010/\u001a\u00020(2\u0006\u0010.\u001a\u00020(H\u0002J\u0010\u00100\u001a\u00020\f2\u0006\u0010.\u001a\u00020(H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/android/tools/lint/checks/TypoLookup$Companion;", "", "<init>", "()V", "NONE", "Lcom/android/tools/lint/checks/TypoLookup;", "WORD_SEPARATOR", "", "FILE_HEADER", "BINARY_FORMAT_VERSION", "", "DEBUG_FORCE_REGENERATE_BINARY", "", "BYTES_PER_ENTRY", "instanceMap", "Ljava/util/WeakHashMap;", "get", "client", "Lcom/android/tools/lint/client/api/LintClient;", "locale", "region", "xmlStream", "Ljava/io/InputStream;", "name", "readData", "binaryFile", "Ljava/io/File;", "createCache", "binaryData", "writeDatabase", "", "file", "lines", "", "(Ljava/io/File;[Ljava/lang/String;)V", "compare", "data", "", "offset", "terminator", "", "s", "", "begin", "initialEnd", "isUpperCase", "b", "toLowerCase", "isLetter", "lint-checks"})
    @SourceDebugExtension(value={"SMAP\nTypoLookup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypoLookup.kt\ncom/android/tools/lint/checks/TypoLookup$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,700:1\n1#2:701\n739#3,9:702\n37#4:711\n36#4,3:712\n*S KotlinDebug\n*F\n+ 1 TypoLookup.kt\ncom/android/tools/lint/checks/TypoLookup$Companion\n*L\n410#1:702,9\n411#1:711\n411#1:712,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @JvmStatic
        @Nullable
        public final TypoLookup get(@NotNull LintClient client, @NotNull String locale, @Nullable String region) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            Class<TypoLookup> clazz = TypoLookup.class;
            synchronized (clazz) {
                TypoLookup db;
                boolean bl = false;
                Object key = locale;
                if (region != null && region.length() == 2) {
                    boolean bl2;
                    boolean bl3 = bl2 = Character.isUpperCase(region.charAt(0)) && Character.isUpperCase(region.charAt(1));
                    if (_Assertions.ENABLED && !bl2) {
                        boolean $i$a$-assert-TypoLookup$Companion$get$1$32 = false;
                        String $i$a$-assert-TypoLookup$Companion$get$1$32 = region;
                        throw new AssertionError((Object)$i$a$-assert-TypoLookup$Companion$get$1$32);
                    }
                    key = locale + "r" + region;
                }
                if ((db = (TypoLookup)instanceMap.get(key)) == null) {
                    String name = "typos-" + (String)key + ".txt";
                    String path = "/typos/" + name;
                    InputStream stream = TypoLookup.class.getResourceAsStream(path);
                    if (stream == null) {
                        if (region != null) {
                            return Companion.get(client, locale, null);
                        }
                        db = NONE;
                    } else {
                        boolean bl4;
                        db = Companion.get(client, stream, name);
                        boolean bl5 = bl4 = db != null;
                        if (_Assertions.ENABLED && !bl4) {
                            boolean bl6 = false;
                            String string = name;
                            throw new AssertionError((Object)string);
                        }
                    }
                    ((Map)instanceMap).put(key, db);
                }
                if (db == NONE) {
                    return null;
                }
                TypoLookup typoLookup = db;
                return typoLookup;
            }
        }

        private final TypoLookup get(LintClient client, InputStream xmlStream, String name) {
            File file = client.getCacheDir(null, true);
            if (file == null) {
                return null;
            }
            File cacheDir = file;
            File binaryData = new File(cacheDir, name + "-2.bin");
            if (!binaryData.exists() && !this.createCache(client, xmlStream, binaryData)) {
                return null;
            }
            if (!binaryData.exists()) {
                Object[] objectArray = new Object[]{binaryData};
                client.log(null, "The typo database file %1$s does not exist", objectArray);
                return null;
            }
            return this.readData(client, xmlStream, binaryData);
        }

        private final TypoLookup readData(LintClient client, InputStream xmlStream, File binaryFile) {
            if (binaryFile == null) {
                return null;
            }
            if (!binaryFile.exists()) {
                Object[] objectArray = new Object[]{binaryFile};
                client.log(null, "%1$s does not exist", objectArray);
                return null;
            }
            try {
                byte[] b = Files.toByteArray((File)binaryFile);
                ByteBuffer buffer = ByteBuffer.wrap(b);
                byte[] byArray = TypoLookup.FILE_HEADER.getBytes(Charsets.US_ASCII);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                byte[] expectedHeader = byArray;
                buffer.rewind();
                for (byte anExpectedHeader : expectedHeader) {
                    if (anExpectedHeader == buffer.get()) continue;
                    client.log(null, "Incorrect file header: not an typo database cache file, or a corrupt cache file", new Object[0]);
                    return null;
                }
                if (buffer.get() != 2) {
                    if (this.createCache(client, xmlStream, binaryFile)) {
                        return this.readData(client, xmlStream, binaryFile);
                    }
                    return null;
                }
                int wordCount = buffer.getInt();
                int[] offsets = new int[wordCount];
                for (int i = 0; i < wordCount; ++i) {
                    offsets[i] = buffer.getInt();
                }
                Intrinsics.checkNotNull((Object)b);
                return new TypoLookup(b, offsets, wordCount, null);
            }
            catch (IOException e) {
                client.log((Throwable)e, null, new Object[0]);
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final boolean createCache(LintClient client, InputStream xmlStream, File binaryData) {
            String[] lines = null;
            try {
                void $this$toTypedArray$iv;
                List list;
                Collection $this$dropLastWhile$iv;
                byte[] byArray = ByteStreams.toByteArray((InputStream)xmlStream);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
                Object object = byArray;
                Charset charset = Charsets.UTF_8;
                object = new String((byte[])object, charset);
                charset = new Regex("\n");
                int n = 0;
                object = charset.split((CharSequence)object, n);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl = false;
                        if (((CharSequence)it).length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                $this$dropLastWhile$iv = list;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                lines = thisCollection$iv.toArray(new String[0]);
            }
            catch (IOException e) {
                client.log((Throwable)e, "Can't read typo database file", new Object[0]);
                return false;
            }
            try {
                this.writeDatabase(binaryData, lines);
                return true;
            }
            catch (IOException ioe) {
                client.log((Throwable)ioe, "Can't write typo cache file", new Object[0]);
                return false;
            }
        }

        private final void writeDatabase(File file, String[] lines) throws IOException {
            Object word;
            ArrayList<CallSite> words = new ArrayList<CallSite>(lines.length);
            for (String line : lines) {
                if (((CharSequence)line).length() == 0 || !Character.isLetter(line.charAt(0))) continue;
                int end = StringsKt.indexOf$default((CharSequence)line, (String)TypoLookup.WORD_SEPARATOR, (int)0, (boolean)false, (int)6, null);
                if (end == -1) {
                    end = ((Object)StringsKt.trim((CharSequence)line)).toString().length();
                }
                String string = line.substring(0, end);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String typo = ((Object)StringsKt.trim((CharSequence)string)).toString();
                String string2 = line.substring(end + 2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String replacements = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                if (((CharSequence)replacements).length() == 0) continue;
                String combined = typo + "\u0000" + replacements;
                words.add((CallSite)((Object)combined));
            }
            byte[][] wordArrays = new byte[words.size()][];
            Companion $this$writeDatabase_u24lambda_u244 = this;
            boolean bl = false;
            int n = words.size();
            for (int i = 0; i < n; ++i) {
                Object e = words.get(i);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                String word2 = (String)e;
                Intrinsics.checkNotNullExpressionValue((Object)word2.getBytes(Charsets.UTF_8), (String)"getBytes(...)");
            }
            Function2 function2 = writeDatabase.2.INSTANCE;
            Arrays.sort((Object[])wordArrays, new Comparator(function2){
                private final /* synthetic */ Function2 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ int compare(Object p0, Object p1) {
                    return ((Number)this.function.invoke(p0, p1)).intValue();
                }
            });
            byte[] byArray = TypoLookup.FILE_HEADER.getBytes(Charsets.US_ASCII);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] headerBytes = byArray;
            int entryCount = ((Object[])wordArrays).length;
            int capacity = entryCount * 28 + headerBytes.length + 5;
            ByteBuffer buffer = ByteBuffer.allocate(capacity);
            buffer.order(ByteOrder.BIG_ENDIAN);
            buffer.put(headerBytes);
            buffer.put((byte)2);
            buffer.putInt(entryCount);
            int wordOffsetTable = buffer.position();
            for (int i = 0; i < entryCount; ++i) {
                buffer.putInt(0);
            }
            int nextEntry = buffer.position();
            int nextOffset = wordOffsetTable;
            int n2 = ((Object[])wordArrays).length;
            for (int i = 0; i < n2; ++i) {
                word = wordArrays[i];
                buffer.position(nextOffset);
                buffer.putInt(nextEntry);
                nextOffset = buffer.position();
                buffer.position(nextEntry);
                buffer.put((byte[])word);
                buffer.put((byte)0);
                nextEntry = buffer.position();
            }
            int size = buffer.position();
            int n3 = n2 = size <= buffer.limit() ? 1 : 0;
            if (_Assertions.ENABLED && n2 == 0) {
                word = "Assertion failed";
                throw new AssertionError(word);
            }
            buffer.mark();
            byte[] b = new byte[size];
            buffer.rewind();
            buffer.get(b);
            File tmp = new File(file.getPath() + "." + new Random().nextInt());
            File file2 = tmp.getParentFile();
            if (file2 != null) {
                File it = file2;
                boolean bl2 = false;
                if (!it.exists()) {
                    it.mkdirs();
                }
            }
            Files.asByteSink((File)tmp, (FileWriteMode[])new FileWriteMode[0]).write(b);
            if (!tmp.renameTo(file)) {
                tmp.delete();
            }
        }

        @VisibleForTesting
        @JvmStatic
        public final int compare(@NotNull byte[] data, int offset, byte terminator, @NotNull CharSequence s, int begin, int initialEnd) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            int end = initialEnd;
            int i = offset;
            int j = begin;
            while (true) {
                int max;
                byte b;
                if ((b = data[i]) == 32 && j == end && end < (max = s.length()) && s.charAt(end) == ' ') {
                    while (end < max) {
                        char c = s.charAt(end);
                        if (!Character.isLetter(c)) {
                            if (c != ' ' || end != j) break;
                            ++end;
                            continue;
                        }
                        ++end;
                    }
                }
                if (j == end) break;
                if (b == 42) {
                    return 0;
                }
                char c = s.charAt(j);
                byte cb = (byte)c;
                int delta = b - cb;
                if (delta != 0 && b != (cb = (byte)Character.toLowerCase(c)) && (delta = (b = (byte)Character.toLowerCase(b)) - cb) != 0) {
                    return delta;
                }
                ++i;
                ++j;
            }
            return data[i] - terminator;
        }

        @VisibleForTesting
        @JvmStatic
        public final int compare(@NotNull byte[] data, int offset, byte terminator, @NotNull byte[] s, int begin, int initialEnd) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            int end = initialEnd;
            int i = offset;
            int j = begin;
            while (true) {
                int max;
                byte b;
                if ((b = data[i]) == 32 && j == end && end < (max = s.length) && s[end] == 32) {
                    while (end < max) {
                        byte cb = s[end];
                        if (!this.isLetter(cb)) {
                            if (cb != 32 || end != j) break;
                            ++end;
                            continue;
                        }
                        ++end;
                    }
                }
                if (j == end) break;
                if (b == 42) {
                    return 0;
                }
                byte cb = s[j];
                int delta = b - cb;
                if (delta != 0) {
                    cb = this.toLowerCase(cb);
                    delta = (b = this.toLowerCase(b)) - cb;
                    if (delta != 0) {
                        return delta;
                    }
                }
                if (b == terminator || cb == terminator) {
                    return delta;
                }
                ++i;
                ++j;
            }
            return data[i] - terminator;
        }

        private final boolean isUpperCase(byte b) {
            return Character.isUpperCase((char)b);
        }

        private final byte toLowerCase(byte b) {
            return (byte)Character.toLowerCase((char)b);
        }

        @JvmStatic
        public final boolean isLetter(byte b) {
            return Character.isLetter((char)b) || (b & 0x80) != 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

