/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.IncidentKt;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u00012\u00020\u0002:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\u0018\u00010\u0006H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/SdCardDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "Issues", "lint-checks"})
public final class SdCardDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf(ULiteralExpression.class);
    }

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(context){
            final /* synthetic */ JavaContext $context;
            {
                this.$context = $context;
            }

            public void visitLiteralExpression(ULiteralExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                String s = UastUtils.evaluateString((UExpression)((UExpression)node));
                if (s != null && ((CharSequence)s).length() > 0) {
                    char c = s.charAt(0);
                    if (c != '/' && c != 'f') {
                        return;
                    }
                    if (StringsKt.startsWith$default((String)s, (String)"/sdcard", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)s, (String)"/mnt/sdcard/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)s, (String)"/system/media/sdcard", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)s, (String)"file://sdcard/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)s, (String)"file:///sdcard/", (boolean)false, (int)2, null)) {
                        String message2 = "Do not hardcode \"/sdcard/\"; use `Environment.getExternalStorageDirectory().getPath()` instead";
                        IncidentKt.Incident((Context)((Context)this.$context)).issue(SdCardDetector.ISSUE).at((Object)node).message(message2).report();
                    } else if (StringsKt.startsWith$default((String)s, (String)"/data/data/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)s, (String)"/data/user/", (boolean)false, (int)2, null)) {
                        String message3 = "Do not hardcode \"`/data/`\"; use `Context.getFilesDir().getPath()` instead";
                        IncidentKt.Incident((Context)((Context)this.$context)).issue(SdCardDetector.ISSUE).at((Object)node).message(message3).report();
                    }
                }
            }
        };
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(SdCardDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"SdCardPath", (String)"Hardcoded reference to `/sdcard`", (String)"\n            Your code should not reference the `/sdcard` path directly; instead use \\\n            `Environment.getExternalStorageDirectory().getPath()`.\n\n            Similarly, do not reference the `/data/data/` path directly; it can vary in multi-user scenarios. \\\n            Instead, use `Context.getFilesDir().getPath()`.", (Implementation)implementation, (String)"https://developer.android.com/training/data-storage#filesExternal", (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/lint/checks/SdCardDetector$Issues;", "", "<init>", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

