/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.AndroidXConstants;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u00012\u00020\u0002:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/FragmentDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "applicableSuperClasses", "", "", "visitClass", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "declaration", "Lorg/jetbrains/uast/UClass;", "Companion", "lint-checks"})
public final class FragmentDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @NotNull
    public List<String> applicableSuperClasses() {
        Object[] objectArray = new String[]{"android.app.Fragment", AndroidXConstants.CLASS_V4_FRAGMENT.oldName()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration instanceof UAnonymousClass) {
            context.report(ISSUE, declaration, context.getNameLocation(declaration), "Fragments should be static such that they can be re-instantiated by the system, and anonymous classes are not static");
            return;
        }
        JavaEvaluator evaluator = context.getEvaluator();
        if (evaluator.isAbstract((PsiModifierListOwner)declaration)) {
            return;
        }
        if (!evaluator.isPublic((UDeclaration)declaration)) {
            context.report(ISSUE, declaration, context.getNameLocation(declaration), "This fragment class should be public (" + declaration.getQualifiedName() + ")");
            return;
        }
        if (declaration.getJavaPsi().getContainingClass() != null && !evaluator.isStatic((PsiModifierListOwner)declaration)) {
            context.report(ISSUE, declaration, context.getNameLocation(declaration), "This fragment inner class should be static (" + declaration.getQualifiedName() + ")");
            return;
        }
        boolean hasDefaultConstructor = false;
        boolean hasConstructor = false;
        for (PsiMethod constructor : declaration.getJavaPsi().getConstructors()) {
            Location location;
            hasConstructor = true;
            if (constructor.getParameterList().getParametersCount() == 0) {
                if (evaluator.isPublic((PsiModifierListOwner)constructor)) {
                    hasDefaultConstructor = true;
                    continue;
                }
                Intrinsics.checkNotNull((Object)constructor);
                location = context.getNameLocation((PsiElement)constructor);
                JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (PsiElement)((PsiElement)constructor), (Location)location, (String)"The default constructor must be public", null, (int)16, null);
                return;
            }
            Intrinsics.checkNotNull((Object)constructor);
            location = context.getNameLocation((PsiElement)constructor);
            String message2 = "Avoid non-default constructors in fragments: use a default constructor plus `Fragment#setArguments(Bundle)` instead";
            JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (PsiElement)((PsiElement)constructor), (Location)location, (String)message2, null, (int)16, null);
        }
        if (!hasDefaultConstructor && hasConstructor) {
            String message3 = "This fragment should provide a default constructor (a public constructor with no arguments) (`" + declaration.getQualifiedName() + "`)";
            context.report(ISSUE, declaration, context.getNameLocation(declaration), message3);
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = new Implementation(FragmentDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"ValidFragment", (String)"Fragment not instantiatable", (String)"\n                From the Fragment documentation:\n                **Every** fragment must have an empty constructor, so it can be instantiated \\\n                when restoring its activity's state. It is strongly recommended that subclasses \\\n                do not have other constructors with parameters, since these constructors will \\\n                not be called when the fragment is re-instantiated; instead, arguments can be \\\n                supplied by the caller with `setArguments(Bundle)` and later retrieved by the \\\n                Fragment with `getArguments()`.\n\n                Note that this is no longer true when you are using \\\n                `androidx.fragment.app.Fragment`; with the `FragmentFactory` you can supply \\\n                any arguments you want (as of version androidx version 1.1).\n                ", (Implementation)implementation, (String)"https://developer.android.com/reference/android/app/Fragment.html#Fragment()", (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/lint/checks/FragmentDetector$Companion;", "", "<init>", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

