/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.detector.api.Lint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.session.KtAnalysisSessionProvider;
import org.jetbrains.kotlin.analysis.api.types.KtType;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UExpressionList;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULabeledExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USwitchClauseExpressionWithBody;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UYieldExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.internal.ImplementationUtilsKt;
import org.jetbrains.uast.kotlin.kinds.KotlinSpecialExpressionKinds;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000x\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u000f\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u001a\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0014\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u0012\u0010\u0019\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u001a\n\u0010\u001a\u001a\u00020\u0001*\u00020\u0001\u001a\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u001dH\u0002\u001a\f\u0010\u001e\u001a\u0004\u0018\u00010\u001f*\u00020 \u001a\f\u0010!\u001a\u0004\u0018\u00010\u001f*\u00020 \u001a\u000e\u0010\"\u001a\u0004\u0018\u00010\u001c*\u00020\u001dH\u0002\u001a\u001e\u0010#\u001a\u00020\b*\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020$2\b\b\u0002\u0010&\u001a\u00020\b\u001a\u001c\u0010#\u001a\u00020\b*\u00020\u00012\u0006\u0010%\u001a\u00020\u00012\b\b\u0002\u0010&\u001a\u00020\b\u001a\n\u0010'\u001a\u00020\b*\u00020(\u001a\n\u0010)\u001a\u00020\b*\u00020\u0001\u001a\n\u0010*\u001a\u00020\b*\u00020+\u001a\n\u0010,\u001a\u00020\b*\u00020\n\u001a\n\u0010-\u001a\u00020\b*\u00020\n\u001a\n\u0010.\u001a\u00020\b*\u00020\n\u001a\n\u0010/\u001a\u00020\b*\u000200\u001a\f\u00101\u001a\u0004\u0018\u000100*\u00020\u0001\u001a\f\u00102\u001a\u0004\u0018\u000100*\u00020\u0001\u001a\n\u00103\u001a\u000200*\u000200\u001a\f\u00104\u001a\u0004\u0018\u000100*\u00020\u0001\u00a8\u00065"}, d2={"findCommonParent", "Lorg/jetbrains/uast/UElement;", "element1", "element2", "getDepth", "", "element", "isReturningContext", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "isReturningLambdaResult", "isScopingFunction", "method", "Lcom/intellij/psi/PsiMethod;", "isScopingFunctionName", "name", "", "isScopingIt", "isScopingThis", "acceptMultiFileClass", "", "Lorg/jetbrains/uast/UFile;", "visitor", "Lorg/jetbrains/uast/visitor/UastVisitor;", "acceptSourceFile", "findSelector", "getLambdaType", "Lcom/intellij/psi/PsiType;", "Lorg/jetbrains/uast/ULambdaExpression;", "getReceiver", "Lcom/intellij/psi/PsiClass;", "Lcom/intellij/psi/PsiMember;", "getReceiverOrContainingClass", "getReturnType", "isBelow", "Lcom/intellij/psi/PsiElement;", "parent", "strict", "isElvisIf", "Lorg/jetbrains/uast/UIfExpression;", "isIncorrectImplicitReturnInLambda", "isReceiver", "Lcom/intellij/psi/PsiParameter;", "isSuperConstructorCall", "isThisConstructorCall", "isThisOrSuperConstructorCall", "isUnconditionalReturn", "Lorg/jetbrains/uast/UExpression;", "nextStatement", "previousStatement", "skipLabeledExpression", "statement", "lint-api"})
@SourceDebugExtension(value={"SMAP\nUastLintUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UastLintUtils.kt\ncom/android/tools/lint/detector/api/UastLintUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 4 KtAnalysisSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider\n+ 5 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1070:1\n1#2:1071\n29#3,2:1072\n51#4:1074\n65#4,8:1075\n18#5:1083\n1747#6,3:1084\n*S KotlinDebug\n*F\n+ 1 UastLintUtils.kt\ncom/android/tools/lint/detector/api/UastLintUtilsKt\n*L\n764#1:1072,2\n764#1:1074\n764#1:1075,8\n790#1:1083\n928#1:1084,3\n*E\n"})
public final class UastLintUtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isScopingThis(@NotNull UCallExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String name = Lint.getMethodName(node);
        if (name == null) return false;
        switch (name.hashCode()) {
            case 3649734: {
                if (name.equals("with")) return UastLintUtilsKt.isScopingFunction(node);
                return false;
            }
            case 93029230: {
                if (name.equals("apply")) return UastLintUtilsKt.isScopingFunction(node);
                return false;
            }
            case 113291: {
                if (!name.equals("run")) return false;
                return UastLintUtilsKt.isScopingFunction(node);
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isScopingIt(@NotNull UCallExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String name = Lint.getMethodName(node);
        if (name == null) return false;
        switch (name.hashCode()) {
            case 107035: {
                if (name.equals("let")) return UastLintUtilsKt.isScopingFunction(node);
                return false;
            }
            case 2997191: {
                if (name.equals("also")) return UastLintUtilsKt.isScopingFunction(node);
                return false;
            }
            case -1066067175: {
                if (name.equals("takeUnless")) return UastLintUtilsKt.isScopingFunction(node);
                return false;
            }
            case -881117180: {
                if (!name.equals("takeIf")) return false;
                return UastLintUtilsKt.isScopingFunction(node);
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isReturningContext(@NotNull UCallExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String name = Lint.getMethodName(node);
        if (name == null) return false;
        switch (name.hashCode()) {
            case 93029230: {
                if (name.equals("apply")) return UastLintUtilsKt.isScopingFunction(node);
                return false;
            }
            case 2997191: {
                if (name.equals("also")) return UastLintUtilsKt.isScopingFunction(node);
                return false;
            }
            case -1066067175: {
                if (name.equals("takeUnless")) return UastLintUtilsKt.isScopingFunction(node);
                return false;
            }
            case -881117180: {
                if (!name.equals("takeIf")) return false;
                return UastLintUtilsKt.isScopingFunction(node);
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isScopingFunctionName(String name) {
        String string = name;
        if (string == null) return false;
        switch (string.hashCode()) {
            case 3649734: {
                if (string.equals("with")) return true;
                return false;
            }
            case 93029230: {
                if (string.equals("apply")) return true;
                return false;
            }
            case 107035: {
                if (string.equals("let")) return true;
                return false;
            }
            case 113291: {
                if (string.equals("run")) return true;
                return false;
            }
            case 2997191: {
                if (string.equals("also")) return true;
                return false;
            }
            case -1066067175: {
                if (string.equals("takeUnless")) return true;
                return false;
            }
            case -881117180: {
                if (!string.equals("takeIf")) return false;
                return true;
            }
        }
        return false;
    }

    public static final boolean isScopingFunction(@NotNull UCallExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Object object = node.getMethodIdentifier();
        if (object == null || (object = object.getName()) == null) {
            object = node.getMethodName();
        }
        if (UastLintUtilsKt.isScopingFunctionName((String)object)) {
            PsiMethod psiMethod = node.resolve();
            if (psiMethod == null) {
                return true;
            }
            PsiMethod called = psiMethod;
            return UastLintUtilsKt.isScopingFunction(called);
        }
        return false;
    }

    public static final boolean isScopingFunction(@NotNull PsiMethod method) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (UastLintUtilsKt.isScopingFunctionName(method.getName())) {
            PsiClass psiClass = method.getContainingClass();
            bl = Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"kotlin.StandardKt__StandardKt");
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isReturningLambdaResult(@NotNull UCallExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String name = Lint.getMethodName(node);
        if (name == null) return false;
        switch (name.hashCode()) {
            case 3649734: {
                if (name.equals("with")) return UastLintUtilsKt.isScopingFunction(node);
                return false;
            }
            case 107035: {
                if (name.equals("let")) return UastLintUtilsKt.isScopingFunction(node);
                return false;
            }
            case 113291: {
                if (!name.equals("run")) return false;
                return UastLintUtilsKt.isScopingFunction(node);
            }
        }
        return false;
    }

    public static final boolean isReceiver(@NotNull PsiParameter $this$isReceiver) {
        Intrinsics.checkNotNullParameter((Object)$this$isReceiver, (String)"<this>");
        String string = $this$isReceiver.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        String name = string;
        return StringsKt.startsWith$default((String)name, (String)"$this", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"$self", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final UElement findSelector(@NotNull UElement $this$findSelector) {
        Intrinsics.checkNotNullParameter((Object)$this$findSelector, (String)"<this>");
        UElement curr = $this$findSelector;
        while (true) {
            UElement uElement;
            UElement uElement2;
            if ((uElement2 = curr) instanceof UQualifiedReferenceExpression) {
                uElement = (UElement)((UQualifiedReferenceExpression)curr).getSelector();
            } else {
                if (!(uElement2 instanceof UParenthesizedExpression)) break;
                uElement = (UElement)((UParenthesizedExpression)curr).getExpression();
            }
            curr = uElement;
        }
        return curr;
    }

    @Nullable
    public static final UExpression nextStatement(@NotNull UElement $this$nextStatement) {
        Intrinsics.checkNotNullParameter((Object)$this$nextStatement, (String)"<this>");
        UElement prev = $this$nextStatement;
        for (UElement curr = prev.getUastParent(); curr != null; curr = curr.getUastParent()) {
            if (curr instanceof UBlockExpression) {
                List expressions = ((UBlockExpression)curr).getExpressions();
                int index = CollectionsKt.indexOf((List)expressions, (Object)prev);
                return index != -1 && index < expressions.size() - 1 ? (UExpression)expressions.get(index + 1) : null;
            }
            prev = curr;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isIncorrectImplicitReturnInLambda(@NotNull UElement $this$isIncorrectImplicitReturnInLambda) {
        void this_$iv$iv$iv;
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$isIncorrectImplicitReturnInLambda, (String)"<this>");
        if (!($this$isIncorrectImplicitReturnInLambda instanceof UReturnExpression)) return false;
        if ($this$isIncorrectImplicitReturnInLambda.getSourcePsi() != null) {
            return false;
        }
        if (!($this$isIncorrectImplicitReturnInLambda.getUastParent() instanceof UBlockExpression)) {
            return false;
        }
        UElement uElement = $this$isIncorrectImplicitReturnInLambda.getUastParent();
        Intrinsics.checkNotNull((Object)uElement, (String)"null cannot be cast to non-null type org.jetbrains.uast.UBlockExpression");
        UBlockExpression block = (UBlockExpression)uElement;
        if (!Intrinsics.areEqual((Object)CollectionsKt.lastOrNull((List)block.getExpressions()), (Object)$this$isIncorrectImplicitReturnInLambda)) {
            return false;
        }
        if (!(block.getUastParent() instanceof ULambdaExpression)) {
            return false;
        }
        UElement uElement2 = block.getUastParent();
        Intrinsics.checkNotNull((Object)uElement2, (String)"null cannot be cast to non-null type org.jetbrains.uast.ULambdaExpression");
        ULambdaExpression lambda = (ULambdaExpression)uElement2;
        PsiType psiType = UastLintUtilsKt.getReturnType(lambda);
        if (psiType == null) return false;
        PsiType returnType = psiType;
        boolean bl = false;
        PsiType psiType2 = returnType instanceof PsiWildcardType ? ((PsiWildcardType)returnType).getBound() : returnType;
        if (psiType2 == null) return false;
        String string = psiType2.getCanonicalText();
        if (string == null) return false;
        String lambdaReturnType = string;
        switch (lambdaReturnType.hashCode()) {
            case 399092968: {
                if (lambdaReturnType.equals("java.lang.Void")) return true;
                break;
            }
            case -1706826127: {
                if (lambdaReturnType.equals("kotlin.Unit")) return true;
                break;
            }
            case 3625364: {
                if (lambdaReturnType.equals("void")) return true;
                break;
            }
            case -1818355776: {
                if (!lambdaReturnType.equals("kotlin.Nothing")) break;
                return true;
            }
        }
        if (!Intrinsics.areEqual((Object)lambdaReturnType, (Object)"java.lang.Object")) {
            return false;
        }
        psiType2 = lambda.getSourcePsi();
        if (!(psiType2 instanceof KtLambdaExpression)) return false;
        KtLambdaExpression ktLambdaExpression = (KtLambdaExpression)psiType2;
        if (ktLambdaExpression == null) {
            return false;
        }
        KtLambdaExpression ktLambda = ktLambdaExpression;
        boolean $i$f$analyze = false;
        Project project = ((KtElement)ktLambda).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        psiType2 = KtAnalysisSessionProvider.Companion.getInstance(project);
        boolean $i$f$analyse = false;
        returnType = this_$iv$iv;
        KtAnalysisSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)ktLambda);
        boolean $i$f$analyse2 = false;
        this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
        this_$iv$iv$iv.getTokenFactory().beforeEnteringAnalysisContext(analysisSession$iv$iv$iv.getToken());
        try {
            KtAnalysisSession $this$isIncorrectImplicitReturnInLambda_u24lambda_u241 = analysisSession$iv$iv$iv;
            boolean bl2 = false;
            KtType ktType = $this$isIncorrectImplicitReturnInLambda_u24lambda_u241.getExpectedType((PsiElement)ktLambda);
            boolean bl3 = ktType != null ? $this$isIncorrectImplicitReturnInLambda_u24lambda_u241.isSuspendFunctionType(ktType) : false;
            return bl3;
        }
        finally {
            this_$iv$iv$iv.getTokenFactory().afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
            this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
        }
    }

    private static final PsiType getReturnType(ULambdaExpression $this$getReturnType) {
        PsiType lambdaType = UastLintUtilsKt.getLambdaType($this$getReturnType);
        return LambdaUtil.getFunctionalInterfaceReturnType((PsiType)lambdaType);
    }

    private static final PsiType getLambdaType(ULambdaExpression $this$getLambdaType) {
        Object object = $this$getLambdaType.getFunctionalInterfaceType();
        if (object == null && (object = $this$getLambdaType.getExpressionType()) == null) {
            UElement uElement = $this$getLambdaType.getUastParent();
            if (uElement != null) {
                UElement it = uElement;
                boolean bl = false;
                UElement uElement2 = it;
                if (uElement2 instanceof UVariable) {
                    object = ((UVariable)it).getType();
                } else if (uElement2 instanceof UCallExpression) {
                    PsiParameter psiParameter = UastUtils.getParameterForArgument((UCallExpression)((UCallExpression)it), (UExpression)((UExpression)$this$getLambdaType));
                    object = psiParameter != null ? psiParameter.getType() : null;
                } else {
                    object = null;
                }
            } else {
                object = null;
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final UExpression statement(@NotNull UElement $this$statement) {
        void $this$getParentOfType$iv;
        Intrinsics.checkNotNullParameter((Object)$this$statement, (String)"<this>");
        UElement uElement = $this$statement;
        boolean strict$iv = false;
        boolean $i$f$getParentOfType = false;
        UExpression uExpression = (UExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, UExpression.class, (boolean)strict$iv);
        if (uExpression == null) {
            return null;
        }
        UExpression prev = uExpression;
        UElement curr = prev.getUastParent();
        while (curr != null) {
            if (curr instanceof UBlockExpression || !(curr instanceof UExpression)) {
                return prev instanceof UParenthesizedExpression ? ((UParenthesizedExpression)prev).getExpression() : prev;
            }
            prev = (UExpression)curr;
            curr = ((UExpression)curr).getUastParent();
        }
        return prev;
    }

    @Nullable
    public static final UExpression previousStatement(@NotNull UElement $this$previousStatement) {
        Intrinsics.checkNotNullParameter((Object)$this$previousStatement, (String)"<this>");
        UElement prev = $this$previousStatement;
        for (UElement curr = prev.getUastParent(); curr != null; curr = curr.getUastParent()) {
            if (curr instanceof UBlockExpression) {
                List expressions = ((UBlockExpression)curr).getExpressions();
                int index = CollectionsKt.indexOf((List)expressions, (Object)prev);
                return index > 0 ? (UExpression)expressions.get(index - 1) : null;
            }
            prev = curr;
        }
        return null;
    }

    public static final boolean isBelow(@NotNull UElement $this$isBelow, @NotNull UElement parent, boolean strict) {
        UElement curr;
        Intrinsics.checkNotNullParameter((Object)$this$isBelow, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        UElement uElement = curr = strict ? $this$isBelow.getUastParent() : $this$isBelow;
        while (curr != null) {
            if (Intrinsics.areEqual((Object)curr, (Object)parent)) {
                return true;
            }
            curr = curr.getUastParent();
        }
        return false;
    }

    public static /* synthetic */ boolean isBelow$default(UElement uElement, UElement uElement2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UastLintUtilsKt.isBelow(uElement, uElement2, bl);
    }

    public static final boolean isBelow(@Nullable PsiElement $this$isBelow, @NotNull PsiElement parent, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        if ($this$isBelow == null) {
            return false;
        }
        return PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)$this$isBelow, (boolean)strict);
    }

    public static /* synthetic */ boolean isBelow$default(PsiElement psiElement, PsiElement psiElement2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UastLintUtilsKt.isBelow(psiElement, psiElement2, bl);
    }

    @Nullable
    public static final PsiClass getReceiverOrContainingClass(@NotNull PsiMember $this$getReceiverOrContainingClass) {
        Intrinsics.checkNotNullParameter((Object)$this$getReceiverOrContainingClass, (String)"<this>");
        PsiClass psiClass = UastLintUtilsKt.getReceiver($this$getReceiverOrContainingClass);
        if (psiClass == null) {
            psiClass = $this$getReceiverOrContainingClass.getContainingClass();
        }
        return psiClass;
    }

    @Nullable
    public static final PsiClass getReceiver(@NotNull PsiMember $this$getReceiver) {
        UTypeReferenceExpression typeReference;
        KtCallableDeclaration ktCallableDeclaration;
        Intrinsics.checkNotNullParameter((Object)$this$getReceiver, (String)"<this>");
        PsiElement unwrapped = LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)$this$getReceiver));
        if (unwrapped instanceof KtNamedFunction ? true : unwrapped instanceof KtProperty) {
            Intrinsics.checkNotNull((Object)unwrapped, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallableDeclaration");
            ktCallableDeclaration = (KtCallableDeclaration)unwrapped;
        } else if (unwrapped instanceof KtPropertyAccessor) {
            ktCallableDeclaration = (KtCallableDeclaration)PsiTreeUtil.getNonStrictParentOfType((PsiElement)unwrapped, (Class[])new Class[0]);
        } else {
            return null;
        }
        if (ktCallableDeclaration == null) {
            return null;
        }
        KtCallableDeclaration callable = ktCallableDeclaration;
        KtTypeReference ktTypeReference = callable.getReceiverTypeReference();
        UElement uElement = ktTypeReference != null ? UastContextKt.toUElement((PsiElement)((PsiElement)ktTypeReference)) : null;
        UTypeReferenceExpression uTypeReferenceExpression = typeReference = uElement instanceof UTypeReferenceExpression ? (UTypeReferenceExpression)uElement : null;
        PsiType psiType = uTypeReferenceExpression != null ? uTypeReferenceExpression.getType() : null;
        PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
        return psiClassType != null ? psiClassType.resolve() : null;
    }

    public static final boolean isElvisIf(@NotNull UIfExpression $this$isElvisIf) {
        Intrinsics.checkNotNullParameter((Object)$this$isElvisIf, (String)"<this>");
        UElement parent = UastUtils.skipParenthesizedExprUp((UElement)$this$isElvisIf.getUastParent());
        return parent instanceof UExpressionList && Intrinsics.areEqual((Object)((UExpressionList)parent).getKind(), (Object)KotlinSpecialExpressionKinds.ELVIS);
    }

    public static final boolean isThisOrSuperConstructorCall(@NotNull UCallExpression $this$isThisOrSuperConstructorCall) {
        Intrinsics.checkNotNullParameter((Object)$this$isThisOrSuperConstructorCall, (String)"<this>");
        return UastLintUtilsKt.isSuperConstructorCall($this$isThisOrSuperConstructorCall) || UastLintUtilsKt.isThisConstructorCall($this$isThisOrSuperConstructorCall);
    }

    public static final boolean isSuperConstructorCall(@NotNull UCallExpression $this$isSuperConstructorCall) {
        Intrinsics.checkNotNullParameter((Object)$this$isSuperConstructorCall, (String)"<this>");
        PsiElement psiElement = $this$isSuperConstructorCall.getSourcePsi();
        return psiElement instanceof KtSuperTypeCallEntry ? true : (psiElement instanceof PsiMethodCallExpression ? Intrinsics.areEqual((Object)$this$isSuperConstructorCall.getMethodName(), (Object)"super") : false);
    }

    public static final boolean isThisConstructorCall(@NotNull UCallExpression $this$isThisConstructorCall) {
        Intrinsics.checkNotNullParameter((Object)$this$isThisConstructorCall, (String)"<this>");
        PsiElement psiElement = $this$isThisConstructorCall.getSourcePsi();
        return psiElement instanceof KtThisExpression ? true : (psiElement instanceof PsiMethodCallExpression ? Intrinsics.areEqual((Object)$this$isThisConstructorCall.getMethodName(), (Object)"this") : false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final void acceptSourceFile(@NotNull UFile $this$acceptSourceFile, @NotNull UastVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)$this$acceptSourceFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        PsiFile sourcePsi = $this$acceptSourceFile.getSourcePsi();
        if (sourcePsi instanceof KtFile) {
            boolean bl;
            block5: {
                Iterable $this$any$iv = ((KtFile)sourcePsi).getAnnotationEntries();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)String.valueOf(it.getShortName()), (Object)"JvmMultifileClass")) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                UastLintUtilsKt.acceptMultiFileClass($this$acceptSourceFile, visitor);
                return;
            }
        }
        $this$acceptSourceFile.accept(visitor);
    }

    @NotNull
    public static final UExpression skipLabeledExpression(@NotNull UExpression $this$skipLabeledExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$skipLabeledExpression, (String)"<this>");
        UExpression expression = $this$skipLabeledExpression;
        while (expression instanceof ULabeledExpression) {
            expression = ((ULabeledExpression)expression).getExpression();
        }
        return expression;
    }

    private static final void acceptMultiFileClass(UFile $this$acceptMultiFileClass, UastVisitor visitor) {
        VirtualFile targetFile = $this$acceptMultiFileClass.getSourcePsi().getVirtualFile();
        if (visitor.visitFile($this$acceptMultiFileClass)) {
            return;
        }
        ImplementationUtilsKt.acceptList((List)$this$acceptMultiFileClass.getUAnnotations(), (UastVisitor)visitor);
        ImplementationUtilsKt.acceptList((List)$this$acceptMultiFileClass.getImports(), (UastVisitor)visitor);
        for (UClass uClass : $this$acceptMultiFileClass.getClasses()) {
            if (visitor.visitClass(uClass)) {
                return;
            }
            ImplementationUtilsKt.acceptList((List)uClass.getUAnnotations(), (UastVisitor)visitor);
            for (UDeclaration declaration : uClass.getUastDeclarations()) {
                VirtualFile declarationFile;
                PsiElement psiElement = declaration.getSourcePsi();
                VirtualFile virtualFile = psiElement != null && (psiElement = psiElement.getContainingFile()) != null ? psiElement.getVirtualFile() : (declarationFile = null);
                if (declarationFile != null && !Intrinsics.areEqual((Object)declarationFile, (Object)targetFile)) continue;
                declaration.accept(visitor);
            }
            visitor.afterVisitClass(uClass);
        }
        visitor.afterVisitFile($this$acceptMultiFileClass);
    }

    public static final boolean isUnconditionalReturn(@NotNull UExpression $this$isUnconditionalReturn) {
        String methodName;
        UExpression uExpression;
        Intrinsics.checkNotNullParameter((Object)$this$isUnconditionalReturn, (String)"<this>");
        UExpression statement = $this$isUnconditionalReturn;
        if (statement instanceof UBlockExpression) {
            uExpression = (UExpression)CollectionsKt.lastOrNull((List)((UBlockExpression)statement).getExpressions());
            if (uExpression != null) {
                UExpression it = uExpression;
                boolean bl = false;
                return UastLintUtilsKt.isUnconditionalReturn(it);
            }
        } else if (statement instanceof UExpressionList) {
            uExpression = (UExpression)CollectionsKt.lastOrNull((List)((UExpressionList)statement).getExpressions());
            if (uExpression != null) {
                UExpression it = uExpression;
                boolean bl = false;
                return UastLintUtilsKt.isUnconditionalReturn(it);
            }
        } else if (statement instanceof UYieldExpression) {
            UExpression yieldExpression = ((UYieldExpression)statement).getExpression();
            if (yieldExpression != null) {
                return UastLintUtilsKt.isUnconditionalReturn(yieldExpression);
            }
        } else {
            if (statement instanceof UParenthesizedExpression) {
                return UastLintUtilsKt.isUnconditionalReturn(((UParenthesizedExpression)statement).getExpression());
            }
            if (statement instanceof UIfExpression) {
                UExpression thenExpression = ((UIfExpression)statement).getThenExpression();
                UExpression elseExpression = ((UIfExpression)statement).getElseExpression();
                if (thenExpression != null && elseExpression != null) {
                    return UastLintUtilsKt.isUnconditionalReturn(thenExpression) && UastLintUtilsKt.isUnconditionalReturn(elseExpression);
                }
                return false;
            }
            if (statement instanceof USwitchExpression) {
                for (UExpression uExpression2 : ((USwitchExpression)statement).getBody().getExpressions()) {
                    if (!(uExpression2 instanceof USwitchClauseExpressionWithBody) || UastLintUtilsKt.isUnconditionalReturn((UExpression)((USwitchClauseExpressionWithBody)uExpression2).getBody())) continue;
                    return false;
                }
                return true;
            }
        }
        if (statement instanceof UReturnExpression || statement instanceof UThrowExpression) {
            return true;
        }
        return statement instanceof UCallExpression && (Intrinsics.areEqual((Object)"error", (Object)(methodName = Lint.getMethodName((UCallExpression)statement))) || Intrinsics.areEqual((Object)"TODO", (Object)methodName));
    }

    @Nullable
    public static final UElement findCommonParent(@NotNull UElement element1, @NotNull UElement element2) {
        int depth1;
        Intrinsics.checkNotNullParameter((Object)element1, (String)"element1");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element2");
        if (element1 == element2) {
            return element1;
        }
        int depth2 = UastLintUtilsKt.getDepth(element2);
        UElement parent1 = element1;
        UElement parent2 = element2;
        for (depth1 = UastLintUtilsKt.getDepth(element1); depth1 > depth2; --depth1) {
            UElement uElement = parent1;
            parent1 = uElement != null ? uElement.getUastParent() : null;
        }
        while (depth2 > depth1) {
            UElement uElement = parent2;
            parent2 = uElement != null ? uElement.getUastParent() : null;
            --depth2;
        }
        while (parent1 != null && parent2 != null && !Intrinsics.areEqual((Object)parent1, (Object)parent2)) {
            parent1 = parent1.getUastParent();
            parent2 = parent2.getUastParent();
        }
        if (parent2 == null) {
            return null;
        }
        return parent1;
    }

    private static final int getDepth(UElement element) {
        int depth = 0;
        for (UElement parent = element; parent != null; parent = parent.getUastParent()) {
            ++depth;
        }
        return depth;
    }
}

