/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rR\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOpenMemberChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "shouldReportOpenFromSource", "", "Lorg/jetbrains/kotlin/KtSourceElement;", "getShouldReportOpenFromSource", "(Lorg/jetbrains/kotlin/KtSourceElement;)Z", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOpenMemberChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOpenMemberChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOpenMemberChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,53:1\n15#2,11:54\n*S KotlinDebug\n*F\n+ 1 FirOpenMemberChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOpenMemberChecker\n*L\n34#1:54,11\n*E\n"})
public final class FirOpenMemberChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirOpenMemberChecker INSTANCE = new FirOpenMemberChecker();

    private FirOpenMemberChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (DeclarationUtilsKt.getCanHaveOpenMembers(declaration)) {
            return;
        }
        org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt.processAllDeclaredCallables$default(declaration.getSymbol(), context2.getSession(), null, arg_0 -> FirOpenMemberChecker.check$lambda$0(declaration, context2, reporter, arg_0), 2, null);
    }

    private final boolean getShouldReportOpenFromSource(KtSourceElement $this$shouldReportOpenFromSource) {
        KtSourceElementKind ktSourceElementKind = $this$shouldReportOpenFromSource.getKind();
        return Intrinsics.areEqual((Object)ktSourceElementKind, (Object)KtRealSourceElementKind.INSTANCE) || Intrinsics.areEqual((Object)ktSourceElementKind, (Object)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE);
    }

    private static final Unit check$lambda$0(FirClass $declaration, CheckerContext $context, DiagnosticReporter $reporter, FirCallableSymbol memberDeclaration) {
        block9: {
            KtSourceElement source;
            block8: {
                block7: {
                    Intrinsics.checkNotNullParameter((Object)memberDeclaration, (String)"memberDeclaration");
                    if (memberDeclaration instanceof FirConstructorSymbol) {
                        return Unit.INSTANCE;
                    }
                    KtSourceElement ktSourceElement = memberDeclaration.getSource();
                    if (ktSourceElement == null) {
                        return Unit.INSTANCE;
                    }
                    source = ktSourceElement;
                    FirCallableSymbol $this$isOpen$iv = memberDeclaration;
                    boolean $i$f$isOpen = false;
                    if (!($this$isOpen$iv.getResolvedStatus().getModality() == Modality.OPEN)) break block7;
                    FirCallableSymbol $this$isOverride$iv = memberDeclaration;
                    boolean $i$f$isOverride = false;
                    if (!$this$isOverride$iv.getRawStatus().isOverride() && $declaration.getClassKind() == ClassKind.ANNOTATION_CLASS) break block8;
                }
                FirBasedSymbol firBasedSymbol = memberDeclaration;
                KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OPEN_KEYWORD;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"OPEN_KEYWORD");
                if (!FirKeywordUtilsKt.hasModifier(firBasedSymbol, ktModifierKeywordToken) || !INSTANCE.getShouldReportOpenFromSource(source)) break block9;
            }
            if ($declaration.getClassKind() == ClassKind.OBJECT) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, $reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNON_FINAL_MEMBER_IN_OBJECT(), null, 8, null);
            } else {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, $reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNON_FINAL_MEMBER_IN_FINAL_CLASS(), null, 8, null);
            }
        }
        return Unit.INSTANCE;
    }
}

