/*
 * Decompiled with CFR 0.152.
 */
package com.android.testing.utils;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0010\u001a=\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0016\u001a%\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u0018\u001a\u0016\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0001\u001a\u0010\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0001H\u0002\u001a\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u000b\u001a\u000e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0001\u001a\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0001\u001a\u0010\u0010 \u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001f\u001a\u00020\u0001\u001a\u000e\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u0001\u001a\u0012\u0010#\u001a\u0004\u0018\u00010\u00012\u0006\u0010$\u001a\u00020\u0001H\u0002\u001a\u0015\u0010%\u001a\u0004\u0018\u00010\u000b2\u0006\u0010$\u001a\u00020\u0001\u00a2\u0006\u0002\u0010&\u001a\u0015\u0010'\u001a\u0004\u0018\u00010\u000b2\u0006\u0010$\u001a\u00020\u0001\u00a2\u0006\u0002\u0010&\u001a\u0015\u0010(\u001a\u0004\u0018\u00010\u000b2\u0006\u0010$\u001a\u00020\u0001\u00a2\u0006\u0002\u0010&\u001a\u0010\u0010)\u001a\u0004\u0018\u00010\u00012\u0006\u0010$\u001a\u00020\u0001\u001a\u0010\u0010*\u001a\u0004\u0018\u00010\u00012\u0006\u0010$\u001a\u00020\u0001\u001a\u0010\u0010+\u001a\u0004\u0018\u00010\u00012\u0006\u0010$\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"SYSTEM_IMAGE_PREFIX", "", "API_PREFIX", "MINOR_API_PREFIX", "API_EXTENSION_PREFIX", "PAGE_ALIGNMENT_SUFFIX_FORMAT", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "PAGE_16K_SOURCE_SUFFIX", "API_OFFSET", "", "VENDOR_OFFSET", "ABI_OFFSET", "MIN_MINOR_VERSION_API", "computeSystemImageHashFromDsl", "version", "minorVersion", "extensionVersion", "imageSource", "pageAlignmentSuffix", "abi", "(IILjava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "computeVersionString", "(IILjava/lang/Integer;)Ljava/lang/String;", "computeVendorString", "computeImageSource", "canSourcePerformNdkTranslation", "", "isTvOrAutoSource", "is16kPageSource", "vendorString", "getPageAlignmentSuffix", "isTvOrAutoDevice", "deviceName", "apiComponentFromHash", "systemImageHash", "parseApiFromHash", "(Ljava/lang/String;)Ljava/lang/Integer;", "parseMinorApiFromHash", "parseExtensionFromHash", "parseVendorFromHash", "parseSystemImageSourceFromHash", "parseAbiFromHash", "common"})
public final class SystemImageHashUtilsKt {
    @NotNull
    private static final String SYSTEM_IMAGE_PREFIX = "system-images;";
    @NotNull
    private static final String API_PREFIX = "android-";
    @NotNull
    private static final String MINOR_API_PREFIX = ".";
    @NotNull
    private static final String API_EXTENSION_PREFIX = "-ext";
    private static final Pattern PAGE_ALIGNMENT_SUFFIX_FORMAT = Pattern.compile("_ps[0-9]+k$");
    @NotNull
    private static final String PAGE_16K_SOURCE_SUFFIX = "_ps16k";
    private static final int API_OFFSET = 1;
    private static final int VENDOR_OFFSET = 2;
    private static final int ABI_OFFSET = 3;
    private static final int MIN_MINOR_VERSION_API = 37;

    @NotNull
    public static final String computeSystemImageHashFromDsl(int version, int minorVersion, @Nullable Integer extensionVersion, @NotNull String imageSource, @NotNull String pageAlignmentSuffix, @NotNull String abi) {
        Intrinsics.checkNotNullParameter((Object)imageSource, (String)"imageSource");
        Intrinsics.checkNotNullParameter((Object)pageAlignmentSuffix, (String)"pageAlignmentSuffix");
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        return SYSTEM_IMAGE_PREFIX + SystemImageHashUtilsKt.computeVersionString(version, minorVersion, extensionVersion) + ";" + SystemImageHashUtilsKt.computeVendorString(imageSource, pageAlignmentSuffix) + ";" + abi;
    }

    @NotNull
    public static final String computeVersionString(int version, int minorVersion, @Nullable Integer extensionVersion) {
        Object minorSuffix = minorVersion != 0 || version >= 37 ? MINOR_API_PREFIX + minorVersion : "";
        Object extensionSuffix = extensionVersion != null ? API_EXTENSION_PREFIX + extensionVersion : "";
        return API_PREFIX + version + (String)minorSuffix + (String)extensionSuffix;
    }

    @NotNull
    public static final String computeVendorString(@NotNull String imageSource, @NotNull String pageAlignmentSuffix) {
        Intrinsics.checkNotNullParameter((Object)imageSource, (String)"imageSource");
        Intrinsics.checkNotNullParameter((Object)pageAlignmentSuffix, (String)"pageAlignmentSuffix");
        return SystemImageHashUtilsKt.computeImageSource(imageSource) + pageAlignmentSuffix;
    }

    private static final String computeImageSource(String imageSource) {
        String string;
        switch (imageSource) {
            case "google": {
                string = "google_apis";
                break;
            }
            case "google-atd": {
                string = "google_atd";
                break;
            }
            case "aosp": {
                string = "default";
                break;
            }
            case "aosp-atd": {
                string = "aosp_atd";
                break;
            }
            default: {
                string = imageSource;
            }
        }
        return string;
    }

    public static final boolean canSourcePerformNdkTranslation(@NotNull String imageSource, int version) {
        Intrinsics.checkNotNullParameter((Object)imageSource, (String)"imageSource");
        String string = SystemImageHashUtilsKt.computeImageSource(imageSource);
        return Intrinsics.areEqual((Object)string, (Object)"google_apis") || Intrinsics.areEqual((Object)string, (Object)"google_apis_playstore") ? version >= 30 : false;
    }

    public static final boolean isTvOrAutoSource(@NotNull String imageSource) {
        Intrinsics.checkNotNullParameter((Object)imageSource, (String)"imageSource");
        return StringsKt.contains$default((CharSequence)imageSource, (CharSequence)"-tv", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)imageSource, (CharSequence)"-auto", (boolean)false, (int)2, null);
    }

    public static final boolean is16kPageSource(@NotNull String vendorString) {
        Intrinsics.checkNotNullParameter((Object)vendorString, (String)"vendorString");
        return StringsKt.contains$default((CharSequence)vendorString, (CharSequence)PAGE_16K_SOURCE_SUFFIX, (boolean)false, (int)2, null);
    }

    @Nullable
    public static final String getPageAlignmentSuffix(@NotNull String vendorString) {
        Intrinsics.checkNotNullParameter((Object)vendorString, (String)"vendorString");
        Matcher $this$getPageAlignmentSuffix_u24lambda_u240 = PAGE_ALIGNMENT_SUFFIX_FORMAT.matcher(vendorString);
        boolean bl = false;
        return $this$getPageAlignmentSuffix_u24lambda_u240.find() ? $this$getPageAlignmentSuffix_u24lambda_u240.group() : null;
    }

    public static final boolean isTvOrAutoDevice(@NotNull String deviceName) {
        Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
        return StringsKt.contains$default((CharSequence)deviceName, (CharSequence)"TV", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)deviceName, (CharSequence)"Auto", (boolean)false, (int)2, null);
    }

    private static final String apiComponentFromHash(String systemImageHash) {
        String[] stringArray = new String[]{";"};
        return (String)CollectionsKt.getOrNull((List)StringsKt.split$default((CharSequence)systemImageHash, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (int)1);
    }

    @Nullable
    public static final Integer parseApiFromHash(@NotNull String systemImageHash) {
        Intrinsics.checkNotNullParameter((Object)systemImageHash, (String)"systemImageHash");
        String string = SystemImageHashUtilsKt.apiComponentFromHash(systemImageHash);
        if (string == null) {
            return null;
        }
        String apiComponent = string;
        if (!StringsKt.startsWith$default((String)apiComponent, (String)API_PREFIX, (boolean)false, (int)2, null)) {
            return null;
        }
        return StringsKt.toIntOrNull((String)StringsKt.substringBefore$default((String)StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)apiComponent, (String)API_PREFIX, null, (int)2, null), (String)MINOR_API_PREFIX, null, (int)2, null), (String)API_EXTENSION_PREFIX, null, (int)2, null));
    }

    @Nullable
    public static final Integer parseMinorApiFromHash(@NotNull String systemImageHash) {
        Intrinsics.checkNotNullParameter((Object)systemImageHash, (String)"systemImageHash");
        String string = SystemImageHashUtilsKt.apiComponentFromHash(systemImageHash);
        if (string == null) {
            return null;
        }
        String apiComponent = string;
        if (!StringsKt.startsWith$default((String)apiComponent, (String)API_PREFIX, (boolean)false, (int)2, null)) {
            return null;
        }
        Integer n = StringsKt.toIntOrNull((String)StringsKt.substringBefore$default((String)StringsKt.substringAfter((String)apiComponent, (String)MINOR_API_PREFIX, (String)""), (String)API_EXTENSION_PREFIX, null, (int)2, null));
        return n != null ? n : 0;
    }

    @Nullable
    public static final Integer parseExtensionFromHash(@NotNull String systemImageHash) {
        Intrinsics.checkNotNullParameter((Object)systemImageHash, (String)"systemImageHash");
        String string = SystemImageHashUtilsKt.apiComponentFromHash(systemImageHash);
        if (string == null) {
            return null;
        }
        String apiComponent = string;
        if (!StringsKt.startsWith$default((String)apiComponent, (String)API_PREFIX, (boolean)false, (int)2, null)) {
            return null;
        }
        return StringsKt.toIntOrNull((String)StringsKt.substringAfter((String)apiComponent, (String)API_EXTENSION_PREFIX, (String)""));
    }

    @Nullable
    public static final String parseVendorFromHash(@NotNull String systemImageHash) {
        Intrinsics.checkNotNullParameter((Object)systemImageHash, (String)"systemImageHash");
        String[] stringArray = new String[]{";"};
        return (String)CollectionsKt.getOrNull((List)StringsKt.split$default((CharSequence)systemImageHash, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (int)2);
    }

    @Nullable
    public static final String parseSystemImageSourceFromHash(@NotNull String systemImageHash) {
        Intrinsics.checkNotNullParameter((Object)systemImageHash, (String)"systemImageHash");
        String string = SystemImageHashUtilsKt.parseVendorFromHash(systemImageHash);
        return string != null ? StringsKt.removeSuffix((String)string, (CharSequence)PAGE_16K_SOURCE_SUFFIX) : null;
    }

    @Nullable
    public static final String parseAbiFromHash(@NotNull String systemImageHash) {
        Intrinsics.checkNotNullParameter((Object)systemImageHash, (String)"systemImageHash");
        String[] stringArray = new String[]{";"};
        return (String)CollectionsKt.getOrNull((List)StringsKt.split$default((CharSequence)systemImageHash, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (int)3);
    }
}

