/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.signing;

import com.android.build.api.dsl.SigningConfig;
import com.android.build.api.variant.impl.SigningConfigImpl;
import com.android.build.gradle.internal.dsl.ModulePropertyKey;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.SigningOptions;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0001#B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JO\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u0007J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0003H\u0007J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0003H\u00d6\u0001R\u0015\u0010\b\u001a\u0004\u0018\u00010\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\t\u001a\u0004\u0018\u00010\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0015\u0010\u0007\u001a\u0004\u0018\u00010\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006$"}, d2={"Lcom/android/build/gradle/internal/signing/SigningConfigData;", "Ljava/io/Serializable;", "name", "", "storeType", "storeFile", "Ljava/io/File;", "storePassword", "keyAlias", "keyPassword", "(Ljava/lang/String;Ljava/lang/String;Ljava/io/File;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getKeyAlias", "()Ljava/lang/String;", "getKeyPassword", "getName", "getStoreFile", "()Ljava/io/File;", "getStorePassword", "getStoreType", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "getKeyPasswordHash", "getStorePasswordHash", "hashCode", "", "toString", "Companion", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nSigningConfigData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SigningConfigData.kt\ncom/android/build/gradle/internal/signing/SigningConfigData\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n1#2:149\n*E\n"})
public final class SigningConfigData
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @Nullable
    private final String storeType;
    @Nullable
    private final File storeFile;
    @Nullable
    private final String storePassword;
    @Nullable
    private final String keyAlias;
    @Nullable
    private final String keyPassword;
    private static final long serialVersionUID = 2L;

    public SigningConfigData(@NotNull String name, @Nullable String storeType2, @Nullable File storeFile2, @Nullable String storePassword2, @Nullable String keyAlias2, @Nullable String keyPassword2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.storeType = storeType2;
        this.storeFile = storeFile2;
        this.storePassword = storePassword2;
        this.keyAlias = keyAlias2;
        this.keyPassword = keyPassword2;
    }

    @Input
    @NotNull
    public final String getName() {
        return this.name;
    }

    @Input
    @Optional
    @Nullable
    public final String getStoreType() {
        return this.storeType;
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    @Optional
    @Nullable
    public final File getStoreFile() {
        return this.storeFile;
    }

    @Internal
    @Nullable
    public final String getStorePassword() {
        return this.storePassword;
    }

    @Input
    @Optional
    @Nullable
    public final String getKeyAlias() {
        return this.keyAlias;
    }

    @Internal
    @Nullable
    public final String getKeyPassword() {
        return this.keyPassword;
    }

    @Input
    @Optional
    @Nullable
    public final String getStorePasswordHash() {
        String string;
        String string2 = this.storePassword;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            string = Hashing.sha256().hashUnencodedChars((CharSequence)it).toString();
        } else {
            string = null;
        }
        return string;
    }

    @Input
    @Optional
    @Nullable
    public final String getKeyPasswordHash() {
        String string;
        String string2 = this.keyPassword;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            string = Hashing.sha256().hashUnencodedChars((CharSequence)it).toString();
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @Nullable
    public final String component2() {
        return this.storeType;
    }

    @Nullable
    public final File component3() {
        return this.storeFile;
    }

    @Nullable
    public final String component4() {
        return this.storePassword;
    }

    @Nullable
    public final String component5() {
        return this.keyAlias;
    }

    @Nullable
    public final String component6() {
        return this.keyPassword;
    }

    @NotNull
    public final SigningConfigData copy(@NotNull String name, @Nullable String storeType2, @Nullable File storeFile2, @Nullable String storePassword2, @Nullable String keyAlias2, @Nullable String keyPassword2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new SigningConfigData(name, storeType2, storeFile2, storePassword2, keyAlias2, keyPassword2);
    }

    public static /* synthetic */ SigningConfigData copy$default(SigningConfigData signingConfigData, String string, String string2, File file, String string3, String string4, String string5, int n, Object object) {
        if ((n & 1) != 0) {
            string = signingConfigData.name;
        }
        if ((n & 2) != 0) {
            string2 = signingConfigData.storeType;
        }
        if ((n & 4) != 0) {
            file = signingConfigData.storeFile;
        }
        if ((n & 8) != 0) {
            string3 = signingConfigData.storePassword;
        }
        if ((n & 0x10) != 0) {
            string4 = signingConfigData.keyAlias;
        }
        if ((n & 0x20) != 0) {
            string5 = signingConfigData.keyPassword;
        }
        return signingConfigData.copy(string, string2, file, string3, string4, string5);
    }

    @NotNull
    public String toString() {
        return "SigningConfigData(name=" + this.name + ", storeType=" + this.storeType + ", storeFile=" + this.storeFile + ", storePassword=" + this.storePassword + ", keyAlias=" + this.keyAlias + ", keyPassword=" + this.keyPassword + ")";
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + (this.storeType == null ? 0 : this.storeType.hashCode());
        result2 = result2 * 31 + (this.storeFile == null ? 0 : this.storeFile.hashCode());
        result2 = result2 * 31 + (this.storePassword == null ? 0 : this.storePassword.hashCode());
        result2 = result2 * 31 + (this.keyAlias == null ? 0 : this.keyAlias.hashCode());
        result2 = result2 * 31 + (this.keyPassword == null ? 0 : this.keyPassword.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SigningConfigData)) {
            return false;
        }
        SigningConfigData signingConfigData = (SigningConfigData)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)signingConfigData.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.storeType, (Object)signingConfigData.storeType)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.storeFile, (Object)signingConfigData.storeFile)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.storePassword, (Object)signingConfigData.storePassword)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.keyAlias, (Object)signingConfigData.keyAlias)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.keyPassword, (Object)signingConfigData.keyPassword);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001c\u0010\t\u001a\u0004\u0018\u00010\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u000bJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/signing/SigningConfigData$Companion;", "", "()V", "serialVersionUID", "", "fromDslSigningConfig", "Lcom/android/build/gradle/internal/signing/SigningConfigData;", "signingConfig", "Lcom/android/build/api/dsl/SigningConfig;", "fromExperimentalPropertiesSigningConfig", "experimentalProperties", "Lorg/gradle/api/provider/MapProperty;", "", "fromProjectOptions", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "fromSigningConfig", "Lcom/android/build/api/variant/impl/SigningConfigImpl;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final SigningConfigData fromExperimentalPropertiesSigningConfig(@NotNull MapProperty<String, Object> experimentalProperties) {
            Intrinsics.checkNotNullParameter(experimentalProperties, (String)"experimentalProperties");
            experimentalProperties.finalizeValue();
            Object object = experimentalProperties.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"experimentalProperties.get()");
            if (ModulePropertyKey.OptionalString.ANDROID_PRIVACY_SANDBOX_LOCAL_DEPLOYMENT_SIGNING_STORE_FILE.getValue((Map)object) == null) {
                return null;
            }
            Object object2 = experimentalProperties.get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"experimentalProperties.get()");
            Object object3 = ModulePropertyKey.OptionalString.ANDROID_PRIVACY_SANDBOX_LOCAL_DEPLOYMENT_SIGNING_NAME.getValue((Map)object2);
            if (object3 == null) {
                object3 = "externalOverride";
            }
            Object object4 = experimentalProperties.get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"experimentalProperties.get()");
            Object object5 = ModulePropertyKey.OptionalString.ANDROID_PRIVACY_SANDBOX_LOCAL_DEPLOYMENT_SIGNING_STORE_TYPE.getValue((Map)object4);
            Object object6 = experimentalProperties.get();
            Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"experimentalProperties.get()");
            Object object7 = ModulePropertyKey.OptionalString.ANDROID_PRIVACY_SANDBOX_LOCAL_DEPLOYMENT_SIGNING_STORE_FILE.getValue((Map)object6);
            Intrinsics.checkNotNull((Object)object7);
            File file = new File((String)object7);
            Object object8 = experimentalProperties.get();
            Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"experimentalProperties.get()");
            Object object9 = ModulePropertyKey.OptionalString.ANDROID_PRIVACY_SANDBOX_LOCAL_DEPLOYMENT_SIGNING_STORE_PASSWORD.getValue((Map)object8);
            if (object9 == null) {
                object9 = "android";
            }
            Object object10 = experimentalProperties.get();
            Intrinsics.checkNotNullExpressionValue((Object)object10, (String)"experimentalProperties.get()");
            Object object11 = ModulePropertyKey.OptionalString.ANDROID_PRIVACY_SANDBOX_LOCAL_DEPLOYMENT_SIGNING_KEY_ALIAS.getValue((Map)object10);
            if (object11 == null) {
                object11 = "AndroidDebugKey";
            }
            Object object12 = experimentalProperties.get();
            Intrinsics.checkNotNullExpressionValue((Object)object12, (String)"experimentalProperties.get()");
            Object object13 = ModulePropertyKey.OptionalString.ANDROID_PRIVACY_SANDBOX_LOCAL_DEPLOYMENT_SIGNING_KEY_PASSWORD.getValue((Map)object12);
            if (object13 == null) {
                object13 = "android";
            }
            return new SigningConfigData((String)object3, (String)object5, file, (String)object9, (String)object11, (String)object13);
        }

        @NotNull
        public final SigningConfigData fromSigningConfig(@NotNull SigningConfigImpl signingConfig2) {
            Intrinsics.checkNotNullParameter((Object)signingConfig2, (String)"signingConfig");
            String string = signingConfig2.getName();
            if (string == null) {
                string = "";
            }
            return new SigningConfigData(string, (String)signingConfig2.getStoreType().getOrNull(), (File)signingConfig2.getStoreFile().getOrNull(), (String)signingConfig2.getStorePassword().getOrNull(), (String)signingConfig2.getKeyAlias().getOrNull(), (String)signingConfig2.getKeyPassword().getOrNull());
        }

        @NotNull
        public final SigningConfigData fromDslSigningConfig(@NotNull SigningConfig signingConfig2) {
            Intrinsics.checkNotNullParameter((Object)signingConfig2, (String)"signingConfig");
            return new SigningConfigData("default", signingConfig2.getStoreType(), signingConfig2.getStoreFile(), signingConfig2.getStorePassword(), signingConfig2.getKeyAlias(), signingConfig2.getKeyPassword());
        }

        @Nullable
        public final SigningConfigData fromProjectOptions(@NotNull ProjectOptions projectOptions) {
            SigningConfigData signingConfigData;
            SigningOptions signingOptions;
            Intrinsics.checkNotNullParameter((Object)projectOptions, (String)"projectOptions");
            SigningOptions signingOptions2 = signingOptions = SigningOptions.readSigningOptions(projectOptions);
            if (signingOptions2 != null) {
                SigningOptions it = signingOptions2;
                boolean bl = false;
                signingConfigData = new SigningConfigData("externalOverride", signingOptions.getStoreType(), new File(signingOptions.getStoreFile()), signingOptions.getStorePassword(), signingOptions.getKeyAlias(), signingOptions.getKeyPassword());
            } else {
                signingConfigData = null;
            }
            return signingConfigData;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

