/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.errors;

import com.android.build.gradle.internal.errors.MessageReceiverImplKt;
import com.android.build.gradle.options.SyncOptions;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageJsonSerializer;
import com.android.ide.common.blame.MessageReceiver;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/errors/MessageReceiverImpl;", "Lcom/android/ide/common/blame/MessageReceiver;", "errorFormatMode", "Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;", "logger", "Lorg/slf4j/Logger;", "(Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;Lorg/slf4j/Logger;)V", "mGson", "Lcom/google/gson/Gson;", "machineReadableMessage", "", "message", "Lcom/android/ide/common/blame/Message;", "messageToString", "receiveMessage", "", "gradle-core"})
public final class MessageReceiverImpl
implements MessageReceiver {
    @NotNull
    private final SyncOptions.ErrorFormatMode errorFormatMode;
    @NotNull
    private final Logger logger;
    @Nullable
    private final Gson mGson;

    public MessageReceiverImpl(@NotNull SyncOptions.ErrorFormatMode errorFormatMode, @NotNull Logger logger) {
        Gson gson2;
        Intrinsics.checkNotNullParameter((Object)((Object)errorFormatMode), (String)"errorFormatMode");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.errorFormatMode = errorFormatMode;
        this.logger = logger;
        if (this.errorFormatMode == SyncOptions.ErrorFormatMode.MACHINE_PARSABLE) {
            GsonBuilder gsonBuilder = new GsonBuilder().disableHtmlEscaping();
            MessageJsonSerializer.registerTypeAdapters((GsonBuilder)gsonBuilder);
            gson2 = gsonBuilder.create();
        } else {
            gson2 = null;
        }
        this.mGson = gson2;
    }

    public void receiveMessage(@NotNull Message message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        switch (WhenMappings.$EnumSwitchMapping$0[message2.getKind().ordinal()]) {
            case 1: {
                this.logger.error(this.messageToString(message2, this.errorFormatMode));
                break;
            }
            case 2: {
                this.logger.warn(this.messageToString(message2, this.errorFormatMode));
                break;
            }
            case 3: {
                this.logger.info(MessageReceiverImplKt.humanReadableMessage(message2));
                break;
            }
            case 4: {
                this.logger.trace(MessageReceiverImplKt.humanReadableMessage(message2));
                break;
            }
            case 5: {
                this.logger.warn(MessageReceiverImplKt.humanReadableMessage(message2));
                break;
            }
            case 6: {
                this.logger.warn(MessageReceiverImplKt.humanReadableMessage(message2));
            }
        }
    }

    private final String messageToString(Message message2, SyncOptions.ErrorFormatMode errorFormatMode) {
        return errorFormatMode == SyncOptions.ErrorFormatMode.MACHINE_PARSABLE ? this.machineReadableMessage(message2) : MessageReceiverImplKt.humanReadableMessage(message2);
    }

    private final String machineReadableMessage(Message message2) {
        Gson gson2 = this.mGson;
        Intrinsics.checkNotNull((Object)gson2);
        return "AGPBI: " + gson2.toJson((Object)message2);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Message.Kind.values().length];
            try {
                nArray[Message.Kind.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Message.Kind.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Message.Kind.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Message.Kind.STATISTICS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Message.Kind.UNKNOWN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Message.Kind.SIMPLE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

