/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.api.dsl.ApkSigningConfig;
import com.android.build.gradle.internal.dsl.InternalSigningConfig;
import com.android.build.gradle.internal.dsl.decorator.annotation.WithLazyInitialization;
import com.android.build.gradle.internal.services.DslServices;
import com.android.builder.signing.DefaultSigningConfig;
import com.google.common.base.MoreObjects;
import java.io.File;
import java.io.Serializable;
import java.security.KeyStore;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Named;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005B\u0017\b\u0007\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0001J\u0012\u0010\u000f\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\u0010\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0016J\u0006\u0010\u0011\u001a\u00020\fJ\u0012\u0010\u0012\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\u0015\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\u0016\u001a\u00020\u0007H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/dsl/SigningConfig;", "Lcom/android/builder/signing/DefaultSigningConfig;", "Ljava/io/Serializable;", "Lorg/gradle/api/Named;", "Lcom/android/build/api/dsl/ApkSigningConfig;", "Lcom/android/build/gradle/internal/dsl/InternalSigningConfig;", "name", "", "dslServices", "Lcom/android/build/gradle/internal/services/DslServices;", "(Ljava/lang/String;Lcom/android/build/gradle/internal/services/DslServices;)V", "initWith", "", "that", "Lcom/android/build/api/dsl/SigningConfig;", "keyAlias", "keyPassword", "lazyInit", "storeFile", "Ljava/io/File;", "storePassword", "storeType", "toString", "gradle-core"})
public abstract class SigningConfig
extends DefaultSigningConfig
implements Serializable,
Named,
ApkSigningConfig,
InternalSigningConfig {
    @Inject
    @WithLazyInitialization(methodName="lazyInit")
    public SigningConfig(@NotNull String name, @NotNull DslServices dslServices2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)dslServices2, (String)"dslServices");
        super(name);
    }

    public final void lazyInit() {
        this.setStoreType(KeyStore.getDefaultType());
    }

    public void initWith(@NotNull com.android.build.api.dsl.SigningConfig that) {
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        if (!(that instanceof SigningConfig)) {
            throw new RuntimeException("Unexpected implementation type");
        }
        this.initWith((DefaultSigningConfig)that);
    }

    @NotNull
    public final SigningConfig initWith(@NotNull SigningConfig that) {
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        return this.initWith((DefaultSigningConfig)that);
    }

    @NotNull
    public final SigningConfig initWith(@NotNull DefaultSigningConfig that) {
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        this.setStoreFile(that.getStoreFile());
        this.setStorePassword(that.getStorePassword());
        this.setKeyAlias(that.getKeyAlias());
        this.setKeyPassword(that.getKeyPassword());
        this.setV1SigningEnabled(that.isV1SigningEnabled());
        this.setV2SigningEnabled(that.isV2SigningEnabled());
        this.setEnableV1Signing(that.getEnableV1Signing());
        this.setEnableV2Signing(that.getEnableV2Signing());
        this.setEnableV3Signing(that.getEnableV3Signing());
        this.setEnableV4Signing(that.getEnableV4Signing());
        this.setStoreType(that.getStoreType());
        return this;
    }

    @NotNull
    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName());
        File file = this.getStoreFile();
        String string = file != null ? file.getAbsolutePath() : null;
        if (string == null) {
            string = "null";
        }
        String string2 = toStringHelper.add("storeFile", (Object)string).add("storePassword", (Object)this.getStorePassword()).add("keyAlias", (Object)this.getKeyAlias()).add("keyPassword", (Object)this.getKeyPassword()).add("storeType", (Object)this.getStoreType()).add("v1SigningEnabled", this.isV1SigningEnabled()).add("v2SigningEnabled", this.isV2SigningEnabled()).add("enableV1Signing", (Object)this.getEnableV1Signing()).add("enableV2Signing", (Object)this.getEnableV2Signing()).add("enableV3Signing", (Object)this.getEnableV3Signing()).add("enableV4Signing", (Object)this.getEnableV4Signing()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toStringHelper(this)\n   \u2026)\n            .toString()");
        return string2;
    }

    public void storeFile(@Nullable File storeFile2) {
        this.setStoreFile(storeFile2);
    }

    public void storePassword(@Nullable String storePassword2) {
        this.setStorePassword(storePassword2);
    }

    public void keyAlias(@Nullable String keyAlias2) {
        this.setKeyAlias(keyAlias2);
    }

    public void keyPassword(@Nullable String keyPassword2) {
        this.setKeyPassword(keyPassword2);
    }

    public void storeType(@Nullable String storeType2) {
        this.setStoreType(storeType2);
    }
}

