/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.variant.FilterConfiguration;
import com.android.build.api.variant.impl.BuiltArtifactsImpl;
import com.android.build.api.variant.impl.BuiltArtifactsLoaderImpl;
import com.android.build.gradle.internal.component.HostTestCreationConfig;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.tasks.GenerateTestConfig;
import com.android.buildanalyzer.common.TaskCategory;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.TEST, secondaryTaskCategories={TaskCategory.METADATA})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\b'\u0018\u0000 \u001a2\u00020\u0001:\u0006\u0015\u0016\u0017\u0018\u0019\u001aB\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0013\u001a\u00020\u0014H\u0014R \u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u00020\u00108G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lcom/android/build/gradle/tasks/GenerateTestConfig;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "<init>", "(Lorg/gradle/api/model/ObjectFactory;)V", "value", "Lcom/android/build/gradle/tasks/GenerateTestConfig$TestConfigInputs;", "testConfigInputs", "getTestConfigInputs", "()Lcom/android/build/gradle/tasks/GenerateTestConfig$TestConfigInputs;", "projectDir", "Lorg/gradle/api/file/RegularFileProperty;", "getProjectDir", "()Lorg/gradle/api/file/RegularFileProperty;", "outputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "doTaskAction", "", "GenerateTestConfigRunnable", "GenerateTestConfigParams", "CreationAction", "TestConfigInputs", "TestConfigProperties", "Companion", "gradle-core"})
public abstract class GenerateTestConfig
extends NonIncrementalTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private TestConfigInputs testConfigInputs;
    @NotNull
    private final DirectoryProperty outputDirectory;
    @NotNull
    private static final String TEST_CONFIG_FILE = "com/android/tools/test_config.properties";
    @NotNull
    private static final String ANDROID_RESOURCE_APK = "android_resource_apk";
    @NotNull
    private static final String ANDROID_MERGED_ASSETS = "android_merged_assets";
    @NotNull
    private static final String ANDROID_MERGED_MANIFEST = "android_merged_manifest";
    @NotNull
    private static final String ANDROID_CUSTOM_PACKAGE = "android_custom_package";
    @NotNull
    private static final String COMMENT_GENERATED_BY_AGP = "Generated by the Android Gradle plugin";

    @Inject
    public GenerateTestConfig(@NotNull ObjectFactory objectFactory) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        DirectoryProperty directoryProperty = objectFactory.directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"directoryProperty(...)");
        this.outputDirectory = directoryProperty;
    }

    @Nested
    @NotNull
    public final TestConfigInputs getTestConfigInputs() {
        TestConfigInputs testConfigInputs = this.testConfigInputs;
        if (testConfigInputs != null) {
            return testConfigInputs;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"testConfigInputs");
        return null;
    }

    @Internal(value="only for task execution")
    @NotNull
    public abstract RegularFileProperty getProjectDir();

    @OutputDirectory
    @NotNull
    public final DirectoryProperty getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    protected void doTaskAction() {
        this.getWorkerExecutor().noIsolation().submit(GenerateTestConfigRunnable.class, new Action(this){
            final /* synthetic */ GenerateTestConfig this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(GenerateTestConfigParams it) {
                it.initializeFromBaseTask(this.this$0);
                Property<TestConfigProperties> property = it.getTestConfigProperties();
                TestConfigInputs testConfigInputs = this.this$0.getTestConfigInputs();
                File file = ((RegularFile)this.this$0.getProjectDir().get()).getAsFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
                property.set((Object)testConfigInputs.computeProperties(file));
                it.getOutputDirectory().set((Provider)this.this$0.getOutputDirectory());
            }
        });
    }

    @JvmStatic
    @VisibleForTesting
    public static final void generateTestConfigFile(@NotNull TestConfigProperties config2, @NotNull Path outputDir) throws IOException {
        Companion.generateTestConfigFile(config2, outputDir);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/tasks/GenerateTestConfig$Companion;", "", "<init>", "()V", "TEST_CONFIG_FILE", "", "ANDROID_RESOURCE_APK", "ANDROID_MERGED_ASSETS", "ANDROID_MERGED_MANIFEST", "ANDROID_CUSTOM_PACKAGE", "COMMENT_GENERATED_BY_AGP", "generateTestConfigFile", "", "config", "Lcom/android/build/gradle/tasks/GenerateTestConfig$TestConfigProperties;", "outputDir", "Ljava/nio/file/Path;", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nGenerateTestConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateTestConfig.kt\ncom/android/build/gradle/tasks/GenerateTestConfig$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,237:1\n774#2:238\n865#2,2:239\n774#2:241\n865#2,2:242\n*S KotlinDebug\n*F\n+ 1 GenerateTestConfig.kt\ncom/android/build/gradle/tasks/GenerateTestConfig$Companion\n*L\n226#1:238\n226#1:239,2\n228#1:241\n228#1:242,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @JvmStatic
        @VisibleForTesting
        public final void generateTestConfigFile(@NotNull TestConfigProperties config2, @NotNull Path outputDir) throws IOException {
            void $this$filterTo$iv$iv;
            void $this$filterTo$iv$iv2;
            Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
            Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
            Properties properties = new Properties();
            properties.setProperty(GenerateTestConfig.ANDROID_RESOURCE_APK, config2.getResourceApkFile());
            properties.setProperty(GenerateTestConfig.ANDROID_MERGED_ASSETS, config2.getMergedAssetsDir());
            properties.setProperty(GenerateTestConfig.ANDROID_MERGED_MANIFEST, config2.getMergedManifestDir());
            properties.setProperty(GenerateTestConfig.ANDROID_CUSTOM_PACKAGE, config2.getCustomPackage());
            StringWriter stringWriter = new StringWriter();
            Closeable closeable = stringWriter;
            Throwable throwable = null;
            try {
                StringWriter it = (StringWriter)closeable;
                boolean bl = false;
                properties.store(it, GenerateTestConfig.COMMENT_GENERATED_BY_AGP);
                it = Unit.INSTANCE;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            String string = stringWriter.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            Iterable $this$filter$iv = StringsKt.lines((CharSequence)string);
            boolean $i$f$filter = false;
            Iterable bl = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (!(!(((CharSequence)it).length() == 0))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List lines = (List)destination$iv$iv;
            Iterable $this$filter$iv2 = lines;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl3 = false;
                if (!(!StringsKt.startsWith$default((String)it, (String)"#", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)it, (CharSequence)GenerateTestConfig.COMMENT_GENERATED_BY_AGP, (boolean)false, (int)2, null))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List linesWithoutTimestamp = (List)destination$iv$iv2;
            String string2 = outputDir.getFileSystem().getSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSeparator(...)");
            Path testConfigFile = outputDir.resolve(StringsKt.replace$default((String)GenerateTestConfig.TEST_CONFIG_FILE, (String)"/", (String)string2, (boolean)false, (int)4, null));
            Files.createDirectories(testConfigFile.getParent(), new FileAttribute[0]);
            Files.write(testConfigFile, (Iterable<? extends CharSequence>)linesWithoutTimestamp, new OpenOption[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/tasks/GenerateTestConfig$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/tasks/GenerateTestConfig;", "Lcom/android/build/gradle/internal/component/HostTestCreationConfig;", "unitTestCreationConfig", "<init>", "(Lcom/android/build/gradle/internal/component/HostTestCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "handleProvider", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "configure", "task", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<GenerateTestConfig, HostTestCreationConfig> {
        @NotNull
        private final HostTestCreationConfig unitTestCreationConfig;

        public CreationAction(@NotNull HostTestCreationConfig unitTestCreationConfig) {
            Intrinsics.checkNotNullParameter((Object)unitTestCreationConfig, (String)"unitTestCreationConfig");
            super(unitTestCreationConfig, false, 2, null);
            this.unitTestCreationConfig = unitTestCreationConfig;
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("generate", "Config");
        }

        @Override
        @NotNull
        public Class<GenerateTestConfig> getType() {
            return GenerateTestConfig.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<GenerateTestConfig> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((HostTestCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("out").on(InternalArtifactType.UNIT_TEST_CONFIG_DIRECTORY.INSTANCE);
        }

        @Override
        public void configure(@NotNull GenerateTestConfig task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            task.testConfigInputs = new TestConfigInputs(this.unitTestCreationConfig);
            task.getProjectDir().set(task.getProject().getProjectDir());
            task.getProjectDir().disallowChanges();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/tasks/GenerateTestConfig$GenerateTestConfigParams;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "<init>", "()V", "testConfigProperties", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/tasks/GenerateTestConfig$TestConfigProperties;", "getTestConfigProperties", "()Lorg/gradle/api/provider/Property;", "outputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "gradle-core"})
    public static abstract class GenerateTestConfigParams
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract Property<TestConfigProperties> getTestConfigProperties();

        @NotNull
        public abstract DirectoryProperty getOutputDirectory();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/tasks/GenerateTestConfig$GenerateTestConfigRunnable;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/tasks/GenerateTestConfig$GenerateTestConfigParams;", "<init>", "()V", "run", "", "gradle-core"})
    public static abstract class GenerateTestConfigRunnable
    extends ProfileAwareWorkAction<GenerateTestConfigParams> {
        @Override
        public void run() {
            Object object = ((GenerateTestConfigParams)this.getParameters()).getTestConfigProperties().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            TestConfigProperties testConfigProperties = (TestConfigProperties)object;
            Path path = ((Directory)((GenerateTestConfigParams)this.getParameters()).getOutputDirectory().get()).getAsFile().toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            Companion.generateTestConfigFile(testConfigProperties, path);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eR\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078G\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00078G\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0019\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u00078G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\nR\u0013\u0010\u0010\u001a\u00020\u00118G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0019\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00078G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\nR\u001b\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00178G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001f"}, d2={"Lcom/android/build/gradle/tasks/GenerateTestConfig$TestConfigInputs;", "", "creationConfig", "Lcom/android/build/gradle/internal/component/HostTestCreationConfig;", "<init>", "(Lcom/android/build/gradle/internal/component/HostTestCreationConfig;)V", "resourceApk", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "getResourceApk", "()Lorg/gradle/api/provider/Provider;", "mergedAssets", "Lorg/gradle/api/file/Directory;", "getMergedAssets", "mergedManifest", "getMergedManifest", "buildDirectoryPath", "", "getBuildDirectoryPath", "()Ljava/lang/String;", "packageNameOfFinalRClass", "getPackageNameOfFinalRClass", "targetConfiguration", "", "Lcom/android/build/api/variant/FilterConfiguration;", "getTargetConfiguration", "()Ljava/util/Collection;", "computeProperties", "Lcom/android/build/gradle/tasks/GenerateTestConfig$TestConfigProperties;", "projectDir", "Ljava/io/File;", "gradle-core"})
    public static final class TestConfigInputs {
        @NotNull
        private final Provider<RegularFile> resourceApk;
        @NotNull
        private final Provider<Directory> mergedAssets;
        @NotNull
        private final Provider<Directory> mergedManifest;
        @NotNull
        private final String buildDirectoryPath;
        @NotNull
        private final Provider<String> packageNameOfFinalRClass;
        @Nullable
        private final Collection<FilterConfiguration> targetConfiguration;

        public TestConfigInputs(@NotNull HostTestCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            this.resourceApk = creationConfig.getArtifacts().get(InternalArtifactType.APK_FOR_LOCAL_TEST.INSTANCE);
            this.mergedAssets = creationConfig.getArtifacts().get((SingleArtifact)SingleArtifact.ASSETS.INSTANCE);
            this.targetConfiguration = creationConfig.getPaths().getTargetFilterConfigurations();
            this.mergedManifest = creationConfig.getMainVariant().getComponentType().isApk() ? creationConfig.getMainVariant().getArtifacts().get(InternalArtifactType.PACKAGED_MANIFESTS.INSTANCE) : creationConfig.getArtifacts().get(InternalArtifactType.PACKAGED_MANIFESTS.INSTANCE);
            this.packageNameOfFinalRClass = creationConfig.getMainVariant().getNamespace();
            File file = ((Directory)creationConfig.getServices().getProjectInfo().getBuildDirectory().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
            File file2 = creationConfig.getServices().getProjectInfo().getProjectDirectory().getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAsFile(...)");
            this.buildDirectoryPath = FilesKt.toRelativeString((File)file, (File)file2);
        }

        @InputFiles
        @PathSensitive(value=PathSensitivity.RELATIVE)
        @NotNull
        public final Provider<RegularFile> getResourceApk() {
            return this.resourceApk;
        }

        @InputFiles
        @PathSensitive(value=PathSensitivity.RELATIVE)
        @NotNull
        public final Provider<Directory> getMergedAssets() {
            return this.mergedAssets;
        }

        @InputFiles
        @PathSensitive(value=PathSensitivity.RELATIVE)
        @NotNull
        public final Provider<Directory> getMergedManifest() {
            return this.mergedManifest;
        }

        @Input
        @NotNull
        public final String getBuildDirectoryPath() {
            return this.buildDirectoryPath;
        }

        @Input
        @NotNull
        public final Provider<String> getPackageNameOfFinalRClass() {
            return this.packageNameOfFinalRClass;
        }

        @Optional
        @Input
        @Nullable
        public final Collection<FilterConfiguration> getTargetConfiguration() {
            return this.targetConfiguration;
        }

        @NotNull
        public final TestConfigProperties computeProperties(@NotNull File projectDir2) {
            Intrinsics.checkNotNullParameter((Object)projectDir2, (String)"projectDir");
            BuiltArtifactsImpl builtArtifactsImpl = new BuiltArtifactsLoaderImpl().load(this.mergedManifest);
            if (builtArtifactsImpl == null) {
                throw new IllegalStateException("Unable to find manifest output".toString());
            }
            BuiltArtifactsImpl manifestsOutputs = builtArtifactsImpl;
            String manifestFile = manifestsOutputs.getMainSplit(this.targetConfiguration).getOutputFile();
            File file = ((RegularFile)this.resourceApk.get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
            String string = FilesKt.relativeTo((File)file, (File)projectDir2).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            File file2 = ((Directory)this.mergedAssets.get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAsFile(...)");
            String string2 = FilesKt.relativeTo((File)file2, (File)projectDir2).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String string3 = FilesKt.relativeTo((File)new File(manifestFile), (File)projectDir2).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            Object object = this.packageNameOfFinalRClass.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return new TestConfigProperties(string, string2, string3, (String)object);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/android/build/gradle/tasks/GenerateTestConfig$TestConfigProperties;", "Ljava/io/Serializable;", "resourceApkFile", "", "mergedAssetsDir", "mergedManifestDir", "customPackage", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getResourceApkFile", "()Ljava/lang/String;", "getMergedAssetsDir", "getMergedManifestDir", "getCustomPackage", "gradle-core"})
    public static final class TestConfigProperties
    implements Serializable {
        @NotNull
        private final String resourceApkFile;
        @NotNull
        private final String mergedAssetsDir;
        @NotNull
        private final String mergedManifestDir;
        @NotNull
        private final String customPackage;

        public TestConfigProperties(@NotNull String resourceApkFile, @NotNull String mergedAssetsDir, @NotNull String mergedManifestDir, @NotNull String customPackage) {
            Intrinsics.checkNotNullParameter((Object)resourceApkFile, (String)"resourceApkFile");
            Intrinsics.checkNotNullParameter((Object)mergedAssetsDir, (String)"mergedAssetsDir");
            Intrinsics.checkNotNullParameter((Object)mergedManifestDir, (String)"mergedManifestDir");
            Intrinsics.checkNotNullParameter((Object)customPackage, (String)"customPackage");
            this.resourceApkFile = resourceApkFile;
            this.mergedAssetsDir = mergedAssetsDir;
            this.mergedManifestDir = mergedManifestDir;
            this.customPackage = customPackage;
        }

        @NotNull
        public final String getResourceApkFile() {
            return this.resourceApkFile;
        }

        @NotNull
        public final String getMergedAssetsDir() {
            return this.mergedAssetsDir;
        }

        @NotNull
        public final String getMergedManifestDir() {
            return this.mergedManifestDir;
        }

        @NotNull
        public final String getCustomPackage() {
            return this.customPackage;
        }
    }
}

