/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactTransformationRequest;
import com.android.build.api.artifact.InAndOutDirectoryOperationRequest;
import com.android.build.api.artifact.impl.InAndOutDirectoryOperationRequestImpl;
import com.android.build.api.variant.BuiltArtifact;
import com.android.build.api.variant.MultiOutputHandler;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.features.AndroidResourcesCreationConfig;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.Aapt2Daemon;
import com.android.build.gradle.internal.services.Aapt2Input;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.OptimizeResourcesTask;
import com.android.build.gradle.internal.tasks.OptimizeResourcesTaskKt;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.tasks.factory.features.AndroidResourcesTaskCreationAction;
import com.android.build.gradle.internal.tasks.factory.features.AndroidResourcesTaskCreationActionImpl;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.internal.workeractions.DecoratedWorkParameters;
import com.android.build.gradle.internal.workeractions.WorkActionAdapter;
import com.android.buildanalyzer.common.TaskCategory;
import java.io.File;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.workers.WorkQueue;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@BuildAnalyzer(primaryTaskCategory=TaskCategory.OPTIMIZATION, secondaryTaskCategories={TaskCategory.ANDROID_RESOURCES})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001:\u0003\u001b\u001c\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0019\u001a\u00020\u001aH\u0014R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000\u00120\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0010R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010R\u0014\u0010\u0017\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lcom/android/build/gradle/internal/tasks/OptimizeResourcesTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "<init>", "()V", "inputProcessedRes", "Lorg/gradle/api/file/DirectoryProperty;", "getInputProcessedRes", "()Lorg/gradle/api/file/DirectoryProperty;", "aapt2", "Lcom/android/build/gradle/internal/services/Aapt2Input;", "getAapt2", "()Lcom/android/build/gradle/internal/services/Aapt2Input;", "enableResourceObfuscation", "Lorg/gradle/api/provider/Property;", "", "getEnableResourceObfuscation", "()Lorg/gradle/api/provider/Property;", "transformationRequest", "Lcom/android/build/api/artifact/ArtifactTransformationRequest;", "getTransformationRequest", "outputsHandler", "Lcom/android/build/api/variant/MultiOutputHandler;", "getOutputsHandler", "optimizedProcessedRes", "getOptimizedProcessedRes", "doTaskAction", "", "OptimizeResourcesParams", "Aapt2OptimizeWorkAction", "CreateAction", "gradle-core"})
public abstract class OptimizeResourcesTask
extends NonIncrementalTask {
    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract DirectoryProperty getInputProcessedRes();

    @Nested
    @NotNull
    public abstract Aapt2Input getAapt2();

    @Input
    @NotNull
    public abstract Property<Boolean> getEnableResourceObfuscation();

    @Internal
    @NotNull
    public abstract Property<ArtifactTransformationRequest<OptimizeResourcesTask>> getTransformationRequest();

    @Nested
    @NotNull
    public abstract Property<MultiOutputHandler> getOutputsHandler();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOptimizedProcessedRes();

    @Override
    protected void doTaskAction() {
        ArtifactTransformationRequest artifactTransformationRequest = (ArtifactTransformationRequest)this.getTransformationRequest().get();
        Task task = (Task)this;
        WorkQueue workQueue2 = this.getWorkerExecutor().noIsolation();
        Intrinsics.checkNotNullExpressionValue((Object)workQueue2, (String)"noIsolation(...)");
        artifactTransformationRequest.submit(task, workQueue2, Aapt2OptimizeWorkAction.class, (Function3)new Function3<BuiltArtifact, Directory, OptimizeResourcesParams, File>(this){
            final /* synthetic */ OptimizeResourcesTask this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final File invoke(BuiltArtifact builtArtifact, Directory outputLocation, OptimizeResourcesParams parameters) {
                Intrinsics.checkNotNullParameter((Object)builtArtifact, (String)"builtArtifact");
                Intrinsics.checkNotNullParameter((Object)outputLocation, (String)"outputLocation");
                Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                parameters.getInputResFile().set(new File(builtArtifact.getOutputFile()));
                parameters.getAapt2Executable().set(Aapt2Daemon.getAapt2Executable(this.this$0.getAapt2()).toFile());
                parameters.getEnableResourceObfuscation().set(this.this$0.getEnableResourceObfuscation().get());
                parameters.getOutputResFile().set(new File(outputLocation.getAsFile(), ((MultiOutputHandler)this.this$0.getOutputsHandler().get()).getOutputNameForSplit("resources", "optimize.ap_", builtArtifact.getOutputType(), builtArtifact.getFilters())));
                File file = ((RegularFile)parameters.getOutputResFile().get()).getAsFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
                return file;
            }
        });
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/internal/tasks/OptimizeResourcesTask$Aapt2OptimizeWorkAction;", "Lcom/android/build/gradle/internal/workeractions/WorkActionAdapter;", "Lcom/android/build/gradle/internal/tasks/OptimizeResourcesTask$OptimizeResourcesParams;", "params", "<init>", "(Lcom/android/build/gradle/internal/tasks/OptimizeResourcesTask$OptimizeResourcesParams;)V", "doExecute", "", "gradle-core"})
    public static abstract class Aapt2OptimizeWorkAction
    implements WorkActionAdapter<OptimizeResourcesParams> {
        @NotNull
        private final OptimizeResourcesParams params;

        @Inject
        public Aapt2OptimizeWorkAction(@NotNull OptimizeResourcesParams params) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            this.params = params;
        }

        @Override
        public void doExecute() {
            OptimizeResourcesTaskKt.doFullTaskAction(this.params);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0002H\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u00020\u0019X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/internal/tasks/OptimizeResourcesTask$CreateAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/OptimizeResourcesTask;", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "Lcom/android/build/gradle/internal/tasks/factory/features/AndroidResourcesTaskCreationAction;", "creationConfig", "<init>", "(Lcom/android/build/gradle/internal/component/ApkCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "transformationRequest", "Lcom/android/build/api/artifact/ArtifactTransformationRequest;", "handleProvider", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "configure", "task", "androidResourcesCreationConfig", "Lcom/android/build/gradle/internal/component/features/AndroidResourcesCreationConfig;", "getAndroidResourcesCreationConfig", "()Lcom/android/build/gradle/internal/component/features/AndroidResourcesCreationConfig;", "gradle-core"})
    public static final class CreateAction
    extends VariantTaskCreationAction<OptimizeResourcesTask, ApkCreationConfig>
    implements AndroidResourcesTaskCreationAction {
        private final /* synthetic */ AndroidResourcesTaskCreationActionImpl $$delegate_0;
        private ArtifactTransformationRequest<OptimizeResourcesTask> transformationRequest;

        public CreateAction(@NotNull ApkCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig, false, 2, null);
            this.$$delegate_0 = new AndroidResourcesTaskCreationActionImpl(creationConfig);
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("optimize", "Resources");
        }

        @Override
        @NotNull
        public Class<OptimizeResourcesTask> getType() {
            return OptimizeResourcesTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<OptimizeResourcesTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            boolean resourceShrinkingEnabled = this.getAndroidResourcesCreationConfig().getUseResourceShrinker();
            InAndOutDirectoryOperationRequest operationRequest2 = ((ApkCreationConfig)this.creationConfig).getArtifacts().use((TaskProvider)taskProvider).wiredWithDirectories((Function1)handleProvider.operationRequest.1.INSTANCE, (Function1)handleProvider.operationRequest.2.INSTANCE);
            this.transformationRequest = resourceShrinkingEnabled ? (ArtifactTransformationRequest)InAndOutDirectoryOperationRequestImpl.toTransformMany$gradle_core$default((InAndOutDirectoryOperationRequestImpl)operationRequest2, InternalArtifactType.SHRUNK_RESOURCES_BINARY_FORMAT.INSTANCE, InternalArtifactType.OPTIMIZED_PROCESSED_RES.INSTANCE, null, null, 12, null) : (ArtifactTransformationRequest)InAndOutDirectoryOperationRequestImpl.toTransformMany$gradle_core$default((InAndOutDirectoryOperationRequestImpl)operationRequest2, InternalArtifactType.LINKED_RESOURCES_BINARY_FORMAT.INSTANCE, InternalArtifactType.OPTIMIZED_PROCESSED_RES.INSTANCE, null, null, 12, null);
        }

        @Override
        public void configure(@NotNull OptimizeResourcesTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            ((ApkCreationConfig)this.creationConfig).getServices().initializeAapt2Input(task.getAapt2(), (Task)task);
            HasConfigurableValuesKt.setDisallowChanges(task.getEnableResourceObfuscation(), false);
            Property<ArtifactTransformationRequest<OptimizeResourcesTask>> property = task.getTransformationRequest();
            ArtifactTransformationRequest<OptimizeResourcesTask> artifactTransformationRequest = this.transformationRequest;
            if (artifactTransformationRequest == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"transformationRequest");
                artifactTransformationRequest = null;
            }
            HasConfigurableValuesKt.setDisallowChanges(property, artifactTransformationRequest);
            HasConfigurableValuesKt.setDisallowChanges(task.getOutputsHandler(), MultiOutputHandler.Companion.create(this.creationConfig));
        }

        @Override
        @NotNull
        public AndroidResourcesCreationConfig getAndroidResourcesCreationConfig() {
            return this.$$delegate_0.getAndroidResourcesCreationConfig();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0005\u00a8\u0006\u000f\u00c0\u0006\u0003"}, d2={"Lcom/android/build/gradle/internal/tasks/OptimizeResourcesTask$OptimizeResourcesParams;", "Lcom/android/build/gradle/internal/workeractions/DecoratedWorkParameters;", "aapt2Executable", "Lorg/gradle/api/file/RegularFileProperty;", "getAapt2Executable", "()Lorg/gradle/api/file/RegularFileProperty;", "inputResFile", "getInputResFile", "enableResourceObfuscation", "Lorg/gradle/api/provider/Property;", "", "getEnableResourceObfuscation", "()Lorg/gradle/api/provider/Property;", "outputResFile", "getOutputResFile", "gradle-core"})
    public static interface OptimizeResourcesParams
    extends DecoratedWorkParameters {
        @NotNull
        public RegularFileProperty getAapt2Executable();

        @NotNull
        public RegularFileProperty getInputResFile();

        @NotNull
        public Property<Boolean> getEnableResourceObfuscation();

        @NotNull
        public RegularFileProperty getOutputResFile();
    }
}

