/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.artifact.impl.SingleInitialProviderRequestImpl;
import com.android.build.api.dsl.SigningConfig;
import com.android.build.api.variant.impl.BundleConfigImpl;
import com.android.build.api.variant.impl.CodeTransparencyImpl;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.scope.ArtifactTypeUtil;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.ProjectServices;
import com.android.build.gradle.internal.signing.SigningConfigData;
import com.android.build.gradle.internal.signing.SigningConfigDataProvider;
import com.android.build.gradle.internal.signing.SigningConfigProviderParams;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.BundleTaskUtil;
import com.android.build.gradle.internal.tasks.FinalizeBundleTask;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.AndroidVariantTaskCreationAction;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.options.StringOption;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.builder.internal.packaging.AabFlinger;
import com.android.ide.common.signing.CertificateInfo;
import com.android.ide.common.signing.KeystoreHelper;
import com.android.tools.build.bundletool.commands.AddTransparencyCommand;
import com.android.utils.FileUtils;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.PrivateKey;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.BUNDLE_PACKAGING)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\b'\u0018\u00002\u00020\u0001:\u0004\u001e\u001f !B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u001c\u001a\u00020\u001dH\u0014R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R$\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t8G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR$\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\b\u001a\u0004\u0018\u00010\r8G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\u00020\u00168G\u00a2\u0006\f\u0012\u0004\b\u0017\u0010\u0003\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0007\u00a8\u0006\""}, d2={"Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "<init>", "()V", "intermediaryBundleFile", "Lorg/gradle/api/file/RegularFileProperty;", "getIntermediaryBundleFile", "()Lorg/gradle/api/file/RegularFileProperty;", "value", "Lcom/android/build/gradle/internal/signing/SigningConfigDataProvider;", "signingConfigData", "getSigningConfigData", "()Lcom/android/build/gradle/internal/signing/SigningConfigDataProvider;", "Lcom/android/build/gradle/internal/signing/SigningConfigData;", "codeTransparencySigningConfigData", "getCodeTransparencySigningConfigData", "()Lcom/android/build/gradle/internal/signing/SigningConfigData;", "tmpDir", "Lorg/gradle/api/file/DirectoryProperty;", "getTmpDir", "()Lorg/gradle/api/file/DirectoryProperty;", "finalBundleFileName", "", "getFinalBundleFileName$annotations", "getFinalBundleFileName", "()Ljava/lang/String;", "finalBundleFile", "getFinalBundleFile", "doTaskAction", "", "Params", "BundleToolRunnable", "CreationForAssetPackBundleAction", "CreationAction", "gradle-core"})
public abstract class FinalizeBundleTask
extends NonIncrementalTask {
    @Nullable
    private SigningConfigDataProvider signingConfigData;
    @Nullable
    private SigningConfigData codeTransparencySigningConfigData;

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public abstract RegularFileProperty getIntermediaryBundleFile();

    @Nested
    @Optional
    @Nullable
    public final SigningConfigDataProvider getSigningConfigData() {
        return this.signingConfigData;
    }

    @Nested
    @Optional
    @Nullable
    public final SigningConfigData getCodeTransparencySigningConfigData() {
        return this.codeTransparencySigningConfigData;
    }

    @Internal
    @NotNull
    public abstract DirectoryProperty getTmpDir();

    @Input
    @NotNull
    public final String getFinalBundleFileName() {
        String string = ((RegularFile)this.getFinalBundleFile().get()).getAsFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    public static /* synthetic */ void getFinalBundleFileName$annotations() {
    }

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getFinalBundleFile();

    @Override
    protected void doTaskAction() {
        this.getWorkerExecutor().noIsolation().submit(BundleToolRunnable.class, new Action(this){
            final /* synthetic */ FinalizeBundleTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(Params it) {
                it.initializeFromBaseTask(this.this$0);
                it.getIntermediaryBundleFile().set((Provider)this.this$0.getIntermediaryBundleFile());
                it.getFinalBundleFile().set((Provider)this.this$0.getFinalBundleFile());
                Object object = this.this$0.getSigningConfigData();
                if (object != null && (object = ((SigningConfigDataProvider)object).convertToParams()) != null) {
                    Object signing = object;
                    boolean bl = false;
                    it.getSigningConfig().set(signing);
                }
                SigningConfigData signingConfigData = this.this$0.getCodeTransparencySigningConfigData();
                if (signingConfigData != null) {
                    SigningConfigData signingData = signingConfigData;
                    boolean bl = false;
                    it.getCodeTransparencySigningConfig().set((Object)new SigningConfigProviderParams(signingData, null));
                }
                it.getTmpDir().set(this.this$0.getTmpDir().getOrNull());
            }
        });
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\b\u0010\r\u001a\u00020\u0006H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask$BundleToolRunnable;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask$Params;", "<init>", "()V", "addCodeTransparencySigning", "", "inputFile", "Ljava/io/File;", "outputFile", "codeSigning", "Lcom/android/build/gradle/internal/signing/SigningConfigData;", "compressBundle", "run", "gradle-core"})
    public static abstract class BundleToolRunnable
    extends ProfileAwareWorkAction<Params> {
        private final void addCodeTransparencySigning(File inputFile, File outputFile, SigningConfigData codeSigning) {
            FileUtils.mkdirs((File)outputFile.getParentFile());
            FileUtils.deleteIfExists((File)outputFile);
            AddTransparencyCommand.Builder builder = AddTransparencyCommand.builder().setBundlePath(inputFile.toPath()).setOutputPath(outputFile.toPath()).setDexMergingChoice(AddTransparencyCommand.DexMergingChoice.CONTINUE);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setDexMergingChoice(...)");
            BundleTaskUtil.setSignerConfig(builder, codeSigning).build().execute();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void compressBundle(File inputFile, File outputFile) {
            Closeable closeable = new FileInputStream(inputFile);
            int n = 8192;
            closeable = new ZipInputStream(closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n));
            Throwable throwable = null;
            try {
                ZipInputStream inputStream = (ZipInputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = new FileOutputStream(outputFile);
                int n2 = 8192;
                closeable2 = new ZipOutputStream(closeable2 instanceof BufferedOutputStream ? (BufferedOutputStream)closeable2 : new BufferedOutputStream((OutputStream)closeable2, n2));
                Throwable throwable2 = null;
                try {
                    ZipOutputStream outputStream = (ZipOutputStream)closeable2;
                    boolean bl2 = false;
                    while (inputStream.getNextEntry() != null) {
                        ZipEntry entry2;
                        ZipEntry outEntry = new ZipEntry(entry2.getName());
                        outEntry.setTime(0L);
                        outputStream.putNextEntry(outEntry);
                        ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
                        outputStream.closeEntry();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block10: {
                FileUtils.deleteIfExists((File)((File)((Params)this.getParameters()).getFinalBundleFile().getAsFile().get()));
                File inputFile = null;
                inputFile = ((RegularFile)((Params)this.getParameters()).getIntermediaryBundleFile().get()).getAsFile();
                run.cleanup.1 cleanup2 = null;
                cleanup2 = run.cleanup.1.INSTANCE;
                try {
                    Serializable serializable;
                    SigningConfigData signingConfigData;
                    SigningConfigProviderParams signingConfigProviderParams = (SigningConfigProviderParams)((Params)this.getParameters()).getCodeTransparencySigningConfig().getOrNull();
                    if (signingConfigProviderParams != null && (signingConfigData = signingConfigProviderParams.resolve()) != null) {
                        SigningConfigData codeSigningConfig = signingConfigData;
                        boolean bl = false;
                        String[] stringArray = new String[]{inputFile.getName()};
                        File outputFile = FileUtils.join((File)((Directory)((Params)this.getParameters()).getTmpDir().get()).getAsFile(), (String[])stringArray);
                        File file = inputFile;
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"element");
                        Intrinsics.checkNotNull((Object)outputFile);
                        this.addCodeTransparencySigning(file, outputFile, codeSigningConfig);
                        inputFile = outputFile;
                        cleanup2 = new Function0<Unit>(outputFile){
                            final /* synthetic */ File $outputFile;
                            {
                                this.$outputFile = $outputFile;
                                super(0);
                            }

                            public final void invoke() {
                                FileUtils.deleteIfExists((File)this.$outputFile);
                            }
                        };
                    }
                    if ((serializable = (SigningConfigProviderParams)((Params)this.getParameters()).getSigningConfig().getOrNull()) != null && (serializable = ((SigningConfigProviderParams)serializable).resolve()) != null) {
                        Serializable it = serializable;
                        boolean bl = false;
                        String string = ((SigningConfigData)it).getKeyAlias();
                        Intrinsics.checkNotNull((Object)string);
                        String keyAlias2 = string;
                        String string2 = ((SigningConfigData)it).getStoreType();
                        File file = ((SigningConfigData)it).getStoreFile();
                        Intrinsics.checkNotNull((Object)file);
                        String string3 = ((SigningConfigData)it).getStorePassword();
                        Intrinsics.checkNotNull((Object)string3);
                        String string4 = ((SigningConfigData)it).getKeyPassword();
                        Intrinsics.checkNotNull((Object)string4);
                        CertificateInfo certificateInfo = KeystoreHelper.getCertificateInfo((String)string2, (File)file, (String)string3, (String)string4, (String)keyAlias2);
                        Object object = ((Params)this.getParameters()).getFinalBundleFile().getAsFile().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                        File file2 = (File)object;
                        Object object2 = keyAlias2;
                        Locale locale = Locale.US;
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                        String string5 = ((String)object2).toUpperCase(locale);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
                        PrivateKey privateKey = certificateInfo.getKey();
                        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"getKey(...)");
                        object2 = (Closeable)new AabFlinger(file2, string5, privateKey, CollectionsKt.listOf((Object)certificateInfo.getCertificate()), 18);
                        Throwable throwable = null;
                        try {
                            AabFlinger aabFlinger = (AabFlinger)object2;
                            boolean bl2 = false;
                            File file3 = inputFile;
                            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"element");
                            aabFlinger.writeZip(file3, -1);
                            Unit unit = Unit.INSTANCE;
                            break block10;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                        }
                    }
                    BundleToolRunnable $this$run_u24lambda_u245 = this;
                    boolean bl = false;
                    File file = inputFile;
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"element");
                    Object object = ((Params)$this$run_u24lambda_u245.getParameters()).getFinalBundleFile().getAsFile().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                    $this$run_u24lambda_u245.compressBundle(file, (File)object);
                }
                finally {
                    ((Function0)cleanup2).invoke();
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask;", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "creationConfig", "<init>", "(Lcom/android/build/gradle/internal/component/ApkCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "handleProvider", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "configure", "task", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<FinalizeBundleTask, ApkCreationConfig> {
        public CreationAction(@NotNull ApkCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig, false, 2, null);
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("sign", "Bundle");
        }

        @Override
        @NotNull
        public Class<FinalizeBundleTask> getType() {
            return FinalizeBundleTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<FinalizeBundleTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            Provider bundleNameProvider2 = ((ApkCreationConfig)this.creationConfig).getServices().getProjectInfo().getProjectBaseName().map(new Transformer(this){
                final /* synthetic */ CreationAction this$0;
                {
                    this.this$0 = $receiver;
                }

                public final String transform(String it) {
                    return it + "-" + ((ApkCreationConfig)CreationAction.access$getCreationConfig$p(this.this$0)).getBaseName() + ".aab";
                }
            });
            String apkLocationOverride = ((ApkCreationConfig)this.creationConfig).getServices().getProjectOptions().get(StringOption.IDE_APK_LOCATION);
            if (apkLocationOverride == null) {
                SingleInitialProviderRequestImpl singleInitialProviderRequestImpl = ((ApkCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE);
                Intrinsics.checkNotNull((Object)bundleNameProvider2);
                singleInitialProviderRequestImpl.withName((Provider<String>)bundleNameProvider2).on((Artifact.Single)SingleArtifact.BUNDLE.INSTANCE);
            } else {
                String[] stringArray = new String[]{((ApkCreationConfig)this.creationConfig).getDirName()};
                SingleInitialProviderRequestImpl singleInitialProviderRequestImpl = ((ApkCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.2.INSTANCE).atLocation(FileUtils.join((File)((ApkCreationConfig)this.creationConfig).getServices().file(apkLocationOverride), (String[])stringArray).getAbsolutePath());
                Intrinsics.checkNotNull((Object)bundleNameProvider2);
                singleInitialProviderRequestImpl.withName((Provider<String>)bundleNameProvider2).on((Artifact.Single)SingleArtifact.BUNDLE.INSTANCE);
            }
        }

        @Override
        public void configure(@NotNull FinalizeBundleTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.INTERMEDIARY_BUNDLE.INSTANCE, (Property)task.getIntermediaryBundleFile());
            task.signingConfigData = SigningConfigDataProvider.Companion.create((ApkCreationConfig)this.creationConfig);
            Object object = ((ApkCreationConfig)this.creationConfig).getBundleConfig();
            if (object != null && (object = ((BundleConfigImpl)object).getCodeTransparency()) != null && (object = ((CodeTransparencyImpl)object).getSigningConfiguration$gradle_core()) != null) {
                Object codeSigning = object;
                boolean bl = false;
                if (codeSigning.getStoreFile() != null && codeSigning.getKeyAlias() != null) {
                    task.codeTransparencySigningConfigData = SigningConfigData.Companion.fromDslSigningConfig((SigningConfig)codeSigning);
                }
            }
            String[] stringArray = new String[]{"tmp", "FinalizeBundle", ((ApkCreationConfig)this.creationConfig).getDirName()};
            HasConfigurableValuesKt.setDisallowChanges((Property)task.getTmpDir(), ((ApkCreationConfig)this.creationConfig).getPaths().intermediatesDir(stringArray));
        }

        public static final /* synthetic */ ComponentCreationConfig access$getCreationConfig$p(CreationAction $this) {
            return $this.creationConfig;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001b"}, d2={"Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask$CreationForAssetPackBundleAction;", "Lcom/android/build/gradle/internal/tasks/factory/AndroidVariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask;", "projectServices", "Lcom/android/build/gradle/internal/services/ProjectServices;", "artifacts", "Lcom/android/build/api/artifact/impl/ArtifactsImpl;", "signingConfig", "Lcom/android/build/api/dsl/SigningConfig;", "isSigningReady", "", "<init>", "(Lcom/android/build/gradle/internal/services/ProjectServices;Lcom/android/build/api/artifact/impl/ArtifactsImpl;Lcom/android/build/api/dsl/SigningConfig;Z)V", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "name", "", "getName", "()Ljava/lang/String;", "handleProvider", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "configure", "task", "gradle-core"})
    public static final class CreationForAssetPackBundleAction
    extends AndroidVariantTaskCreationAction<FinalizeBundleTask> {
        @NotNull
        private final ProjectServices projectServices;
        @NotNull
        private final ArtifactsImpl artifacts;
        @NotNull
        private final SigningConfig signingConfig;
        private final boolean isSigningReady;
        @NotNull
        private final Class<FinalizeBundleTask> type;
        @NotNull
        private final String name;

        public CreationForAssetPackBundleAction(@NotNull ProjectServices projectServices2, @NotNull ArtifactsImpl artifacts2, @NotNull SigningConfig signingConfig2, boolean isSigningReady) {
            Intrinsics.checkNotNullParameter((Object)projectServices2, (String)"projectServices");
            Intrinsics.checkNotNullParameter((Object)artifacts2, (String)"artifacts");
            Intrinsics.checkNotNullParameter((Object)signingConfig2, (String)"signingConfig");
            super(null, 1, null);
            this.projectServices = projectServices2;
            this.artifacts = artifacts2;
            this.signingConfig = signingConfig2;
            this.isSigningReady = isSigningReady;
            this.type = FinalizeBundleTask.class;
            this.name = "signBundle";
        }

        @Override
        @NotNull
        public Class<FinalizeBundleTask> getType() {
            return this.type;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<FinalizeBundleTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            Provider bundleNameProvider2 = this.projectServices.getProjectInfo().getProjectBaseName().map(new Transformer(this){
                final /* synthetic */ CreationForAssetPackBundleAction this$0;
                {
                    this.this$0 = $receiver;
                }

                public final String transform(String it) {
                    return it + (!CreationForAssetPackBundleAction.access$isSigningReady$p(this.this$0) ? "-unsigned" : "") + ".aab";
                }
            });
            Artifact artifact = (Artifact)SingleArtifact.BUNDLE.INSTANCE;
            DirectoryProperty directoryProperty = this.artifacts.getBuildDirectory$gradle_core();
            Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"<get-buildDirectory>(...)");
            File location2 = ArtifactTypeUtil.getOutputPath$default(artifact, directoryProperty, "", new String[0], null, 8, null);
            SingleInitialProviderRequestImpl singleInitialProviderRequestImpl = this.artifacts.setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).atLocation(location2.getAbsolutePath());
            Intrinsics.checkNotNull((Object)bundleNameProvider2);
            singleInitialProviderRequestImpl.withName((Provider<String>)bundleNameProvider2).on((Artifact.Single)SingleArtifact.BUNDLE.INSTANCE);
        }

        @Override
        public void configure(@NotNull FinalizeBundleTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((AndroidVariantTask)task);
            this.artifacts.setTaskInputToFinalProduct(InternalArtifactType.INTERMEDIARY_BUNDLE.INSTANCE, (Property)task.getIntermediaryBundleFile());
            if (this.isSigningReady) {
                SigningConfigData signingConfigData = SigningConfigData.Companion.fromDslSigningConfig(this.signingConfig);
                Provider provider2 = this.projectServices.getProviderFactory().provider(new Callable(signingConfigData){
                    final /* synthetic */ SigningConfigData $signingConfigData;
                    {
                        this.$signingConfigData = $signingConfigData;
                    }

                    public final SigningConfigData call() {
                        return this.$signingConfigData;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"provider(...)");
                task.signingConfigData = new SigningConfigDataProvider((Provider<? extends SigningConfigData>)provider2, null, this.artifacts.get(InternalArtifactType.VALIDATE_SIGNING_CONFIG.INSTANCE));
            }
        }

        public static final /* synthetic */ boolean access$isSigningReady$p(CreationForAssetPackBundleAction $this) {
            return $this.isSigningReady;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0012\u0010\u0011\u001a\u00020\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask$Params;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "<init>", "()V", "intermediaryBundleFile", "Lorg/gradle/api/file/RegularFileProperty;", "getIntermediaryBundleFile", "()Lorg/gradle/api/file/RegularFileProperty;", "finalBundleFile", "getFinalBundleFile", "signingConfig", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/signing/SigningConfigProviderParams;", "getSigningConfig", "()Lorg/gradle/api/provider/Property;", "codeTransparencySigningConfig", "getCodeTransparencySigningConfig", "tmpDir", "Lorg/gradle/api/file/DirectoryProperty;", "getTmpDir", "()Lorg/gradle/api/file/DirectoryProperty;", "gradle-core"})
    public static abstract class Params
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract RegularFileProperty getIntermediaryBundleFile();

        @NotNull
        public abstract RegularFileProperty getFinalBundleFile();

        @NotNull
        public abstract Property<SigningConfigProviderParams> getSigningConfig();

        @NotNull
        public abstract Property<SigningConfigProviderParams> getCodeTransparencySigningConfig();

        @NotNull
        public abstract DirectoryProperty getTmpDir();
    }
}

