/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.attribution.CheckJetifierBuildService;
import com.android.build.gradle.internal.component.TestComponentCreationConfig;
import com.android.build.gradle.internal.component.TestFixturesCreationConfig;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.CheckJetifierTask;
import com.android.build.gradle.internal.tasks.ConfigurationAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalGlobalTask;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationAction;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationConfig;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.internal.variant.ComponentInfo;
import com.android.build.gradle.options.BooleanOption;
import com.android.buildanalyzer.common.CheckJetifierProjectResult;
import com.android.buildanalyzer.common.DependencyPath;
import com.android.buildanalyzer.common.FullDependencyPath;
import com.android.buildanalyzer.common.TaskCategory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.internal.deprecation.DeprecatableConfiguration;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.VERIFICATION)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b'\u0018\u00002\u00020\u0001:\u0002\u001a\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0017H\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/internal/tasks/CheckJetifierTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalGlobalTask;", "<init>", "()V", "jetifierEnabled", "Lorg/gradle/api/provider/Property;", "", "getJetifierEnabled", "()Lorg/gradle/api/provider/Property;", "checkJetifierBuildService", "Lcom/android/build/gradle/internal/attribution/CheckJetifierBuildService;", "getCheckJetifierBuildService", "configurationToResolveFirst", "Lorg/gradle/api/provider/ListProperty;", "", "getConfigurationToResolveFirst", "()Lorg/gradle/api/provider/ListProperty;", "resolutionUnit", "Lcom/android/build/gradle/internal/tasks/CheckJetifierTask$ResolutionUnit;", "getResolutionUnit", "doTaskAction", "", "detect", "Lcom/android/buildanalyzer/common/CheckJetifierProjectResult;", "reportToConsole", "result", "CreationAction", "ResolutionUnit", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nCheckJetifierTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckJetifierTask.kt\ncom/android/build/gradle/internal/tasks/CheckJetifierTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,252:1\n3193#2,10:253\n1863#2,2:263\n1863#2,2:265\n*S KotlinDebug\n*F\n+ 1 CheckJetifierTask.kt\ncom/android/build/gradle/internal/tasks/CheckJetifierTask\n*L\n144#1:253,10\n155#1:263,2\n156#1:265,2\n*E\n"})
public abstract class CheckJetifierTask
extends NonIncrementalGlobalTask {
    @Internal
    @NotNull
    public abstract Property<Boolean> getJetifierEnabled();

    @Internal
    @NotNull
    public abstract Property<CheckJetifierBuildService> getCheckJetifierBuildService();

    @Internal
    @NotNull
    public abstract ListProperty<String> getConfigurationToResolveFirst();

    @Nested
    @NotNull
    public abstract ListProperty<ResolutionUnit> getResolutionUnit();

    @Override
    protected void doTaskAction() {
        if (!((Boolean)this.getJetifierEnabled().get()).booleanValue()) {
            this.getLogger().quiet("Skipping '" + this.getPath() + "' task as Jetifier is already disabled (" + BooleanOption.ENABLE_JETIFIER.getPropertyName() + "=false).");
            return;
        }
        CheckJetifierProjectResult result2 = this.detect();
        this.reportToConsole(result2);
        ((CheckJetifierBuildService)this.getCheckJetifierBuildService().get()).addResult(result2);
    }

    /*
     * WARNING - void declaration
     */
    private final CheckJetifierProjectResult detect() {
        void $this$partition$iv;
        LinkedHashMap<String, FullDependencyPath> dependenciesDependingOnSupportLibs = new LinkedHashMap<String, FullDependencyPath>();
        List resolveFirstNames = (List)this.getConfigurationToResolveFirst().get();
        Object object = this.getResolutionUnit().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Iterable iterable = (Iterable)object;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            ResolutionUnit it = (ResolutionUnit)element$iv;
            boolean bl = false;
            if (resolveFirstNames.contains(it.getConfigurationName())) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List handleFirst = (List)pair.component1();
        List theRest = (List)pair.component2();
        Function1 handler2 = (Function1)new Function1<ResolutionUnit, Unit>(dependenciesDependingOnSupportLibs, this){
            final /* synthetic */ LinkedHashMap<String, FullDependencyPath> $dependenciesDependingOnSupportLibs;
            final /* synthetic */ CheckJetifierTask this$0;
            {
                this.$dependenciesDependingOnSupportLibs = $dependenciesDependingOnSupportLibs;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(ResolutionUnit unit) {
                Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
                Object object = unit.getRootComponent().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                for (DependencyPath pathToSupportLib : new ConfigurationAnalyzer((ResolvedComponentResult)object).findPathsToSupportLibs()) {
                    String directDependency = (String)CollectionsKt.first(pathToSupportLib.getElements());
                    this.$dependenciesDependingOnSupportLibs.computeIfAbsent(directDependency, new Function(this.this$0, unit, pathToSupportLib){
                        final /* synthetic */ CheckJetifierTask this$0;
                        final /* synthetic */ ResolutionUnit $unit;
                        final /* synthetic */ DependencyPath $pathToSupportLib;
                        {
                            this.this$0 = $receiver;
                            this.$unit = $unit;
                            this.$pathToSupportLib = $pathToSupportLib;
                        }

                        public final FullDependencyPath apply(String it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            Object object = this.this$0.getProjectPath().get();
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                            return new FullDependencyPath((String)object, this.$unit.getConfigurationName(), this.$pathToSupportLib);
                        }
                    });
                }
            }
        };
        Iterable $this$forEach$iv = handleFirst;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResolutionUnit it = (ResolutionUnit)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            handler2.invoke((Object)it);
        }
        $this$forEach$iv = theRest;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResolutionUnit it = (ResolutionUnit)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            handler2.invoke((Object)it);
        }
        return new CheckJetifierProjectResult(dependenciesDependingOnSupportLibs);
    }

    private final void reportToConsole(CheckJetifierProjectResult result2) {
        if (result2.isEmpty()) {
            this.getLogger().quiet("Project '" + this.getProjectPath().get() + "' does not use any legacy support libraries. If this is the case for all other projects, you can disable Jetifier by setting " + BooleanOption.ENABLE_JETIFIER.getPropertyName() + "=false in gradle.properties.");
        } else {
            this.getLogger().quiet("The following libraries used by project '" + this.getProjectPath().get() + "' depend on legacy support libraries. To disable Jetifier, you will need to use AndroidX-supported versions of these libraries.");
            this.getLogger().quiet("\t" + StringsKt.replace$default((String)result2.getDisplayString(), (String)"\n", (String)"\n\t", (boolean)false, (int)4, null));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BO\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0010\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u00120\u00120\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/build/gradle/internal/tasks/CheckJetifierTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/CheckJetifierTask;", "creationConfig", "Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;", "checkJetifierBuildService", "Lorg/gradle/api/provider/Provider;", "Lcom/android/build/gradle/internal/attribution/CheckJetifierBuildService;", "variants", "", "Lcom/android/build/gradle/internal/variant/ComponentInfo;", "testComponents", "Lcom/android/build/gradle/internal/component/TestComponentCreationConfig;", "testFixturesComponents", "Lcom/android/build/gradle/internal/component/TestFixturesCreationConfig;", "<init>", "(Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;Lorg/gradle/api/provider/Provider;Ljava/util/Collection;Ljava/util/Collection;Ljava/util/Collection;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configurationsToResolveFirst", "", "kotlin.jvm.PlatformType", "configure", "", "task", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nCheckJetifierTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckJetifierTask.kt\ncom/android/build/gradle/internal/tasks/CheckJetifierTask$CreationAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,252:1\n1557#2:253\n1628#2,3:254\n1557#2:257\n1628#2,3:258\n1557#2:261\n1628#2,3:262\n1368#2:265\n1454#2,5:266\n774#2:271\n865#2,2:272\n1557#2:274\n1628#2,3:275\n*S KotlinDebug\n*F\n+ 1 CheckJetifierTask.kt\ncom/android/build/gradle/internal/tasks/CheckJetifierTask$CreationAction\n*L\n90#1:253\n90#1:254,3\n91#1:257\n91#1:258,3\n92#1:261\n92#1:262,3\n92#1:265\n92#1:266,5\n110#1:271\n110#1:272,2\n111#1:274\n111#1:275,3\n*E\n"})
    public static final class CreationAction
    extends GlobalTaskCreationAction<CheckJetifierTask> {
        @NotNull
        private final GlobalTaskCreationConfig creationConfig;
        @NotNull
        private final Provider<CheckJetifierBuildService> checkJetifierBuildService;
        @NotNull
        private final String name;
        @NotNull
        private final Class<CheckJetifierTask> type;
        @NotNull
        private final List<String> configurationsToResolveFirst;

        /*
         * WARNING - void declaration
         */
        public CreationAction(@NotNull GlobalTaskCreationConfig creationConfig, @NotNull Provider<CheckJetifierBuildService> checkJetifierBuildService, @NotNull Collection<? extends ComponentInfo<?, ?>> variants, @NotNull Collection<? extends TestComponentCreationConfig> testComponents, @NotNull Collection<? extends TestFixturesCreationConfig> testFixturesComponents) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            Collection<VariantDependencies> collection;
            Object it;
            Collection collection2;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            Intrinsics.checkNotNullParameter(checkJetifierBuildService, (String)"checkJetifierBuildService");
            Intrinsics.checkNotNullParameter(variants, (String)"variants");
            Intrinsics.checkNotNullParameter(testComponents, (String)"testComponents");
            Intrinsics.checkNotNullParameter(testFixturesComponents, (String)"testFixturesComponents");
            this.creationConfig = creationConfig;
            this.checkJetifierBuildService = checkJetifierBuildService;
            this.name = "checkJetifier";
            this.type = CheckJetifierTask.class;
            Iterable iterable = variants;
            CreationAction creationAction = this;
            boolean $i$f$map = false;
            void var8_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ComponentInfo componentInfo = (ComponentInfo)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(((ComponentInfo)it).getVariant().getVariantDependencies());
            }
            $this$map$iv = testComponents;
            collection2 = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (TestComponentCreationConfig)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getVariantDependencies());
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = testFixturesComponents;
            collection2 = CollectionsKt.plus((Collection)collection2, (Iterable)collection);
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (TestFixturesCreationConfig)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getVariantDependencies());
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = CollectionsKt.plus((Collection)collection2, (Iterable)collection);
            boolean $i$f$flatMap = false;
            $this$mapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (VariantDependencies)element$iv$iv;
                boolean bl = false;
                Object[] objectArray = new String[]{((VariantDependencies)it).getCompileClasspath().getName(), ((VariantDependencies)it).getRuntimeClasspath().getName()};
                Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            creationAction.configurationsToResolveFirst = (List)destination$iv$iv;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<CheckJetifierTask> getType() {
            return this.type;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void configure(@NotNull CheckJetifierTask task) {
            void $this$mapTo$iv$iv;
            Configuration it;
            Iterable $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            task.setDescription("Checks whether Jetifier is needed for the current project");
            task.setGroup("verification");
            HasConfigurableValuesKt.setDisallowChanges(task.getJetifierEnabled(), this.creationConfig.getServices().getProjectOptions().get(BooleanOption.ENABLE_JETIFIER));
            HasConfigurableValuesKt.setDisallowChanges(task.getCheckJetifierBuildService(), this.checkJetifierBuildService);
            HasConfigurableValuesKt.setDisallowChanges(task.getConfigurationToResolveFirst(), (Iterable)this.configurationsToResolveFirst);
            task.getOutputs().upToDateWhen((Spec)configure.1.INSTANCE);
            ConfigurationContainer configurationContainer = task.getProject().getConfigurations();
            Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"getConfigurations(...)");
            Iterable $this$filter$iv = (Iterable)configurationContainer;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Configuration)element$iv$iv;
                boolean bl = false;
                if (!(it.isCanBeResolved() || it instanceof DeprecatableConfiguration && ((DeprecatableConfiguration)it).canSafelyBeResolved())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Configuration)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                Provider provider2 = it.getIncoming().getResolutionResult().getRootComponent();
                Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"getRootComponent(...)");
                collection.add(new ResolutionUnit(string, (Provider<ResolvedComponentResult>)provider2));
            }
            List resolutionUnit = (List)destination$iv$iv;
            HasConfigurableValuesKt.setDisallowChanges(task.getResolutionUnit(), (Iterable)resolutionUnit);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u00020\u00038G\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/tasks/CheckJetifierTask$ResolutionUnit;", "Ljava/io/Serializable;", "configurationName", "", "rootComponent", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/artifacts/result/ResolvedComponentResult;", "<init>", "(Ljava/lang/String;Lorg/gradle/api/provider/Provider;)V", "getConfigurationName", "()Ljava/lang/String;", "getRootComponent", "()Lorg/gradle/api/provider/Provider;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "gradle-core"})
    public static final class ResolutionUnit
    implements Serializable {
        @NotNull
        private final String configurationName;
        @NotNull
        private final Provider<ResolvedComponentResult> rootComponent;

        public ResolutionUnit(@NotNull String configurationName, @NotNull Provider<ResolvedComponentResult> rootComponent) {
            Intrinsics.checkNotNullParameter((Object)configurationName, (String)"configurationName");
            Intrinsics.checkNotNullParameter(rootComponent, (String)"rootComponent");
            this.configurationName = configurationName;
            this.rootComponent = rootComponent;
        }

        @Internal
        @NotNull
        public final String getConfigurationName() {
            return this.configurationName;
        }

        @Internal
        @NotNull
        public final Provider<ResolvedComponentResult> getRootComponent() {
            return this.rootComponent;
        }

        @NotNull
        public final String component1() {
            return this.configurationName;
        }

        @NotNull
        public final Provider<ResolvedComponentResult> component2() {
            return this.rootComponent;
        }

        @NotNull
        public final ResolutionUnit copy(@NotNull String configurationName, @NotNull Provider<ResolvedComponentResult> rootComponent) {
            Intrinsics.checkNotNullParameter((Object)configurationName, (String)"configurationName");
            Intrinsics.checkNotNullParameter(rootComponent, (String)"rootComponent");
            return new ResolutionUnit(configurationName, rootComponent);
        }

        public static /* synthetic */ ResolutionUnit copy$default(ResolutionUnit resolutionUnit, String string, Provider provider2, int n, Object object) {
            if ((n & 1) != 0) {
                string = resolutionUnit.configurationName;
            }
            if ((n & 2) != 0) {
                provider2 = resolutionUnit.rootComponent;
            }
            return resolutionUnit.copy(string, provider2);
        }

        @NotNull
        public String toString() {
            return "ResolutionUnit(configurationName=" + this.configurationName + ", rootComponent=" + this.rootComponent + ")";
        }

        public int hashCode() {
            int result2 = this.configurationName.hashCode();
            result2 = result2 * 31 + this.rootComponent.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ResolutionUnit)) {
                return false;
            }
            ResolutionUnit resolutionUnit = (ResolutionUnit)other;
            if (!Intrinsics.areEqual((Object)this.configurationName, (Object)resolutionUnit.configurationName)) {
                return false;
            }
            return Intrinsics.areEqual(this.rootComponent, resolutionUnit.rootComponent);
        }
    }
}

