/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.dsl.Lint;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.privaysandboxsdk.PrivacySandboxSdkVariantScope;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.UnsafeOutputsTask;
import com.android.build.gradle.internal.tasks.factory.PrivacySandboxSdkVariantTaskCreationAction;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.utils.FileUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.Internal;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault(because="Copy task")
@BuildAnalyzer(primaryTaskCategory=TaskCategory.LINT)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b'\u0018\u00002\u00020\u0001:\u0002'(B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0018\u001a\u00020\u0019H\u0014J \u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001d\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0000\u00a2\u0006\u0002\b$J\u001d\u0010%\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0000\u00a2\u0006\u0002\b&R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u001a\u0010\f\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\f\u0012\u0004\b\r\u0010\u0003\u001a\u0004\b\u000e\u0010\u0007R\u0014\u0010\u000f\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007R\u0014\u0010\u0011\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007R\u0014\u0010\u0013\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0007R\u001a\u0010\u0015\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\f\u0012\u0004\b\u0016\u0010\u0003\u001a\u0004\b\u0017\u0010\u0007\u00a8\u0006)"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintCopyReportTask;", "Lcom/android/build/gradle/internal/tasks/UnsafeOutputsTask;", "<init>", "()V", "textReportInput", "Lorg/gradle/api/file/RegularFileProperty;", "getTextReportInput", "()Lorg/gradle/api/file/RegularFileProperty;", "htmlReportInput", "getHtmlReportInput", "xmlReportInput", "getXmlReportInput", "sarifReportInput", "getSarifReportInput$annotations", "getSarifReportInput", "textReportOutput", "getTextReportOutput", "htmlReportOutput", "getHtmlReportOutput", "xmlReportOutput", "getXmlReportOutput", "sarifReportOutput", "getSarifReportOutput$annotations", "getSarifReportOutput", "doTaskAction", "", "doCopy", "from", "to", "displayName", "", "registerInputs", "artifacts", "Lcom/android/build/api/artifact/impl/ArtifactsImpl;", "lintOptions", "Lcom/android/build/api/dsl/Lint;", "registerInputs$gradle_core", "configureForStandalone", "configureForStandalone$gradle_core", "CreationAction", "PrivacySandboxCreationAction", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nAndroidLintCopyReportTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidLintCopyReportTask.kt\ncom/android/build/gradle/internal/lint/AndroidLintCopyReportTask\n+ 2 buildServices.kt\ncom/android/build/gradle/internal/services/BuildServicesKt\n*L\n1#1,158:1\n78#2:159\n*S KotlinDebug\n*F\n+ 1 AndroidLintCopyReportTask.kt\ncom/android/build/gradle/internal/lint/AndroidLintCopyReportTask\n*L\n154#1:159\n*E\n"})
public abstract class AndroidLintCopyReportTask
extends UnsafeOutputsTask {
    public AndroidLintCopyReportTask() {
        super("The lintOptions DSL has configured potentially multiple lint tasks to write to the same location, but task should not have overlapping outputs.");
    }

    @Internal
    @NotNull
    public abstract RegularFileProperty getTextReportInput();

    @Internal
    @NotNull
    public abstract RegularFileProperty getHtmlReportInput();

    @Internal
    @NotNull
    public abstract RegularFileProperty getXmlReportInput();

    @Internal
    @NotNull
    public abstract RegularFileProperty getSarifReportInput();

    public static /* synthetic */ void getSarifReportInput$annotations() {
    }

    @Internal
    @NotNull
    public abstract RegularFileProperty getTextReportOutput();

    @Internal
    @NotNull
    public abstract RegularFileProperty getHtmlReportOutput();

    @Internal
    @NotNull
    public abstract RegularFileProperty getXmlReportOutput();

    @Internal
    @NotNull
    public abstract RegularFileProperty getSarifReportOutput();

    public static /* synthetic */ void getSarifReportOutput$annotations() {
    }

    @Override
    protected void doTaskAction() {
        this.doCopy(this.getTextReportInput(), this.getTextReportOutput(), "text");
        this.doCopy(this.getHtmlReportInput(), this.getHtmlReportOutput(), "HTML");
        this.doCopy(this.getXmlReportInput(), this.getXmlReportOutput(), "XML");
        this.doCopy(this.getSarifReportInput(), this.getSarifReportOutput(), "SARIF");
    }

    private final void doCopy(RegularFileProperty from, RegularFileProperty to, String displayName) {
        Object object = (RegularFile)to.getOrNull();
        if (object == null || (object = object.getAsFile()) == null || (object = ((File)object).toPath()) == null) {
            return;
        }
        Object toPath = object;
        Object object2 = (RegularFile)from.getOrNull();
        if (object2 == null || (object2 = object2.getAsFile()) == null || (object2 = ((File)object2).toPath()) == null) {
            return;
        }
        Object inputPath = object2;
        Logger logger = Logging.getLogger(AndroidLintCopyReportTask.class);
        if (!inputPath.toFile().isFile()) {
            logger.warn("Unable to copy the lint " + displayName + " report because it does not exist. The lint " + displayName + " report file was expected to be located at " + inputPath.toAbsolutePath() + ".");
            return;
        }
        logger.lifecycle("Copying lint " + displayName + " report to " + (Path)toPath);
        Files.createDirectories(toPath.getParent(), new FileAttribute[0]);
        FileUtils.copyFile((Path)inputPath, (Path)toPath);
    }

    public final void registerInputs$gradle_core(@NotNull ArtifactsImpl artifacts2, @NotNull Lint lintOptions2) {
        Intrinsics.checkNotNullParameter((Object)artifacts2, (String)"artifacts");
        Intrinsics.checkNotNullParameter((Object)lintOptions2, (String)"lintOptions");
        File textOutput = lintOptions2.getTextOutput();
        if (lintOptions2.getTextReport() && textOutput != null && !Intrinsics.areEqual((Object)textOutput.getPath(), (Object)"stdout") && !Intrinsics.areEqual((Object)textOutput.getPath(), (Object)"stderr")) {
            this.getTextReportInput().set(artifacts2.get(InternalArtifactType.LINT_TEXT_REPORT.INSTANCE));
            this.getTextReportOutput().set(textOutput);
        }
        this.getTextReportInput().disallowChanges();
        this.getTextReportOutput().disallowChanges();
        if (lintOptions2.getHtmlReport() && lintOptions2.getHtmlOutput() != null) {
            this.getHtmlReportInput().set(artifacts2.get(InternalArtifactType.LINT_HTML_REPORT.INSTANCE));
            this.getHtmlReportOutput().set(lintOptions2.getHtmlOutput());
        }
        this.getHtmlReportInput().disallowChanges();
        this.getHtmlReportOutput().disallowChanges();
        if (lintOptions2.getXmlReport() && lintOptions2.getXmlOutput() != null) {
            this.getXmlReportInput().set(artifacts2.get(InternalArtifactType.LINT_XML_REPORT.INSTANCE));
            this.getXmlReportOutput().set(lintOptions2.getXmlOutput());
        }
        this.getXmlReportInput().disallowChanges();
        this.getXmlReportOutput().disallowChanges();
        if (lintOptions2.getSarifReport() && lintOptions2.getSarifOutput() != null) {
            this.getSarifReportInput().set(artifacts2.get(InternalArtifactType.LINT_SARIF_REPORT.INSTANCE));
            this.getSarifReportOutput().set(lintOptions2.getSarifOutput());
        }
        this.getSarifReportInput().disallowChanges();
        this.getSarifReportOutput().disallowChanges();
    }

    public final void configureForStandalone$gradle_core(@NotNull ArtifactsImpl artifacts2, @NotNull Lint lintOptions2) {
        Intrinsics.checkNotNullParameter((Object)artifacts2, (String)"artifacts");
        Intrinsics.checkNotNullParameter((Object)lintOptions2, (String)"lintOptions");
        this.registerInputs$gradle_core(artifacts2, lintOptions2);
        Property property = this.getAnalyticsService();
        BuildServiceRegistry buildServiceRegistry = this.getProject().getGradle().getSharedServices();
        Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry, (String)"getSharedServices(...)");
        BuildServiceRegistry buildServiceRegistry$iv = buildServiceRegistry;
        boolean $i$f$getBuildService = false;
        HasConfigurableValuesKt.setDisallowChanges(property, BuildServicesKt.getBuildService(buildServiceRegistry$iv, AnalyticsService.class));
        this.setVariantName("");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintCopyReportTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/lint/AndroidLintCopyReportTask;", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "variant", "<init>", "(Lcom/android/build/gradle/internal/component/ComponentCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<AndroidLintCopyReportTask, ComponentCreationConfig> {
        @NotNull
        private final String name;

        public CreationAction(@NotNull ComponentCreationConfig variant) {
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            super(variant, false, 2, null);
            this.name = this.computeTaskName("copy", "LintReports");
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<AndroidLintCopyReportTask> getType() {
            return AndroidLintCopyReportTask.class;
        }

        @Override
        public void configure(@NotNull AndroidLintCopyReportTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            task.registerInputs$gradle_core(this.creationConfig.getArtifacts(), this.creationConfig.getGlobal().getLintOptions());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintCopyReportTask$PrivacySandboxCreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/PrivacySandboxSdkVariantTaskCreationAction;", "Lcom/android/build/gradle/internal/lint/AndroidLintCopyReportTask;", "variantScope", "Lcom/android/build/gradle/internal/privaysandboxsdk/PrivacySandboxSdkVariantScope;", "<init>", "(Lcom/android/build/gradle/internal/privaysandboxsdk/PrivacySandboxSdkVariantScope;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "gradle-core"})
    public static final class PrivacySandboxCreationAction
    extends PrivacySandboxSdkVariantTaskCreationAction<AndroidLintCopyReportTask> {
        @NotNull
        private final PrivacySandboxSdkVariantScope variantScope;
        @NotNull
        private final String name;

        public PrivacySandboxCreationAction(@NotNull PrivacySandboxSdkVariantScope variantScope2) {
            Intrinsics.checkNotNullParameter((Object)variantScope2, (String)"variantScope");
            this.variantScope = variantScope2;
            this.name = "copyLintReports";
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<AndroidLintCopyReportTask> getType() {
            return AndroidLintCopyReportTask.class;
        }

        @Override
        public void configure(@NotNull AndroidLintCopyReportTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((AndroidVariantTask)task);
            task.registerInputs$gradle_core(this.variantScope.getArtifacts(), this.variantScope.getLintOptions());
        }
    }
}

