/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.errors;

import com.android.build.gradle.internal.errors.AndroidProblemReporterProvider;
import com.android.build.gradle.internal.errors.AndroidProblemsReporter;
import com.android.build.gradle.internal.errors.MessageReceiverImpl;
import com.android.build.gradle.internal.errors.SyncIssueKey;
import com.android.build.gradle.internal.errors.SyncIssueReporter;
import com.android.build.gradle.internal.errors.SyncIssueReporterImplKt;
import com.android.build.gradle.internal.ide.SyncIssueImpl;
import com.android.build.gradle.internal.services.ServiceRegistrationAction;
import com.android.build.gradle.options.SyncOptions;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.IssueReporter;
import com.android.builder.model.SyncIssue;
import com.android.ide.common.blame.Message;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Project;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001&B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0015\u001a\u00020\u0012H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u0017H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J \u0010 \u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0014J\b\u0010%\u001a\u00020\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000RP\u0010\f\u001aB\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00100\u0010 \u000f* \u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00100\u0010\u0018\u00010\r0\r8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\u00128\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006'"}, d2={"Lcom/android/build/gradle/internal/errors/SyncIssueReporterImpl;", "Lcom/android/build/gradle/internal/errors/SyncIssueReporter;", "mode", "Lcom/android/build/gradle/options/SyncOptions$EvaluationMode;", "errorFormatMode", "Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;", "logger", "Lorg/gradle/api/logging/Logger;", "problemReporter", "Lcom/android/build/gradle/internal/errors/AndroidProblemsReporter;", "<init>", "(Lcom/android/build/gradle/options/SyncOptions$EvaluationMode;Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;Lorg/gradle/api/logging/Logger;Lcom/android/build/gradle/internal/errors/AndroidProblemsReporter;)V", "_syncIssues", "Ljava/util/HashMap;", "Lcom/android/build/gradle/internal/errors/SyncIssueKey;", "kotlin.jvm.PlatformType", "Lcom/android/builder/model/SyncIssue;", "handlerLocked", "", "messageReceiverImpl", "Lcom/android/build/gradle/internal/errors/MessageReceiverImpl;", "isInStandardEvaluationMode", "syncIssues", "Lcom/google/common/collect/ImmutableList;", "getSyncIssues", "()Lcom/google/common/collect/ImmutableList;", "getAllIssuesAndClear", "reportRemainingIssues", "", "hasIssue", "type", "Lcom/android/builder/errors/IssueReporter$Type;", "reportIssue", "severity", "Lcom/android/builder/errors/IssueReporter$Severity;", "exception", "Lcom/android/builder/errors/EvalIssueException;", "lockHandler", "GlobalSyncIssueService", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nSyncIssueReporterImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyncIssueReporterImpl.kt\ncom/android/build/gradle/internal/errors/SyncIssueReporterImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,210:1\n1755#2,3:211\n*S KotlinDebug\n*F\n+ 1 SyncIssueReporterImpl.kt\ncom/android/build/gradle/internal/errors/SyncIssueReporterImpl\n*L\n95#1:211,3\n*E\n"})
public final class SyncIssueReporterImpl
extends SyncIssueReporter {
    @NotNull
    private final SyncOptions.EvaluationMode mode;
    @NotNull
    private final AndroidProblemsReporter problemReporter;
    @GuardedBy(value="this")
    private final HashMap<SyncIssueKey, SyncIssue> _syncIssues;
    @GuardedBy(value="this")
    private boolean handlerLocked;
    @NotNull
    private final MessageReceiverImpl messageReceiverImpl;

    public SyncIssueReporterImpl(@NotNull SyncOptions.EvaluationMode mode, @NotNull SyncOptions.ErrorFormatMode errorFormatMode, @NotNull org.gradle.api.logging.Logger logger, @NotNull AndroidProblemsReporter problemReporter) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)((Object)errorFormatMode), (String)"errorFormatMode");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)problemReporter, (String)"problemReporter");
        this.mode = mode;
        this.problemReporter = problemReporter;
        this._syncIssues = Maps.newHashMap();
        this.messageReceiverImpl = new MessageReceiverImpl(errorFormatMode, (Logger)logger);
    }

    @Override
    public boolean isInStandardEvaluationMode() {
        return this.mode == SyncOptions.EvaluationMode.STANDARD;
    }

    @Override
    @NotNull
    public synchronized ImmutableList<SyncIssue> getSyncIssues() {
        ImmutableList immutableList = ImmutableList.copyOf(this._syncIssues.values());
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(...)");
        return immutableList;
    }

    private final synchronized ImmutableList<SyncIssue> getAllIssuesAndClear() {
        ImmutableList<SyncIssue> issues = this.getSyncIssues();
        this._syncIssues.clear();
        return issues;
    }

    private final void reportRemainingIssues() {
        this.lockHandler();
        ImmutableList<SyncIssue> issues = this.getAllIssuesAndClear();
        EvalIssueException syncErrorToThrow = null;
        UnmodifiableIterator unmodifiableIterator = issues.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)unmodifiableIterator, (String)"iterator(...)");
        UnmodifiableIterator unmodifiableIterator2 = unmodifiableIterator;
        block4: while (unmodifiableIterator2.hasNext()) {
            SyncIssue issue = (SyncIssue)unmodifiableIterator2.next();
            switch (issue.getSeverity()) {
                case 1: {
                    this.messageReceiverImpl.receiveMessage(new Message(Message.Kind.WARNING, issue.getMessage(), null, null, null, 28, null));
                    continue block4;
                }
                case 2: {
                    EvalIssueException exception = new EvalIssueException(issue.getMessage(), issue.getData(), issue.getMultiLineMessage());
                    if (syncErrorToThrow == null) {
                        syncErrorToThrow = exception;
                        continue block4;
                    }
                    ExceptionsKt.addSuppressed((Throwable)((Throwable)syncErrorToThrow), (Throwable)((Throwable)exception));
                    continue block4;
                }
            }
            throw new IllegalStateException("unexpected issue severity for " + issue);
        }
        if (syncErrorToThrow != null) {
            throw syncErrorToThrow;
        }
    }

    public synchronized boolean hasIssue(@NotNull IssueReporter.Type type) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Collection<SyncIssue> collection = this._syncIssues.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SyncIssue issue = (SyncIssue)element$iv;
                    boolean bl2 = false;
                    if (!(issue.getType() == type.getType())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    protected synchronized void reportIssue(@NotNull IssueReporter.Type type, @NotNull IssueReporter.Severity severity, @NotNull EvalIssueException exception) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        SyncIssueImpl issue = new SyncIssueImpl(type, severity, exception);
        HashMap<SyncIssueKey, SyncIssue> hashMap = this._syncIssues;
        Intrinsics.checkNotNullExpressionValue(hashMap, (String)"_syncIssues");
        Map map = hashMap;
        if (!map.containsKey(SyncIssueReporterImplKt.access$syncIssueKeyFrom(issue))) {
            this.problemReporter.reportSyncIssue(type, severity, exception);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 1: {
                if (severity.getSeverity() != 1) {
                    throw exception;
                }
                this.messageReceiverImpl.receiveMessage(new Message(Message.Kind.WARNING, exception.getMessage(), null, null, null, 28, null));
                break;
            }
            case 2: {
                if (this.handlerLocked) {
                    throw new IllegalStateException("Issue registered after handler locked.", (Throwable)exception);
                }
                HashMap<SyncIssueKey, SyncIssue> hashMap2 = this._syncIssues;
                Intrinsics.checkNotNullExpressionValue(hashMap2, (String)"_syncIssues");
                Map map2 = hashMap2;
                map2.put(SyncIssueReporterImplKt.access$syncIssueKeyFrom(issue), issue);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Override
    public synchronized void lockHandler() {
        this.handlerLocked = true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00060\u0004j\u0002`\u0005:\u0002\u0018\u0019B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/internal/errors/SyncIssueReporterImpl$GlobalSyncIssueService;", "Lorg/gradle/api/services/BuildService;", "Lcom/android/build/gradle/internal/errors/SyncIssueReporterImpl$GlobalSyncIssueService$Parameters;", "Lcom/android/builder/errors/IssueReporter;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "<init>", "()V", "reporter", "Lcom/android/build/gradle/internal/errors/SyncIssueReporterImpl;", "getAllIssuesAndClear", "Lcom/google/common/collect/ImmutableList;", "Lcom/android/builder/model/SyncIssue;", "reportIssue", "", "type", "Lcom/android/builder/errors/IssueReporter$Type;", "severity", "Lcom/android/builder/errors/IssueReporter$Severity;", "exception", "Lcom/android/builder/errors/EvalIssueException;", "hasIssue", "", "close", "Parameters", "RegistrationAction", "gradle-core"})
    public static abstract class GlobalSyncIssueService
    extends IssueReporter
    implements BuildService<Parameters>,
    AutoCloseable {
        @NotNull
        private final SyncIssueReporterImpl reporter;

        public GlobalSyncIssueService() {
            Object object = ((Parameters)this.getParameters()).getMode().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            SyncOptions.EvaluationMode evaluationMode = (SyncOptions.EvaluationMode)((Object)object);
            Object object2 = ((Parameters)this.getParameters()).getErrorFormatMode().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            SyncOptions.ErrorFormatMode errorFormatMode = (SyncOptions.ErrorFormatMode)((Object)object2);
            org.gradle.api.logging.Logger logger = Logging.getLogger(GlobalSyncIssueService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            this.reporter = new SyncIssueReporterImpl(evaluationMode, errorFormatMode, logger, ((AndroidProblemReporterProvider)((Parameters)this.getParameters()).getAndroidProblemReporterProviderService().get()).reporter());
        }

        @NotNull
        public final ImmutableList<SyncIssue> getAllIssuesAndClear() {
            return this.reporter.getAllIssuesAndClear();
        }

        protected void reportIssue(@NotNull IssueReporter.Type type, @NotNull IssueReporter.Severity severity, @NotNull EvalIssueException exception) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            this.reporter.reportIssue(type, severity, exception);
        }

        public boolean hasIssue(@NotNull IssueReporter.Type type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return this.reporter.hasIssue(type);
        }

        @Override
        public void close() {
            this.reporter.reportRemainingIssues();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0006R\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\r\u00c0\u0006\u0003"}, d2={"Lcom/android/build/gradle/internal/errors/SyncIssueReporterImpl$GlobalSyncIssueService$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "mode", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/options/SyncOptions$EvaluationMode;", "getMode", "()Lorg/gradle/api/provider/Property;", "errorFormatMode", "Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;", "getErrorFormatMode", "androidProblemReporterProviderService", "Lcom/android/build/gradle/internal/errors/AndroidProblemReporterProvider;", "getAndroidProblemReporterProviderService", "gradle-core"})
        public static interface Parameters
        extends BuildServiceParameters {
            @NotNull
            public Property<SyncOptions.EvaluationMode> getMode();

            @NotNull
            public Property<SyncOptions.ErrorFormatMode> getErrorFormatMode();

            @NotNull
            public Property<AndroidProblemReporterProvider> getAndroidProblemReporterProviderService();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/errors/SyncIssueReporterImpl$GlobalSyncIssueService$RegistrationAction;", "Lcom/android/build/gradle/internal/services/ServiceRegistrationAction;", "Lcom/android/build/gradle/internal/errors/SyncIssueReporterImpl$GlobalSyncIssueService;", "Lcom/android/build/gradle/internal/errors/SyncIssueReporterImpl$GlobalSyncIssueService$Parameters;", "project", "Lorg/gradle/api/Project;", "evaluationMode", "Lcom/android/build/gradle/options/SyncOptions$EvaluationMode;", "errorFormatMode", "Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;", "androidProblemReporterProviderService", "Lorg/gradle/api/provider/Provider;", "Lcom/android/build/gradle/internal/errors/AndroidProblemReporterProvider;", "<init>", "(Lorg/gradle/api/Project;Lcom/android/build/gradle/options/SyncOptions$EvaluationMode;Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;Lorg/gradle/api/provider/Provider;)V", "configure", "", "parameters", "gradle-core"})
        public static final class RegistrationAction
        extends ServiceRegistrationAction<GlobalSyncIssueService, Parameters> {
            @NotNull
            private final SyncOptions.EvaluationMode evaluationMode;
            @NotNull
            private final SyncOptions.ErrorFormatMode errorFormatMode;
            @NotNull
            private final Provider<AndroidProblemReporterProvider> androidProblemReporterProviderService;

            public RegistrationAction(@NotNull Project project, @NotNull SyncOptions.EvaluationMode evaluationMode, @NotNull SyncOptions.ErrorFormatMode errorFormatMode, @NotNull Provider<AndroidProblemReporterProvider> androidProblemReporterProviderService2) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)((Object)evaluationMode), (String)"evaluationMode");
                Intrinsics.checkNotNullParameter((Object)((Object)errorFormatMode), (String)"errorFormatMode");
                Intrinsics.checkNotNullParameter(androidProblemReporterProviderService2, (String)"androidProblemReporterProviderService");
                super(project, GlobalSyncIssueService.class, null, null, 12, null);
                this.evaluationMode = evaluationMode;
                this.errorFormatMode = errorFormatMode;
                this.androidProblemReporterProviderService = androidProblemReporterProviderService2;
            }

            @Override
            public void configure(@NotNull Parameters parameters) {
                Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                parameters.getMode().set((Object)this.evaluationMode);
                parameters.getErrorFormatMode().set((Object)this.errorFormatMode);
                parameters.getAndroidProblemReporterProviderService().set(this.androidProblemReporterProviderService);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SyncOptions.EvaluationMode.values().length];
            try {
                nArray[SyncOptions.EvaluationMode.STANDARD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SyncOptions.EvaluationMode.IDE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

