/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.AarToClassTransform;
import com.android.builder.packaging.JarFlinger;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.artifacts.transform.CacheableTransform;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;

@CacheableTransform
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/android/build/gradle/internal/dependency/AarToRClassTransform;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lorg/gradle/api/artifacts/transform/TransformParameters$None;", "<init>", "()V", "inputAarFile", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "getInputAarFile", "()Lorg/gradle/api/provider/Provider;", "transform", "", "outputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "generateRClassJar", "outputJar", "Ljava/nio/file/Path;", "inputAar", "Ljava/util/zip/ZipFile;", "gradle-core"})
public abstract class AarToRClassTransform
implements TransformAction<TransformParameters.None> {
    @InputArtifact
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public abstract Provider<FileSystemLocation> getInputAarFile();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(@NotNull TransformOutputs outputs2) {
        Intrinsics.checkNotNullParameter((Object)outputs2, (String)"outputs");
        Closeable closeable = new ZipFile(((FileSystemLocation)this.getInputAarFile().get()).getAsFile());
        Throwable throwable = null;
        try {
            ZipFile inputAar = (ZipFile)closeable;
            boolean bl = false;
            File file = ((FileSystemLocation)this.getInputAarFile().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
            String outputFileName = FilesKt.getNameWithoutExtension((File)file) + "-R.jar";
            Path outputJar = outputs2.file((Object)outputFileName).toPath();
            Intrinsics.checkNotNull((Object)outputJar);
            this.generateRClassJar(outputJar, inputAar);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateRClassJar(Path outputJar, ZipFile inputAar) {
        Closeable closeable = (Closeable)new JarFlinger(outputJar, JarFlinger.CLASSES_ONLY);
        Throwable throwable = null;
        try {
            JarFlinger outputApiJar = (JarFlinger)closeable;
            boolean bl = false;
            outputApiJar.setCompressionLevel(0);
            AarToClassTransform.Companion.generateRClassJarFromRTxt$gradle_core(outputApiJar, inputAar);
            AarToClassTransform.Companion.copyAllClassesJarsTo$gradle_core(inputAar, outputApiJar);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

