/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.configure;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.ndk.AbiInfo;
import com.android.build.gradle.internal.ndk.NullableAbiInfo;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\"\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\r\u001a\u00020\u000e*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u0018\u0010\u0012\u001a\u00020\u0013*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014\"\u0015\u0010\u0015\u001a\u00020\f*\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\"\u0015\u0010\u0018\u001a\u00020\f*\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017\"\u0018\u0010\u001a\u001a\u00020\f*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0017\u00a8\u0006\u001c"}, d2={"ndkMetaAbisFile", "Ljava/io/File;", "ndkRoot", "mapTypeToken", "Ljava/lang/reflect/Type;", "kotlin.jvm.PlatformType", "parseAbiJson", "", "Lcom/android/build/gradle/internal/ndk/AbiInfo;", "reader", "Ljava/io/Reader;", "abiFile", "", "bitness", "", "Lcom/android/build/gradle/internal/core/Abi;", "getBitness", "(Lcom/android/build/gradle/internal/core/Abi;)I", "isFallbackAbi", "", "(Lcom/android/build/gradle/internal/core/Abi;)Z", "architecture", "getArchitecture", "(Lcom/android/build/gradle/internal/core/Abi;)Ljava/lang/String;", "triple", "getTriple", "llvmTriple", "getLlvmTriple", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nNdkAbiFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NdkAbiFile.kt\ncom/android/build/gradle/internal/cxx/configure/NdkAbiFileKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1611#2,9:189\n1863#2:198\n1864#2:200\n1620#2:201\n1#3:199\n*S KotlinDebug\n*F\n+ 1 NdkAbiFile.kt\ncom/android/build/gradle/internal/cxx/configure/NdkAbiFileKt\n*L\n95#1:189,9\n95#1:198\n95#1:200\n95#1:201\n95#1:199\n*E\n"})
public final class NdkAbiFileKt {
    private static final Type mapTypeToken = new TypeToken<Map<String, ? extends NullableAbiInfo>>(){}.getType();

    @NotNull
    public static final File ndkMetaAbisFile(@NotNull File ndkRoot) {
        Intrinsics.checkNotNullParameter((Object)ndkRoot, (String)"ndkRoot");
        return new File(ndkRoot, "meta/abis.json");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<AbiInfo> parseAbiJson(@NotNull Reader reader, @NotNull String abiFile) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)abiFile, (String)"abiFile");
        Iterable $this$mapNotNull$iv = ((Map)new Gson().fromJson(reader, mapTypeToken)).entrySet();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            AbiInfo abiInfo;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv;
            boolean bl2 = false;
            NullableAbiInfo raw = (NullableAbiInfo)entry2.getValue();
            Abi abi = Abi.getByName((String)entry2.getKey());
            if (abi == null) {
                if (raw.getArchitecture() == null) {
                    LoggingEnvironmentKt.warnln("Ignoring ABI '" + entry2.getKey() + "' found in ABI metadata file '" + abiFile + "' because it had no 'arch' field.", new Object[0]);
                    abiInfo = null;
                } else if (raw.getTriple() == null) {
                    LoggingEnvironmentKt.warnln("Ignoring ABI '" + entry2.getKey() + "' found in ABI metadata file '" + abiFile + "' because it had no 'triple' field.", new Object[0]);
                    abiInfo = null;
                } else if (raw.getBitness() == null) {
                    LoggingEnvironmentKt.warnln("Ignoring ABI '" + entry2.getKey() + "' found in ABI metadata file '" + abiFile + "' because it had no 'bitness' field.", new Object[0]);
                    abiInfo = null;
                } else if (raw.getLlvmTriple() == null) {
                    LoggingEnvironmentKt.warnln("Ignoring ABI '" + entry2.getKey() + "' found in ABI metadata file '" + abiFile + "' because it had no 'llvm_triple' field.", new Object[0]);
                    abiInfo = null;
                } else {
                    LoggingEnvironmentKt.infoln("ABI '" + entry2.getKey() + "' found in ABI metadata file '" + abiFile + "' was not known in advance.", new Object[0]);
                    Boolean bl3 = raw.isDefault();
                    Boolean bl4 = raw.isDeprecated();
                    abiInfo = new AbiInfo((String)entry2.getKey(), raw.getBitness(), bl3 != null ? bl3 : true, bl4 != null ? bl4 : false, raw.getArchitecture(), raw.getTriple(), raw.getLlvmTriple());
                }
            } else {
                String string;
                String string2;
                String string3 = (String)entry2.getKey();
                Integer n = raw.getBitness();
                int n2 = n != null ? n : NdkAbiFileKt.getBitness(abi);
                Boolean bl5 = raw.isDefault();
                boolean bl6 = bl5 != null ? bl5 : true;
                Boolean bl7 = raw.isDeprecated();
                boolean bl8 = bl7 != null ? bl7 : false;
                String string4 = raw.getArchitecture();
                if (string4 == null) {
                    string4 = NdkAbiFileKt.getArchitecture(abi);
                }
                if ((string2 = raw.getTriple()) == null) {
                    string2 = NdkAbiFileKt.getTriple(abi);
                }
                if ((string = raw.getLlvmTriple()) == null) {
                    string = NdkAbiFileKt.getLlvmTriple(abi);
                }
                abiInfo = new AbiInfo(string3, n2, bl6, bl8, string4, string2, string);
            }
            if (abiInfo == null) continue;
            AbiInfo it$iv$iv = abiInfo;
            boolean bl9 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final int getBitness(Abi $this$bitness) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$bitness.ordinal()]) {
            case 1: {
                n = 32;
                break;
            }
            case 2: {
                n = 32;
                break;
            }
            case 3: {
                n = 32;
                break;
            }
            case 4: {
                n = 32;
                break;
            }
            default: {
                n = 64;
            }
        }
        return n;
    }

    private static final boolean isFallbackAbi(Abi $this$isFallbackAbi) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$isFallbackAbi.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public static final String getArchitecture(@NotNull Abi $this$architecture) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$architecture), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$architecture.ordinal()]) {
            case 3: {
                string = "arm";
                break;
            }
            case 4: {
                string = "arm";
                break;
            }
            case 5: {
                string = "arm64";
                break;
            }
            case 2: {
                string = "mips";
                break;
            }
            case 6: {
                string = "mips64";
                break;
            }
            case 1: {
                string = "x86";
                break;
            }
            case 7: {
                string = "x86_64";
                break;
            }
            default: {
                throw new IllegalStateException("Should only use for fallback".toString());
            }
        }
        return string;
    }

    @NotNull
    public static final String getTriple(@NotNull Abi $this$triple) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$triple), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$triple.ordinal()]) {
            case 3: {
                string = "arm-linux-androideabi";
                break;
            }
            case 4: {
                string = "arm-linux-androideabi";
                break;
            }
            case 5: {
                string = "aarch64-linux-android";
                break;
            }
            case 2: {
                string = "mipsel-linux-android";
                break;
            }
            case 6: {
                string = "mips64el-linux-android";
                break;
            }
            case 1: {
                string = "i686-linux-android";
                break;
            }
            case 7: {
                string = "x86_64-linux-android";
                break;
            }
            default: {
                throw new IllegalStateException("Should only use for fallback".toString());
            }
        }
        return string;
    }

    private static final String getLlvmTriple(Abi $this$llvmTriple) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$llvmTriple.ordinal()]) {
            case 4: {
                string = "armv7-none-linux-androideabi";
                break;
            }
            case 5: {
                string = "aarch64-none-linux-android";
                break;
            }
            case 1: {
                string = "i686-none-linux-android";
                break;
            }
            case 7: {
                string = "x86_64-none-linux-android";
                break;
            }
            default: {
                string = "unknown-llvm-triple";
            }
        }
        return string;
    }

    public static final /* synthetic */ boolean access$isFallbackAbi(Abi $receiver) {
        return NdkAbiFileKt.isFallbackAbi($receiver);
    }

    public static final /* synthetic */ int access$getBitness(Abi $receiver) {
        return NdkAbiFileKt.getBitness($receiver);
    }

    public static final /* synthetic */ String access$getLlvmTriple(Abi $receiver) {
        return NdkAbiFileKt.getLlvmTriple($receiver);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Abi.values().length];
            try {
                nArray[Abi.X86.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Abi.MIPS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Abi.ARMEABI.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Abi.ARMEABI_V7A.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Abi.ARM64_V8A.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Abi.MIPS64.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Abi.X86_64.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

