/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.testing.AdbHelper;
import com.android.build.gradle.internal.testing.EmulatorVersionMetadata;
import com.android.build.gradle.internal.testing.QemuExecutor;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.testing.utils.ManagedDeviceUtilsKt;
import com.android.utils.GrabProcessOutput;
import com.android.utils.ILogger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u00019B}\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011\u0012\u001a\b\u0002\u0010\u0014\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u0015\u0012\u0004\u0012\u00020\u00170\u0011\u00a2\u0006\u0004\b\u0018\u0010\u0019J,\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u00162\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J0\u0010(\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u00162\u0006\u0010*\u001a\u00020+2\b\b\u0002\u0010,\u001a\u00020\u0016J\"\u0010-\u001a\u00020.*\u00020/2\u0006\u0010*\u001a\u00020+2\f\u00100\u001a\b\u0012\u0004\u0012\u00020.01H\u0002J.\u00102\u001a\u00020.2\u0006\u0010%\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u00162\u0006\u00103\u001a\u0002042\u0006\u0010*\u001a\u00020+J \u00105\u001a\u00020.2\u0006\u00106\u001a\u00020\u00162\u0006\u00103\u001a\u0002042\u0006\u0010*\u001a\u00020+H\u0002J0\u00107\u001a\u00020.2\u0006\u00108\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u00162\u0006\u0010*\u001a\u00020+H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u0015\u0012\u0004\u0012\u00020\u00170\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001b\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001c\u0010\u001dR\u001b\u0010 \u001a\u00020\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u001f\u001a\u0004\b!\u0010\"\u00a8\u0006:"}, d2={"Lcom/android/build/gradle/internal/AvdSnapshotHandler;", "", "showFullEmulatorKernelLogging", "", "deviceBootAndSnapshotCheckTimeoutSec", "", "adbHelper", "Lcom/android/build/gradle/internal/testing/AdbHelper;", "emulatorDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "qemuExecutor", "Lcom/android/build/gradle/internal/testing/QemuExecutor;", "extraWaitAfterBootCompleteMs", "executor", "Ljava/util/concurrent/Executor;", "metadataFactory", "Lkotlin/Function1;", "Ljava/io/File;", "Lcom/android/build/gradle/internal/testing/EmulatorVersionMetadata;", "processFactory", "", "", "Ljava/lang/ProcessBuilder;", "<init>", "(ZLjava/lang/Long;Lcom/android/build/gradle/internal/testing/AdbHelper;Lorg/gradle/api/provider/Provider;Lcom/android/build/gradle/internal/testing/QemuExecutor;JLjava/util/concurrent/Executor;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "Ljava/lang/Long;", "emulatorMetadata", "getEmulatorMetadata", "()Lcom/android/build/gradle/internal/testing/EmulatorVersionMetadata;", "emulatorMetadata$delegate", "Lkotlin/Lazy;", "emulatorExecutable", "getEmulatorExecutable", "()Ljava/io/File;", "emulatorExecutable$delegate", "getEmulatorCommand", "avdName", "emulatorGpuFlag", "additionalParams", "checkSnapshotLoadable", "avdLocation", "logger", "Lcom/android/utils/ILogger;", "snapshotName", "waitUntilTimeout", "", "Ljava/lang/Process;", "onTimeout", "Lkotlin/Function0;", "generateSnapshot", "avdManager", "Lcom/android/sdklib/internal/avd/AvdManager;", "deleteSnapshotForDevice", "deviceName", "startEmulatorThenStop", "createSnapshot", "EmulatorSnapshotCannotCreatedException", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nAvdSnapshotHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvdSnapshotHandler.kt\ncom/android/build/gradle/internal/AvdSnapshotHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,439:1\n1#2:440\n37#3,2:441\n*S KotlinDebug\n*F\n+ 1 AvdSnapshotHandler.kt\ncom/android/build/gradle/internal/AvdSnapshotHandler\n*L\n98#1:441,2\n*E\n"})
public final class AvdSnapshotHandler {
    private final boolean showFullEmulatorKernelLogging;
    @Nullable
    private final Long deviceBootAndSnapshotCheckTimeoutSec;
    @NotNull
    private final AdbHelper adbHelper;
    @NotNull
    private final Provider<Directory> emulatorDir;
    @NotNull
    private final QemuExecutor qemuExecutor;
    private final long extraWaitAfterBootCompleteMs;
    @NotNull
    private final Executor executor;
    @NotNull
    private final Function1<File, EmulatorVersionMetadata> metadataFactory;
    @NotNull
    private final Function1<List<String>, ProcessBuilder> processFactory;
    @NotNull
    private final Lazy emulatorMetadata$delegate;
    @NotNull
    private final Lazy emulatorExecutable$delegate;

    public AvdSnapshotHandler(boolean showFullEmulatorKernelLogging, @Nullable Long deviceBootAndSnapshotCheckTimeoutSec, @NotNull AdbHelper adbHelper2, @NotNull Provider<Directory> emulatorDir, @NotNull QemuExecutor qemuExecutor, long extraWaitAfterBootCompleteMs, @NotNull Executor executor2, @NotNull Function1<? super File, EmulatorVersionMetadata> metadataFactory, @NotNull Function1<? super List<String>, ProcessBuilder> processFactory2) {
        Intrinsics.checkNotNullParameter((Object)adbHelper2, (String)"adbHelper");
        Intrinsics.checkNotNullParameter(emulatorDir, (String)"emulatorDir");
        Intrinsics.checkNotNullParameter((Object)qemuExecutor, (String)"qemuExecutor");
        Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
        Intrinsics.checkNotNullParameter(metadataFactory, (String)"metadataFactory");
        Intrinsics.checkNotNullParameter(processFactory2, (String)"processFactory");
        this.showFullEmulatorKernelLogging = showFullEmulatorKernelLogging;
        this.deviceBootAndSnapshotCheckTimeoutSec = deviceBootAndSnapshotCheckTimeoutSec;
        this.adbHelper = adbHelper2;
        this.emulatorDir = emulatorDir;
        this.qemuExecutor = qemuExecutor;
        this.extraWaitAfterBootCompleteMs = extraWaitAfterBootCompleteMs;
        this.executor = executor2;
        this.metadataFactory = metadataFactory;
        this.processFactory = processFactory2;
        this.emulatorMetadata$delegate = LazyKt.lazy((Function0)((Function0)new Function0<EmulatorVersionMetadata>(this){
            final /* synthetic */ AvdSnapshotHandler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final EmulatorVersionMetadata invoke() {
                Object object = (Directory)AvdSnapshotHandler.access$getEmulatorDir$p(this.this$0).getOrNull();
                if (object == null || (object = object.getAsFile()) == null) {
                    throw new IllegalStateException("Emulator dir does not exist".toString());
                }
                Object emulatorDirectory2 = object;
                return (EmulatorVersionMetadata)AvdSnapshotHandler.access$getMetadataFactory$p(this.this$0).invoke(emulatorDirectory2);
            }
        }));
        this.emulatorExecutable$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ AvdSnapshotHandler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final File invoke() {
                AvdSnapshotHandler.access$getEmulatorMetadata(this.this$0);
                Object object = (Directory)AvdSnapshotHandler.access$getEmulatorDir$p(this.this$0).getOrNull();
                if (object == null || (object = object.getAsFile()) == null) {
                    throw new IllegalStateException("Emulator dir does not exist".toString());
                }
                Object emulatorDirectory2 = object;
                return FilesKt.resolve((File)emulatorDirectory2, (String)"emulator");
            }
        }));
    }

    public /* synthetic */ AvdSnapshotHandler(boolean bl, Long l, AdbHelper adbHelper2, Provider provider2, QemuExecutor qemuExecutor, long l2, Executor executor2, Function1 function1, Function1 function12, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            l2 = 5000L;
        }
        if ((n & 0x40) != 0) {
            executor2 = Executors.newSingleThreadExecutor();
        }
        if ((n & 0x80) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n & 0x100) != 0) {
            function12 = 2.INSTANCE;
        }
        this(bl, l, adbHelper2, (Provider<Directory>)provider2, qemuExecutor, l2, executor2, (Function1<? super File, EmulatorVersionMetadata>)function1, (Function1<? super List<String>, ProcessBuilder>)function12);
    }

    private final EmulatorVersionMetadata getEmulatorMetadata() {
        Lazy lazy = this.emulatorMetadata$delegate;
        return (EmulatorVersionMetadata)lazy.getValue();
    }

    @NotNull
    public final File getEmulatorExecutable() {
        Lazy lazy = this.emulatorExecutable$delegate;
        return (File)lazy.getValue();
    }

    private final List<String> getEmulatorCommand(String avdName, String emulatorGpuFlag, List<String> additionalParams) {
        String string;
        SpreadBuilder spreadBuilder = new SpreadBuilder(11);
        spreadBuilder.add((Object)this.getEmulatorExecutable().getAbsolutePath());
        spreadBuilder.add((Object)("@" + avdName));
        spreadBuilder.add((Object)"-no-window");
        spreadBuilder.add((Object)"-no-boot-anim");
        spreadBuilder.add((Object)"-no-audio");
        spreadBuilder.add((Object)"-delay-adb");
        String string2 = string = "-verbose";
        SpreadBuilder spreadBuilder2 = spreadBuilder;
        boolean bl = false;
        boolean bl2 = this.showFullEmulatorKernelLogging;
        spreadBuilder2.add((Object)(bl2 ? string : null));
        spreadBuilder.add((Object)"-show-kernel");
        spreadBuilder.add((Object)"-gpu");
        spreadBuilder.add((Object)emulatorGpuFlag);
        Collection $this$toTypedArray$iv = additionalParams;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new String[0]));
        return CollectionsKt.listOfNotNull((Object[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
    }

    public final boolean checkSnapshotLoadable(@NotNull String avdName, @NotNull File avdLocation, @NotNull String emulatorGpuFlag, @NotNull ILogger logger, @NotNull String snapshotName) {
        Intrinsics.checkNotNullParameter((Object)avdName, (String)"avdName");
        Intrinsics.checkNotNullParameter((Object)avdLocation, (String)"avdLocation");
        Intrinsics.checkNotNullParameter((Object)emulatorGpuFlag, (String)"emulatorGpuFlag");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)snapshotName, (String)"snapshotName");
        logger.info("Checking " + snapshotName + " on device " + avdName + " is loadable.", new Object[0]);
        Object object = new String[]{"-read-only", "-no-snapshot-save", "-check-snapshot-loadable", snapshotName};
        ProcessBuilder processBuilder2 = (ProcessBuilder)this.processFactory.invoke(this.getEmulatorCommand(avdName, emulatorGpuFlag, CollectionsKt.listOf((Object[])object)));
        Map<String, String> map = processBuilder2.environment();
        Intrinsics.checkNotNullExpressionValue(map, (String)"environment(...)");
        object = map;
        String string = "ANDROID_AVD_HOME";
        String string2 = avdLocation.getAbsolutePath();
        object.put(string, string2);
        Process process2 = processBuilder2.start();
        Ref.ObjectRef success2 = new Ref.ObjectRef();
        success2.element = new AtomicBoolean(false);
        Ref.BooleanRef timeout = new Ref.BooleanRef();
        Ref.ObjectRef outputProcessed = new Ref.ObjectRef();
        outputProcessed.element = new CountDownLatch(1);
        try {
            GrabProcessOutput.grabProcessOutput((Process)process2, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.ASYNC, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput((Ref.ObjectRef<CountDownLatch>)outputProcessed, logger, (Ref.ObjectRef<AtomicBoolean>)success2){
                final /* synthetic */ Ref.ObjectRef<CountDownLatch> $outputProcessed;
                final /* synthetic */ ILogger $logger;
                final /* synthetic */ Ref.ObjectRef<AtomicBoolean> $success;
                {
                    this.$outputProcessed = $outputProcessed;
                    this.$logger = $logger;
                    this.$success = $success;
                }

                public void out(String line) {
                    if (line == null) {
                        ((CountDownLatch)this.$outputProcessed.element).countDown();
                        return;
                    }
                    this.$logger.verbose(line, new Object[0]);
                    if (StringsKt.contains$default((CharSequence)line, (CharSequence)"Loadable", (boolean)false, (int)2, null)) {
                        ((AtomicBoolean)this.$success.element).set(true);
                        ((CountDownLatch)this.$outputProcessed.element).countDown();
                    } else if (StringsKt.contains$default((CharSequence)line, (CharSequence)"Not loadable", (boolean)false, (int)2, null)) {
                        ((CountDownLatch)this.$outputProcessed.element).countDown();
                    }
                }

                public void err(String line) {
                }
            });
        }
        catch (Exception e) {
            process2.destroy();
            throw new RuntimeException(e);
        }
        Intrinsics.checkNotNull((Object)process2);
        this.waitUntilTimeout(process2, logger, (Function0<Unit>)((Function0)new Function0<Unit>(timeout, logger, snapshotName, avdName){
            final /* synthetic */ Ref.BooleanRef $timeout;
            final /* synthetic */ ILogger $logger;
            final /* synthetic */ String $snapshotName;
            final /* synthetic */ String $avdName;
            {
                this.$timeout = $timeout;
                this.$logger = $logger;
                this.$snapshotName = $snapshotName;
                this.$avdName = $avdName;
                super(0);
            }

            public final void invoke() {
                this.$timeout.element = true;
                this.$logger.warning("Timed out trying to check " + this.$snapshotName + " for " + this.$avdName + " is loadable.", new Object[0]);
            }
        }));
        if (!timeout.element) {
            Long l = this.deviceBootAndSnapshotCheckTimeoutSec;
            long timeoutSec = l != null ? l : 600L;
            ((CountDownLatch)outputProcessed.element).await(timeoutSec, TimeUnit.SECONDS);
        }
        return ((AtomicBoolean)success2.element).get();
    }

    public static /* synthetic */ boolean checkSnapshotLoadable$default(AvdSnapshotHandler avdSnapshotHandler, String string, File file, String string2, ILogger iLogger, String string3, int n, Object object) {
        if ((n & 0x10) != 0) {
            string3 = "default_boot";
        }
        return avdSnapshotHandler.checkSnapshotLoadable(string, file, string2, iLogger, string3);
    }

    private final void waitUntilTimeout(Process $this$waitUntilTimeout, ILogger logger, Function0<Unit> onTimeout) {
        long timeoutSec;
        Long l = this.deviceBootAndSnapshotCheckTimeoutSec;
        long l2 = timeoutSec = l != null ? l : 600L;
        if (timeoutSec > 0L) {
            logger.verbose("Waiting for a process to complete (timeout " + timeoutSec + " seconds)", new Object[0]);
            if (!$this$waitUntilTimeout.waitFor(timeoutSec, TimeUnit.SECONDS)) {
                onTimeout.invoke();
            }
        } else {
            logger.verbose("Waiting for a process to complete (no timeout)", new Object[0]);
            $this$waitUntilTimeout.waitFor();
        }
    }

    public final void generateSnapshot(@NotNull String avdName, @NotNull File avdLocation, @NotNull String emulatorGpuFlag, @NotNull AvdManager avdManager2, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)avdName, (String)"avdName");
        Intrinsics.checkNotNullParameter((Object)avdLocation, (String)"avdLocation");
        Intrinsics.checkNotNullParameter((Object)emulatorGpuFlag, (String)"emulatorGpuFlag");
        Intrinsics.checkNotNullParameter((Object)avdManager2, (String)"avdManager");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        logger.verbose("Creating snapshot for " + avdName, new Object[0]);
        int maxRetryAttempt = 5;
        EmulatorSnapshotCannotCreatedException lastException = null;
        int n = 0;
        while (n < maxRetryAttempt) {
            int attempt = n++;
            boolean bl = false;
            try {
                logger.verbose("Starting Emulator to create a snapshot for " + avdName + " (Attempt " + (attempt + 1) + "/" + maxRetryAttempt + ")", new Object[0]);
                this.startEmulatorThenStop(true, avdName, avdLocation, emulatorGpuFlag, logger);
                if (!AvdSnapshotHandler.checkSnapshotLoadable$default(this, avdName, avdLocation, emulatorGpuFlag, logger, null, 16, null)) {
                    throw new EmulatorSnapshotCannotCreatedException("Snapshot setup for " + avdName + " ran successfully, but the snapshot failed to be created. This is likely to a lack of disk space for the snapshot. Try the cleanManagedDevices task with the --unused-only flag to remove any unused devices for this project.");
                }
                logger.verbose("Starting Emulator to validate a snapshot for " + avdName + " (Attempt " + (attempt + 1) + "/" + maxRetryAttempt + ")", new Object[0]);
                this.startEmulatorThenStop(false, avdName, avdLocation, emulatorGpuFlag, logger);
                logger.info("Successfully created snapshot for: " + avdName, new Object[0]);
                return;
            }
            catch (EmulatorSnapshotCannotCreatedException e) {
                logger.warning("Failed to create Emulator snapshot image (" + (attempt + 1) + "/" + maxRetryAttempt + "). Error: " + e, new Object[0]);
                lastException = e;
            }
        }
        this.deleteSnapshotForDevice(avdName, avdManager2, logger);
        EmulatorSnapshotCannotCreatedException emulatorSnapshotCannotCreatedException = lastException;
        if (emulatorSnapshotCannotCreatedException == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lastException");
            emulatorSnapshotCannotCreatedException = null;
        }
        throw emulatorSnapshotCannotCreatedException;
    }

    private final void deleteSnapshotForDevice(String deviceName, AvdManager avdManager2, ILogger logger) {
        File file;
        Path path;
        AvdInfo avdInfo = avdManager2.getAvd(deviceName, false);
        if (avdInfo == null || (path = avdInfo.getDataFolderPath()) == null || (file = path.toFile()) == null) {
            return;
        }
        File avdDir = file;
        try {
            logger.warning("Deleting unbootable snapshot for device: " + deviceName, new Object[0]);
            this.qemuExecutor.deleteSnapshot(deviceName, avdDir, "default_boot", logger);
        }
        catch (IOException ioException) {
            logger.error((Throwable)ioException, "Could not delete snapshot default_boot for device " + deviceName + ".", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startEmulatorThenStop(boolean createSnapshot, String avdName, File avdLocation, String emulatorGpuFlag, ILogger logger) {
        String string;
        String deviceId = ManagedDeviceUtilsKt.createSetupDeviceId((String)avdName);
        Object object = new String[6];
        String string2 = string = "-no-snapshot-load";
        int n = 0;
        Object[] objectArray = object;
        String string3 = emulatorGpuFlag;
        String string4 = avdName;
        AvdSnapshotHandler avdSnapshotHandler = this;
        Function1<List<String>, ProcessBuilder> function1 = this.processFactory;
        boolean bl = false;
        boolean bl2 = createSnapshot;
        objectArray[n] = bl2 ? string : null;
        String it = string = "-force-snapshot-load";
        n = 1;
        objectArray = object;
        boolean bl3 = false;
        bl2 = !createSnapshot && this.getEmulatorMetadata().getCanUseForceSnapshotLoad();
        objectArray[n] = bl2 ? string : null;
        it = string = "-read-only";
        n = 2;
        objectArray = object;
        boolean bl4 = false;
        bl2 = !createSnapshot;
        objectArray[n] = bl2 ? string : null;
        it = string = "-no-snapshot-save";
        n = 3;
        objectArray = object;
        boolean bl5 = false;
        bl2 = !createSnapshot;
        objectArray[n] = bl2 ? string : null;
        object[4] = "-id";
        object[5] = deviceId;
        ProcessBuilder processBuilder2 = (ProcessBuilder)function1.invoke(avdSnapshotHandler.getEmulatorCommand(string4, string3, CollectionsKt.listOfNotNull((Object[])object)));
        Map<String, String> map = processBuilder2.environment();
        Intrinsics.checkNotNullExpressionValue(map, (String)"environment(...)");
        object = map;
        string = "ANDROID_AVD_HOME";
        it = avdLocation.getAbsolutePath();
        object.put(string, it);
        Map<String, String> map2 = processBuilder2.environment();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"environment(...)");
        object = map2;
        string = "ANDROID_EMULATOR_WAIT_TIME_BEFORE_KILL";
        Long l = this.deviceBootAndSnapshotCheckTimeoutSec;
        it = String.valueOf(l != null ? l : 600L);
        object.put(string, it);
        Process emulatorProcess = processBuilder2.start();
        AtomicBoolean bootCompleted = new AtomicBoolean(false);
        CountDownLatch outputProcessed = new CountDownLatch(2);
        List emulatorErrorList = new ArrayList();
        try {
            this.executor.execute(new Runnable(emulatorProcess, this, deviceId, logger, avdName, bootCompleted){
                final /* synthetic */ Process $emulatorProcess;
                final /* synthetic */ AvdSnapshotHandler this$0;
                final /* synthetic */ String $deviceId;
                final /* synthetic */ ILogger $logger;
                final /* synthetic */ String $avdName;
                final /* synthetic */ AtomicBoolean $bootCompleted;
                {
                    this.$emulatorProcess = $emulatorProcess;
                    this.this$0 = $receiver;
                    this.$deviceId = $deviceId;
                    this.$logger = $logger;
                    this.$avdName = $avdName;
                    this.$bootCompleted = $bootCompleted;
                }

                public final void run() {
                    String emulatorSerial = null;
                    while (this.$emulatorProcess.isAlive()) {
                        try {
                            emulatorSerial = AvdSnapshotHandler.access$getAdbHelper$p(this.this$0).findDeviceSerialWithId(this.$deviceId, this.$logger);
                            break;
                        }
                        catch (Exception e) {
                            this.$logger.verbose("Waiting for " + this.$avdName + " to be attached to adb. Last attempt: " + e, new Object[0]);
                            Thread.sleep(5000L);
                        }
                    }
                    if (emulatorSerial == null) {
                        return;
                    }
                    this.$logger.verbose(this.$avdName + " is attached to adb (" + emulatorSerial + ").", new Object[0]);
                    while (this.$emulatorProcess.isAlive() && !AvdSnapshotHandler.access$getAdbHelper$p(this.this$0).isBootCompleted(emulatorSerial, this.$logger)) {
                        this.$logger.verbose("Waiting for " + this.$avdName + " to boot up.", new Object[0]);
                        Thread.sleep(5000L);
                    }
                    this.$logger.verbose("Booting " + this.$avdName + " is completed.", new Object[0]);
                    while (this.$emulatorProcess.isAlive() && !AvdSnapshotHandler.access$getAdbHelper$p(this.this$0).isPackageManagerStarted(emulatorSerial, this.$logger)) {
                        this.$logger.verbose("Waiting for PackageManager to be ready on " + this.$avdName + ".", new Object[0]);
                        Thread.sleep(5000L);
                    }
                    this.$logger.verbose("PackageManager is ready on " + this.$avdName + ".", new Object[0]);
                    if (AvdSnapshotHandler.access$getExtraWaitAfterBootCompleteMs$p(this.this$0) > 0L) {
                        Thread.sleep(AvdSnapshotHandler.access$getExtraWaitAfterBootCompleteMs$p(this.this$0));
                    }
                    if (this.$emulatorProcess.isAlive()) {
                        this.$logger.verbose(this.$avdName + " is ready to take a snapshot.", new Object[0]);
                        this.$bootCompleted.set(true);
                        AvdSnapshotHandler.access$getAdbHelper$p(this.this$0).killDevice(emulatorSerial);
                    } else {
                        this.$logger.warning("Emulator process exited unexpectedly with the return code " + this.$emulatorProcess.exitValue() + ".", new Object[0]);
                    }
                }
            });
            GrabProcessOutput.grabProcessOutput((Process)emulatorProcess, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.ASYNC, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput(outputProcessed, emulatorErrorList, logger){
                final /* synthetic */ CountDownLatch $outputProcessed;
                final /* synthetic */ List<String> $emulatorErrorList;
                final /* synthetic */ ILogger $logger;
                {
                    this.$outputProcessed = $outputProcessed;
                    this.$emulatorErrorList = $emulatorErrorList;
                    this.$logger = $logger;
                }

                public void out(String line) {
                    this.processLine(line);
                }

                public void err(String line) {
                    this.processLine(line);
                }

                public final void processLine(String line) {
                    if (line == null) {
                        this.$outputProcessed.countDown();
                        return;
                    }
                    if (StringsKt.contains$default((CharSequence)line, (CharSequence)"ERROR", (boolean)false, (int)2, null)) {
                        this.$emulatorErrorList.add(line);
                    }
                    this.$logger.verbose(line, new Object[0]);
                }
            });
            Intrinsics.checkNotNull((Object)emulatorProcess);
            this.waitUntilTimeout(emulatorProcess, logger, (Function0<Unit>)((Function0)new Function0<Unit>(logger, avdName){
                final /* synthetic */ ILogger $logger;
                final /* synthetic */ String $avdName;
                {
                    this.$logger = $logger;
                    this.$avdName = $avdName;
                    super(0);
                }

                public final void invoke() {
                    this.$logger.warning("Snapshot creation timed out. Closing emulator.", new Object[0]);
                    throw new EmulatorSnapshotCannotCreatedException(StringsKt.trimIndent((String)("\n                    Gradle was not able to complete device setup for: " + this.$avdName + "\n                    This could be due to having insufficient resources to provision the number of\n                    devices requested. Try running the test again and request fewer devices or\n                    fewer shards.\n                ")));
                }
            }));
        }
        finally {
            emulatorProcess.destroy();
        }
        if (!bootCompleted.get()) {
            Long l2 = this.deviceBootAndSnapshotCheckTimeoutSec;
            long timeoutSec = l2 != null ? l2 : 600L;
            outputProcessed.await(timeoutSec, TimeUnit.SECONDS);
            throw new EmulatorSnapshotCannotCreatedException(StringsKt.trimIndent((String)("\n                        Gradle was not able to complete device setup for: " + avdName + "\n                        The emulator failed to open the managed device to generate the snapshot.\n                        This is because the emulator closed unexpectedly (exit value = " + emulatorProcess.exitValue() + ").\n                        The errors recorded from emulator:\n                    ")) + CollectionsKt.joinToString$default((Iterable)emulatorErrorList, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        }
    }

    public static final /* synthetic */ AdbHelper access$getAdbHelper$p(AvdSnapshotHandler $this) {
        return $this.adbHelper;
    }

    public static final /* synthetic */ long access$getExtraWaitAfterBootCompleteMs$p(AvdSnapshotHandler $this) {
        return $this.extraWaitAfterBootCompleteMs;
    }

    public static final /* synthetic */ Provider access$getEmulatorDir$p(AvdSnapshotHandler $this) {
        return $this.emulatorDir;
    }

    public static final /* synthetic */ Function1 access$getMetadataFactory$p(AvdSnapshotHandler $this) {
        return $this.metadataFactory;
    }

    public static final /* synthetic */ EmulatorVersionMetadata access$getEmulatorMetadata(AvdSnapshotHandler $this) {
        return $this.getEmulatorMetadata();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/AvdSnapshotHandler$EmulatorSnapshotCannotCreatedException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "message", "", "<init>", "(Ljava/lang/String;)V", "gradle-core"})
    public static final class EmulatorSnapshotCannotCreatedException
    extends RuntimeException {
        public EmulatorSnapshotCannotCreatedException(@NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            super(message2);
        }
    }
}

