/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.featuresplit;

import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitDeclaration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\"\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u001a\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"FEATURE_NAME_CHARS", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "computeFeatureNames", "", "", "features", "", "Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSplitDeclaration;", "getFeatureName", "modulePath", "gradle-core"})
@JvmName(name="FeatureSplitUtils")
@SourceDebugExtension(value={"SMAP\nFeatureSetMetadataWriterTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureSetMetadataWriterTask.kt\ncom/android/build/gradle/internal/tasks/featuresplit/FeatureSplitUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,209:1\n1490#2:210\n1520#2,3:211\n1523#2,3:221\n766#2:224\n857#2,2:225\n361#3,7:214\n*S KotlinDebug\n*F\n+ 1 FeatureSetMetadataWriterTask.kt\ncom/android/build/gradle/internal/tasks/featuresplit/FeatureSplitUtils\n*L\n173#1:210\n173#1:211,3\n173#1:221,3\n181#1:224\n181#1:225,2\n173#1:214,7\n*E\n"})
public final class FeatureSplitUtils {
    private static final Pattern FEATURE_NAME_CHARS = Pattern.compile("[a-zA-Z0-9_]+");

    @NotNull
    public static final String getFeatureName(@NotNull String modulePath) {
        String string;
        Intrinsics.checkNotNullParameter((Object)modulePath, (String)"modulePath");
        if (Intrinsics.areEqual((Object)modulePath, (Object)":")) {
            string = modulePath;
        } else {
            String string2 = modulePath.substring(StringsKt.lastIndexOf$default((CharSequence)modulePath, (char)':', (int)0, (boolean)false, (int)6, null) + 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, String> computeFeatureNames(@NotNull List<? extends FeatureSplitDeclaration> features) {
        void $this$filterTo$iv$iv;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(features, (String)"features");
        Map result2 = new LinkedHashMap();
        Iterable $this$groupBy$iv = features;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            FeatureSplitDeclaration it2 = (FeatureSplitDeclaration)element$iv$iv;
            boolean $i$a$-groupBy-FeatureSplitUtils$computeFeatureNames$leafMap$32 = false;
            String string = it2.getModulePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.modulePath");
            String key$iv$iv = FeatureSplitUtils.getFeatureName(string);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            FeatureSplitDeclaration $i$a$-groupBy-FeatureSplitUtils$computeFeatureNames$leafMap$32 = (FeatureSplitDeclaration)element$iv$iv;
            List list = list$iv$iv;
            boolean bl = false;
            list.add(it.getModulePath());
        }
        Object leafMap = destination$iv$iv;
        if (leafMap.keySet().contains(":")) {
            throw new RuntimeException("Root module ':' is used as a feature module. This is not supported.");
        }
        Iterable $this$filter$iv = leafMap.keySet();
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String name = (String)element$iv$iv;
            boolean bl = false;
            if (!(!FEATURE_NAME_CHARS.matcher(name).matches())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List invalidNames = (List)destination$iv$iv2;
        if (!invalidNames.isEmpty()) {
            throw new RuntimeException(((StringBuilder)CollectionsKt.joinTo$default((Iterable)invalidNames, (Appendable)new StringBuilder("The following feature module names contain invalid characters. Feature module names can only contain letters, digits and underscores."), (CharSequence)"\n\t-> ", (CharSequence)"\n\t-> ", null, (int)0, null, null, (int)120, null)).toString());
        }
        for (Map.Entry entry : leafMap.entrySet()) {
            String module2;
            String leaf = (String)entry.getKey();
            List modules = (List)entry.getValue();
            if ((String)CollectionsKt.singleOrNull((List)modules) == null) {
                throw new RuntimeException(((StringBuilder)CollectionsKt.joinTo$default((Iterable)modules, (Appendable)new StringBuilder("Module name '" + leaf + "' is used by multiple modules. All dynamic features must have a unique name."), (CharSequence)"\n\t-> ", (CharSequence)"\n\t-> ", null, (int)0, null, null, (int)120, null)).toString());
            }
            result2.put(module2, leaf);
        }
        return result2;
    }
}

