/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.NdkHandlerInput;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.stripping.SymbolStripExecutableFinder;
import com.android.build.gradle.internal.process.GradleProcessExecutor;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.tasks.StripDebugSymbolsTask;
import com.android.build.gradle.internal.tasks.UnstrippedLibs;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import java.io.File;
import java.util.function.Function;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/tasks/StripDebugSymbolsRunnable;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/StripDebugSymbolsRunnable$Params;", "()V", "execOperations", "Lorg/gradle/process/ExecOperations;", "getExecOperations", "()Lorg/gradle/process/ExecOperations;", "run", "", "Params", "gradle-core"})
public abstract class StripDebugSymbolsRunnable
extends ProfileAwareWorkAction<Params> {
    @Inject
    @NotNull
    public abstract ExecOperations getExecOperations();

    @Override
    public void run() {
        LoggerWrapper logger = new LoggerWrapper(Logging.getLogger(StripDebugSymbolsTask.class));
        FileUtils.mkdirs((File)((File)((Params)this.getParameters()).getOutput().get()).getParentFile());
        Object object = ((Params)this.getParameters()).getJustCopyInput().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.justCopyInput.get()");
        if (((Boolean)object).booleanValue()) {
            FileUtils.copyFile((File)((File)((Params)this.getParameters()).getInput().get()), (File)((File)((Params)this.getParameters()).getOutput().get()));
            return;
        }
        Provider provider2 = ((Params)this.getParameters()).getStripToolFinder().orElse(((Params)this.getParameters()).getSdkBuildService().flatMap(new Transformer(this){
            final /* synthetic */ StripDebugSymbolsRunnable this$0;
            {
                this.this$0 = $receiver;
            }

            public final Provider<? extends SymbolStripExecutableFinder> transform(SdkComponentsBuildService sdk) {
                Object object = ((Params)this.this$0.getParameters()).getNdkHandlerInput().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.ndkHandlerInput.get()");
                return sdk.versionedNdkHandler((NdkHandlerInput)object).getStripExecutableFinderProvider();
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"override fun run() {\n   \u2026ut.get())\n        }\n    }");
        Provider stripToolFinder2 = provider2;
        SymbolStripExecutableFinder symbolStripExecutableFinder = (SymbolStripExecutableFinder)stripToolFinder2.get();
        Object object2 = ((Params)this.getParameters()).getInput().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.input.get()");
        File exe2 = symbolStripExecutableFinder.stripToolExecutableFile((File)object2, (Abi)((Object)((Params)this.getParameters()).getAbi().getOrNull()), (Function1<? super String, ? extends File>)((Function1)new Function1<String, File>(this, logger){
            final /* synthetic */ StripDebugSymbolsRunnable this$0;
            final /* synthetic */ LoggerWrapper $logger;
            {
                this.this$0 = $receiver;
                this.$logger = $logger;
                super(1);
            }

            @Nullable
            public final File invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = ((File)((Params)this.this$0.getParameters()).getInput().get()).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parameters.input.get().name");
                UnstrippedLibs.INSTANCE.add(string);
                this.$logger.verbose(it + " Packaging it as is.", new Object[0]);
                return null;
            }
        }));
        if (exe2 == null) {
            FileUtils.copyFile((File)((File)((Params)this.getParameters()).getInput().get()), (File)((File)((Params)this.getParameters()).getOutput().get()));
            return;
        }
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(exe2);
        builder.addArgs("--strip-unneeded");
        builder.addArgs("-o");
        builder.addArgs(((File)((Params)this.getParameters()).getOutput().get()).toString());
        builder.addArgs(((File)((Params)this.getParameters()).getInput().get()).toString());
        ExecOperations execOperations = this.getExecOperations();
        ProcessResult processResult = new GradleProcessExecutor(new Function(execOperations){
            final /* synthetic */ ExecOperations $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final ExecResult apply(Action<? super ExecSpec> p0) {
                return this.$tmp0.exec(p0);
            }
        }).execute(builder.createProcess(), (ProcessOutputHandler)new LoggedProcessOutputHandler((ILogger)logger));
        Intrinsics.checkNotNullExpressionValue((Object)processResult, (String)"GradleProcessExecutor(ex\u2026ler(logger)\n            )");
        ProcessResult result2 = processResult;
        if (result2.getExitValue() != 0) {
            String string = ((File)((Params)this.getParameters()).getInput().get()).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parameters.input.get().name");
            UnstrippedLibs.INSTANCE.add(string);
            logger.verbose("Unable to strip library " + ((File)((Params)this.getParameters()).getInput().get()).getAbsolutePath() + " due to error " + result2.getExitValue() + " returned from " + exe2 + ", packaging it as is.", new Object[0]);
            FileUtils.copyFile((File)((File)((Params)this.getParameters()).getInput().get()), (File)((File)((Params)this.getParameters()).getOutput().get()));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007R\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007R\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007R\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/android/build/gradle/internal/tasks/StripDebugSymbolsRunnable$Params;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "()V", "abi", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/core/Abi;", "getAbi", "()Lorg/gradle/api/provider/Property;", "input", "Ljava/io/File;", "getInput", "justCopyInput", "", "getJustCopyInput", "ndkHandlerInput", "Lcom/android/build/gradle/internal/NdkHandlerInput;", "getNdkHandlerInput", "output", "getOutput", "sdkBuildService", "Lcom/android/build/gradle/internal/SdkComponentsBuildService;", "getSdkBuildService", "stripToolFinder", "Lcom/android/build/gradle/internal/cxx/stripping/SymbolStripExecutableFinder;", "getStripToolFinder", "gradle-core"})
    public static abstract class Params
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract Property<File> getInput();

        @NotNull
        public abstract Property<File> getOutput();

        @NotNull
        public abstract Property<Abi> getAbi();

        @NotNull
        public abstract Property<Boolean> getJustCopyInput();

        @NotNull
        public abstract Property<SdkComponentsBuildService> getSdkBuildService();

        @NotNull
        public abstract Property<NdkHandlerInput> getNdkHandlerInput();

        @NotNull
        public abstract Property<SymbolStripExecutableFinder> getStripToolFinder();
    }
}

