/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.tasks.AarMetadataArtifact;
import com.android.build.gradle.internal.tasks.AarMetadataReader;
import com.android.build.gradle.internal.tasks.CheckAarMetadataWorkParameters;
import com.android.build.gradle.internal.utils.CompileData;
import com.android.build.gradle.internal.utils.SdkUtilsKt;
import com.android.ide.common.repository.AgpVersion;
import com.android.repository.Revision;
import com.android.sdklib.SdkVersionInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.workers.WorkAction;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u001e\u0010\u000f\u001a\u00020\u0005*\u00060\u0010j\u0002`\u00112\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/android/build/gradle/internal/tasks/CheckAarMetadataWorkAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/android/build/gradle/internal/tasks/CheckAarMetadataWorkParameters;", "()V", "checkAarMetadataArtifact", "", "aarMetadataArtifact", "Lcom/android/build/gradle/internal/tasks/AarMetadataArtifact;", "errorMessages", "", "", "execute", "getApiIntFromString", "", "sdkVersion", "appendNumberedErrorMessages", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nCheckAarMetadataTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckAarMetadataTask.kt\ncom/android/build/gradle/internal/tasks/CheckAarMetadataWorkAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,549:1\n1855#2,2:550\n1864#2,2:552\n1864#2,3:554\n1866#2:557\n*S KotlinDebug\n*F\n+ 1 CheckAarMetadataTask.kt\ncom/android/build/gradle/internal/tasks/CheckAarMetadataWorkAction\n*L\n209#1:550,2\n243#1:552,2\n247#1:554,3\n243#1:557\n*E\n"})
public abstract class CheckAarMetadataWorkAction
implements WorkAction<CheckAarMetadataWorkParameters> {
    public void execute() {
        List errorMessages = new ArrayList();
        Object object = ((CheckAarMetadataWorkParameters)this.getParameters()).getAarMetadataArtifacts().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.aarMetadataArtifacts.get()");
        Iterable $this$forEach$iv = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AarMetadataArtifact it = (AarMetadataArtifact)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.checkAarMetadataArtifact(it, errorMessages);
        }
        if (errorMessages.size() > 0) {
            StringBuilder stringBuilder;
            StringBuilder $this$execute_u24lambda_u241 = stringBuilder = new StringBuilder();
            boolean bl = false;
            if (errorMessages.size() == 1) {
                $this$execute_u24lambda_u241.append("An issue was");
            } else {
                $this$execute_u24lambda_u241.append(errorMessages.size()).append(" issues were");
            }
            $this$execute_u24lambda_u241.append(" found when checking AAR metadata:");
            this.appendNumberedErrorMessages($this$execute_u24lambda_u241, errorMessages);
            String string = stringBuilder.toString();
            throw new RuntimeException(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void appendNumberedErrorMessages(StringBuilder $this$appendNumberedErrorMessages, List<String> errorMessages) {
        Iterable $this$forEachIndexed$iv = errorMessages;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void errorMessage;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            $this$appendNumberedErrorMessages.append("\n\n");
            String string2 = "%3d";
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{index + 1};
            String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, this, *args)");
            $this$appendNumberedErrorMessages.append(string3);
            $this$appendNumberedErrorMessages.append(".  ");
            Iterable $this$forEachIndexed$iv2 = StringsKt.lines((CharSequence)((CharSequence)errorMessage));
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv2) {
                void line;
                int n2;
                if ((n2 = index$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string4 = (String)item$iv2;
                int lineIndex = n2;
                boolean bl2 = false;
                if (lineIndex > 0) {
                    $this$appendNumberedErrorMessages.append("\n");
                    if (((CharSequence)line).length() > 0) {
                        $this$appendNumberedErrorMessages.append("      ");
                    }
                }
                $this$appendNumberedErrorMessages.append((String)line);
            }
        }
    }

    private final void checkAarMetadataArtifact(AarMetadataArtifact aarMetadataArtifact, List<String> errorMessages) {
        String minAgpVersion;
        File aarMetadataFile = aarMetadataArtifact.getFile();
        String displayName = aarMetadataArtifact.getDisplayName();
        AarMetadataReader aarMetadataReader = new AarMetadataReader(aarMetadataFile);
        String aarFormatVersion = aarMetadataReader.getAarFormatVersion();
        if (aarFormatVersion == null) {
            errorMessages.add(StringsKt.trimIndent((String)("\n                    The AAR metadata for dependency '" + displayName + "' does not specify an\n                    aarFormatVersion value, which is a required value.\n                    ")));
        } else {
            try {
                int majorAarVersion = Revision.parseRevision((String)aarFormatVersion).getMajor();
                int maxMajorAarVersion = Revision.parseRevision((String)((String)((CheckAarMetadataWorkParameters)this.getParameters()).getAarFormatVersion().get())).getMajor();
                if (majorAarVersion > maxMajorAarVersion) {
                    errorMessages.add(StringsKt.trimIndent((String)("\n                            Dependency '" + displayName + "' has an aarFormatVersion value of\n                            '" + aarFormatVersion + "', which is not compatible with this version of the\n                            Android Gradle plugin.\n\n                            Please upgrade to a newer version of the Android Gradle plugin.\n                            ")));
                }
            }
            catch (NumberFormatException e) {
                errorMessages.add(StringsKt.trimIndent((String)("\n                        The AAR metadata for dependency '" + displayName + "' has an invalid\n                        aarFormatVersion value (" + aarFormatVersion + ").\n\n                        " + e.getMessage() + "\n                        ")));
            }
        }
        String aarMetadataVersion = aarMetadataReader.getAarMetadataVersion();
        if (aarMetadataVersion == null) {
            errorMessages.add(StringsKt.trimIndent((String)("\n                    The AAR metadata for dependency '" + displayName + "' does not specify an\n                    aarMetadataVersion value, which is a required value.\n                    ")));
        } else {
            try {
                int majorAarMetadataVersion = Revision.parseRevision((String)aarMetadataVersion).getMajor();
                int maxMajorAarMetadataVersion = Revision.parseRevision((String)((String)((CheckAarMetadataWorkParameters)this.getParameters()).getAarMetadataVersion().get())).getMajor();
                if (majorAarMetadataVersion > maxMajorAarMetadataVersion) {
                    errorMessages.add(StringsKt.trimIndent((String)("\n                            Dependency '" + displayName + "' has an aarMetadataVersion value of\n                            '" + aarMetadataVersion + "', which is not compatible with this version of the\n                            Android Gradle plugin.\n\n                            Please upgrade to a newer version of the Android Gradle plugin.\n                            ")));
                }
            }
            catch (NumberFormatException e) {
                errorMessages.add(StringsKt.trimIndent((String)("\n                        The AAR metadata for dependency '" + displayName + "' has an invalid\n                        aarMetadataVersion value (" + aarMetadataVersion + ").\n\n                        " + e.getMessage() + "\n                        ")));
            }
        }
        if (!((Boolean)((CheckAarMetadataWorkParameters)this.getParameters()).getDisableCompileSdkChecks().get()).booleanValue()) {
            String minCompileSdkExtension;
            String minCompileSdk;
            String forceCompileSdkPreview = aarMetadataReader.getForceCompileSdkPreview();
            if (forceCompileSdkPreview != null) {
                String compileSdkVersion2 = (String)((CheckAarMetadataWorkParameters)this.getParameters()).getCompileSdkVersion().get();
                Object object = ((CheckAarMetadataWorkParameters)this.getParameters()).getCompileSdkVersion().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.compileSdkVersion.get()");
                String compileSdkPreview = SdkUtilsKt.parseTargetHash((String)object).getCodeName();
                if (!Intrinsics.areEqual((Object)compileSdkPreview, (Object)forceCompileSdkPreview)) {
                    errorMessages.add(StringsKt.trimIndent((String)("\n                            Dependency '" + displayName + "' requires libraries and applications that\n                            depend on it to compile against codename \"" + forceCompileSdkPreview + "\" of the\n                            Android APIs.\n\n                            " + ((CheckAarMetadataWorkParameters)this.getParameters()).getProjectPath().get() + " is currently compiled against " + compileSdkVersion2 + ".\n\n                            Recommended action: Use a different version of dependency '" + displayName + "',\n                            or set compileSdkPreview to \"" + forceCompileSdkPreview + "\" in your build.gradle\n                            file if you intend to experiment with that preview SDK.\n                        ")));
                }
            }
            if ((minCompileSdk = aarMetadataReader.getMinCompileSdk()) != null) {
                Integer minCompileSdkInt = StringsKt.toIntOrNull((String)minCompileSdk);
                if (minCompileSdkInt == null) {
                    errorMessages.add(StringsKt.trimIndent((String)("\n                            The AAR metadata for dependency '" + displayName + "' has an invalid\n                            minCompileSdk value (" + minCompileSdk + ").\n\n                            minCompileSdk must be an integer.\n                            ")));
                } else {
                    String compileSdkVersion3 = (String)((CheckAarMetadataWorkParameters)this.getParameters()).getCompileSdkVersion().get();
                    Intrinsics.checkNotNullExpressionValue((Object)compileSdkVersion3, (String)"compileSdkVersion");
                    int it = this.getApiIntFromString(compileSdkVersion3);
                    boolean bl = false;
                    Integer compileSdkVersionInt = it > 33 ? (Integer)((CheckAarMetadataWorkParameters)this.getParameters()).getPlatformSdkApiLevel().get() : Integer.valueOf(it);
                    int n = minCompileSdkInt;
                    Intrinsics.checkNotNullExpressionValue((Object)compileSdkVersionInt, (String)"compileSdkVersionInt");
                    if (n > compileSdkVersionInt) {
                        Integer maxRecommendedCompileSdk = (Integer)((CheckAarMetadataWorkParameters)this.getParameters()).getMaxRecommendedStableCompileSdkVersionForThisAgp().get();
                        int n2 = minCompileSdkInt;
                        Intrinsics.checkNotNullExpressionValue((Object)maxRecommendedCompileSdk, (String)"maxRecommendedCompileSdk");
                        String recommendation = n2 <= maxRecommendedCompileSdk ? StringsKt.trimIndent((String)("\n                                Recommended action: Update this project to use a newer compileSdk\n                                of at least " + minCompileSdk + ", for example " + maxRecommendedCompileSdk + ".\n                            ")) : StringsKt.trimIndent((String)("\n                                Also, the maximum recommended compile SDK version for Android Gradle\n                                plugin " + ((CheckAarMetadataWorkParameters)this.getParameters()).getAgpVersion().get() + " is " + maxRecommendedCompileSdk + ".\n\n                                Recommended action: Update this project's version of the Android Gradle\n                                plugin to one that supports " + minCompileSdk + ", then update this project to use\n                                compileSdk of at least " + minCompileSdk + ".\n                            "));
                        errorMessages.add(StringsKt.trimIndent((String)("\n                                Dependency '" + displayName + "' requires libraries and applications that\n                                depend on it to compile against version " + minCompileSdk + " or later of the\n                                Android APIs.\n\n                                " + ((CheckAarMetadataWorkParameters)this.getParameters()).getProjectPath().get() + " is currently compiled against " + compileSdkVersion3 + ".\n                            ")) + "\n\n" + recommendation + "\n\nNote that updating a library or application's compileSdk (which\nallows newer APIs to be used) can be done separately from updating\ntargetSdk (which opts the app in to new runtime behavior) and\nminSdk (which determines which devices the app can be installed\non).");
                    }
                }
            }
            if ((minCompileSdkExtension = aarMetadataReader.getMinCompileSdkExtension()) != null) {
                Integer minCompileSdkExtensionInt = StringsKt.toIntOrNull((String)minCompileSdkExtension);
                if (minCompileSdkExtensionInt == null) {
                    errorMessages.add(StringsKt.trimIndent((String)("\n                        The AAR metadata for dependency '" + displayName + "' has an invalid\n                        minCompileSdkExtension value (" + minCompileSdkExtension + ").\n\n                        minCompileSdkExtension must be an integer.\n                        ")));
                } else {
                    int compileSdkExtension;
                    int n;
                    Object object = ((CheckAarMetadataWorkParameters)this.getParameters()).getCompileSdkVersion().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.compileSdkVersion.get()");
                    Integer n3 = SdkUtilsKt.parseTargetHash((String)object).getSdkExtension();
                    if (n3 != null) {
                        n = n3;
                    } else {
                        Integer n4 = (Integer)((CheckAarMetadataWorkParameters)this.getParameters()).getPlatformSdkExtension().getOrNull();
                        n = compileSdkExtension = n4 != null ? n4 : 0;
                    }
                    if (minCompileSdkExtensionInt > compileSdkExtension) {
                        errorMessages.add(StringsKt.trimIndent((String)("\n                            Dependency '" + displayName + "' requires libraries and applications that\n                            depend on it to compile against an SDK with an extension level of\n                            " + minCompileSdkExtension + " or higher.\n\n                            Recommended action: Update this project to use a compileSdkExtension\n                            value of at least " + minCompileSdkExtension + ".\n                        ")));
                    }
                }
            }
        }
        if ((minAgpVersion = aarMetadataReader.getMinAgpVersion()) != null) {
            AgpVersion parsedMinAgpVersion = AgpVersion.Companion.tryParseStable(minAgpVersion);
            if (parsedMinAgpVersion == null) {
                errorMessages.add(StringsKt.trimIndent((String)("\n                        The AAR metadata for dependency '" + displayName + "' has an invalid\n                        minAndroidGradlePluginVersion value (" + minAgpVersion + ").\n\n                        minAndroidGradlePluginVersion must be a stable AGP version,\n                        formatted with major, minor, and micro values (for example \"4.0.0\").\n                        ")));
            } else {
                Object object = ((CheckAarMetadataWorkParameters)this.getParameters()).getAgpVersion().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.agpVersion.get()");
                AgpVersion parsedAgpVersion = AgpVersion.Companion.parse((String)object);
                if (parsedMinAgpVersion.compareTo(parsedAgpVersion) > 0) {
                    errorMessages.add(StringsKt.trimIndent((String)("\n                            Dependency '" + displayName + "' requires Android Gradle plugin " + minAgpVersion + " or higher.\n\n                            This build currently uses Android Gradle plugin " + ((CheckAarMetadataWorkParameters)this.getParameters()).getAgpVersion().get() + ".\n                            ")));
                }
            }
        }
    }

    private final int getApiIntFromString(String sdkVersion) {
        CompileData compileData = SdkUtilsKt.parseTargetHash(sdkVersion);
        if (compileData.getApiLevel() != null) {
            return compileData.getApiLevel();
        }
        if (compileData.getCodeName() != null) {
            return SdkVersionInfo.getApiByPreviewName((String)compileData.getCodeName(), (boolean)true);
        }
        throw new RuntimeException("Unsupported target hash: " + sdkVersion);
    }
}

