/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.targeting.TargetingUtils;
import com.android.tools.build.bundletool.model.utils.TargetingProtoUtils;
import com.android.tools.build.bundletool.splitters.ApkGenerationConfiguration;
import com.android.tools.build.bundletool.splitters.BundleModuleVariantGenerator;
import com.android.tools.build.bundletool.splitters.DexCompressionVariantGenerator;
import com.android.tools.build.bundletool.splitters.NativeLibsCompressionVariantGenerator;
import com.android.tools.build.bundletool.splitters.SigningConfigurationVariantGenerator;
import com.android.tools.build.bundletool.splitters.SparseEncodingVariantGenerator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;

public final class PerModuleVariantTargetingGenerator {
    @Inject
    PerModuleVariantTargetingGenerator() {
    }

    public ImmutableSet<Targeting.VariantTargeting> generateVariants(BundleModule module) {
        return this.generateVariants(module, ApkGenerationConfiguration.getDefaultInstance());
    }

    public ImmutableSet<Targeting.VariantTargeting> generateVariants(BundleModule module, ApkGenerationConfiguration apkGenerationConfiguration) {
        if (PerModuleVariantTargetingGenerator.targetsOnlyPreL(module)) {
            throw CommandExecutionException.builder().withInternalMessage("Cannot generate variants '%s' because it does not target devices on Android L or above.", module.getName()).build();
        }
        ImmutableSet splitVariants = (ImmutableSet)PerModuleVariantTargetingGenerator.getVariantGenerators(apkGenerationConfiguration).stream().flatMap(generator -> generator.generate(module)).collect(ImmutableSet.toImmutableSet());
        return TargetingUtils.cropVariantsWithAppSdkRange((ImmutableSet<Targeting.VariantTargeting>)splitVariants, module.getAndroidManifest().getSdkRange());
    }

    private static ImmutableList<BundleModuleVariantGenerator> getVariantGenerators(ApkGenerationConfiguration apkGenerationConfiguration) {
        return ImmutableList.of(unused -> Stream.of(TargetingProtoUtils.lPlusVariantTargeting()), (Object)new NativeLibsCompressionVariantGenerator(apkGenerationConfiguration), (Object)new DexCompressionVariantGenerator(apkGenerationConfiguration), (Object)new SigningConfigurationVariantGenerator(apkGenerationConfiguration), (Object)new SparseEncodingVariantGenerator(apkGenerationConfiguration));
    }

    private static boolean targetsOnlyPreL(BundleModule module) {
        Optional<Integer> maxSdkVersion = module.getAndroidManifest().getMaxSdkVersion();
        return maxSdkVersion.isPresent() && maxSdkVersion.get() < 21;
    }
}

